/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.Optional;
import net.minecraft.ResourceLocationException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.TemplateMirrorArgument;
import net.minecraft.commands.arguments.TemplateRotationArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockRotProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.bukkit.event.world.AsyncStructureGenerateEvent;

public class PlaceCommand {
    private static final SimpleCommandExceptionType ERROR_FEATURE_FAILED = new SimpleCommandExceptionType((Message)Component.translatable("commands.place.feature.failed"));
    private static final SimpleCommandExceptionType ERROR_JIGSAW_FAILED = new SimpleCommandExceptionType((Message)Component.translatable("commands.place.jigsaw.failed"));
    private static final SimpleCommandExceptionType ERROR_STRUCTURE_FAILED = new SimpleCommandExceptionType((Message)Component.translatable("commands.place.structure.failed"));
    private static final DynamicCommandExceptionType ERROR_TEMPLATE_INVALID = new DynamicCommandExceptionType(template -> Component.translatableEscape("commands.place.template.invalid", template));
    private static final SimpleCommandExceptionType ERROR_TEMPLATE_FAILED = new SimpleCommandExceptionType((Message)Component.translatable("commands.place.template.failed"));
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_TEMPLATES = (context, builder) -> {
        StructureTemplateManager structureManager = ((CommandSourceStack)context.getSource()).getLevel().getStructureManager();
        return SharedSuggestionProvider.suggestResource(structureManager.listTemplates(), builder);
    };

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("place").requires(source -> source.hasPermission(2))).then(Commands.literal("feature").then(((RequiredArgumentBuilder)Commands.argument("feature", ResourceKeyArgument.key(Registries.CONFIGURED_FEATURE)).executes(context -> PlaceCommand.placeFeature((CommandSourceStack)context.getSource(), ResourceKeyArgument.getConfiguredFeature((CommandContext<CommandSourceStack>)context, "feature"), BlockPos.containing(((CommandSourceStack)context.getSource()).getPosition())))).then(Commands.argument("pos", BlockPosArgument.blockPos()).executes(context -> PlaceCommand.placeFeature((CommandSourceStack)context.getSource(), ResourceKeyArgument.getConfiguredFeature((CommandContext<CommandSourceStack>)context, "feature"), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)context, "pos"))))))).then(Commands.literal("jigsaw").then(Commands.argument("pool", ResourceKeyArgument.key(Registries.TEMPLATE_POOL)).then(Commands.argument("target", ResourceLocationArgument.id()).then(((RequiredArgumentBuilder)Commands.argument("max_depth", IntegerArgumentType.integer((int)1, (int)20)).executes(context -> PlaceCommand.placeJigsaw((CommandSourceStack)context.getSource(), ResourceKeyArgument.getStructureTemplatePool((CommandContext<CommandSourceStack>)context, "pool"), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)context, "target"), IntegerArgumentType.getInteger((CommandContext)context, (String)"max_depth"), BlockPos.containing(((CommandSourceStack)context.getSource()).getPosition())))).then(Commands.argument("position", BlockPosArgument.blockPos()).executes(context -> PlaceCommand.placeJigsaw((CommandSourceStack)context.getSource(), ResourceKeyArgument.getStructureTemplatePool((CommandContext<CommandSourceStack>)context, "pool"), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)context, "target"), IntegerArgumentType.getInteger((CommandContext)context, (String)"max_depth"), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)context, "position"))))))))).then(Commands.literal("structure").then(((RequiredArgumentBuilder)Commands.argument("structure", ResourceKeyArgument.key(Registries.STRUCTURE)).executes(context -> PlaceCommand.placeStructure((CommandSourceStack)context.getSource(), ResourceKeyArgument.getStructure((CommandContext<CommandSourceStack>)context, "structure"), BlockPos.containing(((CommandSourceStack)context.getSource()).getPosition())))).then(Commands.argument("pos", BlockPosArgument.blockPos()).executes(context -> PlaceCommand.placeStructure((CommandSourceStack)context.getSource(), ResourceKeyArgument.getStructure((CommandContext<CommandSourceStack>)context, "structure"), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)context, "pos"))))))).then(Commands.literal("template").then(((RequiredArgumentBuilder)Commands.argument("template", ResourceLocationArgument.id()).suggests(SUGGEST_TEMPLATES).executes(context -> PlaceCommand.placeTemplate((CommandSourceStack)context.getSource(), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)context, "template"), BlockPos.containing(((CommandSourceStack)context.getSource()).getPosition()), Rotation.NONE, Mirror.NONE, 1.0f, 0, false))).then(((RequiredArgumentBuilder)Commands.argument("pos", BlockPosArgument.blockPos()).executes(context -> PlaceCommand.placeTemplate((CommandSourceStack)context.getSource(), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)context, "template"), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)context, "pos"), Rotation.NONE, Mirror.NONE, 1.0f, 0, false))).then(((RequiredArgumentBuilder)Commands.argument("rotation", TemplateRotationArgument.templateRotation()).executes(context -> PlaceCommand.placeTemplate((CommandSourceStack)context.getSource(), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)context, "template"), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)context, "pos"), TemplateRotationArgument.getRotation((CommandContext<CommandSourceStack>)context, "rotation"), Mirror.NONE, 1.0f, 0, false))).then(((RequiredArgumentBuilder)Commands.argument("mirror", TemplateMirrorArgument.templateMirror()).executes(context -> PlaceCommand.placeTemplate((CommandSourceStack)context.getSource(), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)context, "template"), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)context, "pos"), TemplateRotationArgument.getRotation((CommandContext<CommandSourceStack>)context, "rotation"), TemplateMirrorArgument.getMirror((CommandContext<CommandSourceStack>)context, "mirror"), 1.0f, 0, false))).then(((RequiredArgumentBuilder)Commands.argument("integrity", FloatArgumentType.floatArg((float)0.0f, (float)1.0f)).executes(context -> PlaceCommand.placeTemplate((CommandSourceStack)context.getSource(), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)context, "template"), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)context, "pos"), TemplateRotationArgument.getRotation((CommandContext<CommandSourceStack>)context, "rotation"), TemplateMirrorArgument.getMirror((CommandContext<CommandSourceStack>)context, "mirror"), FloatArgumentType.getFloat((CommandContext)context, (String)"integrity"), 0, false))).then(((RequiredArgumentBuilder)Commands.argument("seed", IntegerArgumentType.integer()).executes(context -> PlaceCommand.placeTemplate((CommandSourceStack)context.getSource(), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)context, "template"), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)context, "pos"), TemplateRotationArgument.getRotation((CommandContext<CommandSourceStack>)context, "rotation"), TemplateMirrorArgument.getMirror((CommandContext<CommandSourceStack>)context, "mirror"), FloatArgumentType.getFloat((CommandContext)context, (String)"integrity"), IntegerArgumentType.getInteger((CommandContext)context, (String)"seed"), false))).then(Commands.literal("strict").executes(context -> PlaceCommand.placeTemplate((CommandSourceStack)context.getSource(), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)context, "template"), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)context, "pos"), TemplateRotationArgument.getRotation((CommandContext<CommandSourceStack>)context, "rotation"), TemplateMirrorArgument.getMirror((CommandContext<CommandSourceStack>)context, "mirror"), FloatArgumentType.getFloat((CommandContext)context, (String)"integrity"), IntegerArgumentType.getInteger((CommandContext)context, (String)"seed"), true))))))))))));
    }

    public static int placeFeature(CommandSourceStack source, Holder.Reference<ConfiguredFeature<?, ?>> feature, BlockPos pos) throws CommandSyntaxException {
        ServerLevel level = source.getLevel();
        ConfiguredFeature<?, ?> configuredFeature = feature.value();
        ChunkPos chunkPos = new ChunkPos(pos);
        PlaceCommand.checkLoaded(level, new ChunkPos(chunkPos.x - 1, chunkPos.z - 1), new ChunkPos(chunkPos.x + 1, chunkPos.z + 1));
        if (!configuredFeature.place(level, level.getChunkSource().getGenerator(), level.getRandom(), pos)) {
            throw ERROR_FEATURE_FAILED.create();
        }
        String string = feature.key().location().toString();
        source.sendSuccess(() -> Component.translatable("commands.place.feature.success", string, pos.getX(), pos.getY(), pos.getZ()), true);
        return 1;
    }

    public static int placeJigsaw(CommandSourceStack source, Holder<StructureTemplatePool> templatePool, ResourceLocation target, int maxDepth, BlockPos pos) throws CommandSyntaxException {
        ServerLevel level = source.getLevel();
        ChunkPos chunkPos = new ChunkPos(pos);
        PlaceCommand.checkLoaded(level, chunkPos, chunkPos);
        if (!JigsawPlacement.generateJigsaw(level, templatePool, target, maxDepth, pos, false)) {
            throw ERROR_JIGSAW_FAILED.create();
        }
        source.sendSuccess(() -> Component.translatable("commands.place.jigsaw.success", pos.getX(), pos.getY(), pos.getZ()), true);
        return 1;
    }

    public static int placeStructure(CommandSourceStack source, Holder.Reference<Structure> structure, BlockPos pos) throws CommandSyntaxException {
        ServerLevel level = source.getLevel();
        Structure structure1 = structure.value();
        ChunkGenerator generator = level.getChunkSource().getGenerator();
        StructureStart structureStart = structure1.generate(structure, level.dimension(), source.registryAccess(), generator, generator.getBiomeSource(), level.getChunkSource().randomState(), level.getStructureManager(), level.getSeed(), new ChunkPos(pos), 0, level, holder -> true);
        if (!structureStart.isValid()) {
            throw ERROR_STRUCTURE_FAILED.create();
        }
        structureStart.generationEventCause = AsyncStructureGenerateEvent.Cause.COMMAND;
        BoundingBox boundingBox = structureStart.getBoundingBox();
        ChunkPos chunkPos = new ChunkPos(SectionPos.blockToSectionCoord(boundingBox.minX()), SectionPos.blockToSectionCoord(boundingBox.minZ()));
        ChunkPos chunkPos1 = new ChunkPos(SectionPos.blockToSectionCoord(boundingBox.maxX()), SectionPos.blockToSectionCoord(boundingBox.maxZ()));
        PlaceCommand.checkLoaded(level, chunkPos, chunkPos1);
        ChunkPos.rangeClosed(chunkPos, chunkPos1).forEach(chunkPos2 -> structureStart.placeInChunk(level, level.structureManager(), generator, level.getRandom(), new BoundingBox(chunkPos2.getMinBlockX(), level.getMinY(), chunkPos2.getMinBlockZ(), chunkPos2.getMaxBlockX(), level.getMaxY() + 1, chunkPos2.getMaxBlockZ()), (ChunkPos)chunkPos2));
        String string = structure.key().location().toString();
        source.sendSuccess(() -> Component.translatable("commands.place.structure.success", string, pos.getX(), pos.getY(), pos.getZ()), true);
        return 1;
    }

    public static int placeTemplate(CommandSourceStack source, ResourceLocation template, BlockPos pos, Rotation rotation, Mirror mirror, float integrity, int seed, boolean strict) throws CommandSyntaxException {
        boolean flag;
        Optional<StructureTemplate> optional;
        ServerLevel level = source.getLevel();
        StructureTemplateManager structureManager = level.getStructureManager();
        try {
            optional = structureManager.get(template);
        }
        catch (ResourceLocationException var14) {
            throw ERROR_TEMPLATE_INVALID.create((Object)template);
        }
        if (optional.isEmpty()) {
            throw ERROR_TEMPLATE_INVALID.create((Object)template);
        }
        StructureTemplate structureTemplate = optional.get();
        PlaceCommand.checkLoaded(level, new ChunkPos(pos), new ChunkPos(pos.offset(structureTemplate.getSize())));
        StructurePlaceSettings structurePlaceSettings = new StructurePlaceSettings().setMirror(mirror).setRotation(rotation).setKnownShape(strict);
        if (integrity < 1.0f) {
            structurePlaceSettings.clearProcessors().addProcessor(new BlockRotProcessor(integrity)).setRandom(StructureBlockEntity.createRandom(seed));
        }
        if (!(flag = structureTemplate.placeInWorld(level, pos, pos, structurePlaceSettings, StructureBlockEntity.createRandom(seed), 2 | (strict ? 816 : 0)))) {
            throw ERROR_TEMPLATE_FAILED.create();
        }
        source.sendSuccess(() -> Component.translatable("commands.place.template.success", Component.translationArg(template), pos.getX(), pos.getY(), pos.getZ()), true);
        return 1;
    }

    private static void checkLoaded(ServerLevel level, ChunkPos start, ChunkPos end) throws CommandSyntaxException {
        if (ChunkPos.rangeClosed(start, end).filter(chunkPos -> !level.isLoaded(chunkPos.getWorldPosition())).findAny().isPresent()) {
            throw BlockPosArgument.ERROR_NOT_LOADED.create();
        }
    }
}

