/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class SpectateCommand {
    private static final SimpleCommandExceptionType ERROR_SELF = new SimpleCommandExceptionType((Message)Component.translatable("commands.spectate.self"));
    private static final DynamicCommandExceptionType ERROR_NOT_SPECTATOR = new DynamicCommandExceptionType(player -> Component.translatableEscape("commands.spectate.not_spectator", player));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("spectate").requires(source -> source.hasPermission(2))).executes(context -> SpectateCommand.spectate((CommandSourceStack)context.getSource(), null, ((CommandSourceStack)context.getSource()).getPlayerOrException()))).then(((RequiredArgumentBuilder)Commands.argument("target", EntityArgument.entity()).executes(context -> SpectateCommand.spectate((CommandSourceStack)context.getSource(), EntityArgument.getEntity((CommandContext<CommandSourceStack>)context, "target"), ((CommandSourceStack)context.getSource()).getPlayerOrException()))).then(Commands.argument("player", EntityArgument.player()).executes(context -> SpectateCommand.spectate((CommandSourceStack)context.getSource(), EntityArgument.getEntity((CommandContext<CommandSourceStack>)context, "target"), EntityArgument.getPlayer((CommandContext<CommandSourceStack>)context, "player")))))));
    }

    private static int spectate(CommandSourceStack source, @Nullable Entity target, ServerPlayer player) throws CommandSyntaxException {
        if (player == target) {
            throw ERROR_SELF.create();
        }
        if (!player.isSpectator()) {
            throw ERROR_NOT_SPECTATOR.create((Object)player.getDisplayName());
        }
        player.setCamera(target);
        if (target != null) {
            source.sendSuccess(() -> Component.translatable("commands.spectate.success.started", target.getDisplayName()), false);
        } else {
            source.sendSuccess(() -> Component.translatable("commands.spectate.success.stopped"), false);
        }
        return 1;
    }
}

