/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.CompoundTagArgument;
import net.minecraft.commands.arguments.NbtPathArgument;
import net.minecraft.commands.arguments.NbtTagArgument;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.PrimitiveTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.commands.data.BlockDataAccessor;
import net.minecraft.server.commands.data.DataAccessor;
import net.minecraft.server.commands.data.EntityDataAccessor;
import net.minecraft.server.commands.data.StorageDataAccessor;
import net.minecraft.util.Mth;

public class DataCommands {
    private static final SimpleCommandExceptionType ERROR_MERGE_UNCHANGED = new SimpleCommandExceptionType((Message)Component.translatable("commands.data.merge.failed"));
    private static final DynamicCommandExceptionType ERROR_GET_NOT_NUMBER = new DynamicCommandExceptionType(nbtPath -> Component.translatableEscape("commands.data.get.invalid", nbtPath));
    private static final DynamicCommandExceptionType ERROR_GET_NON_EXISTENT = new DynamicCommandExceptionType(nbtPath -> Component.translatableEscape("commands.data.get.unknown", nbtPath));
    private static final SimpleCommandExceptionType ERROR_MULTIPLE_TAGS = new SimpleCommandExceptionType((Message)Component.translatable("commands.data.get.multiple"));
    private static final DynamicCommandExceptionType ERROR_EXPECTED_OBJECT = new DynamicCommandExceptionType(unexpectedNbt -> Component.translatableEscape("commands.data.modify.expected_object", unexpectedNbt));
    private static final DynamicCommandExceptionType ERROR_EXPECTED_VALUE = new DynamicCommandExceptionType(unexpectedNbt -> Component.translatableEscape("commands.data.modify.expected_value", unexpectedNbt));
    private static final Dynamic2CommandExceptionType ERROR_INVALID_SUBSTRING = new Dynamic2CommandExceptionType((startIndex, endIndex) -> Component.translatableEscape("commands.data.modify.invalid_substring", startIndex, endIndex));
    public static final List<Function<String, DataProvider>> ALL_PROVIDERS = ImmutableList.of(EntityDataAccessor.PROVIDER, BlockDataAccessor.PROVIDER, StorageDataAccessor.PROVIDER);
    public static final List<DataProvider> TARGET_PROVIDERS = (List)ALL_PROVIDERS.stream().map(dataProviderFactory -> (DataProvider)dataProviderFactory.apply("target")).collect(ImmutableList.toImmutableList());
    public static final List<DataProvider> SOURCE_PROVIDERS = (List)ALL_PROVIDERS.stream().map(dataProviderFactory -> (DataProvider)dataProviderFactory.apply("source")).collect(ImmutableList.toImmutableList());

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder literalArgumentBuilder = (LiteralArgumentBuilder)Commands.literal("data").requires(source -> source.hasPermission(2));
        for (DataProvider dataProvider : TARGET_PROVIDERS) {
            ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)literalArgumentBuilder.then(dataProvider.wrap((ArgumentBuilder<CommandSourceStack, ?>)Commands.literal("merge"), argumentBuilder -> argumentBuilder.then(Commands.argument("nbt", CompoundTagArgument.compoundTag()).executes(context -> DataCommands.mergeData((CommandSourceStack)context.getSource(), dataProvider.access((CommandContext<CommandSourceStack>)context), CompoundTagArgument.getCompoundTag(context, "nbt"))))))).then(dataProvider.wrap((ArgumentBuilder<CommandSourceStack, ?>)Commands.literal("get"), argumentBuilder -> ((ArgumentBuilder)argumentBuilder.executes(context -> DataCommands.getData((CommandSourceStack)context.getSource(), dataProvider.access((CommandContext<CommandSourceStack>)context)))).then(((RequiredArgumentBuilder)Commands.argument("path", NbtPathArgument.nbtPath()).executes(context -> DataCommands.getData((CommandSourceStack)context.getSource(), dataProvider.access((CommandContext<CommandSourceStack>)context), NbtPathArgument.getPath((CommandContext<CommandSourceStack>)context, "path")))).then(Commands.argument("scale", DoubleArgumentType.doubleArg()).executes(context -> DataCommands.getNumeric((CommandSourceStack)context.getSource(), dataProvider.access((CommandContext<CommandSourceStack>)context), NbtPathArgument.getPath((CommandContext<CommandSourceStack>)context, "path"), DoubleArgumentType.getDouble((CommandContext)context, (String)"scale")))))))).then(dataProvider.wrap((ArgumentBuilder<CommandSourceStack, ?>)Commands.literal("remove"), argumentBuilder -> argumentBuilder.then(Commands.argument("path", NbtPathArgument.nbtPath()).executes(context -> DataCommands.removeData((CommandSourceStack)context.getSource(), dataProvider.access((CommandContext<CommandSourceStack>)context), NbtPathArgument.getPath((CommandContext<CommandSourceStack>)context, "path"))))))).then(DataCommands.decorateModification((argumentBuilder, dataManipulatorDecorator) -> ((ArgumentBuilder)((ArgumentBuilder)((ArgumentBuilder)((ArgumentBuilder)argumentBuilder.then(Commands.literal("insert").then(Commands.argument("index", IntegerArgumentType.integer()).then(dataManipulatorDecorator.create((context, sourceCompoundTag, nbtPath, tags) -> nbtPath.insert(IntegerArgumentType.getInteger((CommandContext)context, (String)"index"), sourceCompoundTag, tags)))))).then(Commands.literal("prepend").then(dataManipulatorDecorator.create((context, sourceCompoundTag, nbtPath, tags) -> nbtPath.insert(0, sourceCompoundTag, tags))))).then(Commands.literal("append").then(dataManipulatorDecorator.create((context, sourceCompoundTag, nbtPath, tags) -> nbtPath.insert(-1, sourceCompoundTag, tags))))).then(Commands.literal("set").then(dataManipulatorDecorator.create((context, sourceCompoundTag, nbtPath, tags) -> nbtPath.set(sourceCompoundTag, (Tag)Iterables.getLast((Iterable)tags)))))).then(Commands.literal("merge").then(dataManipulatorDecorator.create((context, sourceCompoundTag, nbtPath, tags) -> {
                CompoundTag compoundTag = new CompoundTag();
                for (Tag tag : tags) {
                    if (NbtPathArgument.NbtPath.isTooDeep(tag, 0)) {
                        throw NbtPathArgument.ERROR_DATA_TOO_DEEP.create();
                    }
                    if (!(tag instanceof CompoundTag)) {
                        throw ERROR_EXPECTED_OBJECT.create((Object)tag);
                    }
                    CompoundTag compoundTag1 = (CompoundTag)tag;
                    compoundTag.merge(compoundTag1);
                }
                List<Tag> collection = nbtPath.getOrCreate(sourceCompoundTag, CompoundTag::new);
                int i = 0;
                for (Tag tag1 : collection) {
                    if (!(tag1 instanceof CompoundTag)) {
                        throw ERROR_EXPECTED_OBJECT.create((Object)tag1);
                    }
                    CompoundTag compoundTag2 = (CompoundTag)tag1;
                    CompoundTag compoundTag3 = compoundTag2.copy();
                    compoundTag2.merge(compoundTag);
                    i += compoundTag3.equals(compoundTag2) ? 0 : 1;
                }
                return i;
            })))));
        }
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)literalArgumentBuilder);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getAsText(Tag tag) throws CommandSyntaxException {
        Tag tag2 = tag;
        Objects.requireNonNull(tag2);
        Tag tag3 = tag2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{StringTag.class, PrimitiveTag.class}, (Object)tag3, n)) {
            case 0: {
                String string;
                StringTag stringTag = (StringTag)tag3;
                try {
                    String string2;
                    String var7;
                    string = var7 = (string2 = stringTag.value());
                    return string;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            case 1: {
                PrimitiveTag primitiveTag = (PrimitiveTag)tag3;
                String string = primitiveTag.toString();
                return string;
            }
        }
        throw ERROR_EXPECTED_VALUE.create((Object)tag);
    }

    private static List<Tag> stringifyTagList(List<Tag> tagList, StringProcessor processor) throws CommandSyntaxException {
        ArrayList<Tag> list = new ArrayList<Tag>(tagList.size());
        for (Tag tag : tagList) {
            String asText = DataCommands.getAsText(tag);
            list.add(StringTag.valueOf(processor.process(asText)));
        }
        return list;
    }

    private static ArgumentBuilder<CommandSourceStack, ?> decorateModification(BiConsumer<ArgumentBuilder<CommandSourceStack, ?>, DataManipulatorDecorator> decorator) {
        LiteralArgumentBuilder<CommandSourceStack> literalArgumentBuilder = Commands.literal("modify");
        for (DataProvider dataProvider : TARGET_PROVIDERS) {
            dataProvider.wrap((ArgumentBuilder<CommandSourceStack, ?>)literalArgumentBuilder, argumentBuilder -> {
                RequiredArgumentBuilder<CommandSourceStack, NbtPathArgument.NbtPath> argumentBuilder1 = Commands.argument("targetPath", NbtPathArgument.nbtPath());
                for (DataProvider dataProvider1 : SOURCE_PROVIDERS) {
                    decorator.accept((ArgumentBuilder<CommandSourceStack, ?>)argumentBuilder1, dataManipulator -> dataProvider1.wrap((ArgumentBuilder<CommandSourceStack, ?>)Commands.literal("from"), subArgBuilder -> ((ArgumentBuilder)subArgBuilder.executes(context -> DataCommands.manipulateData((CommandContext<CommandSourceStack>)context, dataProvider, dataManipulator, DataCommands.getSingletonSource((CommandContext<CommandSourceStack>)context, dataProvider1)))).then(Commands.argument("sourcePath", NbtPathArgument.nbtPath()).executes(context -> DataCommands.manipulateData((CommandContext<CommandSourceStack>)context, dataProvider, dataManipulator, DataCommands.resolveSourcePath((CommandContext<CommandSourceStack>)context, dataProvider1))))));
                    decorator.accept((ArgumentBuilder<CommandSourceStack, ?>)argumentBuilder1, dataManipulator -> dataProvider1.wrap((ArgumentBuilder<CommandSourceStack, ?>)Commands.literal("string"), subArgBuilder -> ((ArgumentBuilder)subArgBuilder.executes(context -> DataCommands.manipulateData((CommandContext<CommandSourceStack>)context, dataProvider, dataManipulator, DataCommands.stringifyTagList(DataCommands.getSingletonSource((CommandContext<CommandSourceStack>)context, dataProvider1), tagString -> tagString)))).then(((RequiredArgumentBuilder)Commands.argument("sourcePath", NbtPathArgument.nbtPath()).executes(context -> DataCommands.manipulateData((CommandContext<CommandSourceStack>)context, dataProvider, dataManipulator, DataCommands.stringifyTagList(DataCommands.resolveSourcePath((CommandContext<CommandSourceStack>)context, dataProvider1), tagString -> tagString)))).then(((RequiredArgumentBuilder)Commands.argument("start", IntegerArgumentType.integer()).executes(context -> DataCommands.manipulateData((CommandContext<CommandSourceStack>)context, dataProvider, dataManipulator, DataCommands.stringifyTagList(DataCommands.resolveSourcePath((CommandContext<CommandSourceStack>)context, dataProvider1), tagString -> DataCommands.substring(tagString, IntegerArgumentType.getInteger((CommandContext)context, (String)"start")))))).then(Commands.argument("end", IntegerArgumentType.integer()).executes(context -> DataCommands.manipulateData((CommandContext<CommandSourceStack>)context, dataProvider, dataManipulator, DataCommands.stringifyTagList(DataCommands.resolveSourcePath((CommandContext<CommandSourceStack>)context, dataProvider1), tagString -> DataCommands.substring(tagString, IntegerArgumentType.getInteger((CommandContext)context, (String)"start"), IntegerArgumentType.getInteger((CommandContext)context, (String)"end"))))))))));
                }
                decorator.accept((ArgumentBuilder<CommandSourceStack, ?>)argumentBuilder1, dataManipulator -> Commands.literal("value").then(Commands.argument("value", NbtTagArgument.nbtTag()).executes(context -> {
                    List<Tag> list = Collections.singletonList(NbtTagArgument.getNbtTag(context, "value"));
                    return DataCommands.manipulateData((CommandContext<CommandSourceStack>)context, dataProvider, dataManipulator, list);
                })));
                return argumentBuilder.then(argumentBuilder1);
            });
        }
        return literalArgumentBuilder;
    }

    private static String validatedSubstring(String source, int start, int end) throws CommandSyntaxException {
        if (start >= 0 && end <= source.length() && start <= end) {
            return source.substring(start, end);
        }
        throw ERROR_INVALID_SUBSTRING.create((Object)start, (Object)end);
    }

    private static String substring(String source, int start, int end) throws CommandSyntaxException {
        int len = source.length();
        int offset = DataCommands.getOffset(start, len);
        int offset1 = DataCommands.getOffset(end, len);
        return DataCommands.validatedSubstring(source, offset, offset1);
    }

    private static String substring(String source, int start) throws CommandSyntaxException {
        int len = source.length();
        return DataCommands.validatedSubstring(source, DataCommands.getOffset(start, len), len);
    }

    private static int getOffset(int index, int length) {
        return index >= 0 ? index : length + index;
    }

    private static List<Tag> getSingletonSource(CommandContext<CommandSourceStack> context, DataProvider dataProvider) throws CommandSyntaxException {
        DataAccessor dataAccessor = dataProvider.access(context);
        return Collections.singletonList(dataAccessor.getData());
    }

    private static List<Tag> resolveSourcePath(CommandContext<CommandSourceStack> context, DataProvider dataProvider) throws CommandSyntaxException {
        DataAccessor dataAccessor = dataProvider.access(context);
        NbtPathArgument.NbtPath path = NbtPathArgument.getPath(context, "sourcePath");
        return path.get(dataAccessor.getData());
    }

    private static int manipulateData(CommandContext<CommandSourceStack> source, DataProvider dataProvider, DataManipulator dataManipulator, List<Tag> tags) throws CommandSyntaxException {
        DataAccessor dataAccessor = dataProvider.access(source);
        NbtPathArgument.NbtPath path = NbtPathArgument.getPath(source, "targetPath");
        CompoundTag data = dataAccessor.getData();
        int i = dataManipulator.modify(source, data, path, tags);
        if (i == 0) {
            throw ERROR_MERGE_UNCHANGED.create();
        }
        dataAccessor.setData(data);
        ((CommandSourceStack)source.getSource()).sendSuccess(() -> dataAccessor.getModifiedSuccess(), true);
        return i;
    }

    private static int removeData(CommandSourceStack source, DataAccessor accessor, NbtPathArgument.NbtPath path) throws CommandSyntaxException {
        CompoundTag data = accessor.getData();
        int i = path.remove(data);
        if (i == 0) {
            throw ERROR_MERGE_UNCHANGED.create();
        }
        accessor.setData(data);
        source.sendSuccess(() -> accessor.getModifiedSuccess(), true);
        return i;
    }

    public static Tag getSingleTag(NbtPathArgument.NbtPath path, DataAccessor accessor) throws CommandSyntaxException {
        List<Tag> collection = path.get(accessor.getData());
        Iterator iterator = collection.iterator();
        Tag tag = (Tag)iterator.next();
        if (iterator.hasNext()) {
            throw ERROR_MULTIPLE_TAGS.create();
        }
        return tag;
    }

    /*
     * Loose catch block
     */
    private static int getData(CommandSourceStack source, DataAccessor accessor, NbtPathArgument.NbtPath path) throws CommandSyntaxException {
        Tag singleTag;
        Tag tag = singleTag = DataCommands.getSingleTag(path, accessor);
        Objects.requireNonNull(tag);
        Tag tag2 = tag;
        int n = 0;
        int i = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{NumericTag.class, CollectionTag.class, CompoundTag.class, StringTag.class, EndTag.class}, (Object)tag2, n)) {
            case 0 -> {
                NumericTag numericTag = (NumericTag)tag2;
                yield Mth.floor(numericTag.doubleValue());
            }
            case 1 -> {
                CollectionTag collectionTag = (CollectionTag)tag2;
                yield collectionTag.size();
            }
            case 2 -> {
                CompoundTag compoundTag = (CompoundTag)tag2;
                yield compoundTag.size();
            }
            case 3 -> {
                String var12_11;
                StringTag var10_10 = (StringTag)tag2;
                String var14 = var12_11 = var10_10.value();
                yield var14.length();
            }
            case 4 -> {
                EndTag endTag = (EndTag)tag2;
                throw ERROR_GET_NON_EXISTENT.create((Object)path.toString());
            }
            default -> throw new MatchException(null, null);
        };
        source.sendSuccess(() -> accessor.getPrintSuccess(singleTag), false);
        return i;
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    private static int getNumeric(CommandSourceStack source, DataAccessor accessor, NbtPathArgument.NbtPath path, double scale) throws CommandSyntaxException {
        Tag singleTag = DataCommands.getSingleTag(path, accessor);
        if (!(singleTag instanceof NumericTag)) {
            throw ERROR_GET_NOT_NUMBER.create((Object)path.toString());
        }
        int floor = Mth.floor(((NumericTag)singleTag).doubleValue() * scale);
        source.sendSuccess(() -> accessor.getPrintSuccess(path, scale, floor), false);
        return floor;
    }

    private static int getData(CommandSourceStack source, DataAccessor accessor) throws CommandSyntaxException {
        CompoundTag data = accessor.getData();
        source.sendSuccess(() -> accessor.getPrintSuccess(data), false);
        return 1;
    }

    private static int mergeData(CommandSourceStack source, DataAccessor accessor, CompoundTag nbt) throws CommandSyntaxException {
        CompoundTag data = accessor.getData();
        if (NbtPathArgument.NbtPath.isTooDeep(nbt, 0)) {
            throw NbtPathArgument.ERROR_DATA_TOO_DEEP.create();
        }
        CompoundTag compoundTag = data.copy().merge(nbt);
        if (data.equals(compoundTag)) {
            throw ERROR_MERGE_UNCHANGED.create();
        }
        accessor.setData(compoundTag);
        source.sendSuccess(() -> accessor.getModifiedSuccess(), true);
        return 1;
    }

    public static interface DataProvider {
        public DataAccessor access(CommandContext<CommandSourceStack> var1) throws CommandSyntaxException;

        public ArgumentBuilder<CommandSourceStack, ?> wrap(ArgumentBuilder<CommandSourceStack, ?> var1, Function<ArgumentBuilder<CommandSourceStack, ?>, ArgumentBuilder<CommandSourceStack, ?>> var2);
    }

    @FunctionalInterface
    static interface StringProcessor {
        public String process(String var1) throws CommandSyntaxException;
    }

    @FunctionalInterface
    static interface DataManipulator {
        public int modify(CommandContext<CommandSourceStack> var1, CompoundTag var2, NbtPathArgument.NbtPath var3, List<Tag> var4) throws CommandSyntaxException;
    }

    @FunctionalInterface
    static interface DataManipulatorDecorator {
        public ArgumentBuilder<CommandSourceStack, ?> create(DataManipulator var1);
    }
}

