/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import ca.spottedleaf.moonrise.patches.chunk_system.ticket.ChunkSystemTicket;
import ca.spottedleaf.moonrise.patches.chunk_system.ticket.ChunkSystemTicketType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Comparator;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.ExtraCodecs;

public class Ticket<T>
implements Comparable<Ticket>,
ChunkSystemTicket<T> {
    public static final MapCodec<Ticket> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.TICKET_TYPE.byNameCodec().fieldOf("type").forGetter(Ticket::getType), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("level").forGetter(Ticket::getTicketLevel), (App)Codec.LONG.optionalFieldOf("ticks_left", (Object)0L).forGetter(ticket -> ticket.ticksLeft)).apply((Applicative)instance, (type, level, ticks) -> new Ticket((TicketType)type, (int)level, (long)ticks)));
    private final TicketType type;
    private final int ticketLevel;
    private long ticksLeft;
    private T identifier;

    public Object getIdentifier() {
        return this.identifier;
    }

    @Override
    public final long moonrise$getRemoveDelay() {
        return this.ticksLeft;
    }

    @Override
    public final void moonrise$setRemoveDelay(long removeDelay) {
        this.ticksLeft = removeDelay;
    }

    @Override
    public final T moonrise$getIdentifier() {
        return this.identifier;
    }

    @Override
    public final void moonrise$setIdentifier(T identifier) {
        if (identifier == null != (((ChunkSystemTicketType)this.type).moonrise$getIdentifierComparator() == null)) {
            throw new IllegalStateException("Nullability of identifier should match nullability of comparator");
        }
        this.identifier = identifier;
    }

    @Override
    public final int compareTo(Ticket ticket) {
        int levelCompare = Integer.compare(this.ticketLevel, ticket.ticketLevel);
        if (levelCompare != 0) {
            return levelCompare;
        }
        int typeCompare = Long.compare(((ChunkSystemTicketType)this.type).moonrise$getId(), ((ChunkSystemTicketType)ticket.type).moonrise$getId());
        if (typeCompare != 0) {
            return typeCompare;
        }
        Comparator<T> comparator = ((ChunkSystemTicketType)this.type).moonrise$getIdentifierComparator();
        return comparator == null ? 0 : comparator.compare(this.identifier, ticket.identifier);
    }

    public Ticket(TicketType type, int ticketLevel) {
        this(type, ticketLevel, null);
    }

    public Ticket(TicketType type, int ticketLevel, Object identifier) {
        this(type, ticketLevel, type.timeout(), identifier);
    }

    public Ticket(TicketType type, int ticketLevel, long ticksLeft) {
        this(type, ticketLevel, ticksLeft, null);
    }

    private Ticket(TicketType type, int ticketLevel, long ticksLeft, Object identifier) {
        this.identifier = identifier;
        this.type = type;
        this.ticketLevel = ticketLevel;
        this.ticksLeft = ticksLeft;
    }

    public String toString() {
        return "Ticket[" + String.valueOf(this.type) + " " + this.ticketLevel + " (" + String.valueOf(this.identifier) + ")] to die in " + this.ticksLeft;
    }

    public TicketType getType() {
        return this.type;
    }

    public int getTicketLevel() {
        return this.ticketLevel;
    }

    public void resetTicksLeft() {
        this.ticksLeft = this.type.timeout();
    }

    public void decreaseTicksLeft() {
        if (this.type.hasTimeout()) {
            --this.ticksLeft;
        }
    }

    public boolean isTimedOut() {
        return this.type.hasTimeout() && this.ticksLeft < 0L;
    }
}

