/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import ca.spottedleaf.moonrise.common.PlatformHooks;
import ca.spottedleaf.moonrise.patches.chunk_system.ticket.ChunkSystemTicketType;
import java.util.Comparator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;

public final class TicketType<T>
implements ChunkSystemTicketType<T> {
    private static final AtomicLong ID_GENERATOR = new AtomicLong();
    private final long id = ID_GENERATOR.getAndIncrement();
    private Comparator<T> identifierComparator;
    private volatile long[] counterTypes;
    public static final long NO_TIMEOUT = 0L;
    public static final TicketType START = TicketType.register("start", 0L, false, TicketUse.LOADING_AND_SIMULATION);
    public static final TicketType DRAGON = TicketType.register("dragon", 0L, false, TicketUse.LOADING_AND_SIMULATION);
    public static final TicketType PLAYER_LOADING = TicketType.register("player_loading", 0L, false, TicketUse.LOADING);
    public static final TicketType PLAYER_SIMULATION = TicketType.register("player_simulation", 0L, false, TicketUse.SIMULATION);
    public static final TicketType FORCED = TicketType.register("forced", 0L, true, TicketUse.LOADING_AND_SIMULATION);
    public static final TicketType PORTAL = TicketType.register("portal", 300L, true, TicketUse.LOADING_AND_SIMULATION);
    public static final TicketType ENDER_PEARL = TicketType.register("ender_pearl", 40L, false, TicketUse.LOADING_AND_SIMULATION);
    public static final TicketType UNKNOWN = TicketType.register("unknown", 1L, false, TicketUse.LOADING);
    public static final TicketType PLUGIN = TicketType.register("plugin", 0L, false, TicketUse.LOADING_AND_SIMULATION);
    public static final TicketType POST_TELEPORT = TicketType.register("post_teleport", 5L, false, TicketUse.LOADING_AND_SIMULATION);
    public static final TicketType PLUGIN_TICKET = TicketType.register("plugin_ticket", 0L, false, TicketUse.LOADING_AND_SIMULATION);
    public static final TicketType FUTURE_AWAIT;
    public static final TicketType CHUNK_LOAD;
    private final long timeout;
    private final boolean persist;
    private final TicketUse use;
    public static int PLUGIN_TYPE_TIMEOUT;

    @Override
    public final long moonrise$getId() {
        return this.id;
    }

    @Override
    public final Comparator<T> moonrise$getIdentifierComparator() {
        return this.identifierComparator;
    }

    @Override
    public final void moonrise$setIdentifierComparator(Comparator<T> comparator) {
        this.identifierComparator = comparator;
    }

    @Override
    public final long[] moonrise$getCounterTypes() {
        long[] types = this.counterTypes;
        if (types != null) {
            return types;
        }
        this.counterTypes = PlatformHooks.get().getCounterTypesUncached(this);
        return this.counterTypes;
    }

    public static TicketType register(String name, long timeout, boolean persist, TicketUse use) {
        return Registry.register(BuiltInRegistries.TICKET_TYPE, name, new TicketType(timeout, persist, use));
    }

    public TicketType(long timeout, boolean persist, TicketUse use) {
        this.timeout = timeout;
        this.persist = persist;
        this.use = use;
    }

    public boolean persist() {
        return this.persist;
    }

    public TicketUse use() {
        return this.use;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        TicketType that = (TicketType)obj;
        return this.timeout == that.timeout && this.persist == that.persist && Objects.equals((Object)this.use, (Object)that.use);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.timeout, this.persist, this.use});
    }

    public String toString() {
        return "TicketType[timeout=" + this.timeout + ", persist=" + this.persist + ", use=" + String.valueOf((Object)this.use) + "]";
    }

    public long timeout() {
        return this == PLUGIN ? (long)PLUGIN_TYPE_TIMEOUT : this.timeout;
    }

    public boolean doesLoad() {
        return this.use == TicketUse.LOADING || this.use == TicketUse.LOADING_AND_SIMULATION;
    }

    public boolean doesSimulate() {
        return this.use == TicketUse.SIMULATION || this.use == TicketUse.LOADING_AND_SIMULATION;
    }

    public boolean hasTimeout() {
        return this.timeout() != 0L;
    }

    static {
        PLUGIN_TICKET.moonrise$setIdentifierComparator((p1, p2) -> p1.getName().compareTo(p2.getName()));
        FUTURE_AWAIT = TicketType.register("future_await", 0L, false, TicketUse.LOADING_AND_SIMULATION);
        CHUNK_LOAD = TicketType.register("chunk_load", 0L, false, TicketUse.LOADING);
        PLUGIN_TYPE_TIMEOUT = 600;
    }

    public static enum TicketUse {
        LOADING,
        SIMULATION,
        LOADING_AND_SIMULATION;

    }
}

