/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import io.netty.buffer.Unpooled;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.annotation.DoNotUse;
import io.papermc.paper.configuration.GlobalConfiguration;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.resource.ResourcePackCallback;
import net.kyori.adventure.resource.ResourcePackStatus;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.network.Connection;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.DisconnectionDetails;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketUtils;
import net.minecraft.network.protocol.common.ClientboundDisconnectPacket;
import net.minecraft.network.protocol.common.ClientboundKeepAlivePacket;
import net.minecraft.network.protocol.common.ServerCommonPacketListener;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.ServerboundKeepAlivePacket;
import net.minecraft.network.protocol.common.ServerboundPongPacket;
import net.minecraft.network.protocol.common.ServerboundResourcePackPacket;
import net.minecraft.network.protocol.common.custom.BrandPayload;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.common.custom.DiscardedPayload;
import net.minecraft.network.protocol.cookie.ServerboundCookieResponsePacket;
import net.minecraft.network.protocol.game.ClientboundSetDefaultSpawnPositionPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.profiling.Profiler;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.util.CraftLocation;
import org.bukkit.craftbukkit.util.Waitable;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerResourcePackStatusEvent;
import org.slf4j.Logger;

public abstract class ServerCommonPacketListenerImpl
implements ServerCommonPacketListener,
CraftPlayer.TransferCookieConnection {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int LATENCY_CHECK_INTERVAL = 15000;
    private static final int CLOSED_LISTENER_TIMEOUT = 15000;
    private static final net.minecraft.network.chat.Component TIMEOUT_DISCONNECTION_MESSAGE = net.minecraft.network.chat.Component.translatable("disconnect.timeout");
    static final net.minecraft.network.chat.Component DISCONNECT_UNEXPECTED_QUERY = net.minecraft.network.chat.Component.translatable("multiplayer.disconnect.unexpected_query_response");
    protected final MinecraftServer server;
    public final Connection connection;
    private final boolean transferred;
    private long keepAliveTime = Util.getMillis();
    private boolean keepAlivePending;
    private long keepAliveChallenge;
    private long closedListenerTime;
    private boolean closed = false;
    private int latency;
    private volatile boolean suspendFlushingOnServerThread = false;
    protected final ServerPlayer player;
    protected final CraftServer cserver;
    public boolean processedDisconnect;
    public final Map<UUID, ResourcePackCallback> packCallbacks = new ConcurrentHashMap<UUID, ResourcePackCallback>();
    private static final long KEEPALIVE_LIMIT = Long.getLong("paper.playerconnection.keepalive", 30L) * 1000L;
    protected static final ResourceLocation MINECRAFT_BRAND = ResourceLocation.withDefaultNamespace("brand");
    public static final ResourceLocation CUSTOM_REGISTER = ResourceLocation.withDefaultNamespace("register");
    private static final ResourceLocation CUSTOM_UNREGISTER = ResourceLocation.withDefaultNamespace("unregister");

    public ServerCommonPacketListenerImpl(MinecraftServer server, Connection connection, CommonListenerCookie cookie, ServerPlayer player) {
        this.server = server;
        this.connection = connection;
        this.keepAliveTime = Util.getMillis();
        this.latency = cookie.latency();
        this.transferred = cookie.transferred();
        this.player = player;
        this.player.transferCookieConnection = this;
        this.cserver = server.server;
    }

    public CraftPlayer getCraftPlayer() {
        return this.player.getBukkitEntity();
    }

    @Override
    public boolean isTransferred() {
        return this.transferred;
    }

    @Override
    public ConnectionProtocol getProtocol() {
        return this.protocol();
    }

    @Override
    public void sendPacket(Packet<?> packet) {
        this.send(packet);
    }

    @Override
    public void kickPlayer(net.minecraft.network.chat.Component reason, PlayerKickEvent.Cause cause) {
        this.disconnect(reason, cause);
    }

    private void close() {
        if (!this.closed) {
            this.closedListenerTime = Util.getMillis();
            this.closed = true;
        }
    }

    @Override
    public void onDisconnect(DisconnectionDetails details) {
        this.onDisconnect(details, null);
    }

    public void onDisconnect(DisconnectionDetails details, @Nullable Component quitMessage) {
        if (this.isSingleplayerOwner()) {
            LOGGER.info("Stopping singleplayer server as player logged out");
            this.server.halt(false);
        }
    }

    @Override
    public void onPacketError(Packet packet, Exception exception) throws ReportedException {
        ServerCommonPacketListener.super.onPacketError(packet, exception);
        this.server.reportPacketHandlingException(exception, packet.type());
    }

    @Override
    public void handleKeepAlive(ServerboundKeepAlivePacket packet) {
        if (this.keepAlivePending && packet.getId() == this.keepAliveChallenge) {
            int i = (int)(Util.getMillis() - this.keepAliveTime);
            this.latency = (this.latency * 3 + i) / 4;
            this.keepAlivePending = false;
        } else if (!this.isSingleplayerOwner()) {
            this.disconnectAsync(TIMEOUT_DISCONNECTION_MESSAGE, PlayerKickEvent.Cause.TIMEOUT);
        }
    }

    @Override
    public void handlePong(ServerboundPongPacket packet) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handleCustomPayload(ServerboundCustomPayloadPacket packet) {
        Object brand;
        CustomPacketPayload customPacketPayload = packet.payload();
        if (customPacketPayload instanceof BrandPayload) {
            BrandPayload brandPayload = (BrandPayload)customPacketPayload;
            try {
                String string = brandPayload.brand();
                this.player.clientBrandName = brand = string;
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        }
        if (!((brand = packet.payload()) instanceof DiscardedPayload)) return;
        DiscardedPayload discardedPayload = (DiscardedPayload)brand;
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.serverLevel());
        ResourceLocation identifier = packet.payload().type().id();
        byte[] data = discardedPayload.data();
        try {
            boolean registerChannel = CUSTOM_REGISTER.equals(identifier);
            if (registerChannel || CUSTOM_UNREGISTER.equals(identifier)) {
                int startIndex = 0;
                int i = 0;
                while (true) {
                    if (i >= data.length) {
                        this.readChannelIdentifier(data, startIndex, data.length, registerChannel);
                        return;
                    }
                    byte b = data[i];
                    if (b == 0) {
                        this.readChannelIdentifier(data, startIndex, i, registerChannel);
                        startIndex = i + 1;
                    }
                    ++i;
                }
            }
            if (identifier.equals(MINECRAFT_BRAND)) {
                this.player.clientBrandName = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])data)).readUtf(256);
            }
            this.cserver.getMessenger().dispatchIncomingMessage((Player)this.player.getBukkitEntity(), identifier.toString(), data);
            return;
        }
        catch (Exception e) {
            ServerGamePacketListenerImpl.LOGGER.error("Couldn't handle custom payload on channel {}", (Object)identifier, (Object)e);
            this.disconnect(net.minecraft.network.chat.Component.literal("Invalid custom payload payload!"), PlayerKickEvent.Cause.INVALID_PAYLOAD);
            return;
        }
    }

    private void readChannelIdentifier(byte[] data, int from, int to, boolean register) {
        int length = to - from;
        if (length == 0) {
            return;
        }
        String channel = new String(data, from, length, StandardCharsets.US_ASCII);
        if (register) {
            this.getCraftPlayer().addChannel(channel);
        } else {
            this.getCraftPlayer().removeChannel(channel);
        }
    }

    public final boolean isDisconnected() {
        return !this.player.joining && !this.connection.isConnected() || this.processedDisconnect;
    }

    @Override
    public void handleResourcePackResponse(ServerboundResourcePackPacket packet) {
        PlayerResourcePackStatusEvent.Status packStatus;
        ResourcePackCallback callback;
        PacketUtils.ensureRunningOnSameThread(packet, this, this.server);
        if (packet.action() == ServerboundResourcePackPacket.Action.DECLINED && this.server.isResourcePackRequired()) {
            LOGGER.info("Disconnecting {} due to resource pack {} rejection", (Object)this.playerProfile().getName(), (Object)packet.id());
            this.disconnect(net.minecraft.network.chat.Component.translatable("multiplayer.requiredTexturePrompt.disconnect"), PlayerKickEvent.Cause.RESOURCE_PACK_REJECTION);
        }
        if ((callback = packet.action().isTerminal() ? this.packCallbacks.remove(packet.id()) : this.packCallbacks.get(packet.id())) != null) {
            callback.packEventReceived(packet.id(), ResourcePackStatus.valueOf((String)packet.action().name()), (Audience)this.getCraftPlayer());
        }
        this.player.getBukkitEntity().resourcePackStatus = packStatus = PlayerResourcePackStatusEvent.Status.values()[packet.action().ordinal()];
        this.cserver.getPluginManager().callEvent((Event)new PlayerResourcePackStatusEvent((Player)this.getCraftPlayer(), packet.id(), packStatus));
    }

    @Override
    public void handleCookieResponse(ServerboundCookieResponsePacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.server);
        if (this.player.getBukkitEntity().handleCookieResponse(packet)) {
            return;
        }
        this.disconnect(DISCONNECT_UNEXPECTED_QUERY, PlayerKickEvent.Cause.INVALID_COOKIE);
    }

    protected void keepConnectionAlive() {
        Profiler.get().push("keepAlive");
        long millis = Util.getMillis();
        long elapsedTime = millis - this.keepAliveTime;
        if (!this.isSingleplayerOwner() && elapsedTime >= 15000L) {
            if (this.keepAlivePending) {
                if (!this.processedDisconnect && elapsedTime >= KEEPALIVE_LIMIT) {
                    this.disconnect(TIMEOUT_DISCONNECTION_MESSAGE, PlayerKickEvent.Cause.TIMEOUT);
                }
            } else if (this.checkIfClosed(millis)) {
                this.keepAlivePending = true;
                this.keepAliveTime = millis;
                this.keepAliveChallenge = millis;
                this.send(new ClientboundKeepAlivePacket(this.keepAliveChallenge));
            }
        }
        Profiler.get().pop();
    }

    private boolean checkIfClosed(long time) {
        if (this.closed) {
            if (time - this.closedListenerTime >= 15000L) {
                this.disconnect(TIMEOUT_DISCONNECTION_MESSAGE, PlayerKickEvent.Cause.TIMEOUT);
            }
            return false;
        }
        return true;
    }

    public void suspendFlushing() {
        this.suspendFlushingOnServerThread = true;
    }

    public void resumeFlushing() {
        this.suspendFlushingOnServerThread = false;
        this.connection.flushChannel();
    }

    public void send(Packet<?> packet) {
        this.send(packet, null);
    }

    public void send(Packet<?> packet, @Nullable PacketSendListener listener) {
        if (packet == null || this.processedDisconnect) {
            return;
        }
        if (packet instanceof ClientboundSetDefaultSpawnPositionPacket) {
            ClientboundSetDefaultSpawnPositionPacket defaultSpawnPositionPacket = (ClientboundSetDefaultSpawnPositionPacket)packet;
            this.player.compassTarget = CraftLocation.toBukkit(defaultSpawnPositionPacket.getPos(), this.getCraftPlayer().getWorld());
        }
        if (packet.isTerminal()) {
            this.close();
        }
        boolean flag = !this.suspendFlushingOnServerThread || !this.server.isSameThread();
        try {
            this.connection.send(packet, listener, flag);
        }
        catch (Throwable var7) {
            CrashReport crashReport = CrashReport.forThrowable(var7, "Sending packet");
            CrashReportCategory crashReportCategory = crashReport.addCategory("Packet being sent");
            crashReportCategory.setDetail("Packet class", () -> packet.getClass().getCanonicalName());
            throw new ReportedException(crashReport);
        }
    }

    public void disconnect(Component reason) {
        this.disconnect(reason, PlayerKickEvent.Cause.UNKNOWN);
    }

    public void disconnect(Component reason, PlayerKickEvent.Cause cause) {
        this.disconnect(PaperAdventure.asVanilla(reason), cause);
    }

    @Deprecated
    @DoNotUse
    public void disconnect(net.minecraft.network.chat.Component reason) {
        this.disconnect(reason, PlayerKickEvent.Cause.UNKNOWN);
    }

    public void disconnect(net.minecraft.network.chat.Component reason, PlayerKickEvent.Cause cause) {
        this.disconnect(new DisconnectionDetails(reason), cause);
    }

    public void disconnect(final DisconnectionDetails disconnectionDetails, final PlayerKickEvent.Cause cause) {
        if (this.processedDisconnect) {
            return;
        }
        if (!this.cserver.isPrimaryThread()) {
            Waitable waitable = new Waitable(){

                protected Object evaluate() {
                    ServerCommonPacketListenerImpl.this.disconnect(disconnectionDetails, cause);
                    return null;
                }
            };
            this.server.processQueue.add(waitable);
            try {
                waitable.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
            return;
        }
        TranslatableComponent leaveMessage = Component.translatable((String)"multiplayer.player.left", (TextColor)NamedTextColor.YELLOW, (ComponentLike[])new ComponentLike[]{GlobalConfiguration.get().messages.useDisplayNameInQuitMessage ? this.player.getBukkitEntity().displayName() : Component.text((String)this.player.getScoreboardName())});
        PlayerKickEvent event = new PlayerKickEvent((Player)this.player.getBukkitEntity(), PaperAdventure.asAdventure(disconnectionDetails.reason()), (Component)leaveMessage, cause);
        if (this.cserver.getServer().isRunning()) {
            this.cserver.getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled()) {
            return;
        }
        switch (cause) {
            case FLYING_PLAYER: {
                LOGGER.warn("{} was kicked for floating too long!", (Object)this.player.getName().getString());
                break;
            }
            case FLYING_VEHICLE: {
                LOGGER.warn("{} was kicked for floating a vehicle too long!", (Object)this.player.getName().getString());
            }
        }
        this.disconnect0(new DisconnectionDetails(PaperAdventure.asVanilla(event.reason()), disconnectionDetails.report(), disconnectionDetails.bugReportLink()), event.leaveMessage());
    }

    private void disconnect0(DisconnectionDetails disconnectionDetails, @Nullable Component leaveMessage) {
        this.player.quitReason = PlayerQuitEvent.QuitReason.KICKED;
        this.connection.send(new ClientboundDisconnectPacket(disconnectionDetails.reason()), PacketSendListener.thenRun(() -> this.connection.disconnect(disconnectionDetails)));
        this.onDisconnect(disconnectionDetails, leaveMessage);
        this.connection.setReadOnly();
        this.server.scheduleOnMain(this.connection::handleDisconnection);
    }

    public void disconnectAsync(Component reason, PlayerKickEvent.Cause cause) {
        this.disconnectAsync(PaperAdventure.asVanilla(reason), cause);
    }

    public void disconnectAsync(net.minecraft.network.chat.Component reason, PlayerKickEvent.Cause cause) {
        this.disconnectAsync(new DisconnectionDetails(reason), cause);
    }

    public void disconnectAsync(DisconnectionDetails disconnectionInfo, PlayerKickEvent.Cause cause) {
        if (this.cserver.isPrimaryThread()) {
            this.disconnect(disconnectionInfo, cause);
            return;
        }
        this.connection.setReadOnly();
        this.server.scheduleOnMain(() -> {
            this.disconnect(disconnectionInfo, cause);
            if (this.player.quitReason == null) {
                this.connection.enableAutoRead();
            }
        });
    }

    protected boolean isSingleplayerOwner() {
        return this.server.isSingleplayerOwner(this.playerProfile());
    }

    protected abstract GameProfile playerProfile();

    @VisibleForDebug
    public GameProfile getOwner() {
        return this.playerProfile();
    }

    public int latency() {
        return this.latency;
    }

    protected CommonListenerCookie createCookie(ClientInformation clientInformation) {
        return new CommonListenerCookie(this.playerProfile(), this.latency, clientInformation, this.transferred);
    }
}

