/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceMetadata;
import org.slf4j.Logger;

public class FallbackResourceManager
implements ResourceManager {
    static final Logger LOGGER = LogUtils.getLogger();
    protected final List<PackEntry> fallbacks = Lists.newArrayList();
    private final PackType type;
    private final String namespace;

    public FallbackResourceManager(PackType type, String namespace) {
        this.type = type;
        this.namespace = namespace;
    }

    public void push(PackResources resources) {
        this.pushInternal(resources.packId(), resources, null);
    }

    public void push(PackResources resources, Predicate<ResourceLocation> filter) {
        this.pushInternal(resources.packId(), resources, filter);
    }

    public void pushFilterOnly(String name, Predicate<ResourceLocation> filter) {
        this.pushInternal(name, null, filter);
    }

    private void pushInternal(String name, @Nullable PackResources resources, @Nullable Predicate<ResourceLocation> filter) {
        this.fallbacks.add(new PackEntry(name, resources, filter));
    }

    @Override
    public Set<String> getNamespaces() {
        return ImmutableSet.of((Object)this.namespace);
    }

    @Override
    public Optional<Resource> getResource(ResourceLocation location) {
        for (int i = this.fallbacks.size() - 1; i >= 0; --i) {
            IoSupplier<InputStream> resource;
            PackEntry packEntry = this.fallbacks.get(i);
            PackResources packResources = packEntry.resources;
            if (packResources != null && (resource = packResources.getResource(this.type, location)) != null) {
                IoSupplier<ResourceMetadata> ioSupplier = this.createStackMetadataFinder(location, i);
                return Optional.of(FallbackResourceManager.createResource(packResources, location, resource, ioSupplier));
            }
            if (!packEntry.isFiltered(location)) continue;
            LOGGER.warn("Resource {} not found, but was filtered by pack {}", (Object)location, (Object)packEntry.name);
            return Optional.empty();
        }
        return Optional.empty();
    }

    private static Resource createResource(PackResources source, ResourceLocation location, IoSupplier<InputStream> streamSupplier, IoSupplier<ResourceMetadata> metadataSupplier) {
        return new Resource(source, FallbackResourceManager.wrapForDebug(location, source, streamSupplier), metadataSupplier);
    }

    private static IoSupplier<InputStream> wrapForDebug(ResourceLocation location, PackResources packResources, IoSupplier<InputStream> stream) {
        return LOGGER.isDebugEnabled() ? () -> new LeakedResourceWarningInputStream((InputStream)stream.get(), location, packResources.packId()) : stream;
    }

    @Override
    public List<Resource> getResourceStack(ResourceLocation location) {
        ResourceLocation metadataLocation = FallbackResourceManager.getMetadataLocation(location);
        ArrayList<Resource> list = new ArrayList<Resource>();
        boolean flag = false;
        String string = null;
        for (int i = this.fallbacks.size() - 1; i >= 0; --i) {
            IoSupplier<InputStream> resource;
            PackEntry packEntry = this.fallbacks.get(i);
            PackResources packResources = packEntry.resources;
            if (packResources != null && (resource = packResources.getResource(this.type, location)) != null) {
                IoSupplier<ResourceMetadata> ioSupplier = flag ? ResourceMetadata.EMPTY_SUPPLIER : () -> {
                    IoSupplier<InputStream> resource1 = packResources.getResource(this.type, metadataLocation);
                    return resource1 != null ? FallbackResourceManager.parseMetadata(resource1) : ResourceMetadata.EMPTY;
                };
                list.add(new Resource(packResources, resource, ioSupplier));
            }
            if (packEntry.isFiltered(location)) {
                string = packEntry.name;
                break;
            }
            if (!packEntry.isFiltered(metadataLocation)) continue;
            flag = true;
        }
        if (list.isEmpty() && string != null) {
            LOGGER.warn("Resource {} not found, but was filtered by pack {}", (Object)location, string);
        }
        return Lists.reverse(list);
    }

    private static boolean isMetadata(ResourceLocation location) {
        return location.getPath().endsWith(".mcmeta");
    }

    private static ResourceLocation getResourceLocationFromMetadata(ResourceLocation metadataResourceLocation) {
        String sub = metadataResourceLocation.getPath().substring(0, metadataResourceLocation.getPath().length() - ".mcmeta".length());
        return metadataResourceLocation.withPath(sub);
    }

    static ResourceLocation getMetadataLocation(ResourceLocation location) {
        return location.withPath(location.getPath() + ".mcmeta");
    }

    @Override
    public Map<ResourceLocation, Resource> listResources(String path, Predicate<ResourceLocation> filter) {
        record ResourceWithSourceAndIndex(PackResources packResources, IoSupplier<InputStream> resource, int packIndex) {
        }
        HashMap<ResourceLocation, ResourceWithSourceAndIndex> map = new HashMap<ResourceLocation, ResourceWithSourceAndIndex>();
        HashMap map1 = new HashMap();
        int size = this.fallbacks.size();
        for (int i = 0; i < size; ++i) {
            PackEntry packEntry = this.fallbacks.get(i);
            packEntry.filterAll(map.keySet());
            packEntry.filterAll(map1.keySet());
            PackResources packResources = packEntry.resources;
            if (packResources == null) continue;
            int i1 = i;
            packResources.listResources(this.type, this.namespace, path, (path1, inputStream) -> {
                if (FallbackResourceManager.isMetadata(path1)) {
                    if (filter.test(FallbackResourceManager.getResourceLocationFromMetadata(path1))) {
                        map1.put(path1, new ResourceWithSourceAndIndex(packResources, (IoSupplier<InputStream>)inputStream, i1));
                    }
                } else if (filter.test((ResourceLocation)path1)) {
                    map.put((ResourceLocation)path1, new ResourceWithSourceAndIndex(packResources, (IoSupplier<InputStream>)inputStream, i1));
                }
            });
        }
        TreeMap map2 = Maps.newTreeMap();
        map.forEach((path1, resource) -> {
            ResourceLocation metadataLocation = FallbackResourceManager.getMetadataLocation(path1);
            ResourceWithSourceAndIndex resourceWithSourceAndIndex = (ResourceWithSourceAndIndex)map1.get(metadataLocation);
            IoSupplier<ResourceMetadata> ioSupplier = resourceWithSourceAndIndex != null && resourceWithSourceAndIndex.packIndex >= resource.packIndex ? FallbackResourceManager.convertToMetadata(resourceWithSourceAndIndex.resource) : ResourceMetadata.EMPTY_SUPPLIER;
            map2.put(path1, FallbackResourceManager.createResource(resource.packResources, path1, resource.resource, ioSupplier));
        });
        return map2;
    }

    private IoSupplier<ResourceMetadata> createStackMetadataFinder(ResourceLocation location, int fallbackIndex) {
        return () -> {
            ResourceLocation metadataLocation = FallbackResourceManager.getMetadataLocation(location);
            for (int i = this.fallbacks.size() - 1; i >= fallbackIndex; --i) {
                IoSupplier<InputStream> resource;
                PackEntry packEntry = this.fallbacks.get(i);
                PackResources packResources = packEntry.resources;
                if (packResources != null && (resource = packResources.getResource(this.type, metadataLocation)) != null) {
                    return FallbackResourceManager.parseMetadata(resource);
                }
                if (packEntry.isFiltered(metadataLocation)) break;
            }
            return ResourceMetadata.EMPTY;
        };
    }

    private static IoSupplier<ResourceMetadata> convertToMetadata(IoSupplier<InputStream> streamSupplier) {
        return () -> FallbackResourceManager.parseMetadata(streamSupplier);
    }

    private static ResourceMetadata parseMetadata(IoSupplier<InputStream> streamSupplier) throws IOException {
        ResourceMetadata var2;
        try (InputStream inputStream = streamSupplier.get();){
            var2 = ResourceMetadata.fromJsonStream(inputStream);
        }
        return var2;
    }

    private static void applyPackFiltersToExistingResources(PackEntry packEntry, Map<ResourceLocation, EntryStack> resources) {
        for (EntryStack entryStack : resources.values()) {
            if (packEntry.isFiltered(entryStack.fileLocation)) {
                entryStack.fileSources.clear();
                continue;
            }
            if (!packEntry.isFiltered(entryStack.metadataLocation())) continue;
            entryStack.metaSources.clear();
        }
    }

    private void listPackResources(PackEntry entry, String path, Predicate<ResourceLocation> filter, Map<ResourceLocation, EntryStack> output) {
        PackResources packResources = entry.resources;
        if (packResources != null) {
            packResources.listResources(this.type, this.namespace, path, (path1, inputStream) -> {
                if (FallbackResourceManager.isMetadata(path1)) {
                    ResourceLocation resourceLocationFromMetadata = FallbackResourceManager.getResourceLocationFromMetadata(path1);
                    if (!filter.test(resourceLocationFromMetadata)) {
                        return;
                    }
                    output.computeIfAbsent(resourceLocationFromMetadata, (Function<ResourceLocation, EntryStack>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(net.minecraft.resources.ResourceLocation ), (Lnet/minecraft/resources/ResourceLocation;)Lnet/minecraft/server/packs/resources/FallbackResourceManager$EntryStack;)()).metaSources.put(packResources, (IoSupplier<InputStream>)inputStream);
                } else {
                    if (!filter.test((ResourceLocation)path1)) {
                        return;
                    }
                    output.computeIfAbsent(path1, (Function<ResourceLocation, EntryStack>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(net.minecraft.resources.ResourceLocation ), (Lnet/minecraft/resources/ResourceLocation;)Lnet/minecraft/server/packs/resources/FallbackResourceManager$EntryStack;)()).fileSources.add(new ResourceWithSource(packResources, (IoSupplier<InputStream>)inputStream));
                }
            });
        }
    }

    @Override
    public Map<ResourceLocation, List<Resource>> listResourceStacks(String path, Predicate<ResourceLocation> filter) {
        HashMap map = Maps.newHashMap();
        for (PackEntry packEntry : this.fallbacks) {
            FallbackResourceManager.applyPackFiltersToExistingResources(packEntry, map);
            this.listPackResources(packEntry, path, filter, map);
        }
        TreeMap map1 = Maps.newTreeMap();
        for (EntryStack entryStack : map.values()) {
            if (entryStack.fileSources.isEmpty()) continue;
            ArrayList<Resource> list = new ArrayList<Resource>();
            for (ResourceWithSource resourceWithSource : entryStack.fileSources) {
                PackResources packResources = resourceWithSource.source;
                IoSupplier<InputStream> ioSupplier = entryStack.metaSources.get(packResources);
                IoSupplier<ResourceMetadata> ioSupplier1 = ioSupplier != null ? FallbackResourceManager.convertToMetadata(ioSupplier) : ResourceMetadata.EMPTY_SUPPLIER;
                list.add(FallbackResourceManager.createResource(packResources, entryStack.fileLocation, resourceWithSource.resource, ioSupplier1));
            }
            map1.put(entryStack.fileLocation, list);
        }
        return map1;
    }

    @Override
    public Stream<PackResources> listPacks() {
        return this.fallbacks.stream().map(fallback -> fallback.resources).filter(Objects::nonNull);
    }

    record PackEntry(String name, @Nullable PackResources resources, @Nullable Predicate<ResourceLocation> filter) {
        public void filterAll(Collection<ResourceLocation> locations) {
            if (this.filter != null) {
                locations.removeIf(this.filter);
            }
        }

        public boolean isFiltered(ResourceLocation location) {
            return this.filter != null && this.filter.test(location);
        }
    }

    record EntryStack(ResourceLocation fileLocation, ResourceLocation metadataLocation, List<ResourceWithSource> fileSources, Map<PackResources, IoSupplier<InputStream>> metaSources) {
        EntryStack(ResourceLocation fileLocation) {
            this(fileLocation, FallbackResourceManager.getMetadataLocation(fileLocation), new ArrayList<ResourceWithSource>(), (Map<PackResources, IoSupplier<InputStream>>)new Object2ObjectArrayMap());
        }
    }

    record ResourceWithSource(PackResources source, IoSupplier<InputStream> resource) {
    }

    static class LeakedResourceWarningInputStream
    extends FilterInputStream {
        private final Supplier<String> message;
        private boolean closed;

        public LeakedResourceWarningInputStream(InputStream inputStream, ResourceLocation resourceLocation, String packName) {
            super(inputStream);
            Exception exception = new Exception("Stacktrace");
            this.message = () -> {
                StringWriter stringWriter = new StringWriter();
                exception.printStackTrace(new PrintWriter(stringWriter));
                return "Leaked resource: '" + String.valueOf(resourceLocation) + "' loaded from pack: '" + packName + "'\n" + String.valueOf(stringWriter);
            };
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.closed = true;
        }

        protected void finalize() throws Throwable {
            if (!this.closed) {
                LOGGER.warn("{}", (Object)this.message.get());
            }
            super.finalize();
        }
    }
}

