/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.destroystokyo.paper.exception.ServerInternalException;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.ProfileLookupCallback;
import com.mojang.authlib.yggdrasil.ProfileNotFoundException;
import com.mojang.logging.LogUtils;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.util.StacktraceDeobfuscator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.players.BanListEntry;
import net.minecraft.server.players.IpBanList;
import net.minecraft.server.players.IpBanListEntry;
import net.minecraft.server.players.PlayerList;
import net.minecraft.server.players.ServerOpList;
import net.minecraft.server.players.ServerOpListEntry;
import net.minecraft.server.players.UserBanList;
import net.minecraft.server.players.UserBanListEntry;
import net.minecraft.server.players.UserWhiteList;
import net.minecraft.server.players.UserWhiteListEntry;
import net.minecraft.util.StringUtil;
import net.minecraft.world.level.storage.LevelResource;
import org.slf4j.Logger;

public class OldUsersConverter {
    static final Logger LOGGER = LogUtils.getLogger();
    public static final File OLD_IPBANLIST = new File("banned-ips.txt");
    public static final File OLD_USERBANLIST = new File("banned-players.txt");
    public static final File OLD_OPLIST = new File("ops.txt");
    public static final File OLD_WHITELIST = new File("white-list.txt");

    static List<String> readOldListFormat(File inFile, Map<String, String[]> read) throws IOException {
        List lines = Files.readLines((File)inFile, (Charset)StandardCharsets.UTF_8);
        for (String string : lines) {
            if ((string = string.trim()).startsWith("#") || string.length() < 1) continue;
            String[] parts = string.split("\\|");
            read.put(parts[0].toLowerCase(Locale.ROOT), parts);
        }
        return lines;
    }

    private static void lookupPlayers(MinecraftServer server, Collection<String> names, ProfileLookupCallback callback) {
        String[] strings = (String[])names.stream().filter(name -> !StringUtil.isNullOrEmpty(name)).toArray(String[]::new);
        if (server.usesAuthentication() || GlobalConfiguration.get().proxies.isProxyOnlineMode()) {
            server.getProfileRepository().findProfilesByNames(strings, callback);
        } else {
            for (String string : strings) {
                callback.onProfileLookupSucceeded(UUIDUtil.createOfflineProfile(string));
            }
        }
    }

    public static boolean convertUserBanlist(final MinecraftServer server) {
        final UserBanList userBanList = new UserBanList(PlayerList.USERBANLIST_FILE);
        if (OLD_USERBANLIST.exists() && OLD_USERBANLIST.isFile()) {
            if (userBanList.getFile().exists()) {
                try {
                    userBanList.load();
                }
                catch (IOException var6) {
                    LOGGER.warn("Could not load existing file {}", (Object)userBanList.getFile().getName());
                }
            }
            try {
                final HashMap map = Maps.newHashMap();
                OldUsersConverter.readOldListFormat(OLD_USERBANLIST, map);
                ProfileLookupCallback profileLookupCallback = new ProfileLookupCallback(){

                    public void onProfileLookupSucceeded(GameProfile gameProfile) {
                        server.getProfileCache().add(gameProfile);
                        String[] strings = (String[])map.get(gameProfile.getName().toLowerCase(Locale.ROOT));
                        if (strings == null) {
                            LOGGER.warn("Could not convert user banlist entry for {}", (Object)gameProfile.getName());
                            throw new ConversionError("Profile not in the conversionlist");
                        }
                        Date date = strings.length > 1 ? OldUsersConverter.parseDate(strings[1], null) : null;
                        String string = strings.length > 2 ? strings[2] : null;
                        Date date1 = strings.length > 3 ? OldUsersConverter.parseDate(strings[3], null) : null;
                        String string1 = strings.length > 4 ? strings[4] : null;
                        userBanList.add(new UserBanListEntry(gameProfile, date, string, date1, string1));
                    }

                    public void onProfileLookupFailed(String profileName, Exception exception) {
                        LOGGER.warn("Could not lookup user banlist entry for {}", (Object)profileName, (Object)exception);
                        if (!(exception instanceof ProfileNotFoundException)) {
                            throw new ConversionError("Could not request user " + profileName + " from backend systems", exception);
                        }
                    }
                };
                OldUsersConverter.lookupPlayers(server, map.keySet(), profileLookupCallback);
                userBanList.save();
                OldUsersConverter.renameOldFile(OLD_USERBANLIST);
                return true;
            }
            catch (IOException var4) {
                LOGGER.warn("Could not read old user banlist to convert it!", (Throwable)var4);
                return false;
            }
            catch (ConversionError var5) {
                LOGGER.error("Conversion failed, please try again later", (Throwable)var5);
                return false;
            }
        }
        return true;
    }

    public static boolean convertIpBanlist(MinecraftServer server) {
        IpBanList ipBanList = new IpBanList(PlayerList.IPBANLIST_FILE);
        if (OLD_IPBANLIST.exists() && OLD_IPBANLIST.isFile()) {
            if (ipBanList.getFile().exists()) {
                try {
                    ipBanList.load();
                }
                catch (IOException var11) {
                    LOGGER.warn("Could not load existing file {}", (Object)ipBanList.getFile().getName());
                }
            }
            try {
                HashMap map = Maps.newHashMap();
                OldUsersConverter.readOldListFormat(OLD_IPBANLIST, map);
                for (String string : map.keySet()) {
                    String[] strings = (String[])map.get(string);
                    Date date = strings.length > 1 ? OldUsersConverter.parseDate(strings[1], null) : null;
                    String string1 = strings.length > 2 ? strings[2] : null;
                    Date date1 = strings.length > 3 ? OldUsersConverter.parseDate(strings[3], null) : null;
                    String string2 = strings.length > 4 ? strings[4] : null;
                    ipBanList.add(new IpBanListEntry(string, date, string1, date1, string2));
                }
                ipBanList.save();
                OldUsersConverter.renameOldFile(OLD_IPBANLIST);
                return true;
            }
            catch (IOException var10) {
                LOGGER.warn("Could not parse old ip banlist to convert it!", (Throwable)var10);
                return false;
            }
        }
        return true;
    }

    public static boolean convertOpsList(final MinecraftServer server) {
        final ServerOpList serverOpList = new ServerOpList(PlayerList.OPLIST_FILE);
        if (OLD_OPLIST.exists() && OLD_OPLIST.isFile()) {
            if (serverOpList.getFile().exists()) {
                try {
                    serverOpList.load();
                }
                catch (IOException var6) {
                    LOGGER.warn("Could not load existing file {}", (Object)serverOpList.getFile().getName());
                }
            }
            try {
                List lines = Files.readLines((File)OLD_OPLIST, (Charset)StandardCharsets.UTF_8);
                ProfileLookupCallback profileLookupCallback = new ProfileLookupCallback(){

                    public void onProfileLookupSucceeded(GameProfile gameProfile) {
                        server.getProfileCache().add(gameProfile);
                        serverOpList.add(new ServerOpListEntry(gameProfile, server.getOperatorUserPermissionLevel(), false));
                    }

                    public void onProfileLookupFailed(String profileName, Exception exception) {
                        LOGGER.warn("Could not lookup oplist entry for {}", (Object)profileName, (Object)exception);
                        if (!(exception instanceof ProfileNotFoundException)) {
                            throw new ConversionError("Could not request user " + profileName + " from backend systems", exception);
                        }
                    }
                };
                OldUsersConverter.lookupPlayers(server, lines, profileLookupCallback);
                serverOpList.save();
                OldUsersConverter.renameOldFile(OLD_OPLIST);
                return true;
            }
            catch (IOException var4) {
                LOGGER.warn("Could not read old oplist to convert it!", (Throwable)var4);
                return false;
            }
            catch (ConversionError var5) {
                LOGGER.error("Conversion failed, please try again later", (Throwable)var5);
                return false;
            }
        }
        return true;
    }

    public static boolean convertWhiteList(final MinecraftServer server) {
        final UserWhiteList userWhiteList = new UserWhiteList(PlayerList.WHITELIST_FILE);
        if (OLD_WHITELIST.exists() && OLD_WHITELIST.isFile()) {
            if (userWhiteList.getFile().exists()) {
                try {
                    userWhiteList.load();
                }
                catch (IOException var6) {
                    LOGGER.warn("Could not load existing file {}", (Object)userWhiteList.getFile().getName());
                }
            }
            try {
                List lines = Files.readLines((File)OLD_WHITELIST, (Charset)StandardCharsets.UTF_8);
                ProfileLookupCallback profileLookupCallback = new ProfileLookupCallback(){

                    public void onProfileLookupSucceeded(GameProfile gameProfile) {
                        server.getProfileCache().add(gameProfile);
                        userWhiteList.add(new UserWhiteListEntry(gameProfile));
                    }

                    public void onProfileLookupFailed(String profileName, Exception exception) {
                        LOGGER.warn("Could not lookup user whitelist entry for {}", (Object)profileName, (Object)exception);
                        if (!(exception instanceof ProfileNotFoundException)) {
                            throw new ConversionError("Could not request user " + profileName + " from backend systems", exception);
                        }
                    }
                };
                OldUsersConverter.lookupPlayers(server, lines, profileLookupCallback);
                userWhiteList.save();
                OldUsersConverter.renameOldFile(OLD_WHITELIST);
                return true;
            }
            catch (IOException var4) {
                LOGGER.warn("Could not read old whitelist to convert it!", (Throwable)var4);
                return false;
            }
            catch (ConversionError var5) {
                LOGGER.error("Conversion failed, please try again later", (Throwable)var5);
                return false;
            }
        }
        return true;
    }

    @Nullable
    public static UUID convertMobOwnerIfNecessary(final MinecraftServer server, String username) {
        if (!StringUtil.isNullOrEmpty(username) && username.length() <= 16) {
            Optional<UUID> optional = server.getProfileCache().get(username).map(GameProfile::getId);
            if (optional.isPresent()) {
                return optional.get();
            }
            if (!server.isSingleplayer() && server.usesAuthentication()) {
                final ArrayList list = Lists.newArrayList();
                ProfileLookupCallback profileLookupCallback = new ProfileLookupCallback(){

                    public void onProfileLookupSucceeded(GameProfile gameProfile) {
                        server.getProfileCache().add(gameProfile);
                        list.add(gameProfile);
                    }

                    public void onProfileLookupFailed(String profileName, Exception exception) {
                        LOGGER.warn("Could not lookup user whitelist entry for {}", (Object)profileName, (Object)exception);
                    }
                };
                OldUsersConverter.lookupPlayers(server, Lists.newArrayList((Object[])new String[]{username}), profileLookupCallback);
                return !list.isEmpty() ? ((GameProfile)list.get(0)).getId() : null;
            }
            return UUIDUtil.createOfflinePlayerUUID(username);
        }
        try {
            return UUID.fromString(username);
        }
        catch (IllegalArgumentException var5) {
            return null;
        }
    }

    public static boolean convertPlayers(final DedicatedServer server) {
        final File worldPlayersDirectory = OldUsersConverter.getWorldPlayersDirectory(server);
        final File file = new File(worldPlayersDirectory.getParentFile(), "playerdata");
        final File file1 = new File(worldPlayersDirectory.getParentFile(), "unknownplayers");
        if (worldPlayersDirectory.exists() && worldPlayersDirectory.isDirectory()) {
            File[] files = worldPlayersDirectory.listFiles();
            ArrayList list = Lists.newArrayList();
            for (File file2 : files) {
                String sub;
                String name = file2.getName();
                if (!name.toLowerCase(Locale.ROOT).endsWith(".dat") || (sub = name.substring(0, name.length() - ".dat".length())).isEmpty()) continue;
                list.add(sub);
            }
            try {
                Object[] strings = list.toArray(new String[list.size()]);
                ProfileLookupCallback profileLookupCallback = new ProfileLookupCallback(){
                    final /* synthetic */ String[] val$strings;
                    {
                        this.val$strings = stringArray;
                    }

                    public void onProfileLookupSucceeded(GameProfile gameProfile) {
                        server.getProfileCache().add(gameProfile);
                        UUID id = gameProfile.getId();
                        this.movePlayerFile(file, this.getFileNameForProfile(gameProfile.getName()), id.toString());
                    }

                    public void onProfileLookupFailed(String profileName, Exception exception) {
                        LOGGER.warn("Could not lookup user uuid for {}", (Object)profileName, (Object)exception);
                        if (!(exception instanceof ProfileNotFoundException)) {
                            throw new ConversionError("Could not request user " + profileName + " from backend systems", exception);
                        }
                        String fileNameForProfile = this.getFileNameForProfile(profileName);
                        this.movePlayerFile(file1, fileNameForProfile, fileNameForProfile);
                    }

                    private void movePlayerFile(File file3, String oldFileName, String newFileName) {
                        File file4 = new File(worldPlayersDirectory, oldFileName + ".dat");
                        File file5 = new File(file3, newFileName + ".dat");
                        CompoundTag root = null;
                        try {
                            root = NbtIo.readCompressed(new FileInputStream(file4), NbtAccounter.unlimitedHeap());
                        }
                        catch (Exception exception) {
                            StacktraceDeobfuscator.INSTANCE.deobfuscateThrowable(exception);
                            exception.printStackTrace();
                            ServerInternalException.reportInternalException((Throwable)exception);
                        }
                        if (root != null) {
                            if (!root.contains("bukkit")) {
                                root.put("bukkit", new CompoundTag());
                            }
                            CompoundTag data = root.getCompoundOrEmpty("bukkit");
                            data.putString("lastKnownName", oldFileName);
                            try {
                                NbtIo.writeCompressed(root, new FileOutputStream(file1));
                            }
                            catch (Exception exception) {
                                StacktraceDeobfuscator.INSTANCE.deobfuscateThrowable(exception);
                                exception.printStackTrace();
                                ServerInternalException.reportInternalException((Throwable)exception);
                            }
                        }
                        OldUsersConverter.ensureDirectoryExists(file3);
                        if (!file4.renameTo(file5)) {
                            throw new ConversionError("Could not convert file for " + oldFileName);
                        }
                    }

                    private String getFileNameForProfile(String profileName) {
                        String string = null;
                        for (String string1 : this.val$strings) {
                            if (string1 == null || !string1.equalsIgnoreCase(profileName)) continue;
                            string = string1;
                            break;
                        }
                        if (string == null) {
                            throw new ConversionError("Could not find the filename for " + profileName + " anymore");
                        }
                        return string;
                    }
                };
                OldUsersConverter.lookupPlayers(server, Lists.newArrayList((Object[])strings), profileLookupCallback);
                return true;
            }
            catch (ConversionError var12) {
                LOGGER.error("Conversion failed, please try again later", (Throwable)var12);
                return false;
            }
        }
        return true;
    }

    static void ensureDirectoryExists(File dir) {
        if (dir.exists() ? !dir.isDirectory() : !dir.mkdirs()) {
            throw new ConversionError("Can't create directory " + dir.getName() + " in world save directory.");
        }
    }

    public static boolean serverReadyAfterUserconversion(MinecraftServer server) {
        boolean flag = OldUsersConverter.areOldUserlistsRemoved();
        return flag && OldUsersConverter.areOldPlayersConverted(server);
    }

    private static boolean areOldUserlistsRemoved() {
        boolean flag = false;
        if (OLD_USERBANLIST.exists() && OLD_USERBANLIST.isFile()) {
            flag = true;
        }
        boolean flag1 = false;
        if (OLD_IPBANLIST.exists() && OLD_IPBANLIST.isFile()) {
            flag1 = true;
        }
        boolean flag2 = false;
        if (OLD_OPLIST.exists() && OLD_OPLIST.isFile()) {
            flag2 = true;
        }
        boolean flag3 = false;
        if (OLD_WHITELIST.exists() && OLD_WHITELIST.isFile()) {
            flag3 = true;
        }
        if (!(flag || flag1 || flag2 || flag3)) {
            return true;
        }
        LOGGER.warn("**** FAILED TO START THE SERVER AFTER ACCOUNT CONVERSION!");
        LOGGER.warn("** please remove the following files and restart the server:");
        if (flag) {
            LOGGER.warn("* {}", (Object)OLD_USERBANLIST.getName());
        }
        if (flag1) {
            LOGGER.warn("* {}", (Object)OLD_IPBANLIST.getName());
        }
        if (flag2) {
            LOGGER.warn("* {}", (Object)OLD_OPLIST.getName());
        }
        if (flag3) {
            LOGGER.warn("* {}", (Object)OLD_WHITELIST.getName());
        }
        return false;
    }

    private static boolean areOldPlayersConverted(MinecraftServer server) {
        File worldPlayersDirectory = OldUsersConverter.getWorldPlayersDirectory(server);
        if (!worldPlayersDirectory.exists() || !worldPlayersDirectory.isDirectory() || worldPlayersDirectory.list().length <= 0 && worldPlayersDirectory.delete()) {
            return true;
        }
        LOGGER.warn("**** DETECTED OLD PLAYER DIRECTORY IN THE WORLD SAVE");
        LOGGER.warn("**** THIS USUALLY HAPPENS WHEN THE AUTOMATIC CONVERSION FAILED IN SOME WAY");
        LOGGER.warn("** please restart the server and if the problem persists, remove the directory '{}'", (Object)worldPlayersDirectory.getPath());
        return false;
    }

    private static File getWorldPlayersDirectory(MinecraftServer server) {
        return server.getWorldPath(LevelResource.PLAYER_OLD_DATA_DIR).toFile();
    }

    private static void renameOldFile(File convertedFile) {
        File file = new File(convertedFile.getName() + ".converted");
        convertedFile.renameTo(file);
    }

    static Date parseDate(String input, Date defaultValue) {
        Date date;
        try {
            date = BanListEntry.DATE_FORMAT.parse(input);
        }
        catch (ParseException var4) {
            date = defaultValue;
        }
        return date;
    }

    static class ConversionError
    extends RuntimeException {
        ConversionError(String message, Throwable cause) {
            super(message, cause);
        }

        ConversionError(String message) {
            super(message);
        }
    }
}

