/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import java.util.Date;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.server.players.BanListEntry;

public class UserBanListEntry
extends BanListEntry<GameProfile> {
    public UserBanListEntry(@Nullable GameProfile user) {
        this(user, (Date)null, (String)null, (Date)null, (String)null);
    }

    public UserBanListEntry(@Nullable GameProfile profile, @Nullable Date created, @Nullable String source, @Nullable Date expires, @Nullable String reason) {
        super(profile, created, source, expires, reason);
    }

    public UserBanListEntry(JsonObject entryData) {
        super(UserBanListEntry.createGameProfile(entryData), entryData);
    }

    @Override
    protected void serialize(JsonObject data) {
        if (this.getUser() != null) {
            data.addProperty("uuid", ((GameProfile)this.getUser()).getId().toString());
            data.addProperty("name", ((GameProfile)this.getUser()).getName());
            super.serialize(data);
        }
    }

    @Override
    public Component getDisplayName() {
        GameProfile gameProfile = (GameProfile)this.getUser();
        return gameProfile != null ? Component.literal(gameProfile.getName()) : Component.translatable("commands.banlist.entry.unknown");
    }

    @Nullable
    private static GameProfile createGameProfile(JsonObject json) {
        UUID uuid = null;
        String name = null;
        if (json.has("uuid")) {
            String asString = json.get("uuid").getAsString();
            try {
                uuid = UUID.fromString(asString);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (json.has("name")) {
            name = json.get("name").getAsString();
        }
        if (uuid != null || name != null) {
            return new GameProfile(uuid, name);
        }
        return null;
    }
}

