/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import net.minecraft.Util;

public interface StatFormatter {
    public static final DecimalFormat DECIMAL_FORMAT = Util.make(new DecimalFormat("########0.00"), format -> format.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
    public static final StatFormatter DEFAULT = NumberFormat.getIntegerInstance(Locale.US)::format;
    public static final StatFormatter DIVIDE_BY_TEN = decimal -> DECIMAL_FORMAT.format((double)decimal * 0.1);
    public static final StatFormatter DISTANCE = distance -> {
        double d = (double)distance / 100.0;
        double d1 = d / 1000.0;
        if (d1 > 0.5) {
            return DECIMAL_FORMAT.format(d1) + " km";
        }
        return d > 0.5 ? DECIMAL_FORMAT.format(d) + " m" : distance + " cm";
    };
    public static final StatFormatter TIME = time -> {
        double d = (double)time / 20.0;
        double d1 = d / 60.0;
        double d2 = d1 / 60.0;
        double d3 = d2 / 24.0;
        double d4 = d3 / 365.0;
        if (d4 > 0.5) {
            return DECIMAL_FORMAT.format(d4) + " y";
        }
        if (d3 > 0.5) {
            return DECIMAL_FORMAT.format(d3) + " d";
        }
        if (d2 > 0.5) {
            return DECIMAL_FORMAT.format(d2) + " h";
        }
        return d1 > 0.5 ? DECIMAL_FORMAT.format(d1) + " min" : d + " s";
    };

    public String format(int var1);
}

