/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class ARGB {
    public static int alpha(int color) {
        return color >>> 24;
    }

    public static int red(int color) {
        return color >> 16 & 0xFF;
    }

    public static int green(int color) {
        return color >> 8 & 0xFF;
    }

    public static int blue(int color) {
        return color & 0xFF;
    }

    public static int color(int alpha, int red, int green, int blue) {
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    public static int color(int red, int green, int blue) {
        return ARGB.color(255, red, green, blue);
    }

    public static int color(Vec3 color) {
        return ARGB.color(ARGB.as8BitChannel((float)color.x()), ARGB.as8BitChannel((float)color.y()), ARGB.as8BitChannel((float)color.z()));
    }

    public static int multiply(int color1, int color2) {
        if (color1 == -1) {
            return color2;
        }
        return color2 == -1 ? color1 : ARGB.color(ARGB.alpha(color1) * ARGB.alpha(color2) / 255, ARGB.red(color1) * ARGB.red(color2) / 255, ARGB.green(color1) * ARGB.green(color2) / 255, ARGB.blue(color1) * ARGB.blue(color2) / 255);
    }

    public static int scaleRGB(int color, float scale) {
        return ARGB.scaleRGB(color, scale, scale, scale);
    }

    public static int scaleRGB(int color, float redScale, float greenScale, float blueScale) {
        return ARGB.color(ARGB.alpha(color), Math.clamp((long)((int)((float)ARGB.red(color) * redScale)), 0, 255), Math.clamp((long)((int)((float)ARGB.green(color) * greenScale)), 0, 255), Math.clamp((long)((int)((float)ARGB.blue(color) * blueScale)), 0, 255));
    }

    public static int scaleRGB(int color, int scale) {
        return ARGB.color(ARGB.alpha(color), Math.clamp((long)ARGB.red(color) * (long)scale / 255L, 0, 255), Math.clamp((long)ARGB.green(color) * (long)scale / 255L, 0, 255), Math.clamp((long)ARGB.blue(color) * (long)scale / 255L, 0, 255));
    }

    public static int greyscale(int color) {
        int i = (int)((float)ARGB.red(color) * 0.3f + (float)ARGB.green(color) * 0.59f + (float)ARGB.blue(color) * 0.11f);
        return ARGB.color(i, i, i);
    }

    public static int lerp(float delta, int color1, int color2) {
        int i = Mth.lerpInt(delta, ARGB.alpha(color1), ARGB.alpha(color2));
        int i1 = Mth.lerpInt(delta, ARGB.red(color1), ARGB.red(color2));
        int i2 = Mth.lerpInt(delta, ARGB.green(color1), ARGB.green(color2));
        int i3 = Mth.lerpInt(delta, ARGB.blue(color1), ARGB.blue(color2));
        return ARGB.color(i, i1, i2, i3);
    }

    public static int opaque(int color) {
        return color | 0xFF000000;
    }

    public static int transparent(int color) {
        return color & 0xFFFFFF;
    }

    public static int color(int alpha, int color) {
        return alpha << 24 | color & 0xFFFFFF;
    }

    public static int white(float alpha) {
        return ARGB.as8BitChannel(alpha) << 24 | 0xFFFFFF;
    }

    public static int colorFromFloat(float alpha, float red, float green, float blue) {
        return ARGB.color(ARGB.as8BitChannel(alpha), ARGB.as8BitChannel(red), ARGB.as8BitChannel(green), ARGB.as8BitChannel(blue));
    }

    public static Vector3f vector3fFromRGB24(int color) {
        float f = (float)ARGB.red(color) / 255.0f;
        float f1 = (float)ARGB.green(color) / 255.0f;
        float f2 = (float)ARGB.blue(color) / 255.0f;
        return new Vector3f(f, f1, f2);
    }

    public static int average(int color1, int color2) {
        return ARGB.color((ARGB.alpha(color1) + ARGB.alpha(color2)) / 2, (ARGB.red(color1) + ARGB.red(color2)) / 2, (ARGB.green(color1) + ARGB.green(color2)) / 2, (ARGB.blue(color1) + ARGB.blue(color2)) / 2);
    }

    public static int as8BitChannel(float value) {
        return Mth.floor(value * 255.0f);
    }

    public static float alphaFloat(int color) {
        return ARGB.from8BitChannel(ARGB.alpha(color));
    }

    public static float redFloat(int color) {
        return ARGB.from8BitChannel(ARGB.red(color));
    }

    public static float greenFloat(int color) {
        return ARGB.from8BitChannel(ARGB.green(color));
    }

    public static float blueFloat(int color) {
        return ARGB.from8BitChannel(ARGB.blue(color));
    }

    private static float from8BitChannel(int value) {
        return (float)value / 255.0f;
    }

    public static int toABGR(int color) {
        return color & 0xFF00FF00 | (color & 0xFF0000) >> 16 | (color & 0xFF) << 16;
    }

    public static int fromABGR(int color) {
        return ARGB.toABGR(color);
    }
}

