/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import java.util.Locale;
import java.util.UUID;
import java.util.function.IntPredicate;
import java.util.stream.IntStream;
import net.minecraft.Util;
import net.minecraft.core.Vec3i;
import net.minecraft.util.ARGB;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.math.Fraction;
import org.apache.commons.lang3.math.NumberUtils;
import org.joml.Math;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class Mth {
    private static final long UUID_VERSION = 61440L;
    private static final long UUID_VERSION_TYPE_4 = 16384L;
    private static final long UUID_VARIANT = -4611686018427387904L;
    private static final long UUID_VARIANT_2 = Long.MIN_VALUE;
    public static final float PI = (float)java.lang.Math.PI;
    public static final float HALF_PI = 1.5707964f;
    public static final float TWO_PI = (float)java.lang.Math.PI * 2;
    public static final float DEG_TO_RAD = (float)java.lang.Math.PI / 180;
    public static final float RAD_TO_DEG = 57.295776f;
    public static final float EPSILON = 1.0E-5f;
    public static final float SQRT_OF_TWO = Mth.sqrt(2.0f);
    private static final float SIN_SCALE = 10430.378f;
    public static final Vector3f Y_AXIS = new Vector3f(0.0f, 1.0f, 0.0f);
    public static final Vector3f X_AXIS = new Vector3f(1.0f, 0.0f, 0.0f);
    public static final Vector3f Z_AXIS = new Vector3f(0.0f, 0.0f, 1.0f);
    private static final float[] SIN = Util.make(new float[65536], floats -> {
        for (int i1 = 0; i1 < ((float[])floats).length; ++i1) {
            floats[i1] = (float)java.lang.Math.sin((double)i1 * java.lang.Math.PI * 2.0 / 65536.0);
        }
    });
    private static final RandomSource RANDOM = RandomSource.createThreadSafe();
    private static final int[] MULTIPLY_DE_BRUIJN_BIT_POSITION = new int[]{0, 1, 28, 2, 29, 14, 24, 3, 30, 22, 20, 15, 25, 17, 4, 8, 31, 27, 13, 23, 21, 19, 16, 7, 26, 12, 18, 6, 11, 5, 10, 9};
    private static final double ONE_SIXTH = 0.16666666666666666;
    private static final int FRAC_EXP = 8;
    private static final int LUT_SIZE = 257;
    private static final double FRAC_BIAS = Double.longBitsToDouble(4805340802404319232L);
    private static final double[] ASIN_TAB = new double[257];
    private static final double[] COS_TAB = new double[257];

    public static float sin(float value) {
        return SIN[(int)(value * 10430.378f) & 0xFFFF];
    }

    public static float cos(float value) {
        return SIN[(int)(value * 10430.378f + 16384.0f) & 0xFFFF];
    }

    public static float sqrt(float value) {
        return (float)java.lang.Math.sqrt(value);
    }

    public static int floor(float value) {
        int i = (int)value;
        return value < (float)i ? i - 1 : i;
    }

    public static int floor(double value) {
        int i = (int)value;
        return value < (double)i ? i - 1 : i;
    }

    public static long lfloor(double value) {
        long l = (long)value;
        return value < (double)l ? l - 1L : l;
    }

    public static float abs(float value) {
        return java.lang.Math.abs(value);
    }

    public static int abs(int value) {
        return java.lang.Math.abs(value);
    }

    public static int ceil(float value) {
        int i = (int)value;
        return value > (float)i ? i + 1 : i;
    }

    public static int ceil(double value) {
        int i = (int)value;
        return value > (double)i ? i + 1 : i;
    }

    public static int clamp(int value, int min, int max) {
        return java.lang.Math.min(java.lang.Math.max(value, min), max);
    }

    public static long clamp(long value, long min, long max) {
        return java.lang.Math.min(java.lang.Math.max(value, min), max);
    }

    public static float clamp(float value, float min, float max) {
        return value < min ? min : java.lang.Math.min(value, max);
    }

    public static double clamp(double value, double min, double max) {
        return value < min ? min : java.lang.Math.min(value, max);
    }

    public static double clampedLerp(double start, double end, double delta) {
        if (delta < 0.0) {
            return start;
        }
        return delta > 1.0 ? end : Mth.lerp(delta, start, end);
    }

    public static float clampedLerp(float start, float end, float delta) {
        if (delta < 0.0f) {
            return start;
        }
        return delta > 1.0f ? end : Mth.lerp(delta, start, end);
    }

    public static double absMax(double x, double y) {
        if (x < 0.0) {
            x = -x;
        }
        if (y < 0.0) {
            y = -y;
        }
        return java.lang.Math.max(x, y);
    }

    public static int floorDiv(int dividend, int divisor) {
        return java.lang.Math.floorDiv(dividend, divisor);
    }

    public static int nextInt(RandomSource random, int minimum, int maximum) {
        return minimum >= maximum ? minimum : random.nextInt(maximum - minimum + 1) + minimum;
    }

    public static float nextFloat(RandomSource random, float minimum, float maximum) {
        return minimum >= maximum ? minimum : random.nextFloat() * (maximum - minimum) + minimum;
    }

    public static double nextDouble(RandomSource random, double minimum, double maximum) {
        return minimum >= maximum ? minimum : random.nextDouble() * (maximum - minimum) + minimum;
    }

    public static boolean equal(float x, float y) {
        return java.lang.Math.abs(y - x) < 1.0E-5f;
    }

    public static boolean equal(double x, double y) {
        return java.lang.Math.abs(y - x) < (double)1.0E-5f;
    }

    public static int positiveModulo(int x, int y) {
        return java.lang.Math.floorMod(x, y);
    }

    public static float positiveModulo(float numerator, float denominator) {
        return (numerator % denominator + denominator) % denominator;
    }

    public static double positiveModulo(double numerator, double denominator) {
        return (numerator % denominator + denominator) % denominator;
    }

    public static boolean isMultipleOf(int number, int multiple) {
        return number % multiple == 0;
    }

    public static byte packDegrees(float degrees) {
        return (byte)Mth.floor(degrees * 256.0f / 360.0f);
    }

    public static float unpackDegrees(byte degrees) {
        return (float)(degrees * 360) / 256.0f;
    }

    public static int wrapDegrees(int angle) {
        int i = angle % 360;
        if (i >= 180) {
            i -= 360;
        }
        if (i < -180) {
            i += 360;
        }
        return i;
    }

    public static float wrapDegrees(long angle) {
        float f = angle % 360L;
        if (f >= 180.0f) {
            f -= 360.0f;
        }
        if (f < -180.0f) {
            f += 360.0f;
        }
        return f;
    }

    public static float wrapDegrees(float value) {
        float f = value % 360.0f;
        if (f >= 180.0f) {
            f -= 360.0f;
        }
        if (f < -180.0f) {
            f += 360.0f;
        }
        return f;
    }

    public static double wrapDegrees(double value) {
        double d = value % 360.0;
        if (d >= 180.0) {
            d -= 360.0;
        }
        if (d < -180.0) {
            d += 360.0;
        }
        return d;
    }

    public static float degreesDifference(float start, float end) {
        return Mth.wrapDegrees(end - start);
    }

    public static float degreesDifferenceAbs(float start, float end) {
        return Mth.abs(Mth.degreesDifference(start, end));
    }

    public static float rotateIfNecessary(float rotationToAdjust, float actualRotation, float maxDifference) {
        float f = Mth.degreesDifference(rotationToAdjust, actualRotation);
        float f1 = Mth.clamp(f, -maxDifference, maxDifference);
        return actualRotation - f1;
    }

    public static float approach(float value, float limit, float stepSize) {
        stepSize = Mth.abs(stepSize);
        return value < limit ? Mth.clamp(value + stepSize, value, limit) : Mth.clamp(value - stepSize, limit, value);
    }

    public static float approachDegrees(float angle, float limit, float stepSize) {
        float f = Mth.degreesDifference(angle, limit);
        return Mth.approach(angle, angle + f, stepSize);
    }

    public static int getInt(String value, int defaultValue) {
        return NumberUtils.toInt((String)value, (int)defaultValue);
    }

    public static int smallestEncompassingPowerOfTwo(int value) {
        int i = value - 1;
        i |= i >> 1;
        i |= i >> 2;
        i |= i >> 4;
        i |= i >> 8;
        i |= i >> 16;
        return i + 1;
    }

    public static boolean isPowerOfTwo(int value) {
        return value != 0 && (value & value - 1) == 0;
    }

    public static int ceillog2(int value) {
        value = Mth.isPowerOfTwo(value) ? value : Mth.smallestEncompassingPowerOfTwo(value);
        return MULTIPLY_DE_BRUIJN_BIT_POSITION[(int)((long)value * 125613361L >> 27) & 0x1F];
    }

    public static int log2(int value) {
        return Mth.ceillog2(value) - (Mth.isPowerOfTwo(value) ? 0 : 1);
    }

    public static float frac(float number) {
        return number - (float)Mth.floor(number);
    }

    public static double frac(double number) {
        return number - (double)Mth.lfloor(number);
    }

    @Deprecated
    public static long getSeed(Vec3i pos) {
        return Mth.getSeed(pos.getX(), pos.getY(), pos.getZ());
    }

    @Deprecated
    public static long getSeed(int x, int y, int z) {
        long l = (long)(x * 3129871) ^ (long)z * 116129781L ^ (long)y;
        l = l * l * 42317861L + l * 11L;
        return l >> 16;
    }

    public static UUID createInsecureUUID(RandomSource random) {
        long l = random.nextLong() & 0xFFFFFFFFFFFF0FFFL | 0x4000L;
        long l1 = random.nextLong() & 0x3FFFFFFFFFFFFFFFL | Long.MIN_VALUE;
        return new UUID(l, l1);
    }

    public static UUID createInsecureUUID() {
        return Mth.createInsecureUUID(RANDOM);
    }

    public static double inverseLerp(double delta, double start, double end) {
        return (delta - start) / (end - start);
    }

    public static float inverseLerp(float delta, float start, float end) {
        return (delta - start) / (end - start);
    }

    public static boolean rayIntersectsAABB(Vec3 start, Vec3 end, AABB boundingBox) {
        double d = (boundingBox.minX + boundingBox.maxX) * 0.5;
        double d1 = (boundingBox.maxX - boundingBox.minX) * 0.5;
        double d2 = start.x - d;
        if (java.lang.Math.abs(d2) > d1 && d2 * end.x >= 0.0) {
            return false;
        }
        double d3 = (boundingBox.minY + boundingBox.maxY) * 0.5;
        double d4 = (boundingBox.maxY - boundingBox.minY) * 0.5;
        double d5 = start.y - d3;
        if (java.lang.Math.abs(d5) > d4 && d5 * end.y >= 0.0) {
            return false;
        }
        double d6 = (boundingBox.minZ + boundingBox.maxZ) * 0.5;
        double d7 = (boundingBox.maxZ - boundingBox.minZ) * 0.5;
        double d8 = start.z - d6;
        if (java.lang.Math.abs(d8) > d7 && d8 * end.z >= 0.0) {
            return false;
        }
        double abs = java.lang.Math.abs(end.x);
        double abs1 = java.lang.Math.abs(end.y);
        double abs2 = java.lang.Math.abs(end.z);
        double d9 = end.y * d8 - end.z * d5;
        if (java.lang.Math.abs(d9) > d4 * abs2 + d7 * abs1) {
            return false;
        }
        d9 = end.z * d2 - end.x * d8;
        if (java.lang.Math.abs(d9) > d1 * abs2 + d7 * abs) {
            return false;
        }
        d9 = end.x * d5 - end.y * d2;
        return java.lang.Math.abs(d9) < d1 * abs1 + d4 * abs;
    }

    public static double atan2(double y, double x) {
        double d1;
        boolean flag2;
        boolean flag1;
        boolean flag;
        double d = x * x + y * y;
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        boolean bl = flag = y < 0.0;
        if (flag) {
            y = -y;
        }
        boolean bl2 = flag1 = x < 0.0;
        if (flag1) {
            x = -x;
        }
        boolean bl3 = flag2 = y > x;
        if (flag2) {
            d1 = x;
            x = y;
            y = d1;
        }
        d1 = Mth.fastInvSqrt(d);
        x *= d1;
        double d2 = FRAC_BIAS + (y *= d1);
        int i = (int)Double.doubleToRawLongBits(d2);
        double d3 = ASIN_TAB[i];
        double d4 = COS_TAB[i];
        double d5 = d2 - FRAC_BIAS;
        double d6 = y * d4 - x * d5;
        double d7 = (6.0 + d6 * d6) * d6 * 0.16666666666666666;
        double d8 = d3 + d7;
        if (flag2) {
            d8 = 1.5707963267948966 - d8;
        }
        if (flag1) {
            d8 = java.lang.Math.PI - d8;
        }
        if (flag) {
            d8 = -d8;
        }
        return d8;
    }

    public static float invSqrt(float number) {
        return Math.invsqrt((float)number);
    }

    public static double invSqrt(double number) {
        return Math.invsqrt((double)number);
    }

    @Deprecated
    public static double fastInvSqrt(double number) {
        double d = 0.5 * number;
        long l = Double.doubleToRawLongBits(number);
        l = 6910469410427058090L - (l >> 1);
        number = Double.longBitsToDouble(l);
        return number * (1.5 - d * number * number);
    }

    public static float fastInvCubeRoot(float number) {
        int i = Float.floatToIntBits(number);
        i = 1419967116 - i / 3;
        float f = Float.intBitsToFloat(i);
        f = 0.6666667f * f + 1.0f / (3.0f * f * f * number);
        return 0.6666667f * f + 1.0f / (3.0f * f * f * number);
    }

    public static int hsvToRgb(float hue, float saturation, float value) {
        return Mth.hsvToArgb(hue, saturation, value, 0);
    }

    public static int hsvToArgb(float hue, float saturation, float value, int alpha) {
        float f5;
        float f4;
        int i = (int)(hue * 6.0f) % 6;
        float f = hue * 6.0f - (float)i;
        float f1 = value * (1.0f - saturation);
        float f2 = value * (1.0f - f * saturation);
        float f3 = value * (1.0f - (1.0f - f) * saturation);
        return ARGB.color(alpha, Mth.clamp((int)(f4 * 255.0f), 0, 255), Mth.clamp((int)(f5 * 255.0f), 0, 255), Mth.clamp((int)((switch (i) {
            case 0 -> {
                f4 = value;
                f5 = f3;
                yield f1;
            }
            case 1 -> {
                f4 = f2;
                f5 = value;
                yield f1;
            }
            case 2 -> {
                f4 = f1;
                f5 = value;
                yield f3;
            }
            case 3 -> {
                f4 = f1;
                f5 = f2;
                yield value;
            }
            case 4 -> {
                f4 = f3;
                f5 = f1;
                yield value;
            }
            case 5 -> {
                f4 = value;
                f5 = f1;
                yield f2;
            }
            default -> throw new RuntimeException("Something went wrong when converting from HSV to RGB. Input was " + hue + ", " + saturation + ", " + value);
        }) * 255.0f), 0, 255));
    }

    public static int murmurHash3Mixer(int input) {
        input ^= input >>> 16;
        input *= -2048144789;
        input ^= input >>> 13;
        return (input *= -1028477387) ^ input >>> 16;
    }

    public static int binarySearch(int min, int max, IntPredicate isTargetBeforeOrAt) {
        int i = max - min;
        while (i > 0) {
            int i1 = i / 2;
            int i2 = min + i1;
            if (isTargetBeforeOrAt.test(i2)) {
                i = i1;
                continue;
            }
            min = i2 + 1;
            i -= i1 + 1;
        }
        return min;
    }

    public static int lerpInt(float delta, int start, int end) {
        return start + Mth.floor(delta * (float)(end - start));
    }

    public static int lerpDiscrete(float delta, int start, int end) {
        int i = end - start;
        return start + Mth.floor(delta * (float)(i - 1)) + (delta > 0.0f ? 1 : 0);
    }

    public static float lerp(float delta, float start, float end) {
        return start + delta * (end - start);
    }

    public static Vec3 lerp(double delta, Vec3 start, Vec3 end) {
        return new Vec3(Mth.lerp(delta, start.x, end.x), Mth.lerp(delta, start.y, end.y), Mth.lerp(delta, start.z, end.z));
    }

    public static double lerp(double delta, double start, double end) {
        return start + delta * (end - start);
    }

    public static double lerp2(double delta1, double delta2, double start1, double end1, double start2, double end2) {
        return Mth.lerp(delta2, Mth.lerp(delta1, start1, end1), Mth.lerp(delta1, start2, end2));
    }

    public static double lerp3(double delta1, double delta2, double delta3, double start1, double end1, double start2, double end2, double start3, double end3, double start4, double end4) {
        return Mth.lerp(delta3, Mth.lerp2(delta1, delta2, start1, end1, start2, end2), Mth.lerp2(delta1, delta2, start3, end3, start4, end4));
    }

    public static float catmullrom(float delta, float controlPoint1, float controlPoint2, float controlPoint3, float controlPoint4) {
        return 0.5f * (2.0f * controlPoint2 + (controlPoint3 - controlPoint1) * delta + (2.0f * controlPoint1 - 5.0f * controlPoint2 + 4.0f * controlPoint3 - controlPoint4) * delta * delta + (3.0f * controlPoint2 - controlPoint1 - 3.0f * controlPoint3 + controlPoint4) * delta * delta * delta);
    }

    public static double smoothstep(double input) {
        return input * input * input * (input * (input * 6.0 - 15.0) + 10.0);
    }

    public static double smoothstepDerivative(double input) {
        return 30.0 * input * input * (input - 1.0) * (input - 1.0);
    }

    public static int sign(double x) {
        if (x == 0.0) {
            return 0;
        }
        return x > 0.0 ? 1 : -1;
    }

    public static float rotLerp(float delta, float start, float end) {
        return start + delta * Mth.wrapDegrees(end - start);
    }

    public static double rotLerp(double delta, double start, double end) {
        return start + delta * Mth.wrapDegrees(end - start);
    }

    public static float rotLerpRad(float delta, float start, float end) {
        float f;
        for (f = end - start; f < (float)(-java.lang.Math.PI); f += (float)java.lang.Math.PI * 2) {
        }
        while (f >= (float)java.lang.Math.PI) {
            f -= (float)java.lang.Math.PI * 2;
        }
        return start + delta * f;
    }

    public static float triangleWave(float input, float period) {
        return (java.lang.Math.abs(input % period - period * 0.5f) - period * 0.25f) / (period * 0.25f);
    }

    public static float square(float value) {
        return value * value;
    }

    public static double square(double value) {
        return value * value;
    }

    public static int square(int value) {
        return value * value;
    }

    public static long square(long value) {
        return value * value;
    }

    public static double clampedMap(double input, double inputMin, double inputMax, double ouputMin, double outputMax) {
        return Mth.clampedLerp(ouputMin, outputMax, Mth.inverseLerp(input, inputMin, inputMax));
    }

    public static float clampedMap(float input, float inputMin, float inputMax, float outputMin, float outputMax) {
        return Mth.clampedLerp(outputMin, outputMax, Mth.inverseLerp(input, inputMin, inputMax));
    }

    public static double map(double input, double inputMin, double inputMax, double outputMin, double outputMax) {
        return Mth.lerp(Mth.inverseLerp(input, inputMin, inputMax), outputMin, outputMax);
    }

    public static float map(float input, float inputMin, float inputMax, float outputMin, float outputMax) {
        return Mth.lerp(Mth.inverseLerp(input, inputMin, inputMax), outputMin, outputMax);
    }

    public static double wobble(double input) {
        return input + (2.0 * RandomSource.create(Mth.floor(input * 3000.0)).nextDouble() - 1.0) * 1.0E-7 / 2.0;
    }

    public static int roundToward(int value, int factor) {
        return Mth.positiveCeilDiv(value, factor) * factor;
    }

    public static int positiveCeilDiv(int x, int y) {
        return -java.lang.Math.floorDiv(-x, y);
    }

    public static int randomBetweenInclusive(RandomSource random, int minInclusive, int maxInclusive) {
        return random.nextInt(maxInclusive - minInclusive + 1) + minInclusive;
    }

    public static float randomBetween(RandomSource random, float minInclusive, float maxExclusive) {
        return random.nextFloat() * (maxExclusive - minInclusive) + minInclusive;
    }

    public static float normal(RandomSource random, float mean, float deviation) {
        return mean + (float)random.nextGaussian() * deviation;
    }

    public static double lengthSquared(double xDistance, double yDistance) {
        return xDistance * xDistance + yDistance * yDistance;
    }

    public static double length(double xDistance, double yDistance) {
        return java.lang.Math.sqrt(Mth.lengthSquared(xDistance, yDistance));
    }

    public static float length(float xDistance, float yDistance) {
        return (float)java.lang.Math.sqrt(Mth.lengthSquared(xDistance, yDistance));
    }

    public static double lengthSquared(double xDistance, double yDistance, double zDistance) {
        return xDistance * xDistance + yDistance * yDistance + zDistance * zDistance;
    }

    public static double length(double xDistance, double yDistance, double zDistance) {
        return java.lang.Math.sqrt(Mth.lengthSquared(xDistance, yDistance, zDistance));
    }

    public static float lengthSquared(float xDistance, float yDistance, float zDistance) {
        return xDistance * xDistance + yDistance * yDistance + zDistance * zDistance;
    }

    public static int quantize(double value, int factor) {
        return Mth.floor(value / (double)factor) * factor;
    }

    public static IntStream outFromOrigin(int input, int lowerBound, int upperBound) {
        return Mth.outFromOrigin(input, lowerBound, upperBound, 1);
    }

    public static IntStream outFromOrigin(int input, int lowerBound, int upperBound, int steps) {
        if (lowerBound > upperBound) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "upperbound %d expected to be > lowerBound %d", upperBound, lowerBound));
        }
        if (steps < 1) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "steps expected to be >= 1, was %d", steps));
        }
        return input >= lowerBound && input <= upperBound ? IntStream.iterate(input, i -> {
            int abs = java.lang.Math.abs(input - i);
            return input - abs >= lowerBound || input + abs <= upperBound;
        }, i -> {
            int i1;
            boolean flag1;
            boolean flag = i <= input;
            int abs = java.lang.Math.abs(input - i);
            boolean bl = flag1 = input + abs + steps <= upperBound;
            if (!(flag && flag1 || (i1 = input - abs - (flag ? steps : 0)) < lowerBound)) {
                return i1;
            }
            return input + abs + steps;
        }) : IntStream.empty();
    }

    public static Quaternionf rotationAroundAxis(Vector3f axis, Quaternionf cameraOrentation, Quaternionf output) {
        float f = axis.dot(cameraOrentation.x, cameraOrentation.y, cameraOrentation.z);
        return output.set(axis.x * f, axis.y * f, axis.z * f, cameraOrentation.w).normalize();
    }

    public static int mulAndTruncate(Fraction fraction, int factor) {
        return fraction.getNumerator() * factor / fraction.getDenominator();
    }

    public static float easeInOutSine(float value) {
        return -(Mth.cos((float)java.lang.Math.PI * value) - 1.0f) / 2.0f;
    }

    static {
        for (int i = 0; i < 257; ++i) {
            double d = (double)i / 256.0;
            double asin = java.lang.Math.asin(d);
            Mth.COS_TAB[i] = java.lang.Math.cos(asin);
            Mth.ASIN_TAB[i] = asin;
        }
    }
}

