/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Dynamic;
import net.minecraft.util.datafix.fixes.AbstractUUIDFix;
import net.minecraft.util.datafix.fixes.References;

public class BlockEntityUUIDFix
extends AbstractUUIDFix {
    public BlockEntityUUIDFix(Schema outputSchema) {
        super(outputSchema, References.BLOCK_ENTITY);
    }

    protected TypeRewriteRule makeRule() {
        return this.fixTypeEverywhereTyped("BlockEntityUUIDFix", this.getInputSchema().getType(this.typeReference), typed -> {
            typed = this.updateNamedChoice((Typed<?>)typed, "minecraft:conduit", this::updateConduit);
            return this.updateNamedChoice((Typed<?>)typed, "minecraft:skull", this::updateSkull);
        });
    }

    private Dynamic<?> updateSkull(Dynamic<?> skullTag) {
        return skullTag.get("Owner").get().map(dynamic -> BlockEntityUUIDFix.replaceUUIDString(dynamic, "Id", "Id").orElse((Dynamic<?>)((Object)dynamic))).map(dynamic -> skullTag.remove("Owner").set("SkullOwner", (Dynamic<?>)((Object)dynamic))).result().orElse(skullTag);
    }

    private Dynamic<?> updateConduit(Dynamic<?> conduitTag) {
        return BlockEntityUUIDFix.replaceUUIDMLTag(conduitTag, "target_uuid", "Target").orElse(conduitTag);
    }
}

