/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.OptionalDynamic;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import it.unimi.dsi.fastutil.ints.Int2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.util.datafix.fixes.ChunkProtoTickListFix;
import net.minecraft.util.datafix.fixes.References;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableObject;

public class ChunkHeightAndBiomeFix
extends DataFix {
    public static final String DATAFIXER_CONTEXT_TAG = "__context";
    private static final String NAME = "ChunkHeightAndBiomeFix";
    private static final int OLD_SECTION_COUNT = 16;
    private static final int NEW_SECTION_COUNT = 24;
    private static final int NEW_MIN_SECTION_Y = -4;
    public static final int BLOCKS_PER_SECTION = 4096;
    private static final int LONGS_PER_SECTION = 64;
    private static final int HEIGHTMAP_BITS = 9;
    private static final long HEIGHTMAP_MASK = 511L;
    private static final int HEIGHTMAP_OFFSET = 64;
    private static final String[] HEIGHTMAP_TYPES = new String[]{"WORLD_SURFACE_WG", "WORLD_SURFACE", "WORLD_SURFACE_IGNORE_SNOW", "OCEAN_FLOOR_WG", "OCEAN_FLOOR", "MOTION_BLOCKING", "MOTION_BLOCKING_NO_LEAVES"};
    private static final Set<String> STATUS_IS_OR_AFTER_SURFACE = Set.of("surface", "carvers", "liquid_carvers", "features", "light", "spawn", "heightmaps", "full");
    private static final Set<String> STATUS_IS_OR_AFTER_NOISE = Set.of("noise", "surface", "carvers", "liquid_carvers", "features", "light", "spawn", "heightmaps", "full");
    private static final Set<String> BLOCKS_BEFORE_FEATURE_STATUS = Set.of("minecraft:air", "minecraft:basalt", "minecraft:bedrock", "minecraft:blackstone", "minecraft:calcite", "minecraft:cave_air", "minecraft:coarse_dirt", "minecraft:crimson_nylium", "minecraft:dirt", "minecraft:end_stone", "minecraft:grass_block", "minecraft:gravel", "minecraft:ice", "minecraft:lava", "minecraft:mycelium", "minecraft:nether_wart_block", "minecraft:netherrack", "minecraft:orange_terracotta", "minecraft:packed_ice", "minecraft:podzol", "minecraft:powder_snow", "minecraft:red_sand", "minecraft:red_sandstone", "minecraft:sand", "minecraft:sandstone", "minecraft:snow_block", "minecraft:soul_sand", "minecraft:soul_soil", "minecraft:stone", "minecraft:terracotta", "minecraft:warped_nylium", "minecraft:warped_wart_block", "minecraft:water", "minecraft:white_terracotta");
    private static final int BIOME_CONTAINER_LAYER_SIZE = 16;
    private static final int BIOME_CONTAINER_SIZE = 64;
    private static final int BIOME_CONTAINER_TOP_LAYER_OFFSET = 1008;
    public static final String DEFAULT_BIOME = "minecraft:plains";
    private static final Int2ObjectMap<String> BIOMES_BY_ID = new Int2ObjectOpenHashMap();

    public ChunkHeightAndBiomeFix(Schema outputSchema) {
        super(outputSchema, true);
    }

    protected TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(References.CHUNK);
        OpticFinder opticFinder = type.findField("Level");
        OpticFinder opticFinder1 = opticFinder.type().findField("Sections");
        Schema outputSchema = this.getOutputSchema();
        Type type1 = outputSchema.getType(References.CHUNK);
        Type type2 = type1.findField("Level").type();
        Type type3 = type2.findField("Sections").type();
        return this.fixTypeEverywhereTyped(NAME, type, type1, typed -> typed.updateTyped(opticFinder, type2, typed1 -> {
            Dynamic dynamic = (Dynamic)((Object)((Object)((Object)typed1.get(DSL.remainderFinder()))));
            OptionalDynamic optionalDynamic = ((Dynamic)((Object)((Object)((Object)typed.get(DSL.remainderFinder()))))).get(DATAFIXER_CONTEXT_TAG);
            String string = optionalDynamic.get("dimension").asString().result().orElse("");
            String string1 = optionalDynamic.get("generator").asString().result().orElse("");
            boolean flag = "minecraft:overworld".equals(string);
            MutableBoolean mutableBoolean = new MutableBoolean();
            int i = flag ? -4 : 0;
            Dynamic[] biomeContainers = ChunkHeightAndBiomeFix.getBiomeContainers(dynamic, flag, i, mutableBoolean);
            Dynamic<?> dynamic1 = ChunkHeightAndBiomeFix.makePalettedContainer(dynamic.createList(Stream.of(dynamic.createMap((Map)ImmutableMap.of((Object)((Object)dynamic.createString("Name")), (Object)((Object)dynamic.createString("minecraft:air")))))));
            HashSet set = Sets.newHashSet();
            MutableObject mutableObject = new MutableObject(() -> null);
            typed1 = typed1.updateTyped(opticFinder1, type3, typed2 -> {
                IntOpenHashSet set1 = new IntOpenHashSet();
                Dynamic dynamic2 = (Dynamic)((Object)((Object)((Object)((Object)typed2.write().result().orElseThrow(() -> new IllegalStateException("Malformed Chunk.Level.Sections"))))));
                List list = dynamic2.asStream().map(arg_0 -> ChunkHeightAndBiomeFix.lambda$makeRule$6(set, dynamic1, i, biomeContainers, (IntSet)set1, mutableObject, arg_0)).collect(Collectors.toCollection(ArrayList::new));
                for (int i1 = 0; i1 < biomeContainers.length; ++i1) {
                    int i2 = i1 + i;
                    if (!set1.add(i2)) continue;
                    Dynamic dynamic3 = dynamic.createMap(Map.of(dynamic.createString("Y"), dynamic.createInt(i2)));
                    dynamic3 = dynamic3.set("block_states", dynamic1);
                    dynamic3 = dynamic3.set("biomes", biomeContainers[i1]);
                    list.add(dynamic3);
                }
                return Util.readTypedOrThrow(type3, dynamic.createList(list.stream()));
            });
            return typed1.update(DSL.remainderFinder(), dynamic2 -> {
                if (flag) {
                    dynamic2 = this.predictChunkStatusBeforeSurface((Dynamic<?>)((Object)((Object)((Object)dynamic2))), set);
                }
                return ChunkHeightAndBiomeFix.updateChunkTag(dynamic2, flag, mutableBoolean.booleanValue(), "minecraft:noise".equals(string1), (Supplier)mutableObject.getValue());
            });
        }));
    }

    private Dynamic<?> predictChunkStatusBeforeSurface(Dynamic<?> data, Set<String> blockPalette) {
        return data.update("Status", dynamic -> {
            boolean flag1;
            String string = dynamic.asString("empty");
            if (STATUS_IS_OR_AFTER_SURFACE.contains(string)) {
                return dynamic;
            }
            blockPalette.remove("minecraft:air");
            boolean flag = !blockPalette.isEmpty();
            blockPalette.removeAll(BLOCKS_BEFORE_FEATURE_STATUS);
            boolean bl = flag1 = !blockPalette.isEmpty();
            if (flag1) {
                return dynamic.createString("liquid_carvers");
            }
            if ("noise".equals(string) || flag) {
                return dynamic.createString("noise");
            }
            return "biomes".equals(string) ? dynamic.createString("structure_references") : dynamic;
        });
    }

    private static Dynamic<?>[] getBiomeContainers(Dynamic<?> data, boolean overworld, int lowestY, MutableBoolean isTallChunk) {
        Dynamic[] dynamics = new Dynamic[overworld ? 24 : 16];
        int[] ints = data.get("Biomes").asIntStreamOpt().result().map(IntStream::toArray).orElse(null);
        if (ints != null && ints.length == 1536) {
            isTallChunk.setValue(true);
            for (int i = 0; i < 24; ++i) {
                int i1 = i;
                dynamics[i] = ChunkHeightAndBiomeFix.makeBiomeContainer(data, i3 -> ChunkHeightAndBiomeFix.getOldBiome(ints, i1 * 64 + i3));
            }
        } else if (ints != null && ints.length == 1024) {
            int i = 0;
            while (i < 16) {
                int i1 = i - lowestY;
                int f_i = i++;
                dynamics[i1] = ChunkHeightAndBiomeFix.makeBiomeContainer(data, i3 -> ChunkHeightAndBiomeFix.getOldBiome(ints, f_i * 64 + i3));
            }
            if (overworld) {
                int i2;
                Dynamic<?> dynamic = ChunkHeightAndBiomeFix.makeBiomeContainer(data, i3 -> ChunkHeightAndBiomeFix.getOldBiome(ints, i3 % 16));
                Dynamic<?> dynamic1 = ChunkHeightAndBiomeFix.makeBiomeContainer(data, i3 -> ChunkHeightAndBiomeFix.getOldBiome(ints, i3 % 16 + 1008));
                for (i2 = 0; i2 < 4; ++i2) {
                    dynamics[i2] = dynamic;
                }
                for (i2 = 20; i2 < 24; ++i2) {
                    dynamics[i2] = dynamic1;
                }
            }
        } else {
            Arrays.fill((Object[])dynamics, ChunkHeightAndBiomeFix.makePalettedContainer(data.createList(Stream.of(data.createString(DEFAULT_BIOME)))));
        }
        return dynamics;
    }

    private static int getOldBiome(int[] biomes, int index) {
        return biomes[index] & 0xFF;
    }

    private static Dynamic<?> updateChunkTag(Dynamic<?> chunkTag, boolean overworld, boolean isTallChunk, boolean isNoiseGenerator, Supplier<ChunkProtoTickListFix.PoorMansPalettedContainer> paletteSupplier) {
        Dynamic dynamic;
        String string;
        chunkTag = chunkTag.remove("Biomes");
        if (!overworld) {
            return ChunkHeightAndBiomeFix.updateCarvingMasks(chunkTag, 16, 0);
        }
        if (isTallChunk) {
            return ChunkHeightAndBiomeFix.updateCarvingMasks(chunkTag, 24, 0);
        }
        chunkTag = ChunkHeightAndBiomeFix.updateHeightmaps(chunkTag);
        chunkTag = ChunkHeightAndBiomeFix.addPaddingEntries(chunkTag, "LiquidsToBeTicked");
        chunkTag = ChunkHeightAndBiomeFix.addPaddingEntries(chunkTag, "PostProcessing");
        chunkTag = ChunkHeightAndBiomeFix.addPaddingEntries(chunkTag, "ToBeTicked");
        chunkTag = ChunkHeightAndBiomeFix.updateCarvingMasks(chunkTag, 24, 4);
        chunkTag = chunkTag.update("UpgradeData", ChunkHeightAndBiomeFix::shiftUpgradeData);
        if (!isNoiseGenerator) {
            return chunkTag;
        }
        Optional optional = chunkTag.get("Status").result();
        if (optional.isPresent() && !"empty".equals(string = (dynamic = (Dynamic)((Object)optional.get())).asString(""))) {
            chunkTag = chunkTag.set("blending_data", chunkTag.createMap((Map)ImmutableMap.of((Object)((Object)chunkTag.createString("old_noise")), (Object)((Object)chunkTag.createBoolean(STATUS_IS_OR_AFTER_NOISE.contains(string))))));
            ChunkProtoTickListFix.PoorMansPalettedContainer poorMansPalettedContainer = paletteSupplier.get();
            if (poorMansPalettedContainer != null) {
                BitSet bitSet = new BitSet(256);
                boolean flag = string.equals("noise");
                for (int i = 0; i < 16; ++i) {
                    for (int i1 = 0; i1 < 16; ++i1) {
                        boolean flag2;
                        Dynamic<?> dynamic1 = poorMansPalettedContainer.get(i1, 0, i);
                        boolean flag1 = dynamic1 != null && "minecraft:bedrock".equals(dynamic1.get("Name").asString(""));
                        boolean bl = flag2 = dynamic1 != null && "minecraft:air".equals(dynamic1.get("Name").asString(""));
                        if (flag2) {
                            bitSet.set(i * 16 + i1);
                        }
                        flag |= flag1;
                    }
                }
                if (flag && bitSet.cardinality() != bitSet.size()) {
                    Dynamic dynamic2 = "full".equals(string) ? chunkTag.createString("heightmaps") : dynamic;
                    chunkTag = chunkTag.set("below_zero_retrogen", chunkTag.createMap((Map)ImmutableMap.of((Object)((Object)chunkTag.createString("target_status")), (Object)((Object)dynamic2), (Object)((Object)chunkTag.createString("missing_bedrock")), (Object)((Object)chunkTag.createLongList(LongStream.of(bitSet.toLongArray()))))));
                    chunkTag = chunkTag.set("Status", chunkTag.createString("empty"));
                }
                chunkTag = chunkTag.set("isLightOn", chunkTag.createBoolean(false));
            }
        }
        return chunkTag;
    }

    private static <T> Dynamic<T> shiftUpgradeData(Dynamic<T> data) {
        return data.update("Indices", dynamic -> {
            HashMap map = new HashMap();
            dynamic.getMapValues().ifSuccess(map1 -> map1.forEach((dynamic1, dynamic2) -> {
                try {
                    dynamic1.asString().result().map(Integer::parseInt).ifPresent(integer -> {
                        int i = integer - -4;
                        map.put(dynamic1.createString(Integer.toString(i)), dynamic2);
                    });
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }));
            return dynamic.createMap(map);
        });
    }

    private static Dynamic<?> updateCarvingMasks(Dynamic<?> data, int sectionCount, int offset) {
        Dynamic dynamic = data.get("CarvingMasks").orElseEmptyMap();
        dynamic = dynamic.updateMapValues(pair -> {
            long[] longs = BitSet.valueOf(((Dynamic)((Object)((Object)pair.getSecond()))).asByteBuffer().array()).toLongArray();
            long[] longs1 = new long[64 * sectionCount];
            System.arraycopy(longs, 0, longs1, 64 * offset, longs.length);
            return Pair.of((Object)((Object)((Dynamic)((Object)((Object)pair.getFirst())))), (Object)((Object)data.createLongList(LongStream.of(longs1))));
        });
        return data.set("CarvingMasks", dynamic);
    }

    private static Dynamic<?> addPaddingEntries(Dynamic<?> data, String key) {
        List list = data.get(key).orElseEmptyList().asStream().collect(Collectors.toCollection(ArrayList::new));
        if (list.size() == 24) {
            return data;
        }
        Dynamic dynamic = data.emptyList();
        for (int i = 0; i < 4; ++i) {
            list.add(0, dynamic);
            list.add(dynamic);
        }
        return data.set(key, data.createList(list.stream()));
    }

    private static Dynamic<?> updateHeightmaps(Dynamic<?> data) {
        return data.update("Heightmaps", dynamic -> {
            for (String string : HEIGHTMAP_TYPES) {
                dynamic = dynamic.update(string, ChunkHeightAndBiomeFix::getFixedHeightmap);
            }
            return dynamic;
        });
    }

    private static Dynamic<?> getFixedHeightmap(Dynamic<?> dynamic) {
        return dynamic.createLongList(dynamic.asLongStream().map(l -> {
            long l1 = 0L;
            int i = 0;
            while (i + 9 <= 64) {
                long l2 = l >> i & 0x1FFL;
                long l3 = l2 == 0L ? 0L : Math.min(l2 + 64L, 511L);
                l1 |= l3 << i;
                i += 9;
            }
            return l1;
        }));
    }

    private static Dynamic<?> makeBiomeContainer(Dynamic<?> data, Int2IntFunction oldBiomeGetter) {
        int i1;
        Int2IntLinkedOpenHashMap map = new Int2IntLinkedOpenHashMap();
        for (int i = 0; i < 64; ++i) {
            i1 = oldBiomeGetter.applyAsInt(i);
            if (map.containsKey(i1)) continue;
            map.put(i1, map.size());
        }
        Dynamic dynamic = data.createList(map.keySet().stream().map(integer -> data.createString((String)BIOMES_BY_ID.getOrDefault(integer.intValue(), (Object)DEFAULT_BIOME))));
        i1 = ChunkHeightAndBiomeFix.ceillog2(map.size());
        if (i1 == 0) {
            return ChunkHeightAndBiomeFix.makePalettedContainer(dynamic);
        }
        int i2 = 64 / i1;
        int i3 = (64 + i2 - 1) / i2;
        long[] longs = new long[i3];
        int i4 = 0;
        int i5 = 0;
        for (int i6 = 0; i6 < 64; ++i6) {
            int i7 = oldBiomeGetter.applyAsInt(i6);
            int n = i4++;
            longs[n] = longs[n] | (long)map.get(i7) << i5;
            if ((i5 += i1) + i1 <= 64) continue;
            i5 = 0;
        }
        Dynamic dynamic1 = data.createLongList(Arrays.stream(longs));
        return ChunkHeightAndBiomeFix.makePalettedContainer(dynamic, dynamic1);
    }

    private static Dynamic<?> makePalettedContainer(Dynamic<?> palette) {
        return palette.createMap((Map)ImmutableMap.of((Object)((Object)palette.createString("palette")), palette));
    }

    private static Dynamic<?> makePalettedContainer(Dynamic<?> palette, Dynamic<?> blockStates) {
        return palette.createMap((Map)ImmutableMap.of((Object)((Object)palette.createString("palette")), palette, (Object)((Object)palette.createString("data")), blockStates));
    }

    private static Dynamic<?> makeOptimizedPalettedContainer(Dynamic<?> palette, Dynamic<?> blockStates) {
        List list = palette.asStream().collect(Collectors.toCollection(ArrayList::new));
        if (list.size() == 1) {
            return ChunkHeightAndBiomeFix.makePalettedContainer(palette);
        }
        palette = ChunkHeightAndBiomeFix.padPaletteEntries(palette, blockStates, list);
        return ChunkHeightAndBiomeFix.makePalettedContainer(palette, blockStates);
    }

    private static Dynamic<?> padPaletteEntries(Dynamic<?> palette, Dynamic<?> blockStates, List<Dynamic<?>> paletteEntries) {
        int size;
        int i;
        long l = blockStates.asLongStream().count() * 64L;
        long l1 = l / 4096L;
        if (l1 <= (long)(i = ChunkHeightAndBiomeFix.ceillog2(size = paletteEntries.size()))) {
            return palette;
        }
        Dynamic dynamic = palette.createMap((Map)ImmutableMap.of((Object)((Object)palette.createString("Name")), (Object)((Object)palette.createString("minecraft:air"))));
        int i1 = (1 << (int)(l1 - 1L)) + 1;
        int i2 = i1 - size;
        for (int i3 = 0; i3 < i2; ++i3) {
            paletteEntries.add(dynamic);
        }
        return palette.createList(paletteEntries.stream());
    }

    public static int ceillog2(int value) {
        return value == 0 ? 0 : (int)Math.ceil(Math.log(value) / Math.log(2.0));
    }

    private static /* synthetic */ Dynamic lambda$makeRule$6(Set set, Dynamic dynamic1, int i, Dynamic[] biomeContainers, IntSet set1, MutableObject mutableObject, Dynamic dynamic4) {
        int _int = dynamic4.get("Y").asInt(0);
        Dynamic dynamic5 = (Dynamic)((Object)DataFixUtils.orElse(dynamic4.get("Palette").result().flatMap(dynamic7 -> {
            dynamic7.asStream().map(dynamic8 -> dynamic8.get("Name").asString("minecraft:air")).forEach(set::add);
            return dynamic4.get("BlockStates").result().map(dynamic8 -> ChunkHeightAndBiomeFix.makeOptimizedPalettedContainer(dynamic7, dynamic8));
        }), (Object)((Object)dynamic1)));
        Dynamic dynamic6 = dynamic4;
        int i3 = _int - i;
        if (i3 >= 0 && i3 < biomeContainers.length) {
            dynamic6 = dynamic4.set("biomes", biomeContainers[i3]);
        }
        set1.add(_int);
        if (dynamic4.get("Y").asInt(Integer.MAX_VALUE) == 0) {
            mutableObject.setValue(() -> {
                List list1 = dynamic5.get("palette").asList(Function.identity());
                long[] longs = dynamic5.get("data").asLongStream().toArray();
                return new ChunkProtoTickListFix.PoorMansPalettedContainer(list1, longs);
            });
        }
        return dynamic6.set("block_states", dynamic5).remove("Palette").remove("BlockStates");
    }

    static {
        BIOMES_BY_ID.put(0, (Object)"minecraft:ocean");
        BIOMES_BY_ID.put(1, (Object)DEFAULT_BIOME);
        BIOMES_BY_ID.put(2, (Object)"minecraft:desert");
        BIOMES_BY_ID.put(3, (Object)"minecraft:mountains");
        BIOMES_BY_ID.put(4, (Object)"minecraft:forest");
        BIOMES_BY_ID.put(5, (Object)"minecraft:taiga");
        BIOMES_BY_ID.put(6, (Object)"minecraft:swamp");
        BIOMES_BY_ID.put(7, (Object)"minecraft:river");
        BIOMES_BY_ID.put(8, (Object)"minecraft:nether_wastes");
        BIOMES_BY_ID.put(9, (Object)"minecraft:the_end");
        BIOMES_BY_ID.put(10, (Object)"minecraft:frozen_ocean");
        BIOMES_BY_ID.put(11, (Object)"minecraft:frozen_river");
        BIOMES_BY_ID.put(12, (Object)"minecraft:snowy_tundra");
        BIOMES_BY_ID.put(13, (Object)"minecraft:snowy_mountains");
        BIOMES_BY_ID.put(14, (Object)"minecraft:mushroom_fields");
        BIOMES_BY_ID.put(15, (Object)"minecraft:mushroom_field_shore");
        BIOMES_BY_ID.put(16, (Object)"minecraft:beach");
        BIOMES_BY_ID.put(17, (Object)"minecraft:desert_hills");
        BIOMES_BY_ID.put(18, (Object)"minecraft:wooded_hills");
        BIOMES_BY_ID.put(19, (Object)"minecraft:taiga_hills");
        BIOMES_BY_ID.put(20, (Object)"minecraft:mountain_edge");
        BIOMES_BY_ID.put(21, (Object)"minecraft:jungle");
        BIOMES_BY_ID.put(22, (Object)"minecraft:jungle_hills");
        BIOMES_BY_ID.put(23, (Object)"minecraft:jungle_edge");
        BIOMES_BY_ID.put(24, (Object)"minecraft:deep_ocean");
        BIOMES_BY_ID.put(25, (Object)"minecraft:stone_shore");
        BIOMES_BY_ID.put(26, (Object)"minecraft:snowy_beach");
        BIOMES_BY_ID.put(27, (Object)"minecraft:birch_forest");
        BIOMES_BY_ID.put(28, (Object)"minecraft:birch_forest_hills");
        BIOMES_BY_ID.put(29, (Object)"minecraft:dark_forest");
        BIOMES_BY_ID.put(30, (Object)"minecraft:snowy_taiga");
        BIOMES_BY_ID.put(31, (Object)"minecraft:snowy_taiga_hills");
        BIOMES_BY_ID.put(32, (Object)"minecraft:giant_tree_taiga");
        BIOMES_BY_ID.put(33, (Object)"minecraft:giant_tree_taiga_hills");
        BIOMES_BY_ID.put(34, (Object)"minecraft:wooded_mountains");
        BIOMES_BY_ID.put(35, (Object)"minecraft:savanna");
        BIOMES_BY_ID.put(36, (Object)"minecraft:savanna_plateau");
        BIOMES_BY_ID.put(37, (Object)"minecraft:badlands");
        BIOMES_BY_ID.put(38, (Object)"minecraft:wooded_badlands_plateau");
        BIOMES_BY_ID.put(39, (Object)"minecraft:badlands_plateau");
        BIOMES_BY_ID.put(40, (Object)"minecraft:small_end_islands");
        BIOMES_BY_ID.put(41, (Object)"minecraft:end_midlands");
        BIOMES_BY_ID.put(42, (Object)"minecraft:end_highlands");
        BIOMES_BY_ID.put(43, (Object)"minecraft:end_barrens");
        BIOMES_BY_ID.put(44, (Object)"minecraft:warm_ocean");
        BIOMES_BY_ID.put(45, (Object)"minecraft:lukewarm_ocean");
        BIOMES_BY_ID.put(46, (Object)"minecraft:cold_ocean");
        BIOMES_BY_ID.put(47, (Object)"minecraft:deep_warm_ocean");
        BIOMES_BY_ID.put(48, (Object)"minecraft:deep_lukewarm_ocean");
        BIOMES_BY_ID.put(49, (Object)"minecraft:deep_cold_ocean");
        BIOMES_BY_ID.put(50, (Object)"minecraft:deep_frozen_ocean");
        BIOMES_BY_ID.put(127, (Object)"minecraft:the_void");
        BIOMES_BY_ID.put(129, (Object)"minecraft:sunflower_plains");
        BIOMES_BY_ID.put(130, (Object)"minecraft:desert_lakes");
        BIOMES_BY_ID.put(131, (Object)"minecraft:gravelly_mountains");
        BIOMES_BY_ID.put(132, (Object)"minecraft:flower_forest");
        BIOMES_BY_ID.put(133, (Object)"minecraft:taiga_mountains");
        BIOMES_BY_ID.put(134, (Object)"minecraft:swamp_hills");
        BIOMES_BY_ID.put(140, (Object)"minecraft:ice_spikes");
        BIOMES_BY_ID.put(149, (Object)"minecraft:modified_jungle");
        BIOMES_BY_ID.put(151, (Object)"minecraft:modified_jungle_edge");
        BIOMES_BY_ID.put(155, (Object)"minecraft:tall_birch_forest");
        BIOMES_BY_ID.put(156, (Object)"minecraft:tall_birch_hills");
        BIOMES_BY_ID.put(157, (Object)"minecraft:dark_forest_hills");
        BIOMES_BY_ID.put(158, (Object)"minecraft:snowy_taiga_mountains");
        BIOMES_BY_ID.put(160, (Object)"minecraft:giant_spruce_taiga");
        BIOMES_BY_ID.put(161, (Object)"minecraft:giant_spruce_taiga_hills");
        BIOMES_BY_ID.put(162, (Object)"minecraft:modified_gravelly_mountains");
        BIOMES_BY_ID.put(163, (Object)"minecraft:shattered_savanna");
        BIOMES_BY_ID.put(164, (Object)"minecraft:shattered_savanna_plateau");
        BIOMES_BY_ID.put(165, (Object)"minecraft:eroded_badlands");
        BIOMES_BY_ID.put(166, (Object)"minecraft:modified_wooded_badlands_plateau");
        BIOMES_BY_ID.put(167, (Object)"minecraft:modified_badlands_plateau");
        BIOMES_BY_ID.put(168, (Object)"minecraft:bamboo_jungle");
        BIOMES_BY_ID.put(169, (Object)"minecraft:bamboo_jungle_hills");
        BIOMES_BY_ID.put(170, (Object)"minecraft:soul_sand_valley");
        BIOMES_BY_ID.put(171, (Object)"minecraft:crimson_forest");
        BIOMES_BY_ID.put(172, (Object)"minecraft:warped_forest");
        BIOMES_BY_ID.put(173, (Object)"minecraft:basalt_deltas");
        BIOMES_BY_ID.put(174, (Object)"minecraft:dripstone_caves");
        BIOMES_BY_ID.put(175, (Object)"minecraft:lush_caves");
        BIOMES_BY_ID.put(177, (Object)"minecraft:meadow");
        BIOMES_BY_ID.put(178, (Object)"minecraft:grove");
        BIOMES_BY_ID.put(179, (Object)"minecraft:snowy_slopes");
        BIOMES_BY_ID.put(180, (Object)"minecraft:snowcapped_peaks");
        BIOMES_BY_ID.put(181, (Object)"minecraft:lofty_peaks");
        BIOMES_BY_ID.put(182, (Object)"minecraft:stony_peaks");
    }
}

