/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import net.minecraft.Util;
import net.minecraft.util.datafix.LegacyComponentDataFixUtils;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.util.datafix.schemas.NamespacedSchema;

public class EntityCustomNameToComponentFix
extends DataFix {
    public EntityCustomNameToComponentFix(Schema outputSchema) {
        super(outputSchema, true);
    }

    public TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(References.ENTITY);
        Type type1 = this.getOutputSchema().getType(References.ENTITY);
        OpticFinder opticFinder = DSL.fieldFinder((String)"id", NamespacedSchema.namespacedString());
        OpticFinder opticFinder1 = type.findField("CustomName");
        Type type2 = type1.findFieldType("CustomName");
        return this.fixTypeEverywhereTyped("EntityCustomNameToComponentFix", type, type1, typed -> EntityCustomNameToComponentFix.fixEntity(typed, (OpticFinder<String>)opticFinder, (OpticFinder<String>)opticFinder1, type2));
    }

    private static <T> Typed<?> fixEntity(Typed<?> data, OpticFinder<String> customNameOptic, OpticFinder<String> idOptic, Type<T> newType) {
        return data.update(idOptic, newType, string -> {
            String string1 = data.getOptional(customNameOptic).orElse("");
            Dynamic dynamic = EntityCustomNameToComponentFix.fixCustomName(data.getOps(), string, string1);
            return Util.readTypedOrThrow(newType, dynamic).getValue();
        });
    }

    public static <T> Dynamic<T> fixCustomName(DynamicOps<T> ops, String customName, String id) {
        return "minecraft:commandblock_minecart".equals(id) ? new Dynamic<T>(ops, (Object)ops.createString(customName)) : LegacyComponentDataFixUtils.createPlainTextComponent(ops, customName);
    }
}

