/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Dynamic;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.util.datafix.fixes.References;

public class FeatureFlagRemoveFix
extends DataFix {
    private final String name;
    private final Set<String> flagsToRemove;

    public FeatureFlagRemoveFix(Schema outputSchema, String name, Set<String> flagsToRemove) {
        super(outputSchema, false);
        this.name = name;
        this.flagsToRemove = flagsToRemove;
    }

    protected TypeRewriteRule makeRule() {
        return this.fixTypeEverywhereTyped(this.name, this.getInputSchema().getType(References.LEVEL), typed -> typed.update(DSL.remainderFinder(), this::fixTag));
    }

    private <T> Dynamic<T> fixTag(Dynamic<T> tag) {
        List list = tag.get("removed_features").asStream().collect(Collectors.toCollection(ArrayList::new));
        Dynamic<T> dynamic = tag.update("enabled_features", dynamic1 -> (Dynamic)((Object)((Object)DataFixUtils.orElse(dynamic1.asStreamOpt().result().map(stream -> stream.filter(dynamic2 -> {
            Optional optional = dynamic2.asString().result();
            if (optional.isEmpty()) {
                return true;
            }
            boolean flag = this.flagsToRemove.contains(optional.get());
            if (flag) {
                list.add(tag.createString((String)optional.get()));
            }
            return !flag;
        })).map(arg_0 -> ((Dynamic)tag).createList(arg_0)), (Object)dynamic1))));
        if (!list.isEmpty()) {
            dynamic = dynamic.set("removed_features", tag.createList(list.stream()));
        }
        return dynamic;
    }
}

