/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Dynamic;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.util.datafix.fixes.BlockStateData;
import net.minecraft.util.datafix.fixes.EntityBlockStateFix;
import net.minecraft.util.datafix.fixes.References;
import org.apache.commons.lang3.math.NumberUtils;

public class LevelFlatGeneratorInfoFix
extends DataFix {
    private static final String GENERATOR_OPTIONS = "generatorOptions";
    @VisibleForTesting
    static final String DEFAULT = "minecraft:bedrock,2*minecraft:dirt,minecraft:grass_block;1;village";
    private static final Splitter SPLITTER = Splitter.on((char)';').limit(5);
    private static final Splitter LAYER_SPLITTER = Splitter.on((char)',');
    private static final Splitter OLD_AMOUNT_SPLITTER = Splitter.on((char)'x').limit(2);
    private static final Splitter AMOUNT_SPLITTER = Splitter.on((char)'*').limit(2);
    private static final Splitter BLOCK_SPLITTER = Splitter.on((char)':').limit(3);

    public LevelFlatGeneratorInfoFix(Schema outputSchema, boolean changesType) {
        super(outputSchema, changesType);
    }

    public TypeRewriteRule makeRule() {
        return this.fixTypeEverywhereTyped("LevelFlatGeneratorInfoFix", this.getInputSchema().getType(References.LEVEL), typed -> typed.update(DSL.remainderFinder(), this::fix));
    }

    private Dynamic<?> fix(Dynamic<?> dynamic) {
        return dynamic.get("generatorName").asString("").equalsIgnoreCase("flat") ? dynamic.update(GENERATOR_OPTIONS, dynamic1 -> (Dynamic)((Object)((Object)DataFixUtils.orElse((Optional)dynamic1.asString().map(this::fixString).map(arg_0 -> ((Dynamic)((Object)dynamic1)).createString(arg_0)).result(), (Object)dynamic1)))) : dynamic;
    }

    @VisibleForTesting
    String fixString(String string) {
        String string2;
        int i;
        if (string.isEmpty()) {
            return DEFAULT;
        }
        Iterator iterator = SPLITTER.split((CharSequence)string).iterator();
        String string1 = (String)iterator.next();
        if (iterator.hasNext()) {
            i = NumberUtils.toInt((String)string1, (int)0);
            string2 = (String)iterator.next();
        } else {
            i = 0;
            string2 = string1;
        }
        if (i >= 0 && i <= 3) {
            StringBuilder stringBuilder = new StringBuilder();
            Splitter splitter = i < 3 ? OLD_AMOUNT_SPLITTER : AMOUNT_SPLITTER;
            stringBuilder.append(StreamSupport.stream(LAYER_SPLITTER.split((CharSequence)string2).spliterator(), false).map(string3 -> {
                String string4;
                int i1;
                List parts = splitter.splitToList((CharSequence)string3);
                if (parts.size() == 2) {
                    i1 = NumberUtils.toInt((String)((String)parts.get(0)));
                    string4 = (String)parts.get(1);
                } else {
                    i1 = 1;
                    string4 = (String)parts.get(0);
                }
                List parts1 = BLOCK_SPLITTER.splitToList((CharSequence)string4);
                int i2 = ((String)parts1.get(0)).equals("minecraft") ? 1 : 0;
                String string5 = (String)parts1.get(i2);
                int i3 = i == 3 ? EntityBlockStateFix.getBlockId("minecraft:" + string5) : NumberUtils.toInt((String)string5, (int)0);
                int i4 = i2 + 1;
                int i5 = parts1.size() > i4 ? NumberUtils.toInt((String)((String)parts1.get(i4)), (int)0) : 0;
                return (String)(i1 == 1 ? "" : i1 + "*") + BlockStateData.getTag(i3 << 4 | i5).get("Name").asString("");
            }).collect(Collectors.joining(",")));
            while (iterator.hasNext()) {
                stringBuilder.append(';').append((String)iterator.next());
            }
            return stringBuilder.toString();
        }
        return DEFAULT;
    }
}

