/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.util.datafix.fixes.References;

public class MobSpawnerEntityIdentifiersFix
extends DataFix {
    public MobSpawnerEntityIdentifiersFix(Schema outputSchema, boolean changesType) {
        super(outputSchema, changesType);
    }

    private Dynamic<?> fix(Dynamic<?> dynamic) {
        Optional optional1;
        if (!"MobSpawner".equals(dynamic.get("id").asString(""))) {
            return dynamic;
        }
        Optional optional = dynamic.get("EntityId").asString().result();
        if (optional.isPresent()) {
            Dynamic dynamic1 = (Dynamic)((Object)DataFixUtils.orElse((Optional)dynamic.get("SpawnData").result(), (Object)((Object)dynamic.emptyMap())));
            dynamic1 = dynamic1.set("id", dynamic1.createString(((String)optional.get()).isEmpty() ? "Pig" : (String)optional.get()));
            dynamic = dynamic.set("SpawnData", dynamic1);
            dynamic = dynamic.remove("EntityId");
        }
        if ((optional1 = dynamic.get("SpawnPotentials").asStreamOpt().result()).isPresent()) {
            dynamic = dynamic.set("SpawnPotentials", dynamic.createList(((Stream)optional1.get()).map(dynamic2 -> {
                Optional optional2 = dynamic2.get("Type").asString().result();
                if (optional2.isPresent()) {
                    Dynamic dynamic3 = ((Dynamic)((Object)((Object)DataFixUtils.orElse((Optional)dynamic2.get("Properties").result(), (Object)((Object)dynamic2.emptyMap()))))).set("id", dynamic2.createString((String)optional2.get()));
                    return dynamic2.set("Entity", dynamic3).remove("Type").remove("Properties");
                }
                return dynamic2;
            })));
        }
        return dynamic;
    }

    public TypeRewriteRule makeRule() {
        Type type = this.getOutputSchema().getType(References.UNTAGGED_SPAWNER);
        return this.fixTypeEverywhereTyped("MobSpawnerEntityIdentifiersFix", this.getInputSchema().getType(References.UNTAGGED_SPAWNER), type, typed -> {
            Dynamic dynamic = (Dynamic)((Object)((Object)typed.get(DSL.remainderFinder())));
            DataResult typed1 = type.readTyped(this.fix(dynamic = dynamic.set("id", dynamic.createString("MobSpawner"))));
            return typed1.result().isEmpty() ? typed : (Typed)((Pair)typed1.result().get()).getFirst();
        });
    }
}

