/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.TaggedChoice;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.Set;
import net.minecraft.Util;
import net.minecraft.util.datafix.ExtraDataFixUtils;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.util.datafix.schemas.NamespacedSchema;

public class SaddleEquipmentSlotFix
extends DataFix {
    private static final Set<String> ENTITIES_WITH_SADDLE_ITEM = Set.of("minecraft:horse", "minecraft:skeleton_horse", "minecraft:zombie_horse", "minecraft:donkey", "minecraft:mule", "minecraft:camel", "minecraft:llama", "minecraft:trader_llama");
    private static final Set<String> ENTITIES_WITH_SADDLE_FLAG = Set.of("minecraft:pig", "minecraft:strider");
    private static final String SADDLE_FLAG = "Saddle";
    private static final String NEW_SADDLE = "saddle";

    public SaddleEquipmentSlotFix(Schema outputSchema) {
        super(outputSchema, true);
    }

    protected TypeRewriteRule makeRule() {
        TaggedChoice.TaggedChoiceType taggedChoiceType = this.getInputSchema().findChoiceType(References.ENTITY);
        OpticFinder opticFinder = DSL.typeFinder((Type)taggedChoiceType);
        Type type = this.getInputSchema().getType(References.ENTITY);
        Type type1 = this.getOutputSchema().getType(References.ENTITY);
        Type<?> type2 = ExtraDataFixUtils.patchSubType(type, type, type1);
        return this.fixTypeEverywhereTyped("SaddleEquipmentSlotFix", type, type1, typed -> {
            String string = typed.getOptional(opticFinder).map(Pair::getFirst).map(NamespacedSchema::ensureNamespaced).orElse("");
            Typed typed1 = ExtraDataFixUtils.cast(type2, typed);
            if (ENTITIES_WITH_SADDLE_ITEM.contains(string)) {
                return Util.writeAndReadTypedOrThrow(typed1, type1, SaddleEquipmentSlotFix::fixEntityWithSaddleItem);
            }
            return ENTITIES_WITH_SADDLE_FLAG.contains(string) ? Util.writeAndReadTypedOrThrow(typed1, type1, SaddleEquipmentSlotFix::fixEntityWithSaddleFlag) : ExtraDataFixUtils.cast(type1, typed);
        });
    }

    private static Dynamic<?> fixEntityWithSaddleItem(Dynamic<?> data) {
        return data.get("SaddleItem").result().isEmpty() ? data : SaddleEquipmentSlotFix.fixDropChances(data.renameField("SaddleItem", NEW_SADDLE));
    }

    private static Dynamic<?> fixEntityWithSaddleFlag(Dynamic<?> data) {
        boolean _boolean = data.get(SADDLE_FLAG).asBoolean(false);
        data = data.remove(SADDLE_FLAG);
        if (!_boolean) {
            return data;
        }
        Dynamic dynamic = data.emptyMap().set("id", data.createString("minecraft:saddle")).set("count", data.createInt(1));
        return SaddleEquipmentSlotFix.fixDropChances(data.set(NEW_SADDLE, dynamic));
    }

    private static Dynamic<?> fixDropChances(Dynamic<?> data) {
        Dynamic dynamic = data.get("drop_chances").orElseEmptyMap().set(NEW_SADDLE, data.createFloat(2.0f));
        return data.set("drop_chances", dynamic);
    }
}

