/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.util.datafix.ExtraDataFixUtils;
import net.minecraft.util.datafix.fixes.References;

public class TextComponentHoverAndClickEventFix
extends DataFix {
    public TextComponentHoverAndClickEventFix(Schema outputSchema) {
        super(outputSchema, true);
    }

    protected TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(References.TEXT_COMPONENT).findFieldType("hoverEvent");
        return this.createFixer(this.getInputSchema().getTypeRaw(References.TEXT_COMPONENT), this.getOutputSchema().getType(References.TEXT_COMPONENT), type);
    }

    private <C1, C2, H extends Pair<String, ?>> TypeRewriteRule createFixer(Type<C1> inputComponentType, Type<C2> outputComponentType, Type<H> hoverEventType) {
        Type type = DSL.named((String)References.TEXT_COMPONENT.typeName(), (Type)DSL.or((Type)DSL.or((Type)DSL.string(), (Type)DSL.list(inputComponentType)), (Type)DSL.and((Type)DSL.optional((Type)DSL.field((String)"extra", (Type)DSL.list(inputComponentType))), (Type)DSL.optional((Type)DSL.field((String)"separator", inputComponentType)), (Type)DSL.optional((Type)DSL.field((String)"hoverEvent", hoverEventType)), (Type)DSL.remainderType())));
        if (!type.equals((Object)this.getInputSchema().getType(References.TEXT_COMPONENT))) {
            throw new IllegalStateException("Text component type did not match, expected " + String.valueOf(type) + " but got " + String.valueOf(this.getInputSchema().getType(References.TEXT_COMPONENT)));
        }
        Type<?> type1 = ExtraDataFixUtils.patchSubType(type, type, outputComponentType);
        return this.fixTypeEverywhere("TextComponentHoverAndClickEventFix", type, outputComponentType, dynamicOps -> pair -> {
            boolean flag = ((Either)pair.getSecond()).map(either -> false, pair1 -> {
                Pair pair2 = (Pair)((Pair)pair1.getSecond()).getSecond();
                boolean isPresent = ((Either)pair2.getFirst()).left().isPresent();
                boolean isPresent1 = ((Dynamic)((Object)((Object)((Object)((Object)pair2.getSecond()))))).get("clickEvent").result().isPresent();
                return isPresent || isPresent1;
            });
            return !flag ? pair : Util.writeAndReadTypedOrThrow(ExtraDataFixUtils.cast(type1, pair, dynamicOps), outputComponentType, TextComponentHoverAndClickEventFix::fixTextComponent).getValue();
        });
    }

    private static Dynamic<?> fixTextComponent(Dynamic<?> data) {
        return data.renameAndFixField("hoverEvent", "hover_event", TextComponentHoverAndClickEventFix::fixHoverEvent).renameAndFixField("clickEvent", "click_event", TextComponentHoverAndClickEventFix::fixClickEvent);
    }

    private static Dynamic<?> copyFields(Dynamic<?> newData, Dynamic<?> oldData, String ... fields) {
        for (String string : fields) {
            newData = Dynamic.copyField(oldData, string, newData, string);
        }
        return newData;
    }

    private static Dynamic<?> fixHoverEvent(Dynamic<?> data) {
        String string;
        return switch (string = data.get("action").asString("")) {
            case "show_text" -> data.renameField("contents", "value");
            case "show_item" -> {
                Dynamic dynamic = data.get("contents").orElseEmptyMap();
                Optional optional = dynamic.asString().result();
                if (optional.isPresent()) {
                    yield data.renameField("contents", "id");
                }
                yield TextComponentHoverAndClickEventFix.copyFields(data.remove("contents"), dynamic, "id", "count", "components");
            }
            case "show_entity" -> {
                Dynamic dynamic = data.get("contents").orElseEmptyMap();
                yield TextComponentHoverAndClickEventFix.copyFields(data.remove("contents"), dynamic, "id", "type", "name").renameField("id", "uuid").renameField("type", "id");
            }
            default -> data;
        };
    }

    @Nullable
    private static <T> Dynamic<T> fixClickEvent(Dynamic<T> data) {
        String string = data.get("action").asString("");
        String string1 = data.get("value").asString("");
        return switch (string) {
            case "open_url" -> {
                if (!TextComponentHoverAndClickEventFix.validateUri(string1)) {
                    yield null;
                }
                yield data.renameField("value", "url");
            }
            case "open_file" -> data.renameField("value", "path");
            case "run_command", "suggest_command" -> {
                if (!TextComponentHoverAndClickEventFix.validateChat(string1)) {
                    yield null;
                }
                yield data.renameField("value", "command");
            }
            case "change_page" -> {
                Integer integer = data.get("value").result().map(TextComponentHoverAndClickEventFix::parseOldPage).orElse(null);
                if (integer == null) {
                    yield null;
                }
                int max = Math.max(integer, 1);
                yield data.remove("value").set("page", data.createInt(max));
            }
            default -> data;
        };
    }

    @Nullable
    private static Integer parseOldPage(Dynamic<?> data) {
        Optional optional = data.asNumber().result();
        if (optional.isPresent()) {
            return ((Number)optional.get()).intValue();
        }
        try {
            return Integer.parseInt(data.asString(""));
        }
        catch (Exception var3) {
            return null;
        }
    }

    private static boolean validateUri(String uri) {
        try {
            URI uri1 = new URI(uri);
            String scheme = uri1.getScheme();
            if (scheme == null) {
                return false;
            }
            String string = scheme.toLowerCase(Locale.ROOT);
            return "http".equals(string) || "https".equals(string);
        }
        catch (URISyntaxException var4) {
            return false;
        }
    }

    private static boolean validateChat(String chat) {
        for (int i = 0; i < chat.length(); ++i) {
            char c = chat.charAt(i);
            if (c != '\u00a7' && c >= ' ' && c != '\u007f') continue;
            return false;
        }
        return true;
    }
}

