/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.parsing.packrat.commands;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.util.parsing.packrat.DelayedException;
import net.minecraft.util.parsing.packrat.Dictionary;
import net.minecraft.util.parsing.packrat.ErrorCollector;
import net.minecraft.util.parsing.packrat.ErrorEntry;
import net.minecraft.util.parsing.packrat.NamedRule;
import net.minecraft.util.parsing.packrat.ParseState;
import net.minecraft.util.parsing.packrat.SuggestionSupplier;
import net.minecraft.util.parsing.packrat.commands.CommandArgumentParser;
import net.minecraft.util.parsing.packrat.commands.ResourceSuggestion;
import net.minecraft.util.parsing.packrat.commands.StringReaderParserState;

public record Grammar<T>(Dictionary<StringReader> rules, NamedRule<StringReader, T> top) implements CommandArgumentParser<T>
{
    public Grammar {
        rules.checkAllBound();
    }

    public Optional<T> parse(ParseState<StringReader> parseState) {
        return parseState.parseTopRule(this.top);
    }

    @Override
    public T parseForCommands(StringReader reader) throws CommandSyntaxException {
        Object r;
        ErrorCollector.LongestOnly<StringReader> longestOnly = new ErrorCollector.LongestOnly<StringReader>();
        StringReaderParserState stringReaderParserState = new StringReaderParserState(longestOnly, reader);
        Optional<T> optional = this.parse(stringReaderParserState);
        if (optional.isPresent()) {
            return optional.get();
        }
        List<ErrorEntry<StringReader>> list = longestOnly.entries();
        List list1 = list.stream().mapMulti((errorEntry, consumer) -> {
            Object patt0$temp = errorEntry.reason();
            if (patt0$temp instanceof DelayedException) {
                DelayedException delayedException = (DelayedException)patt0$temp;
                consumer.accept(delayedException.create(reader.getString(), errorEntry.cursor()));
            } else {
                Object patt1$temp = errorEntry.reason();
                if (patt1$temp instanceof Exception) {
                    Exception exception1 = (Exception)patt1$temp;
                    consumer.accept(exception1);
                }
            }
        }).toList();
        for (Exception exception : list1) {
            if (!(exception instanceof CommandSyntaxException)) continue;
            CommandSyntaxException commandSyntaxException = (CommandSyntaxException)exception;
            throw commandSyntaxException;
        }
        if (list1.size() == 1 && (r = list1.get(0)) instanceof RuntimeException) {
            RuntimeException runtimeException = (RuntimeException)r;
            throw runtimeException;
        }
        throw new IllegalStateException("Failed to parse: " + list.stream().map(ErrorEntry::toString).collect(Collectors.joining(", ")));
    }

    @Override
    public CompletableFuture<Suggestions> parseForSuggestions(SuggestionsBuilder builder) {
        StringReader stringReader = new StringReader(builder.getInput());
        stringReader.setCursor(builder.getStart());
        ErrorCollector.LongestOnly<StringReader> longestOnly = new ErrorCollector.LongestOnly<StringReader>();
        StringReaderParserState stringReaderParserState = new StringReaderParserState(longestOnly, stringReader);
        this.parse(stringReaderParserState);
        List<ErrorEntry<StringReader>> list = longestOnly.entries();
        if (list.isEmpty()) {
            return builder.buildFuture();
        }
        SuggestionsBuilder suggestionsBuilder = builder.createOffset(longestOnly.cursor());
        for (ErrorEntry<StringReader> errorEntry : list) {
            SuggestionSupplier<StringReader> suggestionSupplier = errorEntry.suggestions();
            if (suggestionSupplier instanceof ResourceSuggestion) {
                ResourceSuggestion resourceSuggestion = (ResourceSuggestion)suggestionSupplier;
                SharedSuggestionProvider.suggestResource(resourceSuggestion.possibleResources(), suggestionsBuilder);
                continue;
            }
            SharedSuggestionProvider.suggest(errorEntry.suggestions().possibleValues(stringReaderParserState), suggestionsBuilder);
        }
        return suggestionsBuilder.buildFuture();
    }
}

