/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongMaps;
import java.io.BufferedWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.ReportType;
import net.minecraft.SharedConstants;
import net.minecraft.util.profiling.ProfileResults;
import net.minecraft.util.profiling.ProfilerPathEntry;
import net.minecraft.util.profiling.ResultField;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;

public class FilledProfileResults
implements ProfileResults {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final ProfilerPathEntry EMPTY = new ProfilerPathEntry(){

        @Override
        public long getDuration() {
            return 0L;
        }

        @Override
        public long getMaxDuration() {
            return 0L;
        }

        @Override
        public long getCount() {
            return 0L;
        }

        @Override
        public Object2LongMap<String> getCounters() {
            return Object2LongMaps.emptyMap();
        }
    };
    private static final Splitter SPLITTER = Splitter.on((char)'\u001e');
    private static final Comparator<Map.Entry<String, CounterCollector>> COUNTER_ENTRY_COMPARATOR = Map.Entry.comparingByValue(Comparator.comparingLong(counterCollector -> counterCollector.totalValue)).reversed();
    private final Map<String, ? extends ProfilerPathEntry> entries;
    private final long startTimeNano;
    private final int startTimeTicks;
    private final long endTimeNano;
    private final int endTimeTicks;
    private final int tickDuration;

    public FilledProfileResults(Map<String, ? extends ProfilerPathEntry> entries, long startTimeNano, int startTimeTicks, long endTimeNano, int endTimeTicks) {
        this.entries = entries;
        this.startTimeNano = startTimeNano;
        this.startTimeTicks = startTimeTicks;
        this.endTimeNano = endTimeNano;
        this.endTimeTicks = endTimeTicks;
        this.tickDuration = endTimeTicks - startTimeTicks;
    }

    private ProfilerPathEntry getEntry(String key) {
        ProfilerPathEntry profilerPathEntry = this.entries.get(key);
        return profilerPathEntry != null ? profilerPathEntry : EMPTY;
    }

    @Override
    public List<ResultField> getTimes(String sectionPath) {
        String string = sectionPath;
        ProfilerPathEntry entry = this.getEntry("root");
        long duration = entry.getDuration();
        ProfilerPathEntry entry1 = this.getEntry((String)sectionPath);
        long duration1 = entry1.getDuration();
        long count = entry1.getCount();
        ArrayList list = Lists.newArrayList();
        if (!((String)sectionPath).isEmpty()) {
            sectionPath = (String)sectionPath + "\u001e";
        }
        long l = 0L;
        for (String string1 : this.entries.keySet()) {
            if (!FilledProfileResults.isDirectChild((String)sectionPath, string1)) continue;
            l += this.getEntry(string1).getDuration();
        }
        float f = l;
        if (l < duration1) {
            l = duration1;
        }
        if (duration < l) {
            duration = l;
        }
        for (String string2 : this.entries.keySet()) {
            if (!FilledProfileResults.isDirectChild((String)sectionPath, string2)) continue;
            ProfilerPathEntry entry2 = this.getEntry(string2);
            long duration2 = entry2.getDuration();
            double d = (double)duration2 * 100.0 / (double)l;
            double d1 = (double)duration2 * 100.0 / (double)duration;
            String sub = string2.substring(((String)sectionPath).length());
            list.add(new ResultField(sub, d, d1, entry2.getCount()));
        }
        if ((float)l > f) {
            list.add(new ResultField("unspecified", (double)((float)l - f) * 100.0 / (double)l, (double)((float)l - f) * 100.0 / (double)duration, count));
        }
        Collections.sort(list);
        list.add(0, new ResultField(string, 100.0, (double)l * 100.0 / (double)duration, count));
        return list;
    }

    private static boolean isDirectChild(String sectionPath, String entry) {
        return entry.length() > sectionPath.length() && entry.startsWith(sectionPath) && entry.indexOf(30, sectionPath.length() + 1) < 0;
    }

    private Map<String, CounterCollector> getCounterValues() {
        TreeMap map = Maps.newTreeMap();
        this.entries.forEach((string, profilerPathEntry) -> {
            Object2LongMap<String> counters = profilerPathEntry.getCounters();
            if (!counters.isEmpty()) {
                List parts = SPLITTER.splitToList((CharSequence)string);
                counters.forEach((string1, _long) -> map.computeIfAbsent(string1, string2 -> new CounterCollector()).addValue(parts.iterator(), (long)_long));
            }
        });
        return map;
    }

    @Override
    public long getStartTimeNano() {
        return this.startTimeNano;
    }

    @Override
    public int getStartTimeTicks() {
        return this.startTimeTicks;
    }

    @Override
    public long getEndTimeNano() {
        return this.endTimeNano;
    }

    @Override
    public int getEndTimeTicks() {
        return this.endTimeTicks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean saveResults(Path path) {
        boolean bl;
        BufferedWriter writer = null;
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);
            writer.write(this.getProfilerResults(this.getNanoDuration(), this.getTickDuration()));
            bl = true;
        }
        catch (Throwable var8) {
            boolean var4;
            try {
                LOGGER.error("Could not save profiler results to {}", (Object)path, (Object)var8);
                var4 = false;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)writer);
            return var4;
        }
        IOUtils.closeQuietly((Writer)writer);
        return bl;
    }

    protected String getProfilerResults(long timeSpan, int tickSpan) {
        StringBuilder stringBuilder = new StringBuilder();
        ReportType.PROFILE.appendHeader(stringBuilder, List.of());
        stringBuilder.append("Version: ").append(SharedConstants.getCurrentVersion().getId()).append('\n');
        stringBuilder.append("Time span: ").append(timeSpan / 1000000L).append(" ms\n");
        stringBuilder.append("Tick span: ").append(tickSpan).append(" ticks\n");
        stringBuilder.append("// This is approximately ").append(String.format(Locale.ROOT, "%.2f", Float.valueOf((float)tickSpan / ((float)timeSpan / 1.0E9f)))).append(" ticks per second. It should be ").append(20).append(" ticks per second\n\n");
        stringBuilder.append("--- BEGIN PROFILE DUMP ---\n\n");
        this.appendProfilerResults(0, "root", stringBuilder);
        stringBuilder.append("--- END PROFILE DUMP ---\n\n");
        Map<String, CounterCollector> counterValues = this.getCounterValues();
        if (!counterValues.isEmpty()) {
            stringBuilder.append("--- BEGIN COUNTER DUMP ---\n\n");
            this.appendCounters(counterValues, stringBuilder, tickSpan);
            stringBuilder.append("--- END COUNTER DUMP ---\n\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public String getProfilerResults() {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendProfilerResults(0, "root", stringBuilder);
        return stringBuilder.toString();
    }

    private static StringBuilder indentLine(StringBuilder builder, int indents) {
        builder.append(String.format(Locale.ROOT, "[%02d] ", indents));
        for (int i = 0; i < indents; ++i) {
            builder.append("|   ");
        }
        return builder;
    }

    private void appendProfilerResults(int depth, String sectionPath, StringBuilder builder) {
        List<ResultField> times = this.getTimes(sectionPath);
        Object2LongMap<String> counters = ((ProfilerPathEntry)ObjectUtils.firstNonNull((Object[])new ProfilerPathEntry[]{this.entries.get(sectionPath), EMPTY})).getCounters();
        counters.forEach((string, _long) -> FilledProfileResults.indentLine(builder, depth).append('#').append((String)string).append(' ').append(_long).append('/').append(_long / (long)this.tickDuration).append('\n'));
        if (times.size() >= 3) {
            for (int i = 1; i < times.size(); ++i) {
                ResultField resultField = times.get(i);
                FilledProfileResults.indentLine(builder, depth).append(resultField.name).append('(').append(resultField.count).append('/').append(String.format(Locale.ROOT, "%.0f", Float.valueOf((float)resultField.count / (float)this.tickDuration))).append(')').append(" - ").append(String.format(Locale.ROOT, "%.2f", resultField.percentage)).append("%/").append(String.format(Locale.ROOT, "%.2f", resultField.globalPercentage)).append("%\n");
                if ("unspecified".equals(resultField.name)) continue;
                try {
                    this.appendProfilerResults(depth + 1, sectionPath + "\u001e" + resultField.name, builder);
                    continue;
                }
                catch (Exception var9) {
                    builder.append("[[ EXCEPTION ").append(var9).append(" ]]");
                }
            }
        }
    }

    private void appendCounterResults(int indents, String name, CounterCollector collector, int tickSpan, StringBuilder builder) {
        FilledProfileResults.indentLine(builder, indents).append(name).append(" total:").append(collector.selfValue).append('/').append(collector.totalValue).append(" average: ").append(collector.selfValue / (long)tickSpan).append('/').append(collector.totalValue / (long)tickSpan).append('\n');
        collector.children.entrySet().stream().sorted(COUNTER_ENTRY_COMPARATOR).forEach(entry -> this.appendCounterResults(indents + 1, (String)entry.getKey(), (CounterCollector)entry.getValue(), tickSpan, builder));
    }

    private void appendCounters(Map<String, CounterCollector> counters, StringBuilder builder, int tickSpan) {
        counters.forEach((string, counterCollector) -> {
            builder.append("-- Counter: ").append((String)string).append(" --\n");
            this.appendCounterResults(0, "root", counterCollector.children.get("root"), tickSpan, builder);
            builder.append("\n\n");
        });
    }

    @Override
    public int getTickDuration() {
        return this.tickDuration;
    }

    static class CounterCollector {
        long selfValue;
        long totalValue;
        final Map<String, CounterCollector> children = Maps.newHashMap();

        CounterCollector() {
        }

        public void addValue(Iterator<String> counters, long value) {
            this.totalValue += value;
            if (!counters.hasNext()) {
                this.selfValue += value;
            } else {
                this.children.computeIfAbsent(counters.next(), string -> new CounterCollector()).addValue(counters, value);
            }
        }
    }
}

