/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling.jfr;

import com.mojang.logging.LogUtils;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.server.Bootstrap;
import net.minecraft.util.profiling.jfr.parse.JfrStatsParser;
import net.minecraft.util.profiling.jfr.parse.JfrStatsResult;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public class SummaryReporter {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Runnable onDeregistration;

    protected SummaryReporter(Runnable onDeregistration) {
        this.onDeregistration = onDeregistration;
    }

    public void recordingStopped(@Nullable Path outputPath) {
        if (outputPath != null) {
            JfrStatsResult jfrStatsResult;
            this.onDeregistration.run();
            SummaryReporter.infoWithFallback(() -> "Dumped flight recorder profiling to " + String.valueOf(outputPath));
            try {
                jfrStatsResult = JfrStatsParser.parse(outputPath);
            }
            catch (Throwable var5) {
                SummaryReporter.warnWithFallback(() -> "Failed to parse JFR recording", var5);
                return;
            }
            try {
                SummaryReporter.infoWithFallback(jfrStatsResult::asJson);
                Path path = outputPath.resolveSibling("jfr-report-" + StringUtils.substringBefore((String)outputPath.getFileName().toString(), (String)".jfr") + ".json");
                Files.writeString(path, (CharSequence)jfrStatsResult.asJson(), StandardOpenOption.CREATE);
                SummaryReporter.infoWithFallback(() -> "Dumped recording summary to " + String.valueOf(path));
            }
            catch (Throwable var4) {
                SummaryReporter.warnWithFallback(() -> "Failed to output JFR report", var4);
            }
        }
    }

    private static void infoWithFallback(Supplier<String> message) {
        if (LogUtils.isLoggerActive()) {
            LOGGER.info(message.get());
        } else {
            Bootstrap.realStdoutPrintln(message.get());
        }
    }

    private static void warnWithFallback(Supplier<String> message, Throwable throwable) {
        if (LogUtils.isLoggerActive()) {
            LOGGER.warn(message.get(), throwable);
        } else {
            Bootstrap.realStdoutPrintln(message.get());
            throwable.printStackTrace(Bootstrap.STDOUT);
        }
    }
}

