/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.mojang.serialization.Codec;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.world.item.ItemStack;

public record LockCode(ItemPredicate predicate) {
    public static final LockCode NO_LOCK = new LockCode(ItemPredicate.Builder.item().build());
    public static final Codec<LockCode> CODEC = ItemPredicate.CODEC.xmap(LockCode::new, LockCode::predicate);
    public static final String TAG_LOCK = "lock";

    public boolean unlocksWith(ItemStack stack) {
        return this.predicate.test(stack);
    }

    public void addToTag(CompoundTag tag, HolderLookup.Provider registries) {
        if (this != NO_LOCK) {
            tag.store(TAG_LOCK, CODEC, registries.createSerializationContext(NbtOps.INSTANCE), this);
        }
    }

    public static LockCode fromTag(CompoundTag tag, HolderLookup.Provider registries) {
        return tag.read(TAG_LOCK, CODEC, registries.createSerializationContext(NbtOps.INSTANCE)).orElse(NO_LOCK);
    }
}

