/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.bukkit.Location;
import org.bukkit.craftbukkit.entity.CraftHumanEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.BlockInventoryHolder;
import org.bukkit.inventory.InventoryHolder;

public class SimpleContainer
implements Container,
StackedContentsCompatible {
    private final int size;
    public final NonNullList<ItemStack> items;
    @Nullable
    private List<ContainerListener> listeners;
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();
    private int maxStack = 99;
    @Nullable
    protected InventoryHolder bukkitOwner;
    @Nullable
    private Supplier<? extends InventoryHolder> bukkitOwnerCreator;

    @Override
    public List<ItemStack> getContents() {
        return this.items;
    }

    @Override
    public void onOpen(CraftHumanEntity player) {
        this.transaction.add(player);
    }

    @Override
    public void onClose(CraftHumanEntity player) {
        this.transaction.remove(player);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public int getMaxStackSize() {
        return this.maxStack;
    }

    @Override
    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    @Override
    @Nullable
    public InventoryHolder getOwner() {
        if (this.bukkitOwner == null && this.bukkitOwnerCreator != null) {
            this.bukkitOwner = this.bukkitOwnerCreator.get();
        }
        return this.bukkitOwner;
    }

    @Override
    @Nullable
    public Location getLocation() {
        InventoryHolder inventoryHolder = this.bukkitOwner;
        if (inventoryHolder instanceof BlockInventoryHolder) {
            BlockInventoryHolder blockInventoryHolder = (BlockInventoryHolder)inventoryHolder;
            return blockInventoryHolder.getBlock().getLocation();
        }
        inventoryHolder = this.bukkitOwner;
        if (inventoryHolder instanceof Entity) {
            Entity entity = (Entity)inventoryHolder;
            return entity.getLocation();
        }
        return null;
    }

    public SimpleContainer(SimpleContainer original) {
        this(original.size);
        for (int slot = 0; slot < original.size; ++slot) {
            this.items.set(slot, original.items.get(slot).copy());
        }
    }

    public SimpleContainer(int size) {
        this(size, null);
    }

    public SimpleContainer(Supplier<? extends InventoryHolder> bukkitOwnerCreator, int size) {
        this(size);
        this.bukkitOwnerCreator = bukkitOwnerCreator;
    }

    public SimpleContainer(int size, @Nullable InventoryHolder owner) {
        this.bukkitOwner = owner;
        this.size = size;
        this.items = NonNullList.withSize(size, ItemStack.EMPTY);
    }

    public SimpleContainer(ItemStack ... items) {
        this.size = items.length;
        this.items = NonNullList.of(ItemStack.EMPTY, items);
    }

    public void addListener(ContainerListener listener) {
        if (this.listeners == null) {
            this.listeners = Lists.newArrayList();
        }
        this.listeners.add(listener);
    }

    public void removeListener(ContainerListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public ItemStack getItem(int index) {
        return index >= 0 && index < this.items.size() ? this.items.get(index) : ItemStack.EMPTY;
    }

    public List<ItemStack> removeAllItems() {
        List<ItemStack> list = this.items.stream().filter(stack -> !stack.isEmpty()).collect(Collectors.toList());
        this.clearContent();
        return list;
    }

    @Override
    public ItemStack removeItem(int index, int count) {
        ItemStack itemStack = ContainerHelper.removeItem(this.items, index, count);
        if (!itemStack.isEmpty()) {
            this.setChanged();
        }
        return itemStack;
    }

    public ItemStack removeItemType(Item item, int amount) {
        ItemStack itemStack = new ItemStack(item, 0);
        for (int i = this.size - 1; i >= 0; --i) {
            ItemStack item1 = this.getItem(i);
            if (!item1.getItem().equals(item)) continue;
            int i1 = amount - itemStack.getCount();
            ItemStack itemStack1 = item1.split(i1);
            itemStack.grow(itemStack1.getCount());
            if (itemStack.getCount() == amount) break;
        }
        if (!itemStack.isEmpty()) {
            this.setChanged();
        }
        return itemStack;
    }

    public ItemStack addItem(ItemStack stack) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack itemStack = stack.copy();
        this.moveItemToOccupiedSlotsWithSameType(itemStack);
        if (itemStack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        this.moveItemToEmptySlots(itemStack);
        return itemStack.isEmpty() ? ItemStack.EMPTY : itemStack;
    }

    public boolean canAddItem(ItemStack stack) {
        boolean flag = false;
        for (ItemStack itemStack : this.items) {
            if (!itemStack.isEmpty() && (!ItemStack.isSameItemSameComponents(itemStack, stack) || itemStack.getCount() >= itemStack.getMaxStackSize())) continue;
            flag = true;
            break;
        }
        return flag;
    }

    @Override
    public ItemStack removeItemNoUpdate(int index) {
        ItemStack itemStack = this.items.get(index);
        if (itemStack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        this.items.set(index, ItemStack.EMPTY);
        return itemStack;
    }

    @Override
    public void setItem(int index, ItemStack stack) {
        this.items.set(index, stack);
        stack.limitSize(this.getMaxStackSize(stack));
        this.setChanged();
    }

    @Override
    public int getContainerSize() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        for (ItemStack itemStack : this.items) {
            if (itemStack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setChanged() {
        if (this.listeners != null) {
            for (ContainerListener containerListener : this.listeners) {
                containerListener.containerChanged(this);
            }
        }
    }

    @Override
    public boolean stillValid(Player player) {
        return true;
    }

    @Override
    public void clearContent() {
        this.items.clear();
        this.setChanged();
    }

    @Override
    public void fillStackedContents(StackedItemContents stackedContents) {
        for (ItemStack itemStack : this.items) {
            stackedContents.accountStack(itemStack);
        }
    }

    public String toString() {
        return this.items.stream().filter(stack -> !stack.isEmpty()).collect(Collectors.toList()).toString();
    }

    private void moveItemToEmptySlots(ItemStack stack) {
        for (int i = 0; i < this.size; ++i) {
            ItemStack item = this.getItem(i);
            if (!item.isEmpty()) continue;
            this.setItem(i, stack.copyAndClear());
            return;
        }
    }

    private void moveItemToOccupiedSlotsWithSameType(ItemStack stack) {
        for (int i = 0; i < this.size; ++i) {
            ItemStack item = this.getItem(i);
            if (!ItemStack.isSameItemSameComponents(item, stack)) continue;
            this.moveItemsBetweenStacks(stack, item);
            if (!stack.isEmpty()) continue;
            return;
        }
    }

    private void moveItemsBetweenStacks(ItemStack stack, ItemStack other) {
        int maxStackSize = this.getMaxStackSize(other);
        int min = Math.min(stack.getCount(), maxStackSize - other.getCount());
        if (min > 0) {
            other.grow(min);
            stack.shrink(min);
            this.setChanged();
        }
    }

    public void fromTag(ListTag tag, HolderLookup.Provider levelRegistry) {
        this.clearContent();
        tag.compoundStream().flatMap(compoundTag -> ItemStack.parse(levelRegistry, compoundTag).stream()).forEach(this::addItem);
    }

    public ListTag createTag(HolderLookup.Provider levelRegistry) {
        ListTag listTag = new ListTag();
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack item = this.getItem(i);
            if (item.isEmpty()) continue;
            listTag.add(item.save(levelRegistry));
        }
        return listTag;
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }
}

