/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.effect;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.raid.Raid;

class BadOmenMobEffect
extends MobEffect {
    protected BadOmenMobEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    @Override
    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }

    @Override
    public boolean applyEffectTick(ServerLevel level, LivingEntity entity, int amplifier) {
        Raid raidAt;
        ServerPlayer serverPlayer;
        if (entity instanceof ServerPlayer && !(serverPlayer = (ServerPlayer)entity).isSpectator() && level.getDifficulty() != Difficulty.PEACEFUL && level.isVillage(serverPlayer.blockPosition()) && ((raidAt = level.getRaidAt(serverPlayer.blockPosition())) == null || raidAt.getRaidOmenLevel() < raidAt.getMaxRaidOmenLevel())) {
            serverPlayer.addEffect(new MobEffectInstance(MobEffects.RAID_OMEN, 600, amplifier));
            serverPlayer.setRaidOmenPosition(serverPlayer.blockPosition());
            return false;
        }
        return true;
    }
}

