/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.effect;

import io.papermc.paper.event.entity.EntityEffectTickEvent;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.InstantenousMobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.bukkit.craftbukkit.potion.CraftPotionEffectType;
import org.bukkit.event.entity.EntityRegainHealthEvent;

class HealOrHarmMobEffect
extends InstantenousMobEffect {
    private final boolean isHarm;

    public HealOrHarmMobEffect(MobEffectCategory category, int color, boolean isHarm) {
        super(category, color);
        this.isHarm = isHarm;
    }

    @Override
    public boolean applyEffectTick(ServerLevel level, LivingEntity entity, int amplifier) {
        if (this.isHarm == entity.isInvertedHealAndHarm()) {
            entity.heal(Math.max(4 << amplifier, 0), EntityRegainHealthEvent.RegainReason.MAGIC);
        } else {
            entity.hurtServer(level, entity.damageSources().magic(), 6 << amplifier);
        }
        return true;
    }

    @Override
    public void applyInstantenousEffect(ServerLevel level, @Nullable Entity source, @Nullable Entity indirectSource, LivingEntity entity, int amplifier, double health) {
        if (!new EntityEffectTickEvent((org.bukkit.entity.LivingEntity)entity.getBukkitLivingEntity(), CraftPotionEffectType.minecraftToBukkit(this), amplifier).callEvent()) {
            return;
        }
        if (this.isHarm == entity.isInvertedHealAndHarm()) {
            int i = (int)(health * (double)(4 << amplifier) + 0.5);
            entity.heal(i, EntityRegainHealthEvent.RegainReason.MAGIC);
        } else {
            int i = (int)(health * (double)(6 << amplifier) + 0.5);
            if (source == null) {
                entity.hurtServer(level, entity.damageSources().magic(), i);
            } else {
                entity.hurtServer(level, entity.damageSources().indirectMagic(source, indirectSource), i);
            }
        }
    }
}

