/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.PushReaction;
import org.bukkit.craftbukkit.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.event.entity.AreaEffectCloudApplyEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRemoveEvent;

public class AreaEffectCloud
extends Entity
implements TraceableEntity {
    private static final int TIME_BETWEEN_APPLICATIONS = 5;
    private static final EntityDataAccessor<Float> DATA_RADIUS = SynchedEntityData.defineId(AreaEffectCloud.class, EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Boolean> DATA_WAITING = SynchedEntityData.defineId(AreaEffectCloud.class, EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<ParticleOptions> DATA_PARTICLE = SynchedEntityData.defineId(AreaEffectCloud.class, EntityDataSerializers.PARTICLE);
    private static final float MAX_RADIUS = 32.0f;
    private static final int DEFAULT_AGE = 0;
    private static final int DEFAULT_DURATION_ON_USE = 0;
    private static final float DEFAULT_RADIUS_ON_USE = 0.0f;
    private static final float DEFAULT_RADIUS_PER_TICK = 0.0f;
    private static final float DEFAULT_POTION_DURATION_SCALE = 1.0f;
    private static final float MINIMAL_RADIUS = 0.5f;
    private static final float DEFAULT_RADIUS = 3.0f;
    public static final float DEFAULT_WIDTH = 6.0f;
    public static final float HEIGHT = 0.5f;
    public static final int INFINITE_DURATION = -1;
    public static final int DEFAULT_LINGERING_DURATION = 600;
    private static final int DEFAULT_WAIT_TIME = 20;
    private static final int DEFAULT_REAPPLICATION_DELAY = 20;
    private static final ColorParticleOption DEFAULT_PARTICLE = ColorParticleOption.create(ParticleTypes.ENTITY_EFFECT, -1);
    public PotionContents potionContents = PotionContents.EMPTY;
    private float potionDurationScale = 1.0f;
    private final Map<Entity, Integer> victims = Maps.newHashMap();
    private int duration = -1;
    public int waitTime = 20;
    public int reapplicationDelay = 20;
    public int durationOnUse = 0;
    public float radiusOnUse = 0.0f;
    public float radiusPerTick = 0.0f;
    @Nullable
    private LivingEntity owner;
    @Nullable
    public UUID ownerUUID;

    public AreaEffectCloud(EntityType<? extends AreaEffectCloud> entityType, Level level) {
        super(entityType, level);
        this.noPhysics = true;
    }

    public AreaEffectCloud(Level level, double x, double y, double z) {
        this((EntityType<? extends AreaEffectCloud>)EntityType.AREA_EFFECT_CLOUD, level);
        this.setPos(x, y, z);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_RADIUS, Float.valueOf(3.0f));
        builder.define(DATA_WAITING, false);
        builder.define(DATA_PARTICLE, DEFAULT_PARTICLE);
    }

    public void setRadius(float radius) {
        if (!this.level().isClientSide) {
            this.getEntityData().set(DATA_RADIUS, Float.valueOf(Mth.clamp(radius, 0.0f, 32.0f)));
        }
    }

    @Override
    public void refreshDimensions() {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        super.refreshDimensions();
        this.setPos(x, y, z);
    }

    public float getRadius() {
        return this.getEntityData().get(DATA_RADIUS).floatValue();
    }

    public void setPotionContents(PotionContents potionContents) {
        this.potionContents = potionContents;
        this.updateColor();
    }

    public void setPotionDurationScale(float potionDurationScale) {
        this.potionDurationScale = potionDurationScale;
    }

    public void updateColor() {
        ParticleOptions particleOptions = this.entityData.get(DATA_PARTICLE);
        if (particleOptions instanceof ColorParticleOption) {
            ColorParticleOption colorParticleOption = (ColorParticleOption)particleOptions;
            int i = this.potionContents.equals(PotionContents.EMPTY) ? 0 : this.potionContents.getColor();
            this.entityData.set(DATA_PARTICLE, ColorParticleOption.create(colorParticleOption.getType(), ARGB.opaque(i)));
        }
    }

    public void addEffect(MobEffectInstance effectInstance) {
        this.setPotionContents(this.potionContents.withEffectAdded(effectInstance));
    }

    public ParticleOptions getParticle() {
        return this.getEntityData().get(DATA_PARTICLE);
    }

    public void setParticle(ParticleOptions particleOption) {
        this.getEntityData().set(DATA_PARTICLE, particleOption);
    }

    protected void setWaiting(boolean waiting) {
        this.getEntityData().set(DATA_WAITING, waiting);
    }

    public boolean isWaiting() {
        return this.getEntityData().get(DATA_WAITING);
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    @Override
    public void inactiveTick() {
        super.inactiveTick();
        if (this.tickCount >= this.waitTime + this.duration) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        }
    }

    @Override
    public void tick() {
        super.tick();
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.serverTick(serverLevel);
        } else {
            this.clientTick();
        }
    }

    private void clientTick() {
        boolean isWaiting = this.isWaiting();
        float radius = this.getRadius();
        if (!isWaiting || !this.random.nextBoolean()) {
            float f;
            int i;
            ParticleOptions particle = this.getParticle();
            if (isWaiting) {
                i = 2;
                f = 0.2f;
            } else {
                i = Mth.ceil((float)Math.PI * radius * radius);
                f = radius;
            }
            for (int i1 = 0; i1 < i; ++i1) {
                float f1 = this.random.nextFloat() * ((float)Math.PI * 2);
                float f2 = Mth.sqrt(this.random.nextFloat()) * f;
                double d = this.getX() + (double)(Mth.cos(f1) * f2);
                double y = this.getY();
                double d1 = this.getZ() + (double)(Mth.sin(f1) * f2);
                if (particle.getType() == ParticleTypes.ENTITY_EFFECT) {
                    if (isWaiting && this.random.nextBoolean()) {
                        this.level().addAlwaysVisibleParticle(ColorParticleOption.create(ParticleTypes.ENTITY_EFFECT, -1), d, y, d1, 0.0, 0.0, 0.0);
                        continue;
                    }
                    this.level().addAlwaysVisibleParticle(particle, d, y, d1, 0.0, 0.0, 0.0);
                    continue;
                }
                if (isWaiting) {
                    this.level().addAlwaysVisibleParticle(particle, d, y, d1, 0.0, 0.0, 0.0);
                    continue;
                }
                this.level().addAlwaysVisibleParticle(particle, d, y, d1, (0.5 - this.random.nextDouble()) * 0.15, 0.01f, (0.5 - this.random.nextDouble()) * 0.15);
            }
        }
    }

    private void serverTick(ServerLevel level) {
        if (this.duration != -1 && this.tickCount >= this.waitTime + this.duration) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else {
            boolean flag;
            boolean isWaiting = this.isWaiting();
            boolean bl = flag = this.tickCount < this.waitTime;
            if (isWaiting != flag) {
                this.setWaiting(flag);
            }
            if (!flag) {
                float radius = this.getRadius();
                if (this.radiusPerTick != 0.0f) {
                    if ((radius += this.radiusPerTick) < 0.5f) {
                        this.discard(EntityRemoveEvent.Cause.DESPAWN);
                        return;
                    }
                    this.setRadius(radius);
                }
                if (this.tickCount % 5 == 0) {
                    this.victims.entrySet().removeIf(victim -> this.tickCount >= (Integer)victim.getValue());
                    if (!this.potionContents.hasEffects()) {
                        this.victims.clear();
                    } else {
                        ArrayList list = new ArrayList();
                        this.potionContents.forEachEffect(list::add, this.potionDurationScale);
                        List<LivingEntity> entitiesOfClass = this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox());
                        if (!entitiesOfClass.isEmpty()) {
                            ArrayList<org.bukkit.entity.LivingEntity> entities = new ArrayList<org.bukkit.entity.LivingEntity>();
                            for (LivingEntity livingEntity : entitiesOfClass) {
                                double d1;
                                double d;
                                double d2;
                                if (this.victims.containsKey(livingEntity) || !livingEntity.isAffectedByPotions()) continue;
                                if (list.stream().noneMatch(livingEntity::canBeAffected) || !((d2 = (d = livingEntity.getX() - this.getX()) * d + (d1 = livingEntity.getZ() - this.getZ()) * d1) <= (double)(radius * radius))) continue;
                                entities.add((org.bukkit.entity.LivingEntity)livingEntity.getBukkitEntity());
                            }
                            AreaEffectCloudApplyEvent event = CraftEventFactory.callAreaEffectCloudApplyEvent(this, entities);
                            if (!event.isCancelled()) {
                                for (org.bukkit.entity.LivingEntity entity : event.getAffectedEntities()) {
                                    if (!(entity instanceof CraftLivingEntity)) continue;
                                    LivingEntity livingEntity = ((CraftLivingEntity)entity).getHandle();
                                    this.victims.put(livingEntity, this.tickCount + this.reapplicationDelay);
                                    for (MobEffectInstance mobEffectInstance : list) {
                                        if (mobEffectInstance.getEffect().value().isInstantenous()) {
                                            mobEffectInstance.getEffect().value().applyInstantenousEffect(level, this, this.getOwner(), livingEntity, mobEffectInstance.getAmplifier(), 0.5);
                                            continue;
                                        }
                                        livingEntity.addEffect(new MobEffectInstance(mobEffectInstance), this, EntityPotionEffectEvent.Cause.AREA_EFFECT_CLOUD);
                                    }
                                    if (this.radiusOnUse != 0.0f) {
                                        if ((radius += this.radiusOnUse) < 0.5f) {
                                            this.discard(EntityRemoveEvent.Cause.DESPAWN);
                                            return;
                                        }
                                        this.setRadius(radius);
                                    }
                                    if (this.durationOnUse == 0 || this.duration == -1) continue;
                                    this.duration += this.durationOnUse;
                                    if (this.duration > 0) continue;
                                    this.discard(EntityRemoveEvent.Cause.DESPAWN);
                                    return;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public float getRadiusOnUse() {
        return this.radiusOnUse;
    }

    public void setRadiusOnUse(float radiusOnUse) {
        this.radiusOnUse = radiusOnUse;
    }

    public float getRadiusPerTick() {
        return this.radiusPerTick;
    }

    public void setRadiusPerTick(float radiusPerTick) {
        this.radiusPerTick = radiusPerTick;
    }

    public int getDurationOnUse() {
        return this.durationOnUse;
    }

    public void setDurationOnUse(int durationOnUse) {
        this.durationOnUse = durationOnUse;
    }

    public int getWaitTime() {
        return this.waitTime;
    }

    public void setWaitTime(int waitTime) {
        this.waitTime = waitTime;
    }

    public void setOwner(@Nullable LivingEntity owner) {
        this.owner = owner;
        this.ownerUUID = owner == null ? null : owner.getUUID();
    }

    @Override
    @Nullable
    public LivingEntity getOwner() {
        Level level;
        if (this.owner != null && !this.owner.isRemoved()) {
            return this.owner;
        }
        if (this.ownerUUID != null && (level = this.level()) instanceof ServerLevel) {
            LivingEntity livingEntity;
            ServerLevel serverLevel = (ServerLevel)level;
            Entity entity = serverLevel.getEntity(this.ownerUUID);
            this.owner = entity instanceof LivingEntity ? (livingEntity = (LivingEntity)entity) : null;
        }
        return this.owner;
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag compound) {
        this.tickCount = compound.getIntOr("Age", 0);
        this.duration = compound.getIntOr("Duration", -1);
        this.waitTime = compound.getIntOr("WaitTime", 20);
        this.reapplicationDelay = compound.getIntOr("ReapplicationDelay", 20);
        this.durationOnUse = compound.getIntOr("DurationOnUse", 0);
        this.radiusOnUse = compound.getFloatOr("RadiusOnUse", 0.0f);
        this.radiusPerTick = compound.getFloatOr("RadiusPerTick", 0.0f);
        this.setRadius(compound.getFloatOr("Radius", 3.0f));
        this.ownerUUID = compound.read("Owner", UUIDUtil.CODEC).orElse(null);
        RegistryOps<Tag> registryOps = this.registryAccess().createSerializationContext(NbtOps.INSTANCE);
        this.setParticle(compound.read("Particle", ParticleTypes.CODEC, registryOps).orElse(DEFAULT_PARTICLE));
        this.setPotionContents(compound.read("potion_contents", PotionContents.CODEC, registryOps).orElse(PotionContents.EMPTY));
        this.potionDurationScale = compound.getFloatOr("potion_duration_scale", 1.0f);
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putInt("Age", this.tickCount);
        compound.putInt("Duration", this.duration);
        compound.putInt("WaitTime", this.waitTime);
        compound.putInt("ReapplicationDelay", this.reapplicationDelay);
        compound.putInt("DurationOnUse", this.durationOnUse);
        compound.putFloat("RadiusOnUse", this.radiusOnUse);
        compound.putFloat("RadiusPerTick", this.radiusPerTick);
        compound.putFloat("Radius", this.getRadius());
        RegistryOps<Tag> registryOps = this.registryAccess().createSerializationContext(NbtOps.INSTANCE);
        compound.store("Particle", ParticleTypes.CODEC, registryOps, this.getParticle());
        compound.storeNullable("Owner", UUIDUtil.CODEC, this.ownerUUID);
        if (!this.potionContents.equals(PotionContents.EMPTY)) {
            compound.store("potion_contents", PotionContents.CODEC, registryOps, this.potionContents);
        }
        if (this.potionDurationScale != 1.0f) {
            compound.putFloat("potion_duration_scale", this.potionDurationScale);
        }
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        if (DATA_RADIUS.equals(key)) {
            this.refreshDimensions();
        }
        super.onSyncedDataUpdated(key);
    }

    @Override
    public PushReaction getPistonPushReaction() {
        return PushReaction.IGNORE;
    }

    @Override
    public EntityDimensions getDimensions(Pose pose) {
        return EntityDimensions.scalable(this.getRadius() * 2.0f, 0.5f);
    }

    @Override
    public final boolean hurtServer(ServerLevel level, DamageSource damageSource, float amount) {
        return false;
    }

    @Override
    @Nullable
    public <T> T get(DataComponentType<? extends T> component) {
        if (component == DataComponents.POTION_CONTENTS) {
            return AreaEffectCloud.castComponentValue(component, this.potionContents);
        }
        return component == DataComponents.POTION_DURATION_SCALE ? AreaEffectCloud.castComponentValue(component, Float.valueOf(this.potionDurationScale)) : super.get(component);
    }

    @Override
    protected void applyImplicitComponents(DataComponentGetter componentGetter) {
        this.applyImplicitComponentIfPresent(componentGetter, DataComponents.POTION_CONTENTS);
        this.applyImplicitComponentIfPresent(componentGetter, DataComponents.POTION_DURATION_SCALE);
        super.applyImplicitComponents(componentGetter);
    }

    @Override
    protected <T> boolean applyImplicitComponent(DataComponentType<T> component, T value) {
        if (component == DataComponents.POTION_CONTENTS) {
            this.setPotionContents(AreaEffectCloud.castComponentValue(DataComponents.POTION_CONTENTS, value));
            return true;
        }
        if (component == DataComponents.POTION_DURATION_SCALE) {
            this.setPotionDurationScale(AreaEffectCloud.castComponentValue(DataComponents.POTION_DURATION_SCALE, value).floatValue());
            return true;
        }
        return super.applyImplicitComponent(component, value);
    }
}

