/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import ca.spottedleaf.moonrise.common.util.ThreadUnsafeRandom;
import ca.spottedleaf.moonrise.common.util.TickThread;
import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.chunk_system.entity.ChunkSystemEntity;
import ca.spottedleaf.moonrise.patches.chunk_system.level.chunk.ChunkData;
import ca.spottedleaf.moonrise.patches.collisions.CollisionUtil;
import ca.spottedleaf.moonrise.patches.entity_tracker.EntityTrackerEntity;
import com.destroystokyo.paper.event.entity.EntityTeleportEndGatewayEvent;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.configuration.type.number.IntOr;
import io.papermc.paper.entity.activation.ActivationRange;
import io.papermc.paper.entity.activation.ActivationType;
import io.papermc.paper.event.entity.EntityKnockbackEvent;
import io.papermc.paper.event.entity.EntityPushedByEntityAttackEvent;
import io.papermc.paper.event.player.PlayerUntrackEntityEvent;
import io.papermc.paper.util.MCUtil;
import io.papermc.paper.util.SizeLimitedSet;
import it.unimi.dsi.fastutil.doubles.DoubleListIterator;
import it.unimi.dsi.fastutil.floats.FloatArraySet;
import it.unimi.dsi.fastutil.floats.FloatArrays;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2DoubleArrayMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityLinkPacket;
import net.minecraft.network.protocol.game.ClientboundTeleportEntityPacket;
import net.minecraft.network.protocol.game.VecDeltaCodec;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SyncedDataHolder;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.Nameable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.InterpolationHandler;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PortalProcessor;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.PositionMoveRotation;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EndGatewayBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.HoneyBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TheEndGatewayBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntityInLevelCallback;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.portal.PortalShape;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.Team;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.PortalType;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.block.EndGateway;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.block.CraftEndGateway;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.craftbukkit.event.CraftPortalEvent;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.inventory.CraftItemType;
import org.bukkit.craftbukkit.util.CraftLocation;
import org.bukkit.craftbukkit.util.CraftVector;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Item;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityAirChangeEvent;
import org.bukkit.event.entity.EntityCombustByBlockEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDismountEvent;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.event.entity.EntityMountEvent;
import org.bukkit.event.entity.EntityPortalEvent;
import org.bukkit.event.entity.EntityPortalExitEvent;
import org.bukkit.event.entity.EntityPoseChangeEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.entity.EntityUnleashEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerUnleashEntityEvent;
import org.bukkit.event.vehicle.VehicleBlockCollisionEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.plugin.PluginManager;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Contract;
import org.slf4j.Logger;

public abstract class Entity
implements SyncedDataHolder,
Nameable,
EntityAccess,
ScoreHolder,
DataComponentGetter,
ChunkSystemEntity,
EntityTrackerEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int CURRENT_LEVEL = 2;
    public boolean preserveMotion = true;
    public static RandomSource SHARED_RANDOM = new RandomRandomSource();
    @Nullable
    public CreatureSpawnEvent.SpawnReason spawnReason;
    public boolean collisionLoadChunks = false;
    @Nullable
    private CraftEntity bukkitEntity;
    public static final String ID_TAG = "id";
    public static final String PASSENGERS_TAG = "Passengers";
    private static final String DATA_TAG = "data";
    private static final AtomicInteger ENTITY_COUNTER = new AtomicInteger();
    public static final int CONTENTS_SLOT_INDEX = 0;
    public static final int BOARDING_COOLDOWN = 60;
    public static final int TOTAL_AIR_SUPPLY = 300;
    public static final int MAX_ENTITY_TAG_COUNT = 1024;
    private static final Codec<List<String>> TAG_LIST_CODEC = Codec.STRING.sizeLimitedListOf(1024);
    public static final float DELTA_AFFECTED_BY_BLOCKS_BELOW_0_2 = 0.2f;
    public static final double DELTA_AFFECTED_BY_BLOCKS_BELOW_0_5 = 0.500001;
    public static final double DELTA_AFFECTED_BY_BLOCKS_BELOW_1_0 = 0.999999;
    public static final int BASE_TICKS_REQUIRED_TO_FREEZE = 140;
    public static final int FREEZE_HURT_FREQUENCY = 40;
    public static final int BASE_SAFE_FALL_DISTANCE = 3;
    private static final ImmutableList<Direction.Axis> YXZ_AXIS_ORDER = ImmutableList.of((Object)Direction.Axis.Y, (Object)Direction.Axis.X, (Object)Direction.Axis.Z);
    private static final ImmutableList<Direction.Axis> YZX_AXIS_ORDER = ImmutableList.of((Object)Direction.Axis.Y, (Object)Direction.Axis.Z, (Object)Direction.Axis.X);
    private static final AABB INITIAL_AABB = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private static final double WATER_FLOW_SCALE = 0.014;
    private static final double LAVA_FAST_FLOW_SCALE = 0.007;
    private static final double LAVA_SLOW_FLOW_SCALE = 0.0023333333333333335;
    public static final String UUID_TAG = "UUID";
    private static double viewScale = 1.0;
    private final EntityType<?> type;
    private int id = ENTITY_COUNTER.incrementAndGet();
    public boolean blocksBuilding;
    public ImmutableList<Entity> passengers = ImmutableList.of();
    protected int boardingCooldown;
    @Nullable
    private Entity vehicle;
    private Level level;
    public double xo;
    public double yo;
    public double zo;
    private Vec3 position;
    private BlockPos blockPosition;
    private ChunkPos chunkPosition;
    private Vec3 deltaMovement = Vec3.ZERO;
    private float yRot;
    private float xRot;
    public float yRotO;
    public float xRotO;
    private AABB bb = INITIAL_AABB;
    public boolean onGround;
    public boolean horizontalCollision;
    public boolean verticalCollision;
    public boolean verticalCollisionBelow;
    public boolean minorHorizontalCollision;
    public boolean hurtMarked;
    protected Vec3 stuckSpeedMultiplier = Vec3.ZERO;
    @Nullable
    private RemovalReason removalReason;
    public static final float DEFAULT_BB_WIDTH = 0.6f;
    public static final float DEFAULT_BB_HEIGHT = 1.8f;
    public float moveDist;
    public float flyDist;
    public double fallDistance;
    private float nextStep = 1.0f;
    public double xOld;
    public double yOld;
    public double zOld;
    public boolean noPhysics;
    public final RandomSource random = SHARED_RANDOM;
    public int tickCount;
    private int remainingFireTicks = -this.getFireImmuneTicks();
    public boolean wasTouchingWater;
    protected Object2DoubleMap<TagKey<Fluid>> fluidHeight = new Object2DoubleArrayMap(2);
    protected boolean wasEyeInWater;
    private final Set<TagKey<Fluid>> fluidOnEyes = new HashSet<TagKey<Fluid>>();
    public int invulnerableTime;
    protected boolean firstTick = true;
    protected final SynchedEntityData entityData;
    protected static final EntityDataAccessor<Byte> DATA_SHARED_FLAGS_ID = SynchedEntityData.defineId(Entity.class, EntityDataSerializers.BYTE);
    protected static final int FLAG_ONFIRE = 0;
    private static final int FLAG_SHIFT_KEY_DOWN = 1;
    private static final int FLAG_SPRINTING = 3;
    private static final int FLAG_SWIMMING = 4;
    public static final int FLAG_INVISIBLE = 5;
    protected static final int FLAG_GLOWING = 6;
    protected static final int FLAG_FALL_FLYING = 7;
    private static final EntityDataAccessor<Integer> DATA_AIR_SUPPLY_ID = SynchedEntityData.defineId(Entity.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Optional<Component>> DATA_CUSTOM_NAME = SynchedEntityData.defineId(Entity.class, EntityDataSerializers.OPTIONAL_COMPONENT);
    private static final EntityDataAccessor<Boolean> DATA_CUSTOM_NAME_VISIBLE = SynchedEntityData.defineId(Entity.class, EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_SILENT = SynchedEntityData.defineId(Entity.class, EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_NO_GRAVITY = SynchedEntityData.defineId(Entity.class, EntityDataSerializers.BOOLEAN);
    protected static final EntityDataAccessor<Pose> DATA_POSE = SynchedEntityData.defineId(Entity.class, EntityDataSerializers.POSE);
    private static final EntityDataAccessor<Integer> DATA_TICKS_FROZEN = SynchedEntityData.defineId(Entity.class, EntityDataSerializers.INT);
    private EntityInLevelCallback levelCallback = EntityInLevelCallback.NULL;
    private final VecDeltaCodec packetPositionCodec = new VecDeltaCodec();
    public boolean hasImpulse;
    @Nullable
    public PortalProcessor portalProcess;
    public int portalCooldown;
    private boolean invulnerable;
    protected UUID uuid = Mth.createInsecureUUID(this.random);
    protected String stringUUID = this.uuid.toString();
    private boolean hasGlowingTag;
    private final Set<String> tags = new SizeLimitedSet(new ObjectOpenHashSet(), 1024);
    private final double[] pistonDeltas = new double[]{0.0, 0.0, 0.0};
    private long pistonDeltasGameTime;
    private EntityDimensions dimensions;
    private float eyeHeight;
    public boolean isInPowderSnow;
    public boolean wasInPowderSnow;
    public Optional<BlockPos> mainSupportingBlockPos = Optional.empty();
    private boolean onGroundNoBlocks = false;
    private float crystalSoundIntensity;
    private int lastCrystalSoundPlayTick;
    public boolean hasVisualFire;
    @Nullable
    private BlockState inBlockState = null;
    private final List<List<Movement>> movementThisTick = new ObjectArrayList();
    private final List<Movement> finalMovementsThisTick = new ObjectArrayList();
    private final LongSet visitedBlocks = new LongOpenHashSet();
    private final InsideBlockEffectApplier.StepBasedCollector insideEffectCollector = new InsideBlockEffectApplier.StepBasedCollector();
    private CustomData customData = CustomData.EMPTY;
    public boolean forceDrops;
    public boolean persist = true;
    public boolean visibleByDefault = true;
    public boolean valid;
    public boolean inWorld = false;
    public boolean generation;
    public int maxAirTicks = this.getDefaultMaxAirSupply();
    @Nullable
    public ProjectileSource projectileSource;
    public boolean lastDamageCancelled;
    public boolean persistentInvisibility = false;
    @Nullable
    public BlockPos lastLavaContact;
    public boolean pluginRemoved = false;
    protected int numCollisions = 0;
    public boolean fromNetherPortal;
    public boolean spawnedViaMobSpawner;
    @Nullable
    public Vec3 origin;
    @Nullable
    public UUID originWorld;
    public boolean freezeLocked = false;
    public boolean fixedPose = false;
    private final int despawnTime;
    public int totalEntityAge;
    public final ActivationType activationType = ActivationType.activationTypeFor(this);
    public final boolean defaultActivationState;
    public long activatedTick = Integer.MIN_VALUE;
    public boolean isTemporarilyActive;
    public long activatedImmunityTick = Integer.MIN_VALUE;
    private final boolean isHardColliding = this.moonrise$isHardCollidingUncached();
    private FullChunkStatus chunkStatus;
    private ChunkData chunkData;
    private int sectionX = Integer.MIN_VALUE;
    private int sectionY = Integer.MIN_VALUE;
    private int sectionZ = Integer.MIN_VALUE;
    private boolean updatingSectionStatus;
    private ChunkMap.TrackedEntity trackedEntity;
    public final Object posLock = new Object();
    @Nullable
    private Vec3 moveVector;
    private double moveStartX;
    private double moveStartY;
    private double moveStartZ;
    private final CommandSource commandSource = new CommandSource(){

        @Override
        public void sendSystemMessage(Component message) {
        }

        @Override
        public CommandSender getBukkitSender(CommandSourceStack wrapper) {
            return Entity.this.getBukkitEntity();
        }

        @Override
        public boolean acceptsSuccess() {
            return ((ServerLevel)Entity.this.level()).getGameRules().getBoolean(GameRules.RULE_SENDCOMMANDFEEDBACK);
        }

        @Override
        public boolean acceptsFailure() {
            return true;
        }

        @Override
        public boolean shouldInformAdmins() {
            return true;
        }
    };

    static boolean isLevelAtLeast(CompoundTag tag, int level) {
        return tag.getIntOr("Bukkit.updateLevel", 2) >= level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CraftEntity getBukkitEntity() {
        if (this.bukkitEntity == null) {
            Entity entity = this;
            synchronized (entity) {
                if (this.bukkitEntity == null) {
                    this.bukkitEntity = CraftEntity.getEntity(this.level.getCraftServer(), this);
                    return this.bukkitEntity;
                }
            }
        }
        return this.bukkitEntity;
    }

    @Nullable
    public CraftEntity getBukkitEntityRaw() {
        return this.bukkitEntity;
    }

    public void inactiveTick() {
    }

    public final AABB getBoundingBoxAt(double x, double y, double z) {
        return this.dimensions.makeBoundingBox(x, y, z);
    }

    @Override
    public final boolean moonrise$isHardColliding() {
        return this.isHardColliding;
    }

    @Override
    public final FullChunkStatus moonrise$getChunkStatus() {
        return this.chunkStatus;
    }

    @Override
    public final void moonrise$setChunkStatus(FullChunkStatus status) {
        this.chunkStatus = status;
    }

    @Override
    public final ChunkData moonrise$getChunkData() {
        return this.chunkData;
    }

    @Override
    public final void moonrise$setChunkData(ChunkData chunkData) {
        this.chunkData = chunkData;
    }

    @Override
    public final int moonrise$getSectionX() {
        return this.sectionX;
    }

    @Override
    public final void moonrise$setSectionX(int x) {
        this.sectionX = x;
    }

    @Override
    public final int moonrise$getSectionY() {
        return this.sectionY;
    }

    @Override
    public final void moonrise$setSectionY(int y) {
        this.sectionY = y;
    }

    @Override
    public final int moonrise$getSectionZ() {
        return this.sectionZ;
    }

    @Override
    public final void moonrise$setSectionZ(int z) {
        this.sectionZ = z;
    }

    @Override
    public final boolean moonrise$isUpdatingSectionStatus() {
        return this.updatingSectionStatus;
    }

    @Override
    public final void moonrise$setUpdatingSectionStatus(boolean to) {
        this.updatingSectionStatus = to;
    }

    @Override
    public final boolean moonrise$hasAnyPlayerPassengers() {
        if (this.passengers.isEmpty()) {
            return false;
        }
        return this.getIndirectPassengersStream().anyMatch(entity -> entity instanceof Player);
    }

    private static float[] calculateStepHeights(AABB box, List<VoxelShape> voxels, List<AABB> aabbs, float stepHeight, float collidedY) {
        Object shape;
        int i;
        FloatArraySet ret = new FloatArraySet();
        int len = voxels.size();
        for (i = 0; i < len; ++i) {
            double yUnoffset;
            double y;
            float step;
            shape = voxels.get(i);
            double[] yCoords = shape.moonrise$rootCoordinatesY();
            double yOffset = shape.moonrise$offsetY();
            double[] dArray = yCoords;
            int n = dArray.length;
            for (int j = 0; j < n && !((step = (float)((y = (yUnoffset = dArray[j]) + yOffset) - box.minY)) > stepHeight); ++j) {
                if (step < 0.0f || step == collidedY) continue;
                ret.add(step);
            }
        }
        len = aabbs.size();
        for (i = 0; i < len; ++i) {
            shape = aabbs.get(i);
            float step1 = (float)(((AABB)shape).minY - box.minY);
            float step2 = (float)(((AABB)shape).maxY - box.minY);
            if (!(step1 < 0.0f) && step1 != collidedY && !(step1 > stepHeight)) {
                ret.add(step1);
            }
            if (step2 < 0.0f || step2 == collidedY || step2 > stepHeight) continue;
            ret.add(step2);
        }
        float[] steps = ret.toFloatArray();
        FloatArrays.unstableSort((float[])steps);
        return steps;
    }

    @Override
    public final ChunkMap.TrackedEntity moonrise$getTrackedEntity() {
        return this.trackedEntity;
    }

    @Override
    public final void moonrise$setTrackedEntity(ChunkMap.TrackedEntity trackedEntity) {
        this.trackedEntity = trackedEntity;
    }

    private static void collectIndirectPassengers(List<Entity> into, List<Entity> from) {
        for (Entity passenger : from) {
            into.add(passenger);
            Entity.collectIndirectPassengers(into, passenger.passengers);
        }
    }

    public Entity(EntityType<?> entityType, Level level) {
        this.type = entityType;
        this.level = level;
        this.dimensions = entityType.getDimensions();
        this.position = Vec3.ZERO;
        this.blockPosition = BlockPos.ZERO;
        this.chunkPosition = ChunkPos.ZERO;
        this.defaultActivationState = level != null ? ActivationRange.initializeEntityActivationState(this, level.spigotConfig) : false;
        SynchedEntityData.Builder builder = new SynchedEntityData.Builder(this);
        builder.define(DATA_SHARED_FLAGS_ID, (byte)0);
        builder.define(DATA_AIR_SUPPLY_ID, this.getMaxAirSupply());
        builder.define(DATA_CUSTOM_NAME_VISIBLE, false);
        builder.define(DATA_CUSTOM_NAME, Optional.empty());
        builder.define(DATA_SILENT, false);
        builder.define(DATA_NO_GRAVITY, false);
        builder.define(DATA_POSE, Pose.STANDING);
        builder.define(DATA_TICKS_FROZEN, 0);
        this.defineSynchedData(builder);
        this.entityData = builder.build();
        this.setPos(0.0, 0.0, 0.0);
        this.eyeHeight = this.dimensions.eyeHeight();
        this.despawnTime = level == null || this.type == EntityType.PLAYER ? -1 : ((IntOr.Disabled)level.paperConfig().entities.spawning.despawnTime.getOrDefault(this.type, (Object)IntOr.Disabled.DISABLED)).or(-1);
    }

    public boolean isColliding(BlockPos pos, BlockState state) {
        VoxelShape voxelShape = state.getCollisionShape(this.level(), pos, CollisionContext.of(this)).move(pos);
        return Shapes.joinIsNotEmpty(voxelShape, Shapes.create(this.getBoundingBox()), BooleanOp.AND);
    }

    public int getTeamColor() {
        PlayerTeam team = this.getTeam();
        return team != null && ((Team)team).getColor().getColor() != null ? ((Team)team).getColor().getColor() : 0xFFFFFF;
    }

    public int getDefaultMaxAirSupply() {
        return 300;
    }

    public boolean isSpectator() {
        return false;
    }

    public final void unRide() {
        if (this.isVehicle()) {
            this.ejectPassengers();
        }
        if (this.isPassenger()) {
            this.stopRiding();
        }
    }

    public void syncPacketPositionCodec(double x, double y, double z) {
        this.packetPositionCodec.setBase(new Vec3(x, y, z));
    }

    public VecDeltaCodec getPositionCodec() {
        return this.packetPositionCodec;
    }

    public EntityType<?> getType() {
        return this.type;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public boolean addTag(String tag) {
        return this.tags.add(tag);
    }

    public boolean removeTag(String tag) {
        return this.tags.remove(tag);
    }

    public void kill(ServerLevel level) {
        this.remove(RemovalReason.KILLED, EntityRemoveEvent.Cause.DEATH);
        this.gameEvent(GameEvent.ENTITY_DIE);
    }

    public final void discard() {
        this.discard(null);
    }

    public final void discard(@Nullable EntityRemoveEvent.Cause cause) {
        this.remove(RemovalReason.DISCARDED, cause);
    }

    protected abstract void defineSynchedData(SynchedEntityData.Builder var1);

    public SynchedEntityData getEntityData() {
        return this.entityData;
    }

    public void refreshEntityData(ServerPlayer to) {
        List<SynchedEntityData.DataValue<?>> list = this.entityData.packAll();
        if (to.getBukkitEntity().canSee(this.getBukkitEntity())) {
            to.connection.send(new ClientboundSetEntityDataPacket(this.getId(), list));
        }
    }

    public void resendPossiblyDesyncedEntityData(ServerPlayer player) {
        if (player.getBukkitEntity().canSee(this.getBukkitEntity())) {
            ChunkMap.TrackedEntity tracker;
            ServerLevel world = (ServerLevel)this.level();
            ChunkMap.TrackedEntity trackedEntity = tracker = world == null ? null : (ChunkMap.TrackedEntity)world.getChunkSource().chunkMap.entityMap.get(this.getId());
            if (tracker == null) {
                return;
            }
            ServerEntity serverEntity = tracker.serverEntity;
            ArrayList<Packet<? super ClientGamePacketListener>> list = new ArrayList<Packet<? super ClientGamePacketListener>>();
            serverEntity.sendPairingData(player, list::add);
            player.connection.send(new ClientboundBundlePacket((Iterable<Packet<? super ClientGamePacketListener>>)list));
        }
    }

    public void resendPossiblyDesyncedDataValues(List<EntityDataAccessor<?>> keys, ServerPlayer to) {
        if (!to.getBukkitEntity().canSee(this.getBukkitEntity())) {
            return;
        }
        ArrayList values = new ArrayList(keys.size());
        for (EntityDataAccessor<?> key : keys) {
            SynchedEntityData.DataItem<?> synchedValue = this.entityData.getItem(key);
            values.add(synchedValue.value());
        }
        to.connection.send(new ClientboundSetEntityDataPacket(this.id, values));
    }

    public boolean equals(Object object) {
        return object instanceof Entity && ((Entity)object).id == this.id;
    }

    public int hashCode() {
        return this.id;
    }

    public void remove(RemovalReason reason) {
        this.remove(reason, null);
    }

    public void remove(RemovalReason reason, @Nullable EntityRemoveEvent.Cause eventCause) {
        this.setRemoved(reason, eventCause);
    }

    public void onClientRemoval() {
    }

    public void onRemoval(RemovalReason reason) {
    }

    public void setPose(Pose pose) {
        if (this.fixedPose) {
            return;
        }
        if (pose == this.getPose()) {
            return;
        }
        if (!this.generation) {
            this.level.getCraftServer().getPluginManager().callEvent((Event)new EntityPoseChangeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), org.bukkit.entity.Pose.values()[pose.ordinal()]));
        }
        this.entityData.set(DATA_POSE, pose);
    }

    public Pose getPose() {
        return this.entityData.get(DATA_POSE);
    }

    public boolean hasPose(Pose pose) {
        return this.getPose() == pose;
    }

    public boolean closerThan(Entity entity, double distance) {
        return this.position().closerThan(entity.position(), distance);
    }

    public boolean closerThan(Entity entity, double horizontalDistance, double verticalDistance) {
        double d = entity.getX() - this.getX();
        double d1 = entity.getY() - this.getY();
        double d2 = entity.getZ() - this.getZ();
        return Mth.lengthSquared(d, d2) < Mth.square(horizontalDistance) && Mth.square(d1) < Mth.square(verticalDistance);
    }

    public void setRot(float yRot, float xRot) {
        if (Float.isNaN(yRot)) {
            yRot = 0.0f;
        }
        if (yRot == Float.POSITIVE_INFINITY || yRot == Float.NEGATIVE_INFINITY) {
            if (this instanceof ServerPlayer) {
                this.level.getCraftServer().getLogger().warning(this.getScoreboardName() + " was caught trying to crash the server with an invalid yaw");
                ((CraftPlayer)this.getBukkitEntity()).kickPlayer("Infinite yaw (Hacking?)");
            }
            yRot = 0.0f;
        }
        if (Float.isNaN(xRot)) {
            xRot = 0.0f;
        }
        if (xRot == Float.POSITIVE_INFINITY || xRot == Float.NEGATIVE_INFINITY) {
            if (this instanceof ServerPlayer) {
                this.level.getCraftServer().getLogger().warning(this.getScoreboardName() + " was caught trying to crash the server with an invalid pitch");
                ((CraftPlayer)this.getBukkitEntity()).kickPlayer("Infinite pitch (Hacking?)");
            }
            xRot = 0.0f;
        }
        this.setYRot(yRot % 360.0f);
        this.setXRot(xRot % 360.0f);
    }

    public final void setPos(Vec3 pos) {
        this.setPos(pos.x(), pos.y(), pos.z());
    }

    public void setPos(double x, double y, double z) {
        this.setPosRaw(x, y, z, true);
    }

    protected final AABB makeBoundingBox() {
        return this.makeBoundingBox(this.position);
    }

    protected AABB makeBoundingBox(Vec3 position) {
        return this.dimensions.makeBoundingBox(position);
    }

    protected void reapplyPosition() {
        this.setPos(this.position.x, this.position.y, this.position.z);
    }

    public void turn(double yRot, double xRot) {
        float f = (float)xRot * 0.15f;
        float f1 = (float)yRot * 0.15f;
        this.setXRot(this.getXRot() + f);
        this.setYRot(this.getYRot() + f1);
        this.setXRot(Mth.clamp(this.getXRot(), -90.0f, 90.0f));
        this.xRotO += f;
        this.yRotO += f1;
        this.xRotO = Mth.clamp(this.xRotO, -90.0f, 90.0f);
        if (this.vehicle != null) {
            this.vehicle.onPassengerTurned(this);
        }
    }

    public void tick() {
        if (this.despawnTime >= 0 && this.totalEntityAge >= this.despawnTime) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
            return;
        }
        this.baseTick();
    }

    public void postTick() {
        if (!(this instanceof ServerPlayer) && this.isAlive()) {
            this.handlePortal();
        }
    }

    public void baseTick() {
        Object object;
        ProfilerFiller profilerFiller = Profiler.get();
        profilerFiller.push("entityBaseTick");
        if (this.firstTick && (object = this) instanceof NeutralMob) {
            NeutralMob neutralMob = (NeutralMob)object;
            neutralMob.tickInitialPersistentAnger(this.level);
        }
        this.inBlockState = null;
        if (this.isPassenger() && this.getVehicle().isRemoved()) {
            this.stopRiding();
        }
        if (this.boardingCooldown > 0) {
            --this.boardingCooldown;
        }
        if (this instanceof ServerPlayer) {
            this.handlePortal();
        }
        if (this.canSpawnSprintParticle()) {
            this.spawnSprintParticle();
        }
        this.wasInPowderSnow = this.isInPowderSnow;
        this.isInPowderSnow = false;
        this.updateInWaterStateAndDoFluidPushing();
        this.updateFluidOnEyes();
        this.updateSwimming();
        object = this.level();
        if (object instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)object;
            if (this.remainingFireTicks > 0) {
                if (this.fireImmune()) {
                    this.setRemainingFireTicks(this.remainingFireTicks - 4);
                    if (this.remainingFireTicks < 0) {
                        this.clearFire();
                    }
                } else {
                    if (this.remainingFireTicks % 20 == 0 && !this.isInLava()) {
                        this.hurtServer(serverLevel, this.damageSources().onFire(), 1.0f);
                    }
                    this.setRemainingFireTicks(this.remainingFireTicks - 1);
                }
            }
        } else {
            this.clearFire();
        }
        if (this.isInLava()) {
            this.fallDistance *= 0.5;
        } else {
            this.lastLavaContact = null;
        }
        this.checkBelowWorld();
        if (!this.level().isClientSide) {
            this.setSharedFlagOnFire(this.remainingFireTicks > 0);
        }
        this.firstTick = false;
        object = this.level();
        if (object instanceof ServerLevel) {
            ServerLevel serverLevelx = (ServerLevel)object;
            if (this instanceof Leashable) {
                Leashable.tickLeash(serverLevelx, (Entity)((Object)((Leashable)((Object)this))));
            }
        }
        profilerFiller.pop();
    }

    public void setSharedFlagOnFire(boolean isOnFire) {
        this.setSharedFlag(0, isOnFire || this.hasVisualFire);
    }

    public void checkBelowWorld() {
        block5: {
            block4: {
                if (!this.level.getWorld().isVoidDamageEnabled()) {
                    return;
                }
                if (this.getY() < (double)this.level.getMinY() + this.level.getWorld().getVoidDamageMinBuildHeightOffset()) break block4;
                if (this.level.getWorld().getEnvironment() != World.Environment.NETHER || !this.level.paperConfig().environment.netherCeilingVoidDamageHeight.test(v -> this.getY() >= (double)v)) break block5;
                Entity entity = this;
                if (!(entity instanceof Player)) break block4;
                Player player = (Player)entity;
                if (player.getAbilities().invulnerable) break block5;
            }
            this.onBelowWorld();
        }
    }

    public void setPortalCooldown() {
        this.portalCooldown = this.getDimensionChangingDelay();
    }

    public void setPortalCooldown(int portalCooldown) {
        this.portalCooldown = portalCooldown;
    }

    public int getPortalCooldown() {
        return this.portalCooldown;
    }

    public boolean isOnPortalCooldown() {
        return this.portalCooldown > 0;
    }

    protected void processPortalCooldown() {
        if (this.isOnPortalCooldown()) {
            --this.portalCooldown;
        }
    }

    public void lavaIgnite() {
        this.lavaIgnite(this.lastLavaContact);
    }

    public void lavaIgnite(@Nullable BlockPos pos) {
        if (!this.fireImmune()) {
            if (this instanceof LivingEntity && this.remainingFireTicks <= 0) {
                CraftEntity damagee;
                CraftBlock damager = pos == null ? null : CraftBlock.at(this.level, pos);
                EntityCombustByBlockEvent combustEvent = new EntityCombustByBlockEvent((org.bukkit.block.Block)damager, (org.bukkit.entity.Entity)(damagee = this.getBukkitEntity()), 15.0f);
                if (combustEvent.callEvent()) {
                    this.igniteForSeconds(combustEvent.getDuration(), false);
                }
            } else {
                this.igniteForSeconds(15.0f, false);
            }
        }
    }

    public void lavaHurt() {
        this.lavaHurt(this.lastLavaContact);
    }

    public void lavaHurt(@Nullable BlockPos pos) {
        ServerLevel serverLevel;
        Level level;
        if (!this.fireImmune() && (level = this.level()) instanceof ServerLevel && this.hurtServer(serverLevel = (ServerLevel)level, this.damageSources().lava().eventBlockDamager(this.level, pos), 4.0f) && this.shouldPlayLavaHurtSound() && !this.isSilent()) {
            serverLevel.playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.GENERIC_BURN, this.getSoundSource(), 0.4f, 2.0f + this.random.nextFloat() * 0.4f);
        }
    }

    protected boolean shouldPlayLavaHurtSound() {
        return true;
    }

    public final void igniteForSeconds(float seconds) {
        this.igniteForSeconds(seconds, true);
    }

    public final void igniteForSeconds(float seconds, boolean callEvent) {
        if (callEvent) {
            EntityCombustEvent event = new EntityCombustEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), seconds);
            if (!event.callEvent()) {
                return;
            }
            seconds = event.getDuration();
        }
        this.igniteForTicks(Mth.floor(seconds * 20.0f));
    }

    public void igniteForTicks(int ticks) {
        if (this.remainingFireTicks < ticks) {
            this.setRemainingFireTicks(ticks);
        }
        this.clearFreeze();
    }

    public void setRemainingFireTicks(int remainingFireTicks) {
        this.remainingFireTicks = remainingFireTicks;
    }

    public int getRemainingFireTicks() {
        return this.remainingFireTicks;
    }

    public void clearFire() {
        this.setRemainingFireTicks(0);
    }

    protected void onBelowWorld() {
        this.discard(EntityRemoveEvent.Cause.OUT_OF_WORLD);
    }

    public boolean isFree(double x, double y, double z) {
        return this.isFree(this.getBoundingBox().move(x, y, z));
    }

    private boolean isFree(AABB box) {
        return this.level().noCollision(this, box) && !this.level().containsAnyLiquid(box);
    }

    public void setOnGround(boolean onGround) {
        this.onGround = onGround;
        this.checkSupportingBlock(onGround, null);
    }

    public void setOnGroundWithMovement(boolean onGround, Vec3 movement) {
        this.setOnGroundWithMovement(onGround, this.horizontalCollision, movement);
    }

    public void setOnGroundWithMovement(boolean onGround, boolean horizontalCollision, Vec3 movement) {
        this.onGround = onGround;
        this.horizontalCollision = horizontalCollision;
        this.checkSupportingBlock(onGround, movement);
    }

    public boolean isSupportedBy(BlockPos pos) {
        return this.mainSupportingBlockPos.isPresent() && this.mainSupportingBlockPos.get().equals(pos);
    }

    protected void checkSupportingBlock(boolean onGround, @Nullable Vec3 movement) {
        if (onGround) {
            AABB boundingBox = this.getBoundingBox();
            AABB aabb = new AABB(boundingBox.minX, boundingBox.minY - 1.0E-6, boundingBox.minZ, boundingBox.maxX, boundingBox.minY, boundingBox.maxZ);
            Optional<BlockPos> optional = this.level.findSupportingBlock(this, aabb);
            if (optional.isPresent() || this.onGroundNoBlocks) {
                this.mainSupportingBlockPos = optional;
            } else if (movement != null) {
                AABB aabb1 = aabb.move(-movement.x, 0.0, -movement.z);
                optional = this.level.findSupportingBlock(this, aabb1);
                this.mainSupportingBlockPos = optional;
            }
            this.onGroundNoBlocks = optional.isEmpty();
        } else {
            this.onGroundNoBlocks = false;
            if (this.mainSupportingBlockPos.isPresent()) {
                this.mainSupportingBlockPos = Optional.empty();
            }
        }
    }

    public boolean onGround() {
        return this.onGround;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(MoverType type, Vec3 movement) {
        Vec3 originalMovement = movement;
        TickThread.ensureTickThread("Cannot move an entity off-main");
        Object object = this.posLock;
        synchronized (object) {
            this.moveStartX = this.getX();
            this.moveStartY = this.getY();
            this.moveStartZ = this.getZ();
            this.moveVector = movement;
        }
        try {
            if (this.noPhysics) {
                this.setPos(this.getX() + movement.x, this.getY() + movement.y, this.getZ() + movement.z);
            } else {
                if (type == MoverType.PISTON) {
                    this.activatedTick = Math.max(this.activatedTick, (long)(MinecraftServer.currentTick + 20));
                    this.activatedImmunityTick = Math.max(this.activatedImmunityTick, (long)(MinecraftServer.currentTick + 20));
                    if ((movement = this.limitPistonMovement(movement)).equals(Vec3.ZERO)) {
                        return;
                    }
                }
                ProfilerFiller profilerFiller = Profiler.get();
                profilerFiller.push("move");
                if (this.stuckSpeedMultiplier.lengthSqr() > 1.0E-7) {
                    movement = movement.multiply(this.stuckSpeedMultiplier);
                    this.stuckSpeedMultiplier = Vec3.ZERO;
                    this.setDeltaMovement(Vec3.ZERO);
                }
                if (this.isTemporarilyActive && !(this instanceof ItemEntity) && movement == this.getDeltaMovement() && type == MoverType.SELF) {
                    this.setDeltaMovement(Vec3.ZERO);
                    profilerFiller.pop();
                    return;
                }
                Vec3 vec3 = this.collide(movement = this.maybeBackOffFromEdge(movement, type));
                double d = vec3.lengthSqr();
                if (d > 1.0E-7 || movement.lengthSqr() - d < 1.0E-7) {
                    BlockHitResult blockHitResult;
                    if (this.fallDistance != 0.0 && d >= 1.0 && (blockHitResult = this.level().clip(new ClipContext(this.position(), this.position().add(vec3), ClipContext.Block.FALLDAMAGE_RESETTING, ClipContext.Fluid.WATER, this))).getType() != HitResult.Type.MISS) {
                        this.resetFallDistance();
                    }
                    Vec3 vec31 = this.position();
                    ObjectArrayList list = new ObjectArrayList();
                    for (Direction.Axis axis : Entity.axisStepOrder(vec3)) {
                        double d1 = vec3.get(axis);
                        if (d1 == 0.0) continue;
                        Vec3 vec32 = vec31.relative(axis.getPositive(), d1);
                        list.add(new Movement(vec31, vec32));
                        vec31 = vec32;
                    }
                    this.movementThisTick.add((List<Movement>)list);
                    this.setPos(vec31);
                }
                profilerFiller.pop();
                profilerFiller.push("rest");
                boolean flag = !Mth.equal(movement.x, vec3.x);
                boolean flag1 = !Mth.equal(movement.z, vec3.z);
                boolean bl = this.horizontalCollision = flag || flag1;
                if (Math.abs(movement.y) > 0.0 || this.isLocalInstanceAuthoritative()) {
                    this.verticalCollision = movement.y != vec3.y;
                    this.verticalCollisionBelow = this.verticalCollision && movement.y < 0.0;
                    this.setOnGroundWithMovement(this.verticalCollisionBelow, this.horizontalCollision, vec3);
                }
                this.minorHorizontalCollision = this.horizontalCollision ? this.isHorizontalCollisionMinor(vec3) : false;
                BlockPos onPosLegacy = this.getOnPosLegacy();
                BlockState blockState = this.level().getBlockState(onPosLegacy);
                if (this.isLocalInstanceAuthoritative()) {
                    this.checkFallDamage(vec3.y, this.onGround(), blockState, onPosLegacy);
                }
                if (this.isRemoved()) {
                    profilerFiller.pop();
                } else {
                    MovementEmission movementEmission;
                    if (this.horizontalCollision) {
                        Vec3 deltaMovement = this.getDeltaMovement();
                        this.setDeltaMovement(flag ? 0.0 : deltaMovement.x, deltaMovement.y, flag1 ? 0.0 : deltaMovement.z);
                    }
                    if (this.canSimulateMovement()) {
                        Block block = blockState.getBlock();
                        if (movement.y != vec3.y) {
                            block.updateEntityMovementAfterFallOn(this.level(), this);
                        }
                    }
                    if (this.horizontalCollision && this.getBukkitEntity() instanceof Vehicle) {
                        Vehicle vehicle = (Vehicle)this.getBukkitEntity();
                        org.bukkit.block.Block block = this.level.getWorld().getBlockAt(Mth.floor(this.getX()), Mth.floor(this.getY()), Mth.floor(this.getZ()));
                        if (movement.x > vec3.x) {
                            block = block.getRelative(BlockFace.EAST);
                        } else if (movement.x < vec3.x) {
                            block = block.getRelative(BlockFace.WEST);
                        } else if (movement.z > vec3.z) {
                            block = block.getRelative(BlockFace.SOUTH);
                        } else if (movement.z < vec3.z) {
                            block = block.getRelative(BlockFace.NORTH);
                        }
                        if (!block.getType().isAir()) {
                            VehicleBlockCollisionEvent event = new VehicleBlockCollisionEvent(vehicle, block, CraftVector.toBukkit(originalMovement));
                            event.callEvent();
                        }
                    }
                    if ((!this.level().isClientSide() || this.isLocalInstanceAuthoritative()) && (movementEmission = this.getMovementEmission()).emitsAnything() && !this.isPassenger()) {
                        this.applyMovementEmissionAndPlaySound(movementEmission, vec3, onPosLegacy, blockState);
                    }
                    float blockSpeedFactor = this.getBlockSpeedFactor();
                    this.setDeltaMovement(this.getDeltaMovement().multiply(blockSpeedFactor, 1.0, blockSpeedFactor));
                    profilerFiller.pop();
                }
            }
        }
        finally {
            object = this.posLock;
            synchronized (object) {
                this.moveVector = null;
            }
        }
    }

    private void applyMovementEmissionAndPlaySound(MovementEmission movementEmission, Vec3 movement, BlockPos pos, BlockState state) {
        float f = 0.6f;
        float f1 = (float)(movement.length() * (double)0.6f);
        float f2 = (float)(movement.horizontalDistance() * (double)0.6f);
        BlockPos onPos = this.getOnPos();
        BlockState blockState = this.level().getBlockState(onPos);
        boolean isStateClimbable = this.isStateClimbable(blockState);
        this.moveDist += isStateClimbable ? f1 : f2;
        this.flyDist += f1;
        if (this.moveDist > this.nextStep && !blockState.isAir()) {
            boolean flag = onPos.equals(pos);
            boolean flag1 = this.vibrationAndSoundEffectsFromBlock(pos, state, movementEmission.emitsSounds(), flag, movement);
            if (!flag) {
                flag1 |= this.vibrationAndSoundEffectsFromBlock(onPos, blockState, false, movementEmission.emitsEvents(), movement);
            }
            if (flag1) {
                this.nextStep = this.nextStep();
            } else if (this.isInWater()) {
                this.nextStep = this.nextStep();
                if (movementEmission.emitsSounds()) {
                    this.waterSwimSound();
                }
                if (movementEmission.emitsEvents()) {
                    this.gameEvent(GameEvent.SWIM);
                }
            }
        } else if (blockState.isAir()) {
            this.processFlappingMovement();
        }
    }

    protected void applyEffectsFromBlocks() {
        this.finalMovementsThisTick.clear();
        this.movementThisTick.forEach(this.finalMovementsThisTick::addAll);
        this.movementThisTick.clear();
        if (this.finalMovementsThisTick.isEmpty()) {
            this.finalMovementsThisTick.add(new Movement(this.oldPosition(), this.position()));
        } else if (this.finalMovementsThisTick.getLast().to.distanceToSqr(this.position()) > 9.999999439624929E-11) {
            this.finalMovementsThisTick.add(new Movement(this.finalMovementsThisTick.getLast().to, this.position()));
        }
        this.applyEffectsFromBlocks(this.finalMovementsThisTick);
    }

    public void removeLatestMovementRecordingBatch() {
        if (!this.movementThisTick.isEmpty()) {
            this.movementThisTick.removeLast();
        }
    }

    public void applyEffectsFromBlocks(Vec3 oldPosition, Vec3 position) {
        this.applyEffectsFromBlocks(List.of(new Movement(oldPosition, position)));
    }

    private void applyEffectsFromBlocks(List<Movement> movements) {
        if (this.isAffectedByBlocks()) {
            if (this.onGround()) {
                BlockPos onPosLegacy = this.getOnPosLegacy();
                BlockState blockState = this.level().getBlockState(onPosLegacy);
                blockState.getBlock().stepOn(this.level(), onPosLegacy, blockState, this);
            }
            boolean isOnFire = this.isOnFire();
            boolean isFreezing = this.isFreezing();
            this.checkInsideBlocks(movements, this.insideEffectCollector);
            this.insideEffectCollector.applyAndClear(this);
            if (this.isInRain()) {
                this.clearFire();
            }
            if (isOnFire && !this.isOnFire() || isFreezing && !this.isFreezing()) {
                this.playEntityOnFireExtinguishedSound();
            }
            if (isOnFire && !this.isOnFire() && this.remainingFireTicks <= 0) {
                this.setRemainingFireTicks(-this.getFireImmuneTicks());
            }
        }
    }

    public boolean isAffectedByBlocks() {
        return !this.isRemoved() && !this.noPhysics;
    }

    private boolean isStateClimbable(BlockState state) {
        return state.is(BlockTags.CLIMBABLE) || state.is(Blocks.POWDER_SNOW);
    }

    private boolean vibrationAndSoundEffectsFromBlock(BlockPos pos, BlockState state, boolean playStepSound, boolean broadcastGameEvent, Vec3 entityPos) {
        if (state.isAir()) {
            return false;
        }
        boolean isStateClimbable = this.isStateClimbable(state);
        if ((this.onGround() || isStateClimbable || this.isCrouching() && entityPos.y == 0.0 || this.isOnRails()) && !this.isSwimming()) {
            if (playStepSound) {
                this.walkingStepSound(pos, state);
            }
            if (broadcastGameEvent) {
                this.level().gameEvent(GameEvent.STEP, this.position(), GameEvent.Context.of(this, state));
            }
            return true;
        }
        return false;
    }

    protected boolean isHorizontalCollisionMinor(Vec3 deltaMovement) {
        return false;
    }

    protected void playEntityOnFireExtinguishedSound() {
        if (!this.level.isClientSide()) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.GENERIC_EXTINGUISH_FIRE, this.getSoundSource(), 0.7f, 1.6f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
        }
    }

    public void extinguishFire() {
        if (this.isOnFire()) {
            this.playEntityOnFireExtinguishedSound();
        }
        this.clearFire();
    }

    protected void processFlappingMovement() {
        if (this.isFlapping()) {
            this.onFlap();
            if (this.getMovementEmission().emitsEvents()) {
                this.gameEvent(GameEvent.FLAP);
            }
        }
    }

    @Deprecated
    public BlockPos getOnPosLegacy() {
        return this.getOnPos(0.2f);
    }

    public BlockPos getBlockPosBelowThatAffectsMyMovement() {
        return this.getOnPos(0.500001f);
    }

    public BlockPos getOnPos() {
        return this.getOnPos(1.0E-5f);
    }

    protected BlockPos getOnPos(float yOffset) {
        if (this.mainSupportingBlockPos.isPresent() && this.level().getChunkIfLoadedImmediately(this.mainSupportingBlockPos.get()) != null) {
            BlockPos blockPos = this.mainSupportingBlockPos.get();
            if (!(yOffset > 1.0E-5f)) {
                return blockPos;
            }
            BlockState blockState = this.level().getBlockState(blockPos);
            return !((double)yOffset <= 0.5 && blockState.is(BlockTags.FENCES) || blockState.is(BlockTags.WALLS) || blockState.getBlock() instanceof FenceGateBlock) ? blockPos.atY(Mth.floor(this.position.y - (double)yOffset)) : blockPos;
        }
        int floor = Mth.floor(this.position.x);
        int floor1 = Mth.floor(this.position.y - (double)yOffset);
        int floor2 = Mth.floor(this.position.z);
        return new BlockPos(floor, floor1, floor2);
    }

    protected float getBlockJumpFactor() {
        float jumpFactor = this.level().getBlockState(this.blockPosition()).getBlock().getJumpFactor();
        float jumpFactor1 = this.level().getBlockState(this.getBlockPosBelowThatAffectsMyMovement()).getBlock().getJumpFactor();
        return (double)jumpFactor == 1.0 ? jumpFactor1 : jumpFactor;
    }

    protected float getBlockSpeedFactor() {
        BlockState blockState = this.level().getBlockState(this.blockPosition());
        float speedFactor = blockState.getBlock().getSpeedFactor();
        if (!blockState.is(Blocks.WATER) && !blockState.is(Blocks.BUBBLE_COLUMN)) {
            return (double)speedFactor == 1.0 ? this.level().getBlockState(this.getBlockPosBelowThatAffectsMyMovement()).getBlock().getSpeedFactor() : speedFactor;
        }
        return speedFactor;
    }

    protected Vec3 maybeBackOffFromEdge(Vec3 vec, MoverType mover) {
        return vec;
    }

    protected Vec3 limitPistonMovement(Vec3 pos) {
        if (pos.lengthSqr() <= 1.0E-7) {
            return pos;
        }
        long gameTime = this.level().getGameTime();
        if (gameTime != this.pistonDeltasGameTime) {
            Arrays.fill(this.pistonDeltas, 0.0);
            this.pistonDeltasGameTime = gameTime;
        }
        if (pos.x != 0.0) {
            double d = this.applyPistonMovementRestriction(Direction.Axis.X, pos.x);
            return Math.abs(d) <= (double)1.0E-5f ? Vec3.ZERO : new Vec3(d, 0.0, 0.0);
        }
        if (pos.y != 0.0) {
            double d = this.applyPistonMovementRestriction(Direction.Axis.Y, pos.y);
            return Math.abs(d) <= (double)1.0E-5f ? Vec3.ZERO : new Vec3(0.0, d, 0.0);
        }
        if (pos.z != 0.0) {
            double d = this.applyPistonMovementRestriction(Direction.Axis.Z, pos.z);
            return Math.abs(d) <= (double)1.0E-5f ? Vec3.ZERO : new Vec3(0.0, 0.0, d);
        }
        return Vec3.ZERO;
    }

    private double applyPistonMovementRestriction(Direction.Axis axis, double distance) {
        int ordinal = axis.ordinal();
        double d = Mth.clamp(distance + this.pistonDeltas[ordinal], -0.51, 0.51);
        distance = d - this.pistonDeltas[ordinal];
        this.pistonDeltas[ordinal] = d;
        return distance;
    }

    private Vec3 collide(Vec3 movement) {
        double stepHeight;
        boolean collidedDownwards;
        Vec3 collided;
        ArrayList<AABB> entityAABBs;
        AABB currentBox;
        block7: {
            block6: {
                double d;
                boolean zZero;
                boolean xZero = movement.x == 0.0;
                boolean yZero = movement.y == 0.0;
                boolean bl = zZero = movement.z == 0.0;
                if (xZero & yZero & zZero) {
                    return movement;
                }
                currentBox = this.getBoundingBox();
                ArrayList<VoxelShape> potentialCollisionsVoxel = new ArrayList<VoxelShape>();
                ArrayList<AABB> potentialCollisionsBB = new ArrayList<AABB>();
                AABB initialCollisionBox = xZero & zZero ? (movement.y < 0.0 ? CollisionUtil.cutDownwards(currentBox, movement.y) : CollisionUtil.cutUpwards(currentBox, movement.y)) : currentBox.expandTowards(movement);
                entityAABBs = new ArrayList<AABB>();
                CollisionUtil.getEntityHardCollisions(this.level, this, initialCollisionBox, entityAABBs, 0, null);
                CollisionUtil.getCollisionsForBlocksOrWorldBorder(this.level, this, initialCollisionBox, potentialCollisionsVoxel, potentialCollisionsBB, 4, null);
                potentialCollisionsBB.addAll(entityAABBs);
                collided = CollisionUtil.performCollisions(movement, currentBox, potentialCollisionsVoxel, potentialCollisionsBB);
                boolean collidedX = collided.x != movement.x;
                boolean collidedY = collided.y != movement.y;
                boolean collidedZ = collided.z != movement.z;
                boolean bl2 = collidedDownwards = collidedY && movement.y < 0.0;
                if (!collidedDownwards && !this.onGround || !collidedX && !collidedZ) break block6;
                stepHeight = this.maxUpStep();
                if (!(d <= 0.0)) break block7;
            }
            return collided;
        }
        AABB collidedYBox = collidedDownwards ? currentBox.move(0.0, collided.y, 0.0) : currentBox;
        AABB stepRetrievalBox = collidedYBox.expandTowards(movement.x, stepHeight, movement.z);
        if (!collidedDownwards) {
            stepRetrievalBox = stepRetrievalBox.expandTowards(0.0, -1.0E-5f, 0.0);
        }
        ArrayList<VoxelShape> stepVoxels = new ArrayList<VoxelShape>();
        ArrayList<AABB> stepAABBs = entityAABBs;
        CollisionUtil.getCollisionsForBlocksOrWorldBorder(this.level, this, stepRetrievalBox, stepVoxels, stepAABBs, 4, null);
        for (float step : Entity.calculateStepHeights(collidedYBox, stepVoxels, stepAABBs, (float)stepHeight, (float)collided.y)) {
            Vec3 stepResult = CollisionUtil.performCollisions(new Vec3(movement.x, step, movement.z), collidedYBox, stepVoxels, stepAABBs);
            if (!(stepResult.horizontalDistanceSqr() > collided.horizontalDistanceSqr())) continue;
            return stepResult.add(0.0, collidedYBox.minY - currentBox.minY, 0.0);
        }
        return collided;
    }

    private static float[] collectCandidateStepUpHeights(AABB box, List<VoxelShape> colliders, float deltaY, float maxUpStep) {
        FloatArraySet set = new FloatArraySet(4);
        block0: for (VoxelShape voxelShape : colliders) {
            DoubleListIterator doubleListIterator = voxelShape.getCoords(Direction.Axis.Y).iterator();
            while (doubleListIterator.hasNext()) {
                double d = (Double)doubleListIterator.next();
                float f = (float)(d - box.minY);
                if (f < 0.0f || f == maxUpStep) continue;
                if (f > deltaY) continue block0;
                set.add(f);
            }
        }
        float[] floats = set.toFloatArray();
        FloatArrays.unstableSort((float[])floats);
        return floats;
    }

    public static Vec3 collideBoundingBox(@Nullable Entity entity, Vec3 vec, AABB collisionBox, Level level, List<VoxelShape> potentialHits) {
        List<VoxelShape> list = Entity.collectColliders(entity, level, potentialHits, collisionBox.expandTowards(vec));
        return Entity.collideWithShapes(vec, collisionBox, list);
    }

    private static List<VoxelShape> collectColliders(@Nullable Entity entity, Level level, List<VoxelShape> collisions, AABB boundingBox) {
        boolean flag;
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)(collisions.size() + 1));
        if (!collisions.isEmpty()) {
            builder.addAll(collisions);
        }
        WorldBorder worldBorder = level.getWorldBorder();
        boolean bl = flag = entity != null && worldBorder.isInsideCloseToBorder(entity, boundingBox);
        if (flag) {
            builder.add((Object)worldBorder.getCollisionShape());
        }
        builder.addAll(level.getBlockCollisions(entity, boundingBox));
        return builder.build();
    }

    private static Vec3 collideWithShapes(Vec3 deltaMovement, AABB entityBB, List<VoxelShape> shapes) {
        if (shapes.isEmpty()) {
            return deltaMovement;
        }
        Vec3 vec3 = Vec3.ZERO;
        for (Direction.Axis axis : Entity.axisStepOrder(deltaMovement)) {
            double d = deltaMovement.get(axis);
            if (d == 0.0) continue;
            double d1 = Shapes.collide(axis, entityBB.move(vec3), shapes, d);
            vec3 = vec3.with(axis, d1);
        }
        return vec3;
    }

    private static Iterable<Direction.Axis> axisStepOrder(Vec3 deltaMovement) {
        return Math.abs(deltaMovement.x) < Math.abs(deltaMovement.z) ? YZX_AXIS_ORDER : YXZ_AXIS_ORDER;
    }

    protected float nextStep() {
        return (int)this.moveDist + 1;
    }

    public SoundEvent getSwimSound() {
        return SoundEvents.GENERIC_SWIM;
    }

    public SoundEvent getSwimSplashSound() {
        return SoundEvents.GENERIC_SPLASH;
    }

    public SoundEvent getSwimHighSpeedSplashSound() {
        return SoundEvents.GENERIC_SPLASH;
    }

    private void checkInsideBlocks(List<Movement> movements, InsideBlockEffectApplier.StepBasedCollector stepBasedCollector) {
        if (this.isAffectedByBlocks()) {
            LongSet set = this.visitedBlocks;
            for (Movement movement : movements) {
                Vec3 vec3 = movement.from();
                Vec3 vec31 = movement.to();
                AABB aabb = this.makeBoundingBox(vec31).deflate(1.0E-5f);
                BlockGetter.forEachBlockIntersectedBetween(vec3, vec31, aabb, (pos, step) -> {
                    BlockState blockState;
                    if (this.isAlive() && !(blockState = this.level().getBlockState(pos)).isAir() && set.add(pos.asLong())) {
                        boolean flag1;
                        boolean flag;
                        VoxelShape entityInsideCollisionShape = blockState.getEntityInsideCollisionShape(this.level(), pos, this);
                        boolean bl = flag = entityInsideCollisionShape == Shapes.block() || this.collidedWithShapeMovingFrom(vec3, vec31, entityInsideCollisionShape.move(new Vec3(pos)).toAabbs());
                        if (flag) {
                            try {
                                stepBasedCollector.advanceStep(step, pos);
                                blockState.entityInside(this.level(), pos, this, stepBasedCollector);
                                this.onInsideBlock(blockState);
                            }
                            catch (Throwable var14) {
                                CrashReport crashReport = CrashReport.forThrowable(var14, "Colliding entity with block");
                                CrashReportCategory crashReportCategory = crashReport.addCategory("Block being collided with");
                                CrashReportCategory.populateBlockDetails(crashReportCategory, this.level(), pos, blockState);
                                CrashReportCategory crashReportCategory1 = crashReport.addCategory("Entity being checked for collision");
                                this.fillCrashReportCategory(crashReportCategory1);
                                throw new ReportedException(crashReport);
                            }
                        }
                        if (flag1 = this.collidedWithFluid(blockState.getFluidState(), pos, vec3, vec31)) {
                            stepBasedCollector.advanceStep(step, pos);
                            blockState.getFluidState().entityInside(this.level(), pos, this, stepBasedCollector);
                        }
                    }
                });
            }
            set.clear();
        }
    }

    private boolean collidedWithFluid(FluidState fluid, BlockPos pos, Vec3 from, Vec3 to) {
        AABB aabb = fluid.getAABB(this.level(), pos);
        return aabb != null && this.collidedWithShapeMovingFrom(from, to, List.of(aabb));
    }

    private boolean collidedWithShapeMovingFrom(Vec3 from, Vec3 to, List<AABB> boxes) {
        AABB aabb = this.makeBoundingBox(from);
        Vec3 vec3 = to.subtract(from);
        return aabb.collidedAlongVector(vec3, boxes);
    }

    protected void onInsideBlock(BlockState state) {
    }

    public BlockPos adjustSpawnLocation(ServerLevel level, BlockPos pos) {
        BlockPos sharedSpawnPos = level.getSharedSpawnPos();
        Vec3 center = sharedSpawnPos.getCenter();
        int i = level.getChunkAt(sharedSpawnPos).getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, sharedSpawnPos.getX(), sharedSpawnPos.getZ()) + 1;
        return BlockPos.containing(center.x, i, center.z);
    }

    public void gameEvent(Holder<GameEvent> gameEvent, @Nullable Entity entity) {
        this.level().gameEvent(entity, gameEvent, this.position);
    }

    public void gameEvent(Holder<GameEvent> gameEvent) {
        this.gameEvent(gameEvent, this);
    }

    private void walkingStepSound(BlockPos pos, BlockState state) {
        this.playStepSound(pos, state);
        if (this.shouldPlayAmethystStepSound(state)) {
            this.playAmethystStepSound();
        }
    }

    protected void waterSwimSound() {
        Entity entity = Objects.requireNonNullElse(this.getControllingPassenger(), this);
        float f = entity == this ? 0.35f : 0.4f;
        Vec3 deltaMovement = entity.getDeltaMovement();
        float min = Math.min(1.0f, (float)Math.sqrt(deltaMovement.x * deltaMovement.x * (double)0.2f + deltaMovement.y * deltaMovement.y + deltaMovement.z * deltaMovement.z * (double)0.2f) * f);
        this.playSwimSound(min);
    }

    protected BlockPos getPrimaryStepSoundBlockPos(BlockPos pos) {
        BlockPos blockPos = pos.above();
        BlockState blockState = this.level().getBlockState(blockPos);
        return !blockState.is(BlockTags.INSIDE_STEP_SOUND_BLOCKS) && !blockState.is(BlockTags.COMBINATION_STEP_SOUND_BLOCKS) ? pos : blockPos;
    }

    protected void playCombinationStepSounds(BlockState primaryState, BlockState secondaryState) {
        SoundType soundType = primaryState.getSoundType();
        this.playSound(soundType.getStepSound(), soundType.getVolume() * 0.15f, soundType.getPitch());
        this.playMuffledStepSound(secondaryState);
    }

    protected void playMuffledStepSound(BlockState state) {
        SoundType soundType = state.getSoundType();
        this.playSound(soundType.getStepSound(), soundType.getVolume() * 0.05f, soundType.getPitch() * 0.8f);
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        SoundType soundType = state.getSoundType();
        this.playSound(soundType.getStepSound(), soundType.getVolume() * 0.15f, soundType.getPitch());
    }

    private boolean shouldPlayAmethystStepSound(BlockState state) {
        return state.is(BlockTags.CRYSTAL_SOUND_BLOCKS) && this.tickCount >= this.lastCrystalSoundPlayTick + 20;
    }

    private void playAmethystStepSound() {
        this.crystalSoundIntensity *= (float)Math.pow(0.997, this.tickCount - this.lastCrystalSoundPlayTick);
        this.crystalSoundIntensity = Math.min(1.0f, this.crystalSoundIntensity + 0.07f);
        float f = 0.5f + this.crystalSoundIntensity * this.random.nextFloat() * 1.2f;
        float f1 = 0.1f + this.crystalSoundIntensity * 1.2f;
        this.playSound(SoundEvents.AMETHYST_BLOCK_CHIME, f1, f);
        this.lastCrystalSoundPlayTick = this.tickCount;
    }

    protected void playSwimSound(float volume) {
        this.playSound(this.getSwimSound(), volume, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
    }

    protected void onFlap() {
    }

    protected boolean isFlapping() {
        return false;
    }

    public void playSound(SoundEvent sound, float volume, float pitch) {
        if (!this.isSilent()) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), sound, this.getSoundSource(), volume, pitch);
        }
    }

    public void playSound(SoundEvent sound) {
        if (!this.isSilent()) {
            this.playSound(sound, 1.0f, 1.0f);
        }
    }

    public boolean isSilent() {
        return this.entityData.get(DATA_SILENT);
    }

    public void setSilent(boolean isSilent) {
        this.entityData.set(DATA_SILENT, isSilent);
    }

    public boolean isNoGravity() {
        return this.entityData.get(DATA_NO_GRAVITY);
    }

    public void setNoGravity(boolean noGravity) {
        this.entityData.set(DATA_NO_GRAVITY, noGravity);
    }

    protected double getDefaultGravity() {
        return 0.0;
    }

    public final double getGravity() {
        return this.isNoGravity() ? 0.0 : this.getDefaultGravity();
    }

    protected void applyGravity() {
        double gravity = this.getGravity();
        if (gravity != 0.0) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -gravity, 0.0));
        }
    }

    protected MovementEmission getMovementEmission() {
        return MovementEmission.ALL;
    }

    public boolean dampensVibrations() {
        return false;
    }

    public final void doCheckFallDamage(double x, double y, double z, boolean onGround) {
        if (!this.touchingUnloadedChunk()) {
            this.checkSupportingBlock(onGround, new Vec3(x, y, z));
            BlockPos onPosLegacy = this.getOnPosLegacy();
            BlockState blockState = this.level().getBlockState(onPosLegacy);
            this.checkFallDamage(y, onGround, blockState, onPosLegacy);
        }
    }

    protected void checkFallDamage(double y, boolean onGround, BlockState state, BlockPos pos) {
        if (!this.isInWater() && y < 0.0) {
            this.fallDistance -= (double)((float)y);
        }
        if (onGround) {
            if (this.fallDistance > 0.0) {
                state.getBlock().fallOn(this.level(), state, pos, this, this.fallDistance);
                this.level().gameEvent(GameEvent.HIT_GROUND, this.position, GameEvent.Context.of(this, this.mainSupportingBlockPos.map(supportingPos -> this.level().getBlockState((BlockPos)supportingPos)).orElse(state)));
            }
            this.resetFallDistance();
        }
    }

    public boolean fireImmune() {
        return this.getType().fireImmune();
    }

    public boolean causeFallDamage(double fallDistance, float damageMultiplier, DamageSource damageSource) {
        if (this.type.is(EntityTypeTags.FALL_DAMAGE_IMMUNE)) {
            return false;
        }
        this.propagateFallToPassengers(fallDistance, damageMultiplier, damageSource);
        return false;
    }

    protected void propagateFallToPassengers(double fallDistance, float damageMultiplier, DamageSource damageSource) {
        if (this.isVehicle()) {
            for (Entity entity : this.getPassengers()) {
                entity.causeFallDamage(fallDistance, damageMultiplier, damageSource);
            }
        }
    }

    public boolean isInWater() {
        return this.wasTouchingWater;
    }

    public boolean isInRain() {
        BlockPos blockPos = this.blockPosition();
        return this.level().isRainingAt(blockPos) || this.level().isRainingAt(BlockPos.containing(blockPos.getX(), this.getBoundingBox().maxY, blockPos.getZ()));
    }

    public boolean isInWaterOrRain() {
        return this.isInWater() || this.isInRain();
    }

    public boolean isInLiquid() {
        return this.isInWater() || this.isInLava();
    }

    public boolean isUnderWater() {
        return this.wasEyeInWater && this.isInWater();
    }

    public void updateSwimming() {
        if (this.isSwimming()) {
            this.setSwimming(this.isSprinting() && this.isInWater() && !this.isPassenger());
        } else {
            this.setSwimming(this.isSprinting() && this.isUnderWater() && !this.isPassenger() && this.level().getFluidState(this.blockPosition).is(FluidTags.WATER));
        }
    }

    protected boolean updateInWaterStateAndDoFluidPushing() {
        this.fluidHeight.clear();
        this.updateInWaterStateAndDoWaterCurrentPushing();
        double d = this.level().dimensionType().ultraWarm() ? 0.007 : 0.0023333333333333335;
        boolean flag = this.updateFluidHeightAndDoFluidPushing(FluidTags.LAVA, d);
        return this.isInWater() || flag;
    }

    void updateInWaterStateAndDoWaterCurrentPushing() {
        AbstractBoat abstractBoat;
        Entity entity = this.getVehicle();
        if (entity instanceof AbstractBoat && !(abstractBoat = (AbstractBoat)entity).isUnderWater()) {
            this.wasTouchingWater = false;
        } else if (this.updateFluidHeightAndDoFluidPushing(FluidTags.WATER, 0.014)) {
            if (!this.wasTouchingWater && !this.firstTick) {
                this.doWaterSplashEffect();
            }
            this.resetFallDistance();
            this.wasTouchingWater = true;
        } else {
            this.wasTouchingWater = false;
        }
    }

    private void updateFluidOnEyes() {
        AbstractBoat abstractBoat;
        this.wasEyeInWater = this.isEyeInFluid(FluidTags.WATER);
        this.fluidOnEyes.clear();
        double eyeY = this.getEyeY();
        Entity entity = this.getVehicle();
        if (!(entity instanceof AbstractBoat) || (abstractBoat = (AbstractBoat)entity).isUnderWater() || !(abstractBoat.getBoundingBox().maxY >= eyeY) || !(abstractBoat.getBoundingBox().minY <= eyeY)) {
            BlockPos blockPos = BlockPos.containing(this.getX(), eyeY, this.getZ());
            FluidState fluidState = this.level().getFluidState(blockPos);
            double d = (float)blockPos.getY() + fluidState.getHeight(this.level(), blockPos);
            if (d > eyeY) {
                fluidState.getTags().forEach(this.fluidOnEyes::add);
            }
        }
    }

    protected void doWaterSplashEffect() {
        double d1;
        double d;
        Entity entity = Objects.requireNonNullElse(this.getControllingPassenger(), this);
        float f = entity == this ? 0.2f : 0.9f;
        Vec3 deltaMovement = entity.getDeltaMovement();
        float min = Math.min(1.0f, (float)Math.sqrt(deltaMovement.x * deltaMovement.x * (double)0.2f + deltaMovement.y * deltaMovement.y + deltaMovement.z * deltaMovement.z * (double)0.2f) * f);
        if (min < 0.25f) {
            this.playSound(this.getSwimSplashSound(), min, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
        } else {
            this.playSound(this.getSwimHighSpeedSplashSound(), min, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
        }
        float f1 = Mth.floor(this.getY());
        int i = 0;
        while ((float)i < 1.0f + this.dimensions.width() * 20.0f) {
            d = (this.random.nextDouble() * 2.0 - 1.0) * (double)this.dimensions.width();
            d1 = (this.random.nextDouble() * 2.0 - 1.0) * (double)this.dimensions.width();
            this.level().addParticle(ParticleTypes.BUBBLE, this.getX() + d, f1 + 1.0f, this.getZ() + d1, deltaMovement.x, deltaMovement.y - this.random.nextDouble() * (double)0.2f, deltaMovement.z);
            ++i;
        }
        i = 0;
        while ((float)i < 1.0f + this.dimensions.width() * 20.0f) {
            d = (this.random.nextDouble() * 2.0 - 1.0) * (double)this.dimensions.width();
            d1 = (this.random.nextDouble() * 2.0 - 1.0) * (double)this.dimensions.width();
            this.level().addParticle(ParticleTypes.SPLASH, this.getX() + d, f1 + 1.0f, this.getZ() + d1, deltaMovement.x, deltaMovement.y, deltaMovement.z);
            ++i;
        }
        this.gameEvent(GameEvent.SPLASH);
    }

    @Deprecated
    protected BlockState getBlockStateOnLegacy() {
        return this.level().getBlockState(this.getOnPosLegacy());
    }

    public BlockState getBlockStateOn() {
        return this.level().getBlockState(this.getOnPos());
    }

    public boolean canSpawnSprintParticle() {
        return this.isSprinting() && !this.isInWater() && !this.isSpectator() && !this.isCrouching() && !this.isInLava() && this.isAlive();
    }

    protected void spawnSprintParticle() {
        BlockPos onPosLegacy = this.getOnPosLegacy();
        BlockState blockState = this.level().getBlockState(onPosLegacy);
        if (blockState.getRenderShape() != RenderShape.INVISIBLE) {
            Vec3 deltaMovement = this.getDeltaMovement();
            BlockPos blockPos = this.blockPosition();
            double d = this.getX() + (this.random.nextDouble() - 0.5) * (double)this.dimensions.width();
            double d1 = this.getZ() + (this.random.nextDouble() - 0.5) * (double)this.dimensions.width();
            if (blockPos.getX() != onPosLegacy.getX()) {
                d = Mth.clamp(d, (double)onPosLegacy.getX(), (double)onPosLegacy.getX() + 1.0);
            }
            if (blockPos.getZ() != onPosLegacy.getZ()) {
                d1 = Mth.clamp(d1, (double)onPosLegacy.getZ(), (double)onPosLegacy.getZ() + 1.0);
            }
            this.level().addParticle(new BlockParticleOption(ParticleTypes.BLOCK, blockState), d, this.getY() + 0.1, d1, deltaMovement.x * -4.0, 1.5, deltaMovement.z * -4.0);
        }
    }

    public boolean isEyeInFluid(TagKey<Fluid> fluidTag) {
        return this.fluidOnEyes.contains(fluidTag);
    }

    public boolean isInLava() {
        return !this.firstTick && this.fluidHeight.getDouble(FluidTags.LAVA) > 0.0;
    }

    public void moveRelative(float amount, Vec3 relative) {
        Vec3 inputVector = Entity.getInputVector(relative, amount, this.getYRot());
        this.setDeltaMovement(this.getDeltaMovement().add(inputVector));
    }

    protected static Vec3 getInputVector(Vec3 relative, float motionScaler, float facing) {
        double d = relative.lengthSqr();
        if (d < 1.0E-7) {
            return Vec3.ZERO;
        }
        Vec3 vec3 = (d > 1.0 ? relative.normalize() : relative).scale(motionScaler);
        float sin = Mth.sin(facing * ((float)Math.PI / 180));
        float cos = Mth.cos(facing * ((float)Math.PI / 180));
        return new Vec3(vec3.x * (double)cos - vec3.z * (double)sin, vec3.y, vec3.z * (double)cos + vec3.x * (double)sin);
    }

    @Deprecated
    public float getLightLevelDependentMagicValue() {
        return this.level().hasChunkAt(this.getBlockX(), this.getBlockZ()) ? this.level().getLightLevelDependentMagicValue(BlockPos.containing(this.getX(), this.getEyeY(), this.getZ())) : 0.0f;
    }

    public void absSnapTo(double x, double y, double z, float yRot, float xRot) {
        this.absSnapTo(x, y, z);
        this.absSnapRotationTo(yRot, xRot);
    }

    public void absSnapRotationTo(float yRot, float xRot) {
        this.setYRot(yRot % 360.0f);
        this.setXRot(Mth.clamp(xRot, -90.0f, 90.0f) % 360.0f);
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
        this.setYHeadRot(yRot);
    }

    public void absSnapTo(double x, double y, double z) {
        double d = Mth.clamp(x, -3.0E7, 3.0E7);
        double d1 = Mth.clamp(z, -3.0E7, 3.0E7);
        this.xo = d;
        this.yo = y;
        this.zo = d1;
        this.setPos(d, y, d1);
        if (this.valid) {
            this.level.getChunk((int)Math.floor(this.getX()) >> 4, (int)Math.floor(this.getZ()) >> 4);
        }
    }

    public void snapTo(Vec3 pos) {
        this.snapTo(pos.x, pos.y, pos.z);
    }

    public void snapTo(double x, double y, double z) {
        this.snapTo(x, y, z, this.getYRot(), this.getXRot());
    }

    public void snapTo(BlockPos pos, float yRot, float xRot) {
        this.snapTo(pos.getBottomCenter(), yRot, xRot);
    }

    public void snapTo(Vec3 pos, float yRot, float xRot) {
        this.snapTo(pos.x, pos.y, pos.z, yRot, xRot);
    }

    public void snapTo(double x, double y, double z, float yRot, float xRot) {
        if (!this.preserveMotion) {
            this.deltaMovement = Vec3.ZERO;
        } else {
            this.preserveMotion = false;
        }
        this.setPosRaw(x, y, z);
        this.setYRot(yRot);
        this.setXRot(xRot);
        this.setOldPosAndRot();
        this.reapplyPosition();
        this.setYHeadRot(yRot);
    }

    public final void setOldPosAndRot() {
        this.setOldPos();
        this.setOldRot();
    }

    public final void setOldPosAndRot(Vec3 pos, float yRot, float xRot) {
        this.setOldPos(pos);
        this.setOldRot(yRot, xRot);
    }

    protected void setOldPos() {
        this.setOldPos(this.position);
    }

    public void setOldRot() {
        this.setOldRot(this.getYRot(), this.getXRot());
    }

    private void setOldPos(Vec3 pos) {
        this.xo = this.xOld = pos.x;
        this.yo = this.yOld = pos.y;
        this.zo = this.zOld = pos.z;
    }

    private void setOldRot(float yRot, float xRot) {
        this.yRotO = yRot;
        this.xRotO = xRot;
    }

    public final Vec3 oldPosition() {
        return new Vec3(this.xOld, this.yOld, this.zOld);
    }

    public float distanceTo(Entity entity) {
        float f = (float)(this.getX() - entity.getX());
        float f1 = (float)(this.getY() - entity.getY());
        float f2 = (float)(this.getZ() - entity.getZ());
        return Mth.sqrt(f * f + f1 * f1 + f2 * f2);
    }

    public double distanceToSqr(double x, double y, double z) {
        double d = this.getX() - x;
        double d1 = this.getY() - y;
        double d2 = this.getZ() - z;
        return d * d + d1 * d1 + d2 * d2;
    }

    public double distanceToSqr(Entity entity) {
        return this.distanceToSqr(entity.position());
    }

    public double distanceToSqr(Vec3 vec) {
        double d = this.getX() - vec.x;
        double d1 = this.getY() - vec.y;
        double d2 = this.getZ() - vec.z;
        return d * d + d1 * d1 + d2 * d2;
    }

    public void playerTouch(Player player) {
    }

    public void push(Entity entity) {
        if (!(this.isPassengerOfSameVehicle(entity) || entity.noPhysics || this.noPhysics)) {
            double d1;
            if (this.level.paperConfig().collisions.onlyPlayersCollide && !(entity instanceof ServerPlayer) && !(this instanceof ServerPlayer)) {
                return;
            }
            double d = entity.getX() - this.getX();
            double max = Mth.absMax(d, d1 = entity.getZ() - this.getZ());
            if (max >= (double)0.01f) {
                max = Math.sqrt(max);
                d /= max;
                d1 /= max;
                double d2 = 1.0 / max;
                if (d2 > 1.0) {
                    d2 = 1.0;
                }
                d *= d2;
                d1 *= d2;
                d *= (double)0.05f;
                d1 *= (double)0.05f;
                if (!this.isVehicle() && this.isPushable()) {
                    this.push(-d, 0.0, -d1);
                }
                if (!entity.isVehicle() && entity.isPushable()) {
                    entity.push(d, 0.0, d1);
                }
            }
        }
    }

    public void push(Vec3 vector) {
        this.push(vector.x, vector.y, vector.z);
    }

    public void push(double x, double y, double z) {
        this.push(x, y, z, null);
    }

    public void push(double x, double y, double z, @Nullable Entity pushingEntity) {
        Vector delta = new Vector(x, y, z);
        if (pushingEntity != null) {
            EntityPushedByEntityAttackEvent event = new EntityPushedByEntityAttackEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), EntityKnockbackEvent.Cause.PUSH, (org.bukkit.entity.Entity)pushingEntity.getBukkitEntity(), delta);
            if (!event.callEvent()) {
                return;
            }
            delta = event.getKnockback();
        }
        this.setDeltaMovement(this.getDeltaMovement().add(delta.getX(), delta.getY(), delta.getZ()));
        this.hasImpulse = true;
    }

    protected void markHurt() {
        this.hurtMarked = true;
    }

    @Deprecated
    public final void hurt(DamageSource damageSource, float amount) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.hurtServer(serverLevel, damageSource, amount);
        }
    }

    @Deprecated
    public final boolean hurtOrSimulate(DamageSource damageSource, float amount) {
        boolean bl;
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            bl = this.hurtServer(serverLevel, damageSource, amount);
        } else {
            bl = this.hurtClient(damageSource);
        }
        return bl;
    }

    public abstract boolean hurtServer(ServerLevel var1, DamageSource var2, float var3);

    public boolean hurtClient(DamageSource damageSource) {
        return false;
    }

    public final Vec3 getViewVector(float partialTicks) {
        return this.calculateViewVector(this.getViewXRot(partialTicks), this.getViewYRot(partialTicks));
    }

    public Direction getNearestViewDirection() {
        return Direction.getApproximateNearest(this.getViewVector(1.0f));
    }

    public float getViewXRot(float partialTicks) {
        return this.getXRot(partialTicks);
    }

    public float getViewYRot(float partialTick) {
        return this.getYRot(partialTick);
    }

    public float getXRot(float partialTick) {
        return partialTick == 1.0f ? this.getXRot() : Mth.lerp(partialTick, this.xRotO, this.getXRot());
    }

    public float getYRot(float partialTick) {
        return partialTick == 1.0f ? this.getYRot() : Mth.rotLerp(partialTick, this.yRotO, this.getYRot());
    }

    public final Vec3 calculateViewVector(float xRot, float yRot) {
        float f = xRot * ((float)Math.PI / 180);
        float f1 = -yRot * ((float)Math.PI / 180);
        float cos = Mth.cos(f1);
        float sin = Mth.sin(f1);
        float cos1 = Mth.cos(f);
        float sin1 = Mth.sin(f);
        return new Vec3(sin * cos1, -sin1, cos * cos1);
    }

    public final Vec3 getUpVector(float partialTick) {
        return this.calculateUpVector(this.getViewXRot(partialTick), this.getViewYRot(partialTick));
    }

    protected final Vec3 calculateUpVector(float xRot, float yRot) {
        return this.calculateViewVector(xRot - 90.0f, yRot);
    }

    public final Vec3 getEyePosition() {
        return new Vec3(this.getX(), this.getEyeY(), this.getZ());
    }

    public final Vec3 getEyePosition(float partialTick) {
        double d = Mth.lerp((double)partialTick, this.xo, this.getX());
        double d1 = Mth.lerp((double)partialTick, this.yo, this.getY()) + (double)this.getEyeHeight();
        double d2 = Mth.lerp((double)partialTick, this.zo, this.getZ());
        return new Vec3(d, d1, d2);
    }

    public Vec3 getLightProbePosition(float partialTicks) {
        return this.getEyePosition(partialTicks);
    }

    public final Vec3 getPosition(float partialTicks) {
        double d = Mth.lerp((double)partialTicks, this.xo, this.getX());
        double d1 = Mth.lerp((double)partialTicks, this.yo, this.getY());
        double d2 = Mth.lerp((double)partialTicks, this.zo, this.getZ());
        return new Vec3(d, d1, d2);
    }

    public HitResult pick(double hitDistance, float partialTicks, boolean hitFluids) {
        Vec3 eyePosition = this.getEyePosition(partialTicks);
        Vec3 viewVector = this.getViewVector(partialTicks);
        Vec3 vec3 = eyePosition.add(viewVector.x * hitDistance, viewVector.y * hitDistance, viewVector.z * hitDistance);
        return this.level().clip(new ClipContext(eyePosition, vec3, ClipContext.Block.OUTLINE, hitFluids ? ClipContext.Fluid.ANY : ClipContext.Fluid.NONE, this));
    }

    public boolean canBeHitByProjectile() {
        return this.isAlive() && this.isPickable();
    }

    public boolean isPickable() {
        return false;
    }

    public boolean isPushable() {
        return this.isCollidable(false);
    }

    public boolean isCollidable(boolean ignoreClimbing) {
        return false;
    }

    public boolean canCollideWithBukkit(Entity entity) {
        return this.isPushable();
    }

    public void awardKillScore(Entity entity, DamageSource damageSource) {
        if (entity instanceof ServerPlayer) {
            CriteriaTriggers.ENTITY_KILLED_PLAYER.trigger((ServerPlayer)entity, this, damageSource);
        }
    }

    public boolean shouldRender(double x, double y, double z) {
        double d = this.getX() - x;
        double d1 = this.getY() - y;
        double d2 = this.getZ() - z;
        double d3 = d * d + d1 * d1 + d2 * d2;
        return this.shouldRenderAtSqrDistance(d3);
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        double size = this.getBoundingBox().getSize();
        if (Double.isNaN(size)) {
            size = 1.0;
        }
        return distance < (size *= 64.0 * viewScale) * size;
    }

    public boolean saveAsPassenger(CompoundTag compound) {
        return this.saveAsPassenger(compound, true, false, false);
    }

    public boolean saveAsPassenger(CompoundTag compound, boolean includeAll, boolean includeNonSaveable, boolean forceSerialization) {
        if (this.removalReason != null && !this.removalReason.shouldSave() && !forceSerialization) {
            return false;
        }
        String encodeId = this.getEncodeId(includeNonSaveable);
        if (!this.persist && !forceSerialization || encodeId == null) {
            return false;
        }
        compound.putString(ID_TAG, encodeId);
        this.saveWithoutId(compound, includeAll, includeNonSaveable, forceSerialization);
        return true;
    }

    public boolean save(CompoundTag compound) {
        return !this.isPassenger() && this.saveAsPassenger(compound);
    }

    public CompoundTag saveWithoutId(CompoundTag compound) {
        return this.saveWithoutId(compound, true, false, false);
    }

    public CompoundTag saveWithoutId(CompoundTag compound, boolean includeAll, boolean includeNonSaveable, boolean forceSerialization) {
        try {
            int ticksFrozen;
            if (includeAll) {
                if (this.vehicle != null) {
                    compound.store("Pos", Vec3.CODEC, new Vec3(this.vehicle.getX(), this.getY(), this.vehicle.getZ()));
                } else {
                    compound.store("Pos", Vec3.CODEC, this.position());
                }
            }
            this.setDeltaMovement(MCUtil.sanitizeNanInf(this.deltaMovement, 0.0));
            compound.store("Motion", Vec3.CODEC, this.getDeltaMovement());
            if (Float.isNaN(this.yRot)) {
                this.yRot = 0.0f;
            }
            if (Float.isNaN(this.xRot)) {
                this.xRot = 0.0f;
            }
            compound.store("Rotation", Vec2.CODEC, new Vec2(this.getYRot(), this.getXRot()));
            compound.putDouble("fall_distance", this.fallDistance);
            compound.putShort("Fire", (short)this.remainingFireTicks);
            compound.putShort("Air", (short)this.getAirSupply());
            compound.putBoolean("OnGround", this.onGround());
            compound.putBoolean("Invulnerable", this.invulnerable);
            compound.putInt("PortalCooldown", this.portalCooldown);
            if (includeAll) {
                compound.store(UUID_TAG, UUIDUtil.CODEC, this.getUUID());
                compound.putLong("WorldUUIDLeast", this.level.getWorld().getUID().getLeastSignificantBits());
                compound.putLong("WorldUUIDMost", this.level.getWorld().getUID().getMostSignificantBits());
            }
            compound.putInt("Bukkit.updateLevel", 2);
            if (!this.persist) {
                compound.putBoolean("Bukkit.persist", this.persist);
            }
            if (!this.visibleByDefault) {
                compound.putBoolean("Bukkit.visibleByDefault", this.visibleByDefault);
            }
            if (this.persistentInvisibility) {
                compound.putBoolean("Bukkit.invisible", this.persistentInvisibility);
            }
            if (this.maxAirTicks != this.getDefaultMaxAirSupply()) {
                compound.putInt("Bukkit.MaxAirSupply", this.getMaxAirSupply());
            }
            compound.putInt("Spigot.ticksLived", this.totalEntityAge);
            Component customName = this.getCustomName();
            if (customName != null) {
                RegistryOps<Tag> registryOps = this.registryAccess().createSerializationContext(NbtOps.INSTANCE);
                compound.store("CustomName", ComponentSerialization.CODEC, registryOps, customName);
            }
            if (this.isCustomNameVisible()) {
                compound.putBoolean("CustomNameVisible", this.isCustomNameVisible());
            }
            if (this.isSilent()) {
                compound.putBoolean("Silent", this.isSilent());
            }
            if (this.isNoGravity()) {
                compound.putBoolean("NoGravity", this.isNoGravity());
            }
            if (this.hasGlowingTag) {
                compound.putBoolean("Glowing", true);
            }
            if ((ticksFrozen = this.getTicksFrozen()) > 0) {
                compound.putInt("TicksFrozen", this.getTicksFrozen());
            }
            if (this.hasVisualFire) {
                compound.putBoolean("HasVisualFire", this.hasVisualFire);
            }
            if (!this.tags.isEmpty()) {
                compound.store("Tags", TAG_LIST_CODEC, List.copyOf(this.tags));
            }
            if (!this.customData.isEmpty()) {
                compound.store(DATA_TAG, CustomData.CODEC, this.customData);
            }
            this.addAdditionalSaveData(compound, includeAll);
            if (this.isVehicle()) {
                ListTag listTag = new ListTag();
                for (Entity entity : this.getPassengers()) {
                    CompoundTag compoundTag;
                    if (!entity.saveAsPassenger(compoundTag = new CompoundTag(), includeAll, includeNonSaveable, forceSerialization)) continue;
                    listTag.add(compoundTag);
                }
                if (!listTag.isEmpty()) {
                    compound.put(PASSENGERS_TAG, listTag);
                }
            }
            if (this.bukkitEntity != null) {
                this.bukkitEntity.storeBukkitValues(compound);
            }
            if (this.origin != null) {
                UUID originWorld;
                UUID uUID = this.originWorld != null ? this.originWorld : (originWorld = this.level != null ? this.level.getWorld().getUID() : null);
                if (originWorld != null) {
                    compound.store("Paper.OriginWorld", UUIDUtil.CODEC, originWorld);
                }
                compound.store("Paper.Origin", Vec3.CODEC, this.origin);
            }
            if (this.spawnReason != null) {
                compound.putString("Paper.SpawnReason", this.spawnReason.name());
            }
            if (this.spawnedViaMobSpawner) {
                compound.putBoolean("Paper.FromMobSpawner", true);
            }
            if (this.fromNetherPortal) {
                compound.putBoolean("Paper.FromNetherPortal", true);
            }
            if (this.freezeLocked) {
                compound.putBoolean("Paper.FreezeLock", true);
            }
            return compound;
        }
        catch (Throwable var8) {
            CrashReport crashReport = CrashReport.forThrowable(var8, "Saving entity NBT");
            CrashReportCategory crashReportCategory = crashReport.addCategory("Entity being saved");
            this.fillCrashReportCategory(crashReportCategory);
            throw new ReportedException(crashReport);
        }
    }

    public void load(CompoundTag compound) {
        try {
            Optional<Vec3> originVec;
            Vec3 vec3 = compound.read("Pos", Vec3.CODEC).orElse(Vec3.ZERO);
            Vec3 vec31 = compound.read("Motion", Vec3.CODEC).orElse(Vec3.ZERO);
            vec31 = MCUtil.sanitizeNanInf(vec31, 0.0);
            Vec2 vec2 = compound.read("Rotation", Vec2.CODEC).orElse(Vec2.ZERO);
            this.setDeltaMovement(Math.abs(vec31.x) > 10.0 ? 0.0 : vec31.x, Math.abs(vec31.y) > 10.0 ? 0.0 : vec31.y, Math.abs(vec31.z) > 10.0 ? 0.0 : vec31.z);
            this.hasImpulse = true;
            double d = 3.0000512E7;
            this.setPosRaw(Mth.clamp(vec3.x, -3.0000512E7, 3.0000512E7), Mth.clamp(vec3.y, -2.0E7, 2.0E7), Mth.clamp(vec3.z, -3.0000512E7, 3.0000512E7));
            this.setYRot(vec2.x);
            this.setXRot(vec2.y);
            this.setOldPosAndRot();
            this.setYHeadRot(this.getYRot());
            this.setYBodyRot(this.getYRot());
            this.fallDistance = compound.getDoubleOr("fall_distance", 0.0);
            this.remainingFireTicks = compound.getShortOr("Fire", (short)0);
            this.setAirSupply(compound.getIntOr("Air", this.getMaxAirSupply()));
            this.onGround = compound.getBooleanOr("OnGround", false);
            this.invulnerable = compound.getBooleanOr("Invulnerable", false);
            this.portalCooldown = compound.getIntOr("PortalCooldown", 0);
            compound.read(UUID_TAG, UUIDUtil.CODEC).ifPresent(uuid -> {
                this.uuid = uuid;
                this.stringUUID = this.uuid.toString();
            });
            if (!(Double.isFinite(this.getX()) && Double.isFinite(this.getY()) && Double.isFinite(this.getZ()))) {
                throw new IllegalStateException("Entity has invalid position");
            }
            if (Double.isFinite(this.getYRot()) && Double.isFinite(this.getXRot())) {
                this.reapplyPosition();
                this.setRot(this.getYRot(), this.getXRot());
                RegistryOps<Tag> registryOps = this.registryAccess().createSerializationContext(NbtOps.INSTANCE);
                this.setCustomName(compound.read("CustomName", ComponentSerialization.CODEC, registryOps).orElse(null));
                this.setCustomNameVisible(compound.getBooleanOr("CustomNameVisible", false));
                this.setSilent(compound.getBooleanOr("Silent", false));
                this.setNoGravity(compound.getBooleanOr("NoGravity", false));
                this.setGlowingTag(compound.getBooleanOr("Glowing", false));
                this.setTicksFrozen(compound.getIntOr("TicksFrozen", 0));
                this.hasVisualFire = compound.getBooleanOr("HasVisualFire", false);
                this.customData = compound.read(DATA_TAG, CustomData.CODEC).orElse(CustomData.EMPTY);
                this.tags.clear();
                compound.read("Tags", TAG_LIST_CODEC).ifPresent(this.tags::addAll);
                this.readAdditionalSaveData(compound);
                if (this.repositionEntityAfterLoad()) {
                    this.reapplyPosition();
                }
            } else {
                throw new IllegalStateException("Entity has invalid rotation");
            }
            if (this instanceof LivingEntity) {
                this.totalEntityAge = compound.getIntOr("Spigot.ticksLived", 0);
            }
            this.persist = compound.getBooleanOr("Bukkit.persist", true);
            this.visibleByDefault = compound.getBooleanOr("Bukkit.visibleByDefault", true);
            this.maxAirTicks = compound.getIntOr("Bukkit.MaxAirSupply", this.maxAirTicks);
            this.getBukkitEntity().readBukkitValues(compound);
            if (compound.contains("Bukkit.invisible")) {
                boolean bukkitInvisible = compound.getBooleanOr("Bukkit.invisible", false);
                this.setInvisible(bukkitInvisible);
                this.persistentInvisibility = bukkitInvisible;
            }
            if ((originVec = compound.read("Paper.Origin", Vec3.CODEC)).isPresent()) {
                UUID originWorld = null;
                if (compound.contains("Paper.OriginWorld")) {
                    originWorld = compound.read("Paper.OriginWorld", UUIDUtil.CODEC).orElse(null);
                } else if (this.level != null) {
                    originWorld = this.level.getWorld().getUID();
                }
                this.originWorld = originWorld;
                this.origin = originVec.get();
            }
            this.spawnedViaMobSpawner = compound.getBooleanOr("Paper.FromMobSpawner", false);
            this.fromNetherPortal = compound.getBooleanOr("Paper.FromNetherPortal", false);
            if (compound.contains("Paper.SpawnReason")) {
                String spawnReasonName = compound.getString("Paper.SpawnReason").orElse(null);
                try {
                    this.spawnReason = CreatureSpawnEvent.SpawnReason.valueOf((String)spawnReasonName);
                }
                catch (Exception ignored) {
                    LOGGER.error("Unknown SpawnReason " + spawnReasonName + " for " + String.valueOf(this));
                }
            }
            if (this.spawnReason == null) {
                if (this.spawnedViaMobSpawner) {
                    this.spawnReason = CreatureSpawnEvent.SpawnReason.SPAWNER;
                } else if (this instanceof Mob && (this instanceof Animal || this instanceof AbstractFish) && !((Mob)this).removeWhenFarAway(0.0) && !compound.getBooleanOr("PersistenceRequired", false)) {
                    this.spawnReason = CreatureSpawnEvent.SpawnReason.NATURAL;
                }
            }
            if (this.spawnReason == null) {
                this.spawnReason = CreatureSpawnEvent.SpawnReason.DEFAULT;
            }
            if (compound.contains("Paper.FreezeLock")) {
                this.freezeLocked = compound.getBooleanOr("Paper.FreezeLock", false);
            }
        }
        catch (Throwable var8) {
            CrashReport crashReport = CrashReport.forThrowable(var8, "Loading entity NBT");
            CrashReportCategory crashReportCategory = crashReport.addCategory("Entity being loaded");
            this.fillCrashReportCategory(crashReportCategory);
            throw new ReportedException(crashReport);
        }
    }

    protected boolean repositionEntityAfterLoad() {
        return true;
    }

    @Nullable
    public final String getEncodeId() {
        return this.getEncodeId(false);
    }

    @Nullable
    public final String getEncodeId(boolean includeNonSaveable) {
        EntityType<?> type = this.getType();
        ResourceLocation key = EntityType.getKey(type);
        return (type.canSerialize() || includeNonSaveable) && key != null ? key.toString() : null;
    }

    protected void addAdditionalSaveData(CompoundTag tag, boolean includeAll) {
        this.addAdditionalSaveData(tag);
    }

    protected abstract void readAdditionalSaveData(CompoundTag var1);

    protected abstract void addAdditionalSaveData(CompoundTag var1);

    @Nullable
    public ItemEntity spawnAtLocation(ServerLevel level, ItemLike item) {
        return this.spawnAtLocation(level, item, 0);
    }

    @Nullable
    public ItemEntity spawnAtLocation(ServerLevel level, ItemLike item, int yOffset) {
        return this.spawnAtLocation(level, new ItemStack(item), (float)yOffset);
    }

    @Nullable
    public ItemEntity spawnAtLocation(ServerLevel level, ItemStack stack) {
        return this.spawnAtLocation(level, stack, 0.0f);
    }

    @Nullable
    public ItemEntity spawnAtLocation(ServerLevel level, ItemStack stack, float yOffset) {
        return this.spawnAtLocation(level, stack, yOffset, null);
    }

    @Nullable
    public ItemEntity spawnAtLocation(ServerLevel level, ItemStack stack, float yOffset, @Nullable Consumer<? super ItemEntity> delayedAddConsumer) {
        if (stack.isEmpty()) {
            return null;
        }
        if (this instanceof LivingEntity && !this.forceDrops) {
            ((LivingEntity)this).drops.add(new DefaultDrop(stack, itemStack -> {
                ItemEntity itemEntity = new ItemEntity(this.level, this.getX(), this.getY() + (double)yOffset, this.getZ(), (ItemStack)itemStack);
                itemEntity.setDefaultPickUpDelay();
                this.level.addFreshEntity(itemEntity);
                if (delayedAddConsumer != null) {
                    delayedAddConsumer.accept(itemEntity);
                }
            }));
            return null;
        }
        ItemEntity itemEntity = new ItemEntity(level, this.getX(), this.getY() + (double)yOffset, this.getZ(), stack.copy());
        stack.setCount(0);
        itemEntity.setDefaultPickUpDelay();
        itemEntity.setDefaultPickUpDelay();
        return this.spawnAtLocation(level, itemEntity);
    }

    @Nullable
    public ItemEntity spawnAtLocation(ServerLevel level, ItemEntity itemEntity) {
        EntityDropItemEvent event = new EntityDropItemEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (Item)itemEntity.getBukkitEntity());
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return null;
        }
        level.addFreshEntity(itemEntity);
        return itemEntity;
    }

    public boolean isAlive() {
        return !this.isRemoved();
    }

    public boolean isInWall() {
        if (this.noPhysics) {
            return false;
        }
        double reducedWith = this.dimensions.width() * 0.8f;
        AABB boundingBox = AABB.ofSize(this.getEyePosition(), reducedWith, 1.0E-6, reducedWith);
        Level world = this.level;
        if (CollisionUtil.isEmpty(boundingBox)) {
            return false;
        }
        int minBlockX = Mth.floor(boundingBox.minX);
        int minBlockY = Mth.floor(boundingBox.minY);
        int minBlockZ = Mth.floor(boundingBox.minZ);
        int maxBlockX = Mth.floor(boundingBox.maxX);
        int maxBlockY = Mth.floor(boundingBox.maxY);
        int maxBlockZ = Mth.floor(boundingBox.maxZ);
        int minChunkX = minBlockX >> 4;
        int minChunkY = minBlockY >> 4;
        int minChunkZ = minBlockZ >> 4;
        int maxChunkX = maxBlockX >> 4;
        int maxChunkY = maxBlockY >> 4;
        int maxChunkZ = maxBlockZ >> 4;
        int minSection = WorldUtil.getMinSection(world);
        ChunkSource chunkSource = world.getChunkSource();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int currChunkZ = minChunkZ; currChunkZ <= maxChunkZ; ++currChunkZ) {
            for (int currChunkX = minChunkX; currChunkX <= maxChunkX; ++currChunkX) {
                LevelChunkSection[] sections = chunkSource.getChunk(currChunkX, currChunkZ, ChunkStatus.FULL, true).getSections();
                for (int currChunkY = minChunkY; currChunkY <= maxChunkY; ++currChunkY) {
                    LevelChunkSection section;
                    int sectionIdx = currChunkY - minSection;
                    if (sectionIdx < 0 || sectionIdx >= sections.length || (section = sections[sectionIdx]).hasOnlyAir()) continue;
                    PalettedContainer<BlockState> blocks = section.states;
                    int minXIterate = currChunkX == minChunkX ? minBlockX & 0xF : 0;
                    int maxXIterate = currChunkX == maxChunkX ? maxBlockX & 0xF : 15;
                    int minZIterate = currChunkZ == minChunkZ ? minBlockZ & 0xF : 0;
                    int maxZIterate = currChunkZ == maxChunkZ ? maxBlockZ & 0xF : 15;
                    int minYIterate = currChunkY == minChunkY ? minBlockY & 0xF : 0;
                    int maxYIterate = currChunkY == maxChunkY ? maxBlockY & 0xF : 15;
                    for (int currY = minYIterate; currY <= maxYIterate; ++currY) {
                        int blockY = currY | currChunkY << 4;
                        mutablePos.setY(blockY);
                        for (int currZ = minZIterate; currZ <= maxZIterate; ++currZ) {
                            int blockZ = currZ | currChunkZ << 4;
                            mutablePos.setZ(blockZ);
                            for (int currX = minXIterate; currX <= maxXIterate; ++currX) {
                                VoxelShape collisionShape;
                                int blockX = currX | currChunkX << 4;
                                mutablePos.setX(blockX);
                                BlockState blockState = blocks.get(currX | currZ << 4 | currY << 8);
                                if (blockState.moonrise$emptyCollisionShape() || !blockState.isSuffocating(world, mutablePos) || (collisionShape = blockState.getCollisionShape(world, mutablePos)).isEmpty()) continue;
                                AABB toCollide = boundingBox.move(-((double)blockX), -((double)blockY), -((double)blockZ));
                                AABB singleAABB = collisionShape.moonrise$getSingleAABBRepresentation();
                                if (!(singleAABB != null ? CollisionUtil.voxelShapeIntersect(singleAABB, toCollide) : CollisionUtil.voxelShapeIntersectNoEmpty(collisionShape, toCollide))) continue;
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        Entity entity;
        if (this.isAlive() && (entity = this) instanceof Leashable) {
            Leashable leashable = (Leashable)((Object)entity);
            if (leashable.getLeashHolder() == player) {
                if (!this.level().isClientSide()) {
                    PlayerUnleashEntityEvent event = CraftEventFactory.callPlayerUnleashEntityEvent(this, player, hand, !player.hasInfiniteMaterials());
                    if (event.isCancelled()) {
                        ((ServerPlayer)player).connection.send(new ClientboundSetEntityLinkPacket(this, leashable.getLeashHolder()));
                        return InteractionResult.PASS;
                    }
                    if (!event.isDropLeash()) {
                        leashable.removeLeash();
                    } else {
                        leashable.dropLeash();
                    }
                    this.gameEvent(GameEvent.ENTITY_INTERACT, player);
                }
                return InteractionResult.SUCCESS.withoutItem();
            }
            ItemStack itemInHand = player.getItemInHand(hand);
            if (itemInHand.is(Items.LEAD) && leashable.canHaveALeashAttachedToIt()) {
                if (!this.level().isClientSide()) {
                    if (CraftEventFactory.callPlayerLeashEntityEvent(this, player, player, hand).isCancelled()) {
                        ((ServerPlayer)player).connection.send(new ClientboundSetEntityLinkPacket(this, leashable.getLeashHolder()));
                        player.containerMenu.sendAllDataToRemote();
                        return InteractionResult.PASS;
                    }
                    leashable.setLeashedTo(player, true);
                }
                itemInHand.shrink(1);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public boolean canCollideWith(Entity entity) {
        return entity.canBeCollidedWith() && !this.isPassengerOfSameVehicle(entity);
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    public void rideTick() {
        this.setDeltaMovement(Vec3.ZERO);
        this.tick();
        if (this.isPassenger()) {
            this.getVehicle().positionRider(this);
        }
    }

    public final void positionRider(Entity passenger) {
        if (this.hasPassenger(passenger)) {
            this.positionRider(passenger, Entity::setPos);
        }
    }

    protected void positionRider(Entity passenger, MoveFunction callback) {
        Vec3 passengerRidingPosition = this.getPassengerRidingPosition(passenger);
        Vec3 vehicleAttachmentPoint = passenger.getVehicleAttachmentPoint(this);
        callback.accept(passenger, passengerRidingPosition.x - vehicleAttachmentPoint.x, passengerRidingPosition.y - vehicleAttachmentPoint.y, passengerRidingPosition.z - vehicleAttachmentPoint.z);
    }

    public void onPassengerTurned(Entity entityToUpdate) {
    }

    public Vec3 getVehicleAttachmentPoint(Entity entity) {
        return this.getAttachments().get(EntityAttachment.VEHICLE, 0, this.yRot);
    }

    public Vec3 getPassengerRidingPosition(Entity entity) {
        return this.position().add(this.getPassengerAttachmentPoint(entity, this.dimensions, 1.0f));
    }

    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions dimensions, float partialTick) {
        return Entity.getDefaultPassengerAttachmentPoint(this, entity, dimensions.attachments());
    }

    protected static Vec3 getDefaultPassengerAttachmentPoint(Entity vehicle, Entity passenger, EntityAttachments attachments) {
        int index = vehicle.getPassengers().indexOf(passenger);
        return attachments.getClamped(EntityAttachment.PASSENGER, index, vehicle.yRot);
    }

    public boolean startRiding(Entity vehicle) {
        return this.startRiding(vehicle, false);
    }

    public boolean showVehicleHealth() {
        return this instanceof LivingEntity;
    }

    public boolean startRiding(Entity vehicle, boolean force) {
        if (vehicle == this.vehicle || vehicle.level != this.level) {
            return false;
        }
        if (!vehicle.couldAcceptPassenger()) {
            return false;
        }
        if (!(force || this.level().isClientSide() || vehicle.type.canSerialize())) {
            return false;
        }
        Entity entity = vehicle;
        while (entity.vehicle != null) {
            if (entity.vehicle == this) {
                return false;
            }
            entity = entity.vehicle;
        }
        if (force || this.canRide(vehicle) && vehicle.canAddPassenger(this)) {
            EntityMountEvent event;
            if (vehicle.getBukkitEntity() instanceof Vehicle && this.getBukkitEntity() instanceof org.bukkit.entity.LivingEntity) {
                event = new VehicleEnterEvent((Vehicle)vehicle.getBukkitEntity(), (org.bukkit.entity.Entity)this.getBukkitEntity());
                if (this.valid) {
                    Bukkit.getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return false;
                }
            }
            event = new EntityMountEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)vehicle.getBukkitEntity());
            if (this.valid) {
                Bukkit.getPluginManager().callEvent((Event)event);
            }
            if (event.isCancelled()) {
                return false;
            }
            if (this.isPassenger()) {
                this.stopRiding();
            }
            this.setPose(Pose.STANDING);
            this.vehicle = vehicle;
            this.vehicle.addPassenger(this);
            vehicle.getIndirectPassengersStream().filter(passenger -> passenger instanceof ServerPlayer).forEach(passenger -> CriteriaTriggers.START_RIDING_TRIGGER.trigger((ServerPlayer)passenger));
            return true;
        }
        return false;
    }

    protected boolean canRide(Entity vehicle) {
        return !this.isShiftKeyDown() && this.boardingCooldown <= 0;
    }

    public void ejectPassengers() {
        for (int i = this.passengers.size() - 1; i >= 0; --i) {
            ((Entity)this.passengers.get(i)).stopRiding();
        }
    }

    public void removeVehicle() {
        this.removeVehicle(false);
    }

    public void removeVehicle(boolean suppressCancellation) {
        if (this.vehicle != null) {
            Entity entity = this.vehicle;
            this.vehicle = null;
            if (!entity.removePassenger(this, suppressCancellation)) {
                this.vehicle = entity;
            }
        }
    }

    public void stopRiding() {
        this.stopRiding(false);
    }

    public void stopRiding(boolean suppressCancellation) {
        this.removeVehicle(suppressCancellation);
    }

    protected void addPassenger(Entity passenger) {
        if (passenger.getVehicle() != this) {
            throw new IllegalStateException("Use x.startRiding(y), not y.addPassenger(x)");
        }
        if (this.passengers.isEmpty()) {
            this.passengers = ImmutableList.of((Object)passenger);
        } else {
            ArrayList list = Lists.newArrayList(this.passengers);
            if (!this.level().isClientSide && passenger instanceof Player && !(this.getFirstPassenger() instanceof Player)) {
                list.add(0, passenger);
            } else {
                list.add(passenger);
            }
            this.passengers = ImmutableList.copyOf((Collection)list);
        }
        this.gameEvent(GameEvent.ENTITY_MOUNT, passenger);
    }

    protected boolean removePassenger(Entity passenger) {
        return this.removePassenger(passenger, false);
    }

    protected boolean removePassenger(Entity passenger, boolean suppressCancellation) {
        EntityDismountEvent event;
        Entity orig;
        if (passenger.getVehicle() == this) {
            throw new IllegalStateException("Use x.stopRiding(y), not y.removePassenger(x)");
        }
        CraftEntity craft = (CraftEntity)passenger.getBukkitEntity().getVehicle();
        Entity entity2 = orig = craft == null ? null : craft.getHandle();
        if (this.getBukkitEntity() instanceof Vehicle && passenger.getBukkitEntity() instanceof org.bukkit.entity.LivingEntity) {
            CraftEntity craftn;
            Entity n;
            event = new VehicleExitEvent((Vehicle)this.getBukkitEntity(), (org.bukkit.entity.LivingEntity)passenger.getBukkitEntity(), !suppressCancellation);
            if (this.valid) {
                Bukkit.getPluginManager().callEvent((Event)event);
            }
            Entity entity3 = n = (craftn = (CraftEntity)passenger.getBukkitEntity().getVehicle()) == null ? null : craftn.getHandle();
            if (event.isCancelled() || n != orig) {
                return false;
            }
        }
        event = new EntityDismountEvent((org.bukkit.entity.Entity)passenger.getBukkitEntity(), (org.bukkit.entity.Entity)this.getBukkitEntity(), !suppressCancellation);
        if (this.valid) {
            Bukkit.getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled()) {
            return false;
        }
        this.passengers = this.passengers.size() == 1 && this.passengers.get(0) == passenger ? ImmutableList.of() : (ImmutableList)this.passengers.stream().filter(entity -> entity != passenger).collect(ImmutableList.toImmutableList());
        passenger.boardingCooldown = 60;
        this.gameEvent(GameEvent.ENTITY_DISMOUNT, passenger);
        return true;
    }

    protected boolean canAddPassenger(Entity passenger) {
        return this.passengers.isEmpty();
    }

    protected boolean couldAcceptPassenger() {
        return true;
    }

    public final boolean isInterpolating() {
        return this.getInterpolation() != null && this.getInterpolation().hasActiveInterpolation();
    }

    public final void moveOrInterpolateTo(Vec3 pos, float yRot, float xRot) {
        InterpolationHandler interpolation = this.getInterpolation();
        if (interpolation != null) {
            interpolation.interpolateTo(pos, yRot, xRot);
        } else {
            this.setPos(pos);
            this.setRot(yRot, xRot);
        }
    }

    @Nullable
    public InterpolationHandler getInterpolation() {
        return null;
    }

    public void lerpHeadTo(float yaw, int pitch) {
        this.setYHeadRot(yaw);
    }

    public float getPickRadius() {
        return 0.0f;
    }

    public Vec3 getLookAngle() {
        return this.calculateViewVector(this.getXRot(), this.getYRot());
    }

    public Vec3 getHandHoldingItemAngle(net.minecraft.world.item.Item item) {
        Entity entity = this;
        if (!(entity instanceof Player)) {
            return Vec3.ZERO;
        }
        Player player = (Player)entity;
        boolean flag = player.getOffhandItem().is(item) && !player.getMainHandItem().is(item);
        HumanoidArm humanoidArm = flag ? player.getMainArm().getOpposite() : player.getMainArm();
        return this.calculateViewVector(0.0f, this.getYRot() + (float)(humanoidArm == HumanoidArm.RIGHT ? 80 : -80)).scale(0.5);
    }

    public Vec2 getRotationVector() {
        return new Vec2(this.getXRot(), this.getYRot());
    }

    public Vec3 getForward() {
        return Vec3.directionFromRotation(this.getRotationVector());
    }

    public void setAsInsidePortal(Portal portal, BlockPos pos) {
        if (this.isOnPortalCooldown()) {
            this.setPortalCooldown();
        } else if (this.portalProcess == null || !this.portalProcess.isSamePortal(portal)) {
            this.portalProcess = new PortalProcessor(portal, pos.immutable());
        } else if (!this.portalProcess.isInsidePortalThisTick()) {
            this.portalProcess.updateEntryPosition(pos.immutable());
            this.portalProcess.setAsInsidePortalThisTick(true);
        }
    }

    protected void handlePortal() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.processPortalCooldown();
            if (this.portalProcess != null) {
                if (this.portalProcess.processPortalTeleportation(serverLevel, this, this.canUsePortal(false))) {
                    ProfilerFiller profilerFiller = Profiler.get();
                    profilerFiller.push("portal");
                    this.setPortalCooldown();
                    TeleportTransition portalDestination = this.portalProcess.getPortalDestination(serverLevel, this);
                    if (portalDestination != null) {
                        ServerLevel level2 = portalDestination.newLevel();
                        if (this instanceof ServerPlayer || level2 != null && (level2.dimension() == serverLevel.dimension() || this.canTeleport(serverLevel, level2))) {
                            this.teleport(portalDestination);
                        }
                    }
                    profilerFiller.pop();
                } else if (this.portalProcess.hasExpired()) {
                    this.portalProcess = null;
                }
            }
        }
    }

    public int getDimensionChangingDelay() {
        Entity firstPassenger = this.getFirstPassenger();
        return firstPassenger instanceof ServerPlayer ? firstPassenger.getDimensionChangingDelay() : 300;
    }

    public void lerpMotion(double x, double y, double z) {
        this.setDeltaMovement(x, y, z);
    }

    public void handleDamageEvent(DamageSource damageSource) {
    }

    public void handleEntityEvent(byte id) {
        switch (id) {
            case 53: {
                HoneyBlock.showSlideParticles(this);
            }
        }
    }

    public void animateHurt(float yaw) {
    }

    public boolean isOnFire() {
        boolean flag = this.level() != null && this.level().isClientSide;
        return !this.fireImmune() && (this.remainingFireTicks > 0 || flag && this.getSharedFlag(0));
    }

    public boolean isPassenger() {
        return this.getVehicle() != null;
    }

    public boolean isVehicle() {
        return !this.passengers.isEmpty();
    }

    public boolean dismountsUnderwater() {
        return this.getType().is(EntityTypeTags.DISMOUNTS_UNDERWATER);
    }

    public boolean canControlVehicle() {
        return !this.getType().is(EntityTypeTags.NON_CONTROLLING_RIDER);
    }

    public void setShiftKeyDown(boolean keyDown) {
        this.setSharedFlag(1, keyDown);
    }

    public boolean isShiftKeyDown() {
        return this.getSharedFlag(1);
    }

    public boolean isSteppingCarefully() {
        return this.isShiftKeyDown();
    }

    public boolean isSuppressingBounce() {
        return this.isShiftKeyDown();
    }

    public boolean isDiscrete() {
        return this.isShiftKeyDown();
    }

    public boolean isDescending() {
        return this.isShiftKeyDown();
    }

    public boolean isCrouching() {
        return this.hasPose(Pose.CROUCHING);
    }

    public boolean isSprinting() {
        return this.getSharedFlag(3);
    }

    public void setSprinting(boolean sprinting) {
        this.setSharedFlag(3, sprinting);
    }

    public boolean isSwimming() {
        return this.getSharedFlag(4);
    }

    public boolean isVisuallySwimming() {
        return this.hasPose(Pose.SWIMMING);
    }

    public boolean isVisuallyCrawling() {
        return this.isVisuallySwimming() && !this.isInWater();
    }

    public void setSwimming(boolean swimming) {
        if (this.valid && this.isSwimming() != swimming && this instanceof LivingEntity && CraftEventFactory.callToggleSwimEvent((LivingEntity)this, swimming).isCancelled()) {
            return;
        }
        this.setSharedFlag(4, swimming);
    }

    public final boolean hasGlowingTag() {
        return this.hasGlowingTag;
    }

    public final void setGlowingTag(boolean hasGlowingTag) {
        this.hasGlowingTag = hasGlowingTag;
        this.setSharedFlag(6, this.isCurrentlyGlowing());
    }

    public boolean isCurrentlyGlowing() {
        return this.level().isClientSide() ? this.getSharedFlag(6) : this.hasGlowingTag;
    }

    public boolean isInvisible() {
        return this.getSharedFlag(5);
    }

    public boolean isInvisibleTo(Player player) {
        if (player.isSpectator()) {
            return false;
        }
        PlayerTeam team = this.getTeam();
        return (team == null || player == null || player.getTeam() != team || !((Team)team).canSeeFriendlyInvisibles()) && this.isInvisible();
    }

    public boolean isOnRails() {
        return false;
    }

    public void updateDynamicGameEventListener(BiConsumer<DynamicGameEventListener<?>, ServerLevel> listenerConsumer) {
    }

    @Nullable
    public PlayerTeam getTeam() {
        if (!this.level().paperConfig().scoreboards.allowNonPlayerEntitiesOnScoreboards && !(this instanceof Player)) {
            return null;
        }
        return this.level().getScoreboard().getPlayersTeam(this.getScoreboardName());
    }

    public final boolean isAlliedTo(@Nullable Entity entity) {
        return entity != null && (this == entity || this.considersEntityAsAlly(entity) || entity.considersEntityAsAlly(this));
    }

    protected boolean considersEntityAsAlly(Entity entity) {
        return this.isAlliedTo(entity.getTeam());
    }

    public boolean isAlliedTo(@Nullable Team team) {
        return this.getTeam() != null && this.getTeam().isAlliedTo(team);
    }

    public void setInvisible(boolean invisible) {
        if (!this.persistentInvisibility) {
            this.setSharedFlag(5, invisible);
        }
    }

    public boolean getSharedFlag(int flag) {
        return (this.entityData.get(DATA_SHARED_FLAGS_ID) & 1 << flag) != 0;
    }

    public void setSharedFlag(int flag, boolean set) {
        byte b = this.entityData.get(DATA_SHARED_FLAGS_ID);
        if (set) {
            this.entityData.set(DATA_SHARED_FLAGS_ID, (byte)(b | 1 << flag));
        } else {
            this.entityData.set(DATA_SHARED_FLAGS_ID, (byte)(b & ~(1 << flag)));
        }
    }

    public int getMaxAirSupply() {
        return this.maxAirTicks;
    }

    public int getAirSupply() {
        return this.entityData.get(DATA_AIR_SUPPLY_ID);
    }

    public void setAirSupply(int air) {
        EntityAirChangeEvent event = new EntityAirChangeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), air);
        if (this.valid) {
            event.getEntity().getServer().getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled() && this.getAirSupply() != air) {
            this.entityData.markDirty(DATA_AIR_SUPPLY_ID);
            return;
        }
        this.entityData.set(DATA_AIR_SUPPLY_ID, event.getAmount());
    }

    public void clearFreeze() {
        if (this.freezeLocked) {
            return;
        }
        this.setTicksFrozen(0);
    }

    public int getTicksFrozen() {
        return this.entityData.get(DATA_TICKS_FROZEN);
    }

    public void setTicksFrozen(int ticksFrozen) {
        this.entityData.set(DATA_TICKS_FROZEN, ticksFrozen);
    }

    public float getPercentFrozen() {
        int ticksRequiredToFreeze = this.getTicksRequiredToFreeze();
        return (float)Math.min(this.getTicksFrozen(), ticksRequiredToFreeze) / (float)ticksRequiredToFreeze;
    }

    public boolean isFullyFrozen() {
        return this.getTicksFrozen() >= this.getTicksRequiredToFreeze();
    }

    public int getTicksRequiredToFreeze() {
        return 140;
    }

    public void thunderHit(ServerLevel level, LightningBolt lightning) {
        this.setRemainingFireTicks(this.remainingFireTicks + 1);
        CraftEntity thisBukkitEntity = this.getBukkitEntity();
        CraftEntity stormBukkitEntity = lightning.getBukkitEntity();
        PluginManager pluginManager = Bukkit.getPluginManager();
        if (this.remainingFireTicks == 0) {
            EntityCombustByEntityEvent entityCombustEvent = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)stormBukkitEntity, (org.bukkit.entity.Entity)thisBukkitEntity, 8.0f);
            pluginManager.callEvent((Event)entityCombustEvent);
            if (!entityCombustEvent.isCancelled()) {
                this.igniteForSeconds(entityCombustEvent.getDuration(), false);
            } else {
                this.setRemainingFireTicks(this.remainingFireTicks - 1);
            }
        }
        if (thisBukkitEntity instanceof Hanging) {
            HangingBreakByEntityEvent hangingEvent = new HangingBreakByEntityEvent((Hanging)thisBukkitEntity, (org.bukkit.entity.Entity)stormBukkitEntity);
            pluginManager.callEvent((Event)hangingEvent);
            if (hangingEvent.isCancelled()) {
                return;
            }
        }
        if (this.fireImmune()) {
            return;
        }
        if (!this.hurtServer(level, this.damageSources().lightningBolt().eventEntityDamager(lightning), 5.0f)) {
            return;
        }
    }

    public void onAboveBubbleColumn(boolean downwards, BlockPos pos) {
        Entity.handleOnAboveBubbleColumn(this, downwards, pos);
    }

    protected static void handleOnAboveBubbleColumn(Entity entity, boolean downwards, BlockPos pos) {
        Vec3 deltaMovement = entity.getDeltaMovement();
        double max = downwards ? Math.max(-0.9, deltaMovement.y - 0.03) : Math.min(1.8, deltaMovement.y + 0.1);
        entity.setDeltaMovement(deltaMovement.x, max, deltaMovement.z);
        Entity.sendBubbleColumnParticles(entity.level, pos);
    }

    protected static void sendBubbleColumnParticles(Level level, BlockPos pos) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (int i = 0; i < 2; ++i) {
                serverLevel.sendParticles(ParticleTypes.SPLASH, (double)pos.getX() + level.random.nextDouble(), pos.getY() + 1, (double)pos.getZ() + level.random.nextDouble(), 1, 0.0, 0.0, 0.0, 1.0);
                serverLevel.sendParticles(ParticleTypes.BUBBLE, (double)pos.getX() + level.random.nextDouble(), pos.getY() + 1, (double)pos.getZ() + level.random.nextDouble(), 1, 0.0, 0.01, 0.0, 0.2);
            }
        }
    }

    public void onInsideBubbleColumn(boolean downwards) {
        Entity.handleOnInsideBubbleColumn(this, downwards);
    }

    protected static void handleOnInsideBubbleColumn(Entity entity, boolean downwards) {
        Vec3 deltaMovement = entity.getDeltaMovement();
        double max = downwards ? Math.max(-0.3, deltaMovement.y - 0.03) : Math.min(0.7, deltaMovement.y + 0.06);
        entity.setDeltaMovement(deltaMovement.x, max, deltaMovement.z);
        entity.resetFallDistance();
    }

    public boolean killedEntity(ServerLevel level, LivingEntity entity) {
        return true;
    }

    public void checkSlowFallDistance() {
        if (this.getDeltaMovement().y() > -0.5 && this.fallDistance > 1.0) {
            this.fallDistance = 1.0;
        }
    }

    public void resetFallDistance() {
        this.fallDistance = 0.0;
    }

    protected void moveTowardsClosestSpace(double x, double y, double z) {
        BlockPos blockPos = BlockPos.containing(x, y, z);
        Vec3 vec3 = new Vec3(x - (double)blockPos.getX(), y - (double)blockPos.getY(), z - (double)blockPos.getZ());
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        Direction direction = Direction.UP;
        double d = Double.MAX_VALUE;
        for (Direction direction1 : new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST, Direction.UP}) {
            double d2;
            mutableBlockPos.setWithOffset((Vec3i)blockPos, direction1);
            if (this.level().getBlockState(mutableBlockPos).isCollisionShapeFullBlock(this.level(), mutableBlockPos)) continue;
            double d1 = vec3.get(direction1.getAxis());
            double d3 = d2 = direction1.getAxisDirection() == Direction.AxisDirection.POSITIVE ? 1.0 - d1 : d1;
            if (!(d2 < d)) continue;
            d = d2;
            direction = direction1;
        }
        float f = this.random.nextFloat() * 0.2f + 0.1f;
        float f1 = direction.getAxisDirection().getStep();
        Vec3 vec31 = this.getDeltaMovement().scale(0.75);
        if (direction.getAxis() == Direction.Axis.X) {
            this.setDeltaMovement(f1 * f, vec31.y, vec31.z);
        } else if (direction.getAxis() == Direction.Axis.Y) {
            this.setDeltaMovement(vec31.x, f1 * f, vec31.z);
        } else if (direction.getAxis() == Direction.Axis.Z) {
            this.setDeltaMovement(vec31.x, vec31.y, f1 * f);
        }
    }

    public void makeStuckInBlock(BlockState state, Vec3 motionMultiplier) {
        this.resetFallDistance();
        this.stuckSpeedMultiplier = motionMultiplier;
    }

    private static Component removeAction(Component name) {
        MutableComponent mutableComponent = name.plainCopy().setStyle(name.getStyle().withClickEvent(null));
        for (Component component : name.getSiblings()) {
            mutableComponent.append(Entity.removeAction(component));
        }
        return mutableComponent;
    }

    @Override
    public Component getName() {
        Component customName = this.getCustomName();
        return customName != null ? Entity.removeAction(customName) : this.getTypeName();
    }

    protected Component getTypeName() {
        return this.type.getDescription();
    }

    public boolean is(Entity entity) {
        return this == entity;
    }

    public float getYHeadRot() {
        return 0.0f;
    }

    public void setYHeadRot(float yHeadRot) {
    }

    public void setYBodyRot(float yBodyRot) {
    }

    public boolean isAttackable() {
        return true;
    }

    public boolean skipAttackInteraction(Entity entity) {
        return false;
    }

    public String toString() {
        String string = this.level() == null ? "~NULL~" : this.level().toString();
        return this.removalReason != null ? String.format(Locale.ROOT, "%s['%s'/%d, uuid='%s', l='%s', x=%.2f, y=%.2f, z=%.2f, cpos=%s, tl=%d, v=%b, removed=%s]", new Object[]{this.getClass().getSimpleName(), this.getName().getString(), this.id, this.uuid, string, this.getX(), this.getY(), this.getZ(), this.chunkPosition(), this.tickCount, this.valid, this.removalReason}) : String.format(Locale.ROOT, "%s['%s'/%d, uuid='%s', l='%s', x=%.2f, y=%.2f, z=%.2f, cpos=%s, tl=%d, v=%b]", this.getClass().getSimpleName(), this.getName().getString(), this.id, this.uuid, string, this.getX(), this.getY(), this.getZ(), this.chunkPosition(), this.tickCount, this.valid);
    }

    public final boolean isInvulnerableToBase(DamageSource damageSource) {
        return this.isRemoved() || this.invulnerable && !damageSource.is(DamageTypeTags.BYPASSES_INVULNERABILITY) && !damageSource.isCreativePlayer() || damageSource.is(DamageTypeTags.IS_FIRE) && this.fireImmune() || damageSource.is(DamageTypeTags.IS_FALL) && this.getType().is(EntityTypeTags.FALL_DAMAGE_IMMUNE);
    }

    public boolean isInvulnerable() {
        return this.invulnerable;
    }

    public void setInvulnerable(boolean isInvulnerable) {
        this.invulnerable = isInvulnerable;
    }

    public void copyPosition(Entity entity) {
        this.snapTo(entity.getX(), entity.getY(), entity.getZ(), entity.getYRot(), entity.getXRot());
    }

    public void restoreFrom(Entity entity) {
        CraftEntity bukkitEntity = entity.bukkitEntity;
        if (bukkitEntity != null) {
            bukkitEntity.setHandle(this);
            this.bukkitEntity = bukkitEntity;
        }
        CompoundTag compoundTag = entity.saveWithoutId(new CompoundTag());
        compoundTag.remove("Dimension");
        this.load(compoundTag);
        this.portalCooldown = entity.portalCooldown;
        this.portalProcess = entity.portalProcess;
    }

    @Nullable
    public Entity teleport(TeleportTransition teleportTransition) {
        if (!(this.isAlive() && this.valid || teleportTransition.newLevel() == this.level)) {
            LOGGER.warn("Illegal Entity Teleport {} to {}:{}", new Object[]{this, teleportTransition.newLevel(), teleportTransition.position(), new Throwable()});
            return null;
        }
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!this.isRemoved()) {
                boolean flag;
                EntityTeleportEvent teleEvent;
                BlockEntity blockEntity;
                PositionMoveRotation absolutePosition = PositionMoveRotation.calculateAbsolute(PositionMoveRotation.of(this), PositionMoveRotation.of(teleportTransition), teleportTransition.relatives());
                Vec3 velocity = absolutePosition.deltaMovement();
                Location to = CraftLocation.toBukkit(absolutePosition.position(), (World)teleportTransition.newLevel().getWorld(), absolutePosition.yRot(), absolutePosition.xRot());
                if (this.portalProcess != null && this.portalProcess.isSamePortal((EndGatewayBlock)Blocks.END_GATEWAY) && (blockEntity = this.level.getBlockEntity(this.portalProcess.getEntryPosition())) instanceof TheEndGatewayBlockEntity) {
                    TheEndGatewayBlockEntity theEndGatewayBlockEntity = (TheEndGatewayBlockEntity)blockEntity;
                    teleEvent = new EntityTeleportEndGatewayEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), this.getBukkitEntity().getLocation(), to, (EndGateway)new CraftEndGateway(to.getWorld(), theEndGatewayBlockEntity));
                    teleEvent.callEvent();
                } else {
                    teleEvent = CraftEventFactory.callEntityTeleportEvent(this, to);
                }
                if (teleEvent.isCancelled() || teleEvent.getTo() == null) {
                    return null;
                }
                if (!to.equals((Object)teleEvent.getTo())) {
                    to = teleEvent.getTo();
                    teleportTransition = new TeleportTransition(((CraftWorld)to.getWorld()).getHandle(), CraftLocation.toVec3(to), Vec3.ZERO, to.getYaw(), to.getPitch(), teleportTransition.missingRespawnBlock(), teleportTransition.asPassenger(), Set.of(), teleportTransition.postTeleportTransition(), teleportTransition.cause());
                    velocity = Vec3.ZERO;
                }
                if (this.portalProcess != null) {
                    CraftEntity bukkitEntity = this.getBukkitEntity();
                    EntityPortalExitEvent event = new EntityPortalExitEvent((org.bukkit.entity.Entity)bukkitEntity, bukkitEntity.getLocation(), to.clone(), bukkitEntity.getVelocity(), CraftVector.toBukkit(velocity));
                    event.callEvent();
                    if (!(event.isCancelled() || event.getTo() == null || event.getTo().equals((Object)event.getFrom()) && event.getAfter().equals((Object)event.getBefore()))) {
                        to = event.getTo().clone();
                        velocity = CraftVector.toVec3(event.getAfter());
                        teleportTransition = new TeleportTransition(((CraftWorld)to.getWorld()).getHandle(), CraftLocation.toVec3(to), velocity, to.getYaw(), to.getPitch(), teleportTransition.missingRespawnBlock(), teleportTransition.asPassenger(), Set.of(), teleportTransition.postTeleportTransition(), teleportTransition.cause());
                    }
                }
                if (this.isRemoved()) {
                    return null;
                }
                ServerLevel level2 = teleportTransition.newLevel();
                boolean bl = flag = level2.dimension() != serverLevel.dimension();
                if (!teleportTransition.asPassenger()) {
                    this.stopRiding();
                }
                return flag ? this.teleportCrossDimension(level2, teleportTransition) : this.teleportSameDimension(serverLevel, teleportTransition);
            }
        }
        return null;
    }

    private Entity teleportSameDimension(ServerLevel level, TeleportTransition teleportTransition) {
        for (Entity entity : this.getPassengers()) {
            entity.teleport(this.calculatePassengerTransition(teleportTransition, entity));
        }
        ProfilerFiller profilerFiller = Profiler.get();
        profilerFiller.push("teleportSameDimension");
        this.teleportSetPosition(PositionMoveRotation.of(teleportTransition), teleportTransition.relatives());
        if (!teleportTransition.asPassenger()) {
            this.sendTeleportTransitionToRidingPlayers(teleportTransition);
        }
        teleportTransition.postTeleportTransition().onTransition(this);
        profilerFiller.pop();
        return this;
    }

    private Entity teleportCrossDimension(ServerLevel level, TeleportTransition teleportTransition) {
        List<Entity> passengers = this.getPassengers();
        ArrayList<Entity> list = new ArrayList<Entity>(passengers.size());
        this.ejectPassengers();
        for (Entity entity : passengers) {
            Entity entity1 = entity.teleport(this.calculatePassengerTransition(teleportTransition, entity));
            if (entity1 == null) continue;
            list.add(entity1);
        }
        ProfilerFiller profilerFiller = Profiler.get();
        profilerFiller.push("teleportCrossDimension");
        Object entityx = this.getType().create(level, EntitySpawnReason.DIMENSION_TRAVEL);
        if (entityx == null) {
            profilerFiller.pop();
            return null;
        }
        Entity entity = this;
        if (entity instanceof Leashable) {
            Leashable leashable = (Leashable)((Object)entity);
            leashable.dropLeash();
        }
        ((Entity)entityx).restoreFrom(this);
        this.removeAfterChangingDimensions();
        ((Entity)entityx).teleportSetPosition(PositionMoveRotation.of(teleportTransition), teleportTransition.relatives());
        if (this.inWorld) {
            level.addDuringTeleport((Entity)entityx);
        }
        for (Entity entity2 : list) {
            entity2.startRiding((Entity)entityx, true);
        }
        level.resetEmptyTime();
        teleportTransition.postTeleportTransition().onTransition((Entity)entityx);
        profilerFiller.pop();
        return entityx;
    }

    private TeleportTransition calculatePassengerTransition(TeleportTransition teleportTransition, Entity entity) {
        float f = teleportTransition.yRot() + (teleportTransition.relatives().contains((Object)Relative.Y_ROT) ? 0.0f : entity.getYRot() - this.getYRot());
        float f1 = teleportTransition.xRot() + (teleportTransition.relatives().contains((Object)Relative.X_ROT) ? 0.0f : entity.getXRot() - this.getXRot());
        Vec3 vec3 = entity.position().subtract(this.position());
        Vec3 vec31 = teleportTransition.position().add(teleportTransition.relatives().contains((Object)Relative.X) ? 0.0 : vec3.x(), teleportTransition.relatives().contains((Object)Relative.Y) ? 0.0 : vec3.y(), teleportTransition.relatives().contains((Object)Relative.Z) ? 0.0 : vec3.z());
        return teleportTransition.withPosition(vec31).withRotation(f, f1).transitionAsPassenger();
    }

    private void sendTeleportTransitionToRidingPlayers(TeleportTransition teleportTransition) {
        LivingEntity controllingPassenger = this.getControllingPassenger();
        for (Entity entity : this.getIndirectPassengers()) {
            if (!(entity instanceof ServerPlayer)) continue;
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (controllingPassenger != null && serverPlayer.getId() == controllingPassenger.getId()) {
                serverPlayer.connection.send(ClientboundTeleportEntityPacket.teleport(this.getId(), PositionMoveRotation.of(teleportTransition), teleportTransition.relatives(), this.onGround));
                continue;
            }
            serverPlayer.connection.send(ClientboundTeleportEntityPacket.teleport(this.getId(), PositionMoveRotation.of(this), Set.of(), this.onGround));
        }
    }

    public void teleportSetPosition(PositionMoveRotation positionMovementRotation, Set<Relative> relatives) {
        PositionMoveRotation positionMoveRotation = PositionMoveRotation.of(this);
        PositionMoveRotation positionMoveRotation1 = PositionMoveRotation.calculateAbsolute(positionMoveRotation, positionMovementRotation, relatives);
        this.setPosRaw(positionMoveRotation1.position().x, positionMoveRotation1.position().y, positionMoveRotation1.position().z);
        this.setYRot(positionMoveRotation1.yRot());
        this.setYHeadRot(positionMoveRotation1.yRot());
        this.setXRot(positionMoveRotation1.xRot());
        this.reapplyPosition();
        this.setOldPosAndRot();
        this.setDeltaMovement(positionMoveRotation1.deltaMovement());
        this.movementThisTick.clear();
    }

    public void forceSetRotation(float yRot, float xRot) {
        this.setYRot(yRot);
        this.setYHeadRot(yRot);
        this.setXRot(xRot);
        this.setOldRot();
    }

    public void placePortalTicket(BlockPos pos) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.getChunkSource().addTicketWithRadius(TicketType.PORTAL, new ChunkPos(pos), 3);
        }
    }

    protected void removeAfterChangingDimensions() {
        Leashable leashable;
        this.setRemoved(RemovalReason.CHANGED_DIMENSION, null);
        Entity entity = this;
        if (entity instanceof Leashable && (leashable = (Leashable)((Object)entity)).isLeashed()) {
            EntityUnleashEvent event = new EntityUnleashEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), EntityUnleashEvent.UnleashReason.UNKNOWN, false);
            event.callEvent();
            if (!event.isDropLeash()) {
                leashable.removeLeash();
            } else {
                leashable.dropLeash();
            }
        }
    }

    public Vec3 getRelativePortalPosition(Direction.Axis axis, BlockUtil.FoundRectangle portal) {
        return PortalShape.getRelativePosition(portal, axis, this.position(), this.getDimensions(this.getPose()));
    }

    @Nullable
    public CraftPortalEvent callPortalEvent(Entity entity, Location exit, PlayerTeleportEvent.TeleportCause cause, int searchRadius, int creationRadius) {
        CraftEntity bukkitEntity = entity.getBukkitEntity();
        Location enter = bukkitEntity.getLocation();
        PortalType portalType = switch (cause) {
            case PlayerTeleportEvent.TeleportCause.END_PORTAL -> PortalType.ENDER;
            case PlayerTeleportEvent.TeleportCause.NETHER_PORTAL -> PortalType.NETHER;
            case PlayerTeleportEvent.TeleportCause.END_GATEWAY -> PortalType.END_GATEWAY;
            default -> PortalType.CUSTOM;
        };
        EntityPortalEvent event = new EntityPortalEvent((org.bukkit.entity.Entity)bukkitEntity, enter, exit, searchRadius, true, creationRadius, portalType);
        event.callEvent();
        if (event.isCancelled() || event.getTo() == null || event.getTo().getWorld() == null || !entity.isAlive()) {
            return null;
        }
        return new CraftPortalEvent(event);
    }

    public boolean canUsePortal(boolean allowPassengers) {
        return (allowPassengers || !this.isPassenger()) && this.isAlive();
    }

    public boolean canTeleport(Level fromLevel, Level toLevel) {
        if (!this.isAlive() || !this.valid) {
            return false;
        }
        if (fromLevel.dimension() == Level.END && toLevel.dimension() == Level.OVERWORLD) {
            for (Entity entity : this.getPassengers()) {
                if (!(entity instanceof ServerPlayer)) continue;
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                if (serverPlayer.seenCredits) continue;
                return false;
            }
        }
        return true;
    }

    public float getBlockExplosionResistance(Explosion explosion, BlockGetter level, BlockPos pos, BlockState blockState, FluidState fluidState, float explosionPower) {
        return explosionPower;
    }

    public boolean shouldBlockExplode(Explosion explosion, BlockGetter level, BlockPos pos, BlockState blockState, float explosionPower) {
        return true;
    }

    public int getMaxFallDistance() {
        return 3;
    }

    public boolean isIgnoringBlockTriggers() {
        return false;
    }

    public void fillCrashReportCategory(CrashReportCategory category) {
        category.setDetail("Entity Type", () -> String.valueOf(EntityType.getKey(this.getType())) + " (" + this.getClass().getCanonicalName() + ")");
        category.setDetail("Entity ID", this.id);
        category.setDetail("Entity Name", () -> this.getName().getString());
        category.setDetail("Entity's Exact location", String.format(Locale.ROOT, "%.2f, %.2f, %.2f", this.getX(), this.getY(), this.getZ()));
        category.setDetail("Entity's Block location", CrashReportCategory.formatLocation((LevelHeightAccessor)this.level(), Mth.floor(this.getX()), Mth.floor(this.getY()), Mth.floor(this.getZ())));
        Vec3 deltaMovement = this.getDeltaMovement();
        category.setDetail("Entity's Momentum", String.format(Locale.ROOT, "%.2f, %.2f, %.2f", deltaMovement.x, deltaMovement.y, deltaMovement.z));
        category.setDetail("Entity's Passengers", () -> this.getPassengers().toString());
        category.setDetail("Entity's Vehicle", () -> String.valueOf(this.getVehicle()));
    }

    public boolean displayFireAnimation() {
        return this.isOnFire() && !this.isSpectator();
    }

    public void setUUID(UUID uniqueId) {
        this.uuid = uniqueId;
        this.stringUUID = this.uuid.toString();
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    public String getStringUUID() {
        return this.stringUUID;
    }

    @Override
    public String getScoreboardName() {
        return this.stringUUID;
    }

    public boolean isPushedByFluid() {
        return true;
    }

    public static double getViewScale() {
        return viewScale;
    }

    public static void setViewScale(double renderDistWeight) {
        viewScale = renderDistWeight;
    }

    @Override
    public Component getDisplayName() {
        return PlayerTeam.formatNameForTeam(this.getTeam(), this.getName()).withStyle(style -> style.withHoverEvent(this.createHoverEvent()).withInsertion(this.getStringUUID()));
    }

    public void setCustomName(@Nullable Component name) {
        this.entityData.set(DATA_CUSTOM_NAME, Optional.ofNullable(name));
    }

    @Override
    @Nullable
    public Component getCustomName() {
        return this.entityData.get(DATA_CUSTOM_NAME).orElse(null);
    }

    @Override
    public boolean hasCustomName() {
        return this.entityData.get(DATA_CUSTOM_NAME).isPresent();
    }

    public void setCustomNameVisible(boolean alwaysRenderNameTag) {
        this.entityData.set(DATA_CUSTOM_NAME_VISIBLE, alwaysRenderNameTag);
    }

    public boolean isCustomNameVisible() {
        return this.entityData.get(DATA_CUSTOM_NAME_VISIBLE);
    }

    public final boolean teleportTo(ServerLevel level, double x, double y, double z, Set<Relative> relativeMovements, float yaw, float pitch, boolean setCamera) {
        return this.teleportTo(level, x, y, z, relativeMovements, yaw, pitch, setCamera, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public boolean teleportTo(ServerLevel level, double x, double y, double z, Set<Relative> relativeMovements, float yaw, float pitch, boolean setCamera, PlayerTeleportEvent.TeleportCause cause) {
        Entity entity = this.teleport(new TeleportTransition(level, new Vec3(x, y, z), Vec3.ZERO, yaw, pitch, relativeMovements, TeleportTransition.DO_NOTHING, cause));
        return entity != null;
    }

    public void dismountTo(double x, double y, double z) {
        this.teleportTo(x, y, z);
    }

    public void teleportTo(double x, double y, double z) {
        if (this.level() instanceof ServerLevel) {
            this.snapTo(x, y, z, this.getYRot(), this.getXRot());
            this.teleportPassengers();
        }
    }

    public void teleportPassengers() {
        this.getSelfAndPassengers().forEach(entity -> {
            for (Entity entity1 : entity.passengers) {
                entity.positionRider(entity1, Entity::snapTo);
            }
        });
    }

    public void teleportRelative(double dx, double dy, double dz) {
        this.teleportTo(this.getX() + dx, this.getY() + dy, this.getZ() + dz);
    }

    public boolean shouldShowName() {
        return this.isCustomNameVisible();
    }

    @Override
    public void onSyncedDataUpdated(List<SynchedEntityData.DataValue<?>> dataValues) {
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        if (DATA_POSE.equals(key)) {
            this.refreshDimensions();
        }
    }

    @Deprecated
    protected void fixupDimensions() {
        EntityDimensions dimensions;
        Pose pose = this.getPose();
        this.dimensions = dimensions = this.getDimensions(pose);
        this.eyeHeight = dimensions.eyeHeight();
    }

    public void refreshDimensions() {
        boolean flag;
        EntityDimensions dimensions;
        EntityDimensions entityDimensions = this.dimensions;
        Pose pose = this.getPose();
        this.dimensions = dimensions = this.getDimensions(pose);
        this.eyeHeight = dimensions.eyeHeight();
        this.reapplyPosition();
        boolean bl = flag = dimensions.width() <= 4.0f && dimensions.height() <= 4.0f;
        if (!(this.level.isClientSide || this.firstTick || this.noPhysics || !flag || !(dimensions.width() > entityDimensions.width()) && !(dimensions.height() > entityDimensions.height()) || this instanceof Player)) {
            this.fudgePositionAfterSizeChange(entityDimensions);
        }
    }

    public boolean fudgePositionAfterSizeChange(EntityDimensions dimensions) {
        VoxelShape voxelShape1;
        Optional<Vec3> optional1;
        double d1;
        double d;
        EntityDimensions dimensions1 = this.getDimensions(this.getPose());
        Vec3 vec3 = this.position().add(0.0, (double)dimensions.height() / 2.0, 0.0);
        VoxelShape voxelShape = Shapes.create(AABB.ofSize(vec3, d = (double)Math.max(0.0f, dimensions1.width() - dimensions.width()) + 1.0E-6, d1 = (double)Math.max(0.0f, dimensions1.height() - dimensions.height()) + 1.0E-6, d));
        Optional<Vec3> optional = this.level.findFreePosition(this, voxelShape, vec3, dimensions1.width(), dimensions1.height(), dimensions1.width());
        if (optional.isPresent()) {
            this.setPos(optional.get().add(0.0, (double)(-dimensions1.height()) / 2.0, 0.0));
            return true;
        }
        if (dimensions1.width() > dimensions.width() && dimensions1.height() > dimensions.height() && (optional1 = this.level.findFreePosition(this, voxelShape1 = Shapes.create(AABB.ofSize(vec3, d, 1.0E-6, d)), vec3, dimensions1.width(), dimensions.height(), dimensions1.width())).isPresent()) {
            this.setPos(optional1.get().add(0.0, (double)(-dimensions.height()) / 2.0 + 1.0E-6, 0.0));
            return true;
        }
        return false;
    }

    public Direction getDirection() {
        return Direction.fromYRot(this.getYRot());
    }

    public Direction getMotionDirection() {
        return this.getDirection();
    }

    protected HoverEvent createHoverEvent() {
        return new HoverEvent.ShowEntity(new HoverEvent.EntityTooltipInfo(this.getType(), this.getUUID(), this.getName()));
    }

    public boolean broadcastToPlayer(ServerPlayer player) {
        return true;
    }

    @Override
    public final AABB getBoundingBox() {
        return this.bb;
    }

    public final void setBoundingBox(AABB bb) {
        double minX = bb.minX;
        double minY = bb.minY;
        double minZ = bb.minZ;
        double maxX = bb.maxX;
        double maxY = bb.maxY;
        double maxZ = bb.maxZ;
        double len = bb.maxX - bb.minX;
        if (len < 0.0) {
            maxX = minX;
        }
        if (len > 64.0) {
            maxX = minX + 64.0;
        }
        if ((len = bb.maxY - bb.minY) < 0.0) {
            maxY = minY;
        }
        if (len > 64.0) {
            maxY = minY + 64.0;
        }
        if ((len = bb.maxZ - bb.minZ) < 0.0) {
            maxZ = minZ;
        }
        if (len > 64.0) {
            maxZ = minZ + 64.0;
        }
        this.bb = new AABB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public final float getEyeHeight(Pose pose) {
        return this.getDimensions(pose).eyeHeight();
    }

    public final float getEyeHeight() {
        return this.eyeHeight;
    }

    public Vec3 getLeashOffset(float partialTick) {
        return this.getLeashOffset();
    }

    protected Vec3 getLeashOffset() {
        return new Vec3(0.0, this.getEyeHeight(), this.getBbWidth() * 0.4f);
    }

    public SlotAccess getSlot(int slot) {
        return SlotAccess.NULL;
    }

    public Level getCommandSenderWorld() {
        return this.level();
    }

    @Nullable
    public MinecraftServer getServer() {
        return this.level().getServer();
    }

    public InteractionResult interactAt(Player player, Vec3 vec, InteractionHand hand) {
        return InteractionResult.PASS;
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return false;
    }

    public void startSeenByPlayer(ServerPlayer serverPlayer) {
    }

    public void stopSeenByPlayer(ServerPlayer serverPlayer) {
        if (PlayerUntrackEntityEvent.getHandlerList().getRegisteredListeners().length > 0) {
            new PlayerUntrackEntityEvent((org.bukkit.entity.Player)serverPlayer.getBukkitEntity(), (org.bukkit.entity.Entity)this.getBukkitEntity()).callEvent();
        }
    }

    public float rotate(Rotation transformRotation) {
        float f = Mth.wrapDegrees(this.getYRot());
        switch (transformRotation) {
            case CLOCKWISE_180: {
                return f + 180.0f;
            }
            case COUNTERCLOCKWISE_90: {
                return f + 270.0f;
            }
            case CLOCKWISE_90: {
                return f + 90.0f;
            }
        }
        return f;
    }

    public float mirror(Mirror transformMirror) {
        float f = Mth.wrapDegrees(this.getYRot());
        switch (transformMirror) {
            case FRONT_BACK: {
                return -f;
            }
            case LEFT_RIGHT: {
                return 180.0f - f;
            }
        }
        return f;
    }

    public ProjectileDeflection deflection(Projectile projectile) {
        return this.getType().is(EntityTypeTags.DEFLECTS_PROJECTILES) ? ProjectileDeflection.REVERSE : ProjectileDeflection.NONE;
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        return null;
    }

    public final boolean hasControllingPassenger() {
        return this.getControllingPassenger() != null;
    }

    public final List<Entity> getPassengers() {
        return this.passengers;
    }

    @Nullable
    public Entity getFirstPassenger() {
        return this.passengers.isEmpty() ? null : (Entity)this.passengers.get(0);
    }

    public boolean hasPassenger(Entity entity) {
        return this.passengers.contains((Object)entity);
    }

    public boolean hasPassenger(Predicate<Entity> predicate) {
        for (Entity entity : this.passengers) {
            if (!predicate.test(entity)) continue;
            return true;
        }
        return false;
    }

    private Stream<Entity> getIndirectPassengersStream() {
        if (this.passengers.isEmpty()) {
            return Stream.of(new Entity[0]);
        }
        return this.passengers.stream().flatMap(Entity::getSelfAndPassengers);
    }

    public Stream<Entity> getSelfAndPassengers() {
        if (this.passengers.isEmpty()) {
            return Stream.of(this);
        }
        return Stream.concat(Stream.of(this), this.getIndirectPassengersStream());
    }

    public Stream<Entity> getPassengersAndSelf() {
        if (this.passengers.isEmpty()) {
            return Stream.of(this);
        }
        return Stream.concat(this.passengers.stream().flatMap(Entity::getPassengersAndSelf), Stream.of(this));
    }

    public Iterable<Entity> getIndirectPassengers() {
        ArrayList<Entity> ret = new ArrayList<Entity>();
        if (this.passengers.isEmpty()) {
            return ret;
        }
        Entity.collectIndirectPassengers(ret, this.passengers);
        return ret;
    }

    public int countPlayerPassengers() {
        return (int)this.getIndirectPassengersStream().filter(passenger -> passenger instanceof Player).count();
    }

    public boolean hasExactlyOnePlayerPassenger() {
        if (this.passengers.isEmpty()) {
            return false;
        }
        return this.countPlayerPassengers() == 1;
    }

    public Entity getRootVehicle() {
        Entity entity = this;
        while (entity.isPassenger()) {
            entity = entity.getVehicle();
        }
        return entity;
    }

    public boolean isPassengerOfSameVehicle(Entity entity) {
        return this.getRootVehicle() == entity.getRootVehicle();
    }

    public boolean hasIndirectPassenger(Entity entity) {
        if (!entity.isPassenger()) {
            return false;
        }
        Entity vehicle = entity.getVehicle();
        return vehicle == this || this.hasIndirectPassenger(vehicle);
    }

    public final boolean isLocalInstanceAuthoritative() {
        return this.level.isClientSide() ? this.isLocalClientAuthoritative() : !this.isClientAuthoritative();
    }

    protected boolean isLocalClientAuthoritative() {
        LivingEntity controllingPassenger = this.getControllingPassenger();
        return controllingPassenger != null && controllingPassenger.isLocalClientAuthoritative();
    }

    public boolean isClientAuthoritative() {
        LivingEntity controllingPassenger = this.getControllingPassenger();
        return controllingPassenger != null && controllingPassenger.isClientAuthoritative();
    }

    public boolean canSimulateMovement() {
        return this.isLocalInstanceAuthoritative();
    }

    public boolean isEffectiveAi() {
        return this.isLocalInstanceAuthoritative();
    }

    protected static Vec3 getCollisionHorizontalEscapeVector(double vehicleWidth, double passengerWidth, float yRot) {
        double d = (vehicleWidth + passengerWidth + (double)1.0E-5f) / 2.0;
        float f = -Mth.sin(yRot * ((float)Math.PI / 180));
        float cos = Mth.cos(yRot * ((float)Math.PI / 180));
        float max = Math.max(Math.abs(f), Math.abs(cos));
        return new Vec3((double)f * d / (double)max, 0.0, (double)cos * d / (double)max);
    }

    public Vec3 getDismountLocationForPassenger(LivingEntity passenger) {
        return new Vec3(this.getX(), this.getBoundingBox().maxY, this.getZ());
    }

    @Nullable
    public Entity getVehicle() {
        return this.vehicle;
    }

    @Nullable
    public Entity getControlledVehicle() {
        return this.vehicle != null && this.vehicle.getControllingPassenger() == this ? this.vehicle : null;
    }

    public PushReaction getPistonPushReaction() {
        return PushReaction.NORMAL;
    }

    public SoundSource getSoundSource() {
        return SoundSource.NEUTRAL;
    }

    public int getFireImmuneTicks() {
        return 1;
    }

    public CommandSourceStack createCommandSourceStackForNameResolution(ServerLevel level) {
        return new CommandSourceStack(this.commandSource, this.position(), this.getRotationVector(), level, 0, this.getName().getString(), this.getDisplayName(), level.getServer(), this);
    }

    public void lookAt(EntityAnchorArgument.Anchor anchor, Vec3 target) {
        Vec3 vec3 = anchor.apply(this);
        double d = target.x - vec3.x;
        double d1 = target.y - vec3.y;
        double d2 = target.z - vec3.z;
        double squareRoot = Math.sqrt(d * d + d2 * d2);
        this.setXRot(Mth.wrapDegrees((float)(-(Mth.atan2(d1, squareRoot) * 180.0 / 3.1415927410125732))));
        this.setYRot(Mth.wrapDegrees((float)(Mth.atan2(d2, d) * 180.0 / 3.1415927410125732) - 90.0f));
        this.setYHeadRot(this.getYRot());
        this.xRotO = this.getXRot();
        this.yRotO = this.getYRot();
    }

    public float getPreciseBodyRotation(float partialTick) {
        return Mth.lerp(partialTick, this.yRotO, this.yRot);
    }

    public boolean updateFluidHeightAndDoFluidPushing(TagKey<Fluid> fluid, double flowScale) {
        if (this.touchingUnloadedChunk()) {
            return false;
        }
        AABB boundingBox = this.getBoundingBox().deflate(0.001);
        Level world = this.level;
        int minSection = WorldUtil.getMinSection(world);
        int minBlockX = Mth.floor(boundingBox.minX);
        int minBlockY = Math.max(minSection << 4, Mth.floor(boundingBox.minY));
        int minBlockZ = Mth.floor(boundingBox.minZ);
        int maxBlockX = Mth.ceil(boundingBox.maxX) - 1;
        int maxBlockY = Math.min(WorldUtil.getMaxSection(world) << 4 | 0xF, Mth.ceil(boundingBox.maxY) - 1);
        int maxBlockZ = Mth.ceil(boundingBox.maxZ) - 1;
        boolean isPushable = this.isPushedByFluid();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        Vec3 pushVector = Vec3.ZERO;
        double totalPushes = 0.0;
        double maxHeightDiff = 0.0;
        boolean inFluid = false;
        int minChunkX = minBlockX >> 4;
        int maxChunkX = maxBlockX >> 4;
        int minChunkY = minBlockY >> 4;
        int maxChunkY = maxBlockY >> 4;
        int minChunkZ = minBlockZ >> 4;
        int maxChunkZ = maxBlockZ >> 4;
        ChunkSource chunkSource = world.getChunkSource();
        for (int currChunkZ = minChunkZ; currChunkZ <= maxChunkZ; ++currChunkZ) {
            for (int currChunkX = minChunkX; currChunkX <= maxChunkX; ++currChunkX) {
                LevelChunkSection[] sections = chunkSource.getChunk(currChunkX, currChunkZ, ChunkStatus.FULL, false).getSections();
                for (int currChunkY = minChunkY; currChunkY <= maxChunkY; ++currChunkY) {
                    LevelChunkSection section;
                    int sectionIdx = currChunkY - minSection;
                    if (sectionIdx < 0 || sectionIdx >= sections.length || (section = sections[sectionIdx]).hasOnlyAir()) continue;
                    PalettedContainer<BlockState> blocks = section.states;
                    int minXIterate = currChunkX == minChunkX ? minBlockX & 0xF : 0;
                    int maxXIterate = currChunkX == maxChunkX ? maxBlockX & 0xF : 15;
                    int minZIterate = currChunkZ == minChunkZ ? minBlockZ & 0xF : 0;
                    int maxZIterate = currChunkZ == maxChunkZ ? maxBlockZ & 0xF : 15;
                    int minYIterate = currChunkY == minChunkY ? minBlockY & 0xF : 0;
                    int maxYIterate = currChunkY == maxChunkY ? maxBlockY & 0xF : 15;
                    for (int currY = minYIterate; currY <= maxYIterate; ++currY) {
                        for (int currZ = minZIterate; currZ <= maxZIterate; ++currZ) {
                            for (int currX = minXIterate; currX <= maxXIterate; ++currX) {
                                FluidState fluidState = blocks.get(currX | currZ << 4 | currY << 8).getFluidState();
                                if (fluidState.isEmpty() || !fluidState.is(fluid)) continue;
                                mutablePos.set(currX | currChunkX << 4, currY | currChunkY << 4, currZ | currChunkZ << 4);
                                double height = (float)mutablePos.getY() + fluidState.getHeight(world, mutablePos);
                                double diff = height - boundingBox.minY;
                                if (diff < 0.0) continue;
                                inFluid = true;
                                maxHeightDiff = Math.max(maxHeightDiff, diff);
                                if (!isPushable) continue;
                                totalPushes += 1.0;
                                Vec3 flow = fluidState.getFlow(world, mutablePos);
                                pushVector = diff < 0.4 ? pushVector.add(flow.scale(diff)) : pushVector.add(flow);
                            }
                        }
                    }
                }
            }
        }
        this.fluidHeight.put(fluid, maxHeightDiff);
        if (pushVector.lengthSqr() == 0.0) {
            return inFluid;
        }
        pushVector = pushVector.scale(1.0 / totalPushes);
        Vec3 currMovement = this.getDeltaMovement();
        if (!(this instanceof Player)) {
            pushVector = pushVector.normalize();
        }
        pushVector = pushVector.scale(flowScale);
        if (Math.abs(currMovement.x) < 0.003 && Math.abs(currMovement.z) < 0.003 && pushVector.length() < 0.0045000000000000005) {
            pushVector = pushVector.normalize().scale(0.0045000000000000005);
        }
        this.setDeltaMovement(currMovement.add(pushVector));
        return true;
    }

    public boolean touchingUnloadedChunk() {
        AABB aabb = this.getBoundingBox().inflate(1.0);
        int floor = Mth.floor(aabb.minX);
        int ceil = Mth.ceil(aabb.maxX);
        int floor1 = Mth.floor(aabb.minZ);
        int ceil1 = Mth.ceil(aabb.maxZ);
        return !this.level().hasChunksAt(floor, floor1, ceil, ceil1);
    }

    public double getFluidHeight(TagKey<Fluid> fluidTag) {
        return this.fluidHeight.getDouble(fluidTag);
    }

    public double getFluidJumpThreshold() {
        return (double)this.getEyeHeight() < 0.4 ? 0.0 : 0.4;
    }

    public final float getBbWidth() {
        return this.dimensions.width();
    }

    public final float getBbHeight() {
        return this.dimensions.height();
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity entity) {
        return new ClientboundAddEntityPacket(this, entity);
    }

    public EntityDimensions getDimensions(Pose pose) {
        return this.type.getDimensions();
    }

    public final EntityAttachments getAttachments() {
        return this.dimensions.attachments();
    }

    public Vec3 position() {
        return this.position;
    }

    public Vec3 trackingPosition() {
        return this.position();
    }

    @Override
    public BlockPos blockPosition() {
        return this.blockPosition;
    }

    public BlockState getInBlockState() {
        if (this.inBlockState == null) {
            this.inBlockState = this.level().getBlockState(this.blockPosition());
        }
        return this.inBlockState;
    }

    public ChunkPos chunkPosition() {
        return this.chunkPosition;
    }

    public Vec3 getDeltaMovement() {
        return this.deltaMovement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDeltaMovement(Vec3 deltaMovement) {
        Object object = this.posLock;
        synchronized (object) {
            this.deltaMovement = deltaMovement;
        }
    }

    public void addDeltaMovement(Vec3 addend) {
        this.setDeltaMovement(this.getDeltaMovement().add(addend));
    }

    public void setDeltaMovement(double x, double y, double z) {
        this.setDeltaMovement(new Vec3(x, y, z));
    }

    public final int getBlockX() {
        return this.blockPosition.getX();
    }

    public final double getX() {
        return this.position.x;
    }

    public double getX(double scale) {
        return this.position.x + (double)this.getBbWidth() * scale;
    }

    public double getRandomX(double scale) {
        return this.getX((2.0 * this.random.nextDouble() - 1.0) * scale);
    }

    public final int getBlockY() {
        return this.blockPosition.getY();
    }

    public final double getY() {
        return this.position.y;
    }

    public double getY(double scale) {
        return this.position.y + (double)this.getBbHeight() * scale;
    }

    public double getRandomY() {
        return this.getY(this.random.nextDouble());
    }

    public double getEyeY() {
        return this.position.y + (double)this.eyeHeight;
    }

    public final int getBlockZ() {
        return this.blockPosition.getZ();
    }

    public final double getZ() {
        return this.position.z;
    }

    public double getZ(double scale) {
        return this.position.z + (double)this.getBbWidth() * scale;
    }

    public double getRandomZ(double scale) {
        return this.getZ((2.0 * this.random.nextDouble() - 1.0) * scale);
    }

    public static boolean checkPosition(Entity entity, double newX, double newY, double newZ) {
        String entityInfo;
        if (Double.isFinite(newX) && Double.isFinite(newY) && Double.isFinite(newZ)) {
            return true;
        }
        try {
            entityInfo = entity.toString();
        }
        catch (Exception ex) {
            entityInfo = "[Entity info unavailable] ";
        }
        LOGGER.error("New entity position is invalid! Tried to set invalid position ({},{},{}) for entity {} located at {}, entity info: {}", new Object[]{newX, newY, newZ, entity.getClass().getName(), entity.position(), entityInfo, new Throwable()});
        return false;
    }

    public final void setPosRaw(double x, double y, double z) {
        this.setPosRaw(x, y, z, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setPosRaw(double x, double y, double z, boolean forceBoundingBoxUpdate) {
        if (this.updatingSectionStatus) {
            LOGGER.error("Refusing to update position for entity " + String.valueOf(this) + " to position " + String.valueOf(new Vec3(x, y, z)) + " since it is processing a section status update", new Throwable());
            return;
        }
        if (!Entity.checkPosition(this, x, y, z)) {
            return;
        }
        if (this instanceof ItemEntity && GlobalConfiguration.get().misc.fixEntityPositionDesync) {
            x = (double)Mth.lfloor(x * 4096.0) * 2.44140625E-4;
            y = (double)Mth.lfloor(y * 4096.0) * 2.44140625E-4;
            z = (double)Mth.lfloor(z * 4096.0) * 2.44140625E-4;
        }
        if (this.position.x != x || this.position.y != y || this.position.z != z) {
            Object object = this.posLock;
            synchronized (object) {
                this.position = new Vec3(x, y, z);
            }
            int floor = Mth.floor(x);
            int floor1 = Mth.floor(y);
            int floor2 = Mth.floor(z);
            if (floor != this.blockPosition.getX() || floor1 != this.blockPosition.getY() || floor2 != this.blockPosition.getZ()) {
                this.blockPosition = new BlockPos(floor, floor1, floor2);
                this.inBlockState = null;
                if (SectionPos.blockToSectionCoord(floor) != this.chunkPosition.x || SectionPos.blockToSectionCoord(floor2) != this.chunkPosition.z) {
                    this.chunkPosition = new ChunkPos(this.blockPosition);
                }
            }
            this.levelCallback.onMove();
        }
        if (!(this instanceof HangingEntity) && (forceBoundingBoxUpdate || this.position.x != x || this.position.y != y || this.position.z != z)) {
            this.setBoundingBox(this.makeBoundingBox());
        }
    }

    public void checkDespawn() {
    }

    public Vec3 getRopeHoldPosition(float partialTicks) {
        return this.getPosition(partialTicks).add(0.0, (double)this.eyeHeight * 0.7, 0.0);
    }

    public void recreateFromPacket(ClientboundAddEntityPacket packet) {
        int id = packet.getId();
        double x = packet.getX();
        double y = packet.getY();
        double z = packet.getZ();
        this.syncPacketPositionCodec(x, y, z);
        this.snapTo(x, y, z, packet.getYRot(), packet.getXRot());
        this.setId(id);
        this.setUUID(packet.getUUID());
        Vec3 vec3 = new Vec3(packet.getXa(), packet.getYa(), packet.getZa());
        this.setDeltaMovement(vec3);
    }

    @Nullable
    public ItemStack getPickResult() {
        return null;
    }

    public void setIsInPowderSnow(boolean isInPowderSnow) {
        this.isInPowderSnow = isInPowderSnow;
    }

    public boolean canFreeze() {
        return !this.getType().is(EntityTypeTags.FREEZE_IMMUNE_ENTITY_TYPES);
    }

    public boolean isFreezing() {
        return this.getTicksFrozen() > 0;
    }

    public float getBukkitYaw() {
        return this.yRot;
    }

    public float getYRot() {
        return this.yRot;
    }

    public float getVisualRotationYInDegrees() {
        return this.getYRot();
    }

    public void setYRot(float yRot) {
        if (!Float.isFinite(yRot)) {
            Util.logAndPauseIfInIde("Invalid entity rotation: " + yRot + ", discarding.");
        } else {
            this.yRot = yRot;
        }
    }

    public float getXRot() {
        return this.xRot;
    }

    public void setXRot(float xRot) {
        if (!Float.isFinite(xRot)) {
            Util.logAndPauseIfInIde("Invalid entity rotation: " + xRot + ", discarding.");
        } else {
            this.xRot = Math.clamp(xRot % 360.0f, -90.0f, 90.0f);
        }
    }

    public boolean canSprint() {
        return false;
    }

    public float maxUpStep() {
        return 0.0f;
    }

    public void onExplosionHit(@Nullable Entity entity) {
    }

    @Override
    public final boolean isRemoved() {
        return this.removalReason != null;
    }

    @Nullable
    public RemovalReason getRemovalReason() {
        return this.removalReason;
    }

    @Override
    public final void setRemoved(RemovalReason removalReason, @Nullable EntityRemoveEvent.Cause cause) {
        boolean alreadyRemoved;
        if (!this.level.moonrise$getEntityLookup().canRemoveEntity(this)) {
            LOGGER.warn("Entity " + String.valueOf(this) + " is currently prevented from being removed from the world since it is processing section status updates", new Throwable());
            return;
        }
        CraftEventFactory.callEntityRemoveEvent(this, cause);
        boolean bl = alreadyRemoved = this.removalReason != null;
        if (this.removalReason == null) {
            this.removalReason = removalReason;
        }
        if (this.removalReason.shouldDestroy()) {
            this.stopRiding();
        }
        if (this.removalReason != RemovalReason.UNLOADED_TO_CHUNK) {
            this.getPassengers().forEach(Entity::stopRiding);
        }
        this.levelCallback.onRemove(removalReason);
        this.onRemoval(removalReason);
        if (!(this instanceof ServerPlayer) && removalReason != RemovalReason.CHANGED_DIMENSION && !alreadyRemoved) {
            this.retireScheduler();
        }
    }

    public void unsetRemoved() {
        this.removalReason = null;
    }

    public final void retireScheduler() {
        this.getBukkitEntity().taskScheduler.retire();
    }

    @Override
    public void setLevelCallback(EntityInLevelCallback levelCallback) {
        this.levelCallback = levelCallback;
    }

    @Override
    public boolean shouldBeSaved() {
        return !(this.removalReason != null && !this.removalReason.shouldSave() || this.isPassenger() || this.isVehicle() && this.moonrise$hasAnyPlayerPassengers());
    }

    @Override
    public boolean isAlwaysTicking() {
        return false;
    }

    public boolean mayInteract(ServerLevel level, BlockPos pos) {
        return true;
    }

    public Level level() {
        return this.level;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public DamageSources damageSources() {
        return this.level().damageSources();
    }

    public RegistryAccess registryAccess() {
        return this.level().registryAccess();
    }

    protected void lerpPositionAndRotationStep(int steps, double targetX, double targetY, double targetZ, double targetYRot, double targetXRot) {
        double d = 1.0 / (double)steps;
        double d1 = Mth.lerp(d, this.getX(), targetX);
        double d2 = Mth.lerp(d, this.getY(), targetY);
        double d3 = Mth.lerp(d, this.getZ(), targetZ);
        float f = (float)Mth.rotLerp(d, (double)this.getYRot(), targetYRot);
        float f1 = (float)Mth.lerp(d, (double)this.getXRot(), targetXRot);
        this.setPos(d1, d2, d3);
        this.setRot(f, f1);
    }

    public RandomSource getRandom() {
        return this.random;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Vec3 getKnownMovement() {
        Vec3 vec3;
        LivingEntity livingEntity = this.getControllingPassenger();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (this.isAlive()) {
                vec3 = player.getKnownMovement();
                return vec3;
            }
        }
        vec3 = this.getDeltaMovement();
        return vec3;
    }

    @Nullable
    public ItemStack getWeaponItem() {
        return null;
    }

    public Optional<ResourceKey<LootTable>> getLootTable() {
        return this.type.getDefaultLootTable();
    }

    protected void applyImplicitComponents(DataComponentGetter componentGetter) {
        this.applyImplicitComponentIfPresent(componentGetter, DataComponents.CUSTOM_NAME);
        this.applyImplicitComponentIfPresent(componentGetter, DataComponents.CUSTOM_DATA);
    }

    public final void applyComponentsFromItemStack(ItemStack stack) {
        this.applyImplicitComponents(stack.getComponents());
    }

    @Override
    @Nullable
    public <T> T get(DataComponentType<? extends T> component) {
        if (component == DataComponents.CUSTOM_NAME) {
            return Entity.castComponentValue(component, this.getCustomName());
        }
        return component == DataComponents.CUSTOM_DATA ? (T)Entity.castComponentValue(component, this.customData) : null;
    }

    @Nullable
    @Contract(value="_,!null->!null;_,_->_")
    protected static <T> T castComponentValue(DataComponentType<T> componentType, @Nullable Object value) {
        return (T)value;
    }

    public <T> void setComponent(DataComponentType<T> component, T value) {
        this.applyImplicitComponent(component, value);
    }

    protected <T> boolean applyImplicitComponent(DataComponentType<T> component, T value) {
        if (component == DataComponents.CUSTOM_NAME) {
            this.setCustomName(Entity.castComponentValue(DataComponents.CUSTOM_NAME, value));
            return true;
        }
        if (component == DataComponents.CUSTOM_DATA) {
            this.customData = Entity.castComponentValue(DataComponents.CUSTOM_DATA, value);
            return true;
        }
        return false;
    }

    protected <T> boolean applyImplicitComponentIfPresent(DataComponentGetter componentGetter, DataComponentType<T> component) {
        T object = componentGetter.get(component);
        return object != null && this.applyImplicitComponent(component, object);
    }

    public static int nextEntityId() {
        return ENTITY_COUNTER.incrementAndGet();
    }

    public boolean isTicking() {
        return ((ServerLevel)this.level()).isPositionEntityTicking(this.blockPosition());
    }

    public static enum RemovalReason {
        KILLED(true, false),
        DISCARDED(true, false),
        UNLOADED_TO_CHUNK(false, true),
        UNLOADED_WITH_PLAYER(false, false),
        CHANGED_DIMENSION(false, false);

        private final boolean destroy;
        private final boolean save;

        private RemovalReason(boolean destroy, boolean save) {
            this.destroy = destroy;
            this.save = save;
        }

        public boolean shouldDestroy() {
            return this.destroy;
        }

        public boolean shouldSave() {
            return this.save;
        }
    }

    record Movement(Vec3 from, Vec3 to) {
    }

    public static enum MovementEmission {
        NONE(false, false),
        SOUNDS(true, false),
        EVENTS(false, true),
        ALL(true, true);

        final boolean sounds;
        final boolean events;

        private MovementEmission(boolean sounds, boolean events) {
            this.sounds = sounds;
            this.events = events;
        }

        public boolean emitsAnything() {
            return this.events || this.sounds;
        }

        public boolean emitsEvents() {
            return this.events;
        }

        public boolean emitsSounds() {
            return this.sounds;
        }
    }

    public record DefaultDrop(net.minecraft.world.item.Item item, org.bukkit.inventory.ItemStack stack, @Nullable Consumer<ItemStack> dropConsumer) {
        public DefaultDrop(ItemStack stack, Consumer<ItemStack> dropConsumer) {
            this(stack.getItem(), CraftItemStack.asCraftMirror(stack), dropConsumer);
        }

        public void runConsumer(Consumer<org.bukkit.inventory.ItemStack> fallback) {
            if (this.dropConsumer == null || CraftItemType.bukkitToMinecraft(this.stack.getType()) != this.item) {
                fallback.accept(this.stack);
            } else {
                this.dropConsumer.accept(CraftItemStack.asNMSCopy(this.stack));
            }
        }
    }

    @FunctionalInterface
    public static interface MoveFunction {
        public void accept(Entity var1, double var2, double var4, double var6);
    }

    private static final class RandomRandomSource
    extends ThreadUnsafeRandom {
        private boolean locked = false;

        public RandomRandomSource() {
            this(RandomSupport.generateUniqueSeed());
        }

        public RandomRandomSource(long seed) {
            super(seed);
        }

        @Override
        public synchronized void setSeed(long seed) {
            if (this.locked) {
                LOGGER.error("Ignoring setSeed on Entity.SHARED_RANDOM", new Throwable());
            } else {
                super.setSeed(seed);
                this.locked = true;
            }
        }
    }
}

