/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.mojang.serialization.Codec;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class EntityEquipment {
    public static final Codec<EntityEquipment> CODEC = Codec.unboundedMap(EquipmentSlot.CODEC, ItemStack.CODEC).xmap(map -> {
        EnumMap<EquipmentSlot, ItemStack> map1 = new EnumMap<EquipmentSlot, ItemStack>(EquipmentSlot.class);
        map1.putAll((Map<EquipmentSlot, ItemStack>)map);
        return new EntityEquipment(map1);
    }, entityEquipment -> {
        EnumMap<EquipmentSlot, ItemStack> map = new EnumMap<EquipmentSlot, ItemStack>(entityEquipment.items);
        map.values().removeIf(ItemStack::isEmpty);
        return map;
    });
    private final EnumMap<EquipmentSlot, ItemStack> items;

    private EntityEquipment(EnumMap<EquipmentSlot, ItemStack> items) {
        this.items = items;
    }

    public EntityEquipment() {
        this(new EnumMap<EquipmentSlot, ItemStack>(EquipmentSlot.class));
    }

    public ItemStack set(EquipmentSlot slot, ItemStack stack) {
        stack.getItem().verifyComponentsAfterLoad(stack);
        return Objects.requireNonNullElse(this.items.put(slot, stack), ItemStack.EMPTY);
    }

    public ItemStack get(EquipmentSlot slot) {
        return this.items.getOrDefault(slot, ItemStack.EMPTY);
    }

    public boolean isEmpty() {
        for (ItemStack itemStack : this.items.values()) {
            if (itemStack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void tick(Entity entity) {
        for (Map.Entry<EquipmentSlot, ItemStack> entry : this.items.entrySet()) {
            ItemStack itemStack = entry.getValue();
            if (itemStack.isEmpty()) continue;
            itemStack.inventoryTick(entity.level(), entity, entry.getKey());
        }
    }

    public void setAll(EntityEquipment equipment) {
        this.items.clear();
        this.items.putAll(equipment.items);
    }

    public void dropAll(LivingEntity entity) {
        for (ItemStack itemStack : this.items.values()) {
            entity.drop(itemStack, true, false);
        }
        this.clear();
    }

    public void clear() {
        this.items.replaceAll((equipmentSlot, itemStack) -> ItemStack.EMPTY);
    }

    public boolean has(EquipmentSlot slot) {
        return this.items.containsKey(slot);
    }
}

