/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.UUIDLookup;
import net.minecraft.world.level.entity.UniquelyIdentifyable;

public class EntityReference<StoredEntityType extends UniquelyIdentifyable> {
    private static final Codec<? extends EntityReference<?>> CODEC = UUIDUtil.CODEC.xmap(EntityReference::new, EntityReference::getUUID);
    private static final StreamCodec<ByteBuf, ? extends EntityReference<?>> STREAM_CODEC = UUIDUtil.STREAM_CODEC.map(EntityReference::new, EntityReference::getUUID);
    private Either<UUID, StoredEntityType> entity;

    public static <Type extends UniquelyIdentifyable> Codec<EntityReference<Type>> codec() {
        return CODEC;
    }

    public static <Type extends UniquelyIdentifyable> StreamCodec<ByteBuf, EntityReference<Type>> streamCodec() {
        return STREAM_CODEC;
    }

    public EntityReference(StoredEntityType entity) {
        this.entity = Either.right(entity);
    }

    public EntityReference(UUID uuid) {
        this.entity = Either.left(uuid);
    }

    public UUID getUUID() {
        return this.entity.map(uuid -> uuid, UniquelyIdentifyable::getUUID);
    }

    @Nullable
    public StoredEntityType getEntity(UUIDLookup<? super StoredEntityType> uuidLookup, Class<StoredEntityType> entityClass) {
        StoredEntityType uniquelyIdentifyable1;
        Optional<UUID> optional1;
        Optional<StoredEntityType> optional = this.entity.right();
        if (optional.isPresent()) {
            UniquelyIdentifyable uniquelyIdentifyable = (UniquelyIdentifyable)optional.get();
            if (!uniquelyIdentifyable.isRemoved()) {
                return (StoredEntityType)uniquelyIdentifyable;
            }
            this.entity = Either.left(uniquelyIdentifyable.getUUID());
        }
        if ((optional1 = this.entity.left()).isPresent() && (uniquelyIdentifyable1 = this.resolve((UniquelyIdentifyable)uuidLookup.getEntity(optional1.get()), entityClass)) != null && !uniquelyIdentifyable1.isRemoved()) {
            this.entity = Either.right(uniquelyIdentifyable1);
            return uniquelyIdentifyable1;
        }
        return null;
    }

    @Nullable
    private StoredEntityType resolve(@Nullable UniquelyIdentifyable entity, Class<StoredEntityType> entityClass) {
        return (StoredEntityType)(entity != null && entityClass.isAssignableFrom(entity.getClass()) ? (UniquelyIdentifyable)entityClass.cast(entity) : null);
    }

    public boolean matches(StoredEntityType entity) {
        return this.getUUID().equals(entity.getUUID());
    }

    public void store(CompoundTag tag, String key) {
        tag.store(key, UUIDUtil.CODEC, this.getUUID());
    }

    @Nullable
    public static <StoredEntityType extends UniquelyIdentifyable> StoredEntityType get(@Nullable EntityReference<StoredEntityType> reference, UUIDLookup<? super StoredEntityType> uuidLookup, Class<StoredEntityType> entityClass) {
        return reference != null ? (StoredEntityType)reference.getEntity(uuidLookup, entityClass) : null;
    }

    @Nullable
    public static <StoredEntityType extends UniquelyIdentifyable> EntityReference<StoredEntityType> read(CompoundTag tag, String key) {
        return tag.read(key, EntityReference.codec()).orElse(null);
    }

    @Nullable
    public static <StoredEntityType extends UniquelyIdentifyable> EntityReference<StoredEntityType> readWithOldOwnerConversion(CompoundTag tag, String key, Level level) {
        Optional<UUID> optional = tag.read(key, UUIDUtil.CODEC);
        return optional.isPresent() ? new EntityReference(optional.get()) : (EntityReference)tag.getString(key).map(string -> OldUsersConverter.convertMobOwnerIfNecessary(level.getServer(), string)).map(EntityReference::new).orElse(null);
    }
}

