/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.destroystokyo.paper.event.entity.ExperienceOrbMergeEvent;
import com.destroystokyo.paper.event.player.PlayerPickupExperienceEvent;
import io.papermc.paper.annotation.DoNotUse;
import io.papermc.paper.configuration.GlobalConfiguration;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.InterpolationHandler;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.player.PlayerExpCooldownChangeEvent;
import org.bukkit.event.player.PlayerItemMendEvent;

public class ExperienceOrb
extends Entity {
    protected static final EntityDataAccessor<Integer> DATA_VALUE = SynchedEntityData.defineId(ExperienceOrb.class, EntityDataSerializers.INT);
    private static final int LIFETIME = 6000;
    private static final int ENTITY_SCAN_PERIOD = 20;
    private static final int MAX_FOLLOW_DIST = 8;
    private static final int ORB_GROUPS_PER_AREA = 40;
    private static final double ORB_MERGE_DISTANCE = 0.5;
    private static final short DEFAULT_HEALTH = 5;
    private static final short DEFAULT_AGE = 0;
    private static final short DEFAULT_VALUE = 0;
    private static final int DEFAULT_COUNT = 1;
    private int age = 0;
    private int health = 5;
    public int count = 1;
    @Nullable
    private Player followingPlayer;
    private final InterpolationHandler interpolation = new InterpolationHandler(this);
    @Nullable
    public UUID sourceEntityId;
    @Nullable
    public UUID triggerEntityId;
    public ExperienceOrb.SpawnReason spawnReason = ExperienceOrb.SpawnReason.UNKNOWN;

    private void loadPaperNBT(CompoundTag tag) {
        CompoundTag expData = tag.getCompoundOrEmpty("Paper.ExpData");
        if (expData.isEmpty()) {
            return;
        }
        this.sourceEntityId = expData.read("source", UUIDUtil.CODEC).orElse(null);
        this.triggerEntityId = expData.read("trigger", UUIDUtil.CODEC).orElse(null);
        expData.getString("reason").ifPresent(reason -> {
            try {
                this.spawnReason = ExperienceOrb.SpawnReason.valueOf((String)reason);
            }
            catch (Exception e) {
                this.level().getCraftServer().getLogger().warning("Invalid spawnReason set for experience orb: " + e.getMessage() + " - " + reason);
            }
        });
    }

    private void savePaperNBT(CompoundTag tag) {
        CompoundTag expData = new CompoundTag();
        expData.storeNullable("source", UUIDUtil.CODEC, this.sourceEntityId);
        expData.storeNullable("trigger", UUIDUtil.CODEC, this.triggerEntityId);
        if (this.spawnReason != ExperienceOrb.SpawnReason.UNKNOWN) {
            expData.putString("reason", this.spawnReason.name());
        }
        tag.put("Paper.ExpData", expData);
    }

    @Deprecated
    @DoNotUse
    public ExperienceOrb(Level level, double x, double y, double z, int value) {
        this(level, x, y, z, value, null, null);
    }

    public ExperienceOrb(Level level, double x, double y, double z, int value, @Nullable ExperienceOrb.SpawnReason reason, @Nullable Entity triggerId) {
        this(level, x, y, z, value, reason, triggerId, null);
    }

    public ExperienceOrb(Level level, double x, double y, double z, int value, @Nullable ExperienceOrb.SpawnReason reason, @Nullable Entity triggerId, @Nullable Entity sourceId) {
        this((EntityType<? extends ExperienceOrb>)EntityType.EXPERIENCE_ORB, level);
        this.sourceEntityId = sourceId != null ? sourceId.getUUID() : null;
        this.triggerEntityId = triggerId != null ? triggerId.getUUID() : null;
        this.spawnReason = reason != null ? reason : ExperienceOrb.SpawnReason.UNKNOWN;
        this.setPos(x, y, z);
        if (!this.level().isClientSide) {
            this.setYRot((float)(this.random.nextDouble() * 360.0));
            this.setDeltaMovement((this.random.nextDouble() * (double)0.2f - (double)0.1f) * 2.0, this.random.nextDouble() * 0.2 * 2.0, (this.random.nextDouble() * (double)0.2f - (double)0.1f) * 2.0);
        }
        this.setValue(value);
    }

    public ExperienceOrb(EntityType<? extends ExperienceOrb> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_VALUE, 0);
    }

    @Override
    protected double getDefaultGravity() {
        return 0.03;
    }

    @Override
    public void tick() {
        this.interpolation.interpolate();
        if (this.firstTick && this.level().isClientSide) {
            this.firstTick = false;
        } else {
            boolean flag;
            super.tick();
            boolean bl = flag = !this.level().noCollision(this.getBoundingBox());
            if (this.isEyeInFluid(FluidTags.WATER)) {
                this.setUnderwaterMovement();
            } else if (!flag) {
                this.applyGravity();
            }
            if (this.level().getFluidState(this.blockPosition()).is(FluidTags.LAVA)) {
                this.setDeltaMovement((this.random.nextFloat() - this.random.nextFloat()) * 0.2f, 0.2f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f);
            }
            if (this.tickCount % 20 == 1) {
                this.scanForMerges();
            }
            this.followNearbyPlayer();
            if (this.followingPlayer == null && !this.level().isClientSide && flag) {
                this.moveTowardsClosestSpace(this.getX(), (this.getBoundingBox().minY + this.getBoundingBox().maxY) / 2.0, this.getZ());
                this.hasImpulse = true;
            }
            double d = this.getDeltaMovement().y;
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.applyEffectsFromBlocks();
            float f = 0.98f;
            if (this.onGround()) {
                f = this.level().getBlockState(this.getBlockPosBelowThatAffectsMyMovement()).getBlock().getFriction() * 0.98f;
            }
            this.setDeltaMovement(this.getDeltaMovement().scale(f));
            if (this.verticalCollisionBelow && d < -this.getGravity()) {
                this.setDeltaMovement(new Vec3(this.getDeltaMovement().x, -d * 0.4, this.getDeltaMovement().z));
            }
            ++this.age;
            if (this.age >= 6000) {
                this.discard(EntityRemoveEvent.Cause.DESPAWN);
            }
        }
    }

    private void followNearbyPlayer() {
        Player prevTarget = this.followingPlayer;
        if (this.followingPlayer == null || this.followingPlayer.isSpectator() || this.followingPlayer.distanceToSqr(this) > 64.0) {
            Player nearestPlayer = this.level().getNearestPlayer(this, 8.0);
            this.followingPlayer = nearestPlayer != null && !nearestPlayer.isSpectator() && !nearestPlayer.isDeadOrDying() ? nearestPlayer : null;
        }
        boolean cancelled = false;
        if (this.followingPlayer != prevTarget) {
            EntityTargetLivingEntityEvent event = CraftEventFactory.callEntityTargetLivingEvent(this, this.followingPlayer, this.followingPlayer != null ? EntityTargetEvent.TargetReason.CLOSEST_PLAYER : EntityTargetEvent.TargetReason.FORGOT_TARGET);
            LivingEntity target = event.getTarget() == null ? null : ((CraftLivingEntity)event.getTarget()).getHandle();
            cancelled = event.isCancelled();
            if (cancelled) {
                this.followingPlayer = prevTarget;
            } else {
                Player player = this.followingPlayer = target instanceof Player ? (Player)target : null;
            }
        }
        if (this.followingPlayer != null && !cancelled) {
            Vec3 vec3 = new Vec3(this.followingPlayer.getX() - this.getX(), this.followingPlayer.getY() + (double)this.followingPlayer.getEyeHeight() / 2.0 - this.getY(), this.followingPlayer.getZ() - this.getZ());
            double d = vec3.lengthSqr();
            double d1 = 1.0 - Math.sqrt(d) / 8.0;
            this.setDeltaMovement(this.getDeltaMovement().add(vec3.normalize().scale(d1 * d1 * 0.1)));
        }
    }

    @Override
    public BlockPos getBlockPosBelowThatAffectsMyMovement() {
        return this.getOnPos(0.999999f);
    }

    private void scanForMerges() {
        if (this.level() instanceof ServerLevel) {
            for (ExperienceOrb experienceOrb : this.level().getEntities(EntityTypeTest.forClass(ExperienceOrb.class), this.getBoundingBox().inflate(0.5), this::canMerge)) {
                this.merge(experienceOrb);
            }
        }
    }

    public static void award(ServerLevel level, Vec3 pos, int amount) {
        ExperienceOrb.award(level, pos, amount, null, null, null);
    }

    public static void award(ServerLevel level, Vec3 pos, int amount, @Nullable ExperienceOrb.SpawnReason reason, @Nullable Entity triggerId) {
        ExperienceOrb.award(level, pos, amount, reason, triggerId, null);
    }

    public static void award(ServerLevel level, Vec3 pos, int amount, @Nullable ExperienceOrb.SpawnReason reason, @Nullable Entity triggerId, @Nullable Entity sourceId) {
        while (amount > 0) {
            int experienceValue = ExperienceOrb.getExperienceValue(amount);
            amount -= experienceValue;
            if (ExperienceOrb.tryMergeToExisting(level, pos, experienceValue)) continue;
            level.addFreshEntity(new ExperienceOrb(level, pos.x(), pos.y(), pos.z(), experienceValue, reason, triggerId, sourceId));
        }
    }

    private static boolean tryMergeToExisting(ServerLevel level, Vec3 pos, int amount) {
        AABB aabb = AABB.ofSize(pos, 1.0, 1.0, 1.0);
        int randomInt = level.getRandom().nextInt(GlobalConfiguration.get().misc.xpOrbGroupsPerArea.or(40));
        List<ExperienceOrb> entities = level.getEntities(EntityTypeTest.forClass(ExperienceOrb.class), aabb, orb -> ExperienceOrb.canMerge(orb, randomInt, amount));
        if (!entities.isEmpty()) {
            ExperienceOrb experienceOrb = entities.get(0);
            ++experienceOrb.count;
            experienceOrb.age = 0;
            return true;
        }
        return false;
    }

    private boolean canMerge(ExperienceOrb orb) {
        return orb != this && ExperienceOrb.canMerge(orb, this.getId(), this.getValue());
    }

    private static boolean canMerge(ExperienceOrb orb, int amount, int other) {
        return !orb.isRemoved() && (orb.getId() - amount) % GlobalConfiguration.get().misc.xpOrbGroupsPerArea.or(40) == 0 && orb.getValue() == other;
    }

    private void merge(ExperienceOrb orb) {
        if (!new ExperienceOrbMergeEvent((org.bukkit.entity.ExperienceOrb)this.getBukkitEntity(), (org.bukkit.entity.ExperienceOrb)orb.getBukkitEntity()).callEvent()) {
            return;
        }
        this.count += orb.count;
        this.age = Math.min(this.age, orb.age);
        orb.discard(EntityRemoveEvent.Cause.MERGE);
    }

    private void setUnderwaterMovement() {
        Vec3 deltaMovement = this.getDeltaMovement();
        this.setDeltaMovement(deltaMovement.x * (double)0.99f, Math.min(deltaMovement.y + (double)5.0E-4f, (double)0.06f), deltaMovement.z * (double)0.99f);
    }

    @Override
    protected void doWaterSplashEffect() {
    }

    @Override
    public final boolean hurtClient(DamageSource damageSource) {
        return !this.isInvulnerableToBase(damageSource);
    }

    @Override
    public final boolean hurtServer(ServerLevel level, DamageSource damageSource, float amount) {
        if (this.isInvulnerableToBase(damageSource)) {
            return false;
        }
        this.markHurt();
        this.health = (int)((float)this.health - amount);
        if (this.health <= 0) {
            this.discard(EntityRemoveEvent.Cause.DEATH);
        }
        return true;
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        compound.putShort("Health", (short)this.health);
        compound.putShort("Age", (short)this.age);
        compound.putInt("Value", this.getValue());
        compound.putInt("Count", this.count);
        this.savePaperNBT(compound);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        this.health = compound.getShortOr("Health", (short)5);
        this.age = compound.getShortOr("Age", (short)0);
        this.setValue(compound.getIntOr("Value", 0));
        this.count = compound.read("Count", ExtraCodecs.POSITIVE_INT).orElse(1);
        this.loadPaperNBT(compound);
    }

    @Override
    public void playerTouch(Player entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (entity.takeXpDelay == 0 && new PlayerPickupExperienceEvent((org.bukkit.entity.Player)serverPlayer.getBukkitEntity(), (org.bukkit.entity.ExperienceOrb)this.getBukkitEntity()).callEvent()) {
                entity.takeXpDelay = CraftEventFactory.callPlayerXpCooldownEvent(entity, 2, PlayerExpCooldownChangeEvent.ChangeReason.PICKUP_ORB).getNewCooldown();
                entity.take(this, 1);
                int i = this.repairPlayerItems(serverPlayer, this.getValue());
                if (i > 0) {
                    entity.giveExperiencePoints(CraftEventFactory.callPlayerExpChangeEvent(entity, this).getAmount());
                }
                --this.count;
                if (this.count == 0) {
                    this.discard(EntityRemoveEvent.Cause.PICKUP);
                }
            }
        }
    }

    private int repairPlayerItems(ServerPlayer player, int value) {
        Optional<EnchantedItemInUse> randomItemWith = EnchantmentHelper.getRandomItemWith(EnchantmentEffectComponents.REPAIR_WITH_XP, player, ItemStack::isDamaged);
        if (randomItemWith.isPresent()) {
            int i1;
            ItemStack itemStack = randomItemWith.get().itemStack();
            int i = EnchantmentHelper.modifyDurabilityToRepairFromXp(player.serverLevel(), itemStack, value);
            int min = Math.min(i, itemStack.getDamageValue());
            int consumedExperience = min > 0 ? min * value / i : 0;
            PlayerItemMendEvent event = CraftEventFactory.callPlayerItemMendEvent(player, this, itemStack, randomItemWith.get().inSlot(), min, consumedExperience);
            min = event.getRepairAmount();
            if (event.isCancelled()) {
                return value;
            }
            itemStack.setDamageValue(itemStack.getDamageValue() - min);
            if (min > 0 && (i1 = value - min * value / i) > 0) {
                return this.repairPlayerItems(player, i1);
            }
            return 0;
        }
        return value;
    }

    public int getValue() {
        return this.entityData.get(DATA_VALUE);
    }

    public void setValue(int value) {
        this.entityData.set(DATA_VALUE, value);
    }

    public int getIcon() {
        int value = this.getValue();
        if (value >= 2477) {
            return 10;
        }
        if (value >= 1237) {
            return 9;
        }
        if (value >= 617) {
            return 8;
        }
        if (value >= 307) {
            return 7;
        }
        if (value >= 149) {
            return 6;
        }
        if (value >= 73) {
            return 5;
        }
        if (value >= 37) {
            return 4;
        }
        if (value >= 17) {
            return 3;
        }
        if (value >= 7) {
            return 2;
        }
        return value >= 3 ? 1 : 0;
    }

    public static int getExperienceValue(int expValue) {
        if (expValue > 162670129) {
            return expValue - 100000;
        }
        if (expValue > 81335063) {
            return 81335063;
        }
        if (expValue > 40667527) {
            return 40667527;
        }
        if (expValue > 20333759) {
            return 20333759;
        }
        if (expValue > 10166857) {
            return 10166857;
        }
        if (expValue > 5083423) {
            return 5083423;
        }
        if (expValue > 2541701) {
            return 2541701;
        }
        if (expValue > 1270849) {
            return 1270849;
        }
        if (expValue > 635413) {
            return 635413;
        }
        if (expValue > 317701) {
            return 317701;
        }
        if (expValue > 158849) {
            return 158849;
        }
        if (expValue > 79423) {
            return 79423;
        }
        if (expValue > 39709) {
            return 39709;
        }
        if (expValue > 19853) {
            return 19853;
        }
        if (expValue > 9923) {
            return 9923;
        }
        if (expValue > 4957) {
            return 4957;
        }
        if (expValue >= 2477) {
            return 2477;
        }
        if (expValue >= 1237) {
            return 1237;
        }
        if (expValue >= 617) {
            return 617;
        }
        if (expValue >= 307) {
            return 307;
        }
        if (expValue >= 149) {
            return 149;
        }
        if (expValue >= 73) {
            return 73;
        }
        if (expValue >= 37) {
            return 37;
        }
        if (expValue >= 17) {
            return 17;
        }
        if (expValue >= 7) {
            return 7;
        }
        return expValue >= 3 ? 3 : 1;
    }

    @Override
    public boolean isAttackable() {
        return false;
    }

    @Override
    public SoundSource getSoundSource() {
        return SoundSource.AMBIENT;
    }

    @Override
    public InterpolationHandler getInterpolation() {
        return this.interpolation;
    }
}

