/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectType;

public interface InsideBlockEffectApplier {
    public static final InsideBlockEffectApplier NOOP = new InsideBlockEffectApplier(){

        @Override
        public void apply(InsideBlockEffectType type) {
        }

        @Override
        public void runBefore(InsideBlockEffectType type, Consumer<Entity> effect) {
        }

        @Override
        public void runAfter(InsideBlockEffectType type, Consumer<Entity> effect) {
        }
    };

    public void apply(InsideBlockEffectType var1);

    public void runBefore(InsideBlockEffectType var1, Consumer<Entity> var2);

    public void runAfter(InsideBlockEffectType var1, Consumer<Entity> var2);

    public static class StepBasedCollector
    implements InsideBlockEffectApplier {
        private static final InsideBlockEffectType[] APPLY_ORDER = InsideBlockEffectType.values();
        private static final int NO_STEP = -1;
        private final Map<InsideBlockEffectType, Consumer<Entity>> effectsInStep = new EnumMap<InsideBlockEffectType, Consumer<Entity>>(InsideBlockEffectType.class);
        private final Map<InsideBlockEffectType, List<Consumer<Entity>>> beforeEffectsInStep = Util.makeEnumMap(InsideBlockEffectType.class, insideBlockEffectType -> new ArrayList());
        private final Map<InsideBlockEffectType, List<Consumer<Entity>>> afterEffectsInStep = Util.makeEnumMap(InsideBlockEffectType.class, insideBlockEffectType -> new ArrayList());
        private final List<Consumer<Entity>> finalEffects = new ArrayList<Consumer<Entity>>();
        private int lastStep = -1;
        private BlockPos currentBlockPos = null;

        public void advanceStep(int step, BlockPos pos) {
            this.currentBlockPos = pos;
            if (this.lastStep != step) {
                this.lastStep = step;
                this.flushStep();
            }
        }

        public void applyAndClear(Entity entity) {
            this.flushStep();
            for (Consumer<Entity> consumer : this.finalEffects) {
                if (!entity.isAlive()) break;
                consumer.accept(entity);
            }
            this.finalEffects.clear();
            this.lastStep = -1;
        }

        private void flushStep() {
            for (InsideBlockEffectType insideBlockEffectType : APPLY_ORDER) {
                List<Consumer<Entity>> list = this.beforeEffectsInStep.get((Object)insideBlockEffectType);
                this.finalEffects.addAll(list);
                list.clear();
                Consumer<Entity> consumer = this.effectsInStep.remove((Object)insideBlockEffectType);
                if (consumer instanceof Consumer) {
                    Consumer<Entity> recordedEffect = consumer;
                    this.finalEffects.add(recordedEffect);
                }
                List<Consumer<Entity>> list1 = this.afterEffectsInStep.get((Object)insideBlockEffectType);
                this.finalEffects.addAll(list1);
                list1.clear();
            }
        }

        @Override
        public void apply(InsideBlockEffectType type) {
            this.effectsInStep.put(type, this.recorded(type));
        }

        @Override
        public void runBefore(InsideBlockEffectType type, Consumer<Entity> effect) {
            this.beforeEffectsInStep.get((Object)type).add(effect);
        }

        @Override
        public void runAfter(InsideBlockEffectType type, Consumer<Entity> effect) {
            this.afterEffectsInStep.get((Object)type).add(effect);
        }

        private Consumer<Entity> recorded(InsideBlockEffectType type) {
            return new RecordedEffect(this.currentBlockPos.immutable(), type.effect());
        }

        record RecordedEffect(BlockPos blockPos, InsideBlockEffectType.Applier applier) implements Consumer<Entity>
        {
            @Override
            public void accept(Entity entity) {
                this.applier.affect(entity, this.blockPos);
            }
        }
    }
}

