/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.BaseFireBlock;

public enum InsideBlockEffectType {
    FREEZE(entity -> {
        entity.setIsInPowderSnow(true);
        if (entity.canFreeze() && !entity.freezeLocked) {
            entity.setTicksFrozen(Math.min(entity.getTicksRequiredToFreeze(), entity.getTicksFrozen() + 1));
        }
    }),
    FIRE_IGNITE(BaseFireBlock::fireIgnite),
    LAVA_IGNITE((entity, pos) -> entity.lavaIgnite(pos)),
    EXTINGUISH(Entity::clearFire);

    private final Applier effect;

    private InsideBlockEffectType(Consumer<Entity> effect) {
        this((Entity entity, BlockPos block) -> effect.accept(entity));
    }

    private InsideBlockEffectType(Applier effect) {
        this.effect = effect;
    }

    public Applier effect() {
        return this.effect;
    }

    @FunctionalInterface
    public static interface Applier {
        public void affect(Entity var1, BlockPos var2);
    }
}

