/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Attackable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.Targeting;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.event.entity.EntityDamageEvent;

public class Interaction
extends Entity
implements Attackable,
Targeting {
    private static final EntityDataAccessor<Float> DATA_WIDTH_ID = SynchedEntityData.defineId(Interaction.class, EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> DATA_HEIGHT_ID = SynchedEntityData.defineId(Interaction.class, EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Boolean> DATA_RESPONSE_ID = SynchedEntityData.defineId(Interaction.class, EntityDataSerializers.BOOLEAN);
    private static final String TAG_WIDTH = "width";
    private static final String TAG_HEIGHT = "height";
    private static final String TAG_ATTACK = "attack";
    private static final String TAG_INTERACTION = "interaction";
    private static final String TAG_RESPONSE = "response";
    private static final float DEFAULT_WIDTH = 1.0f;
    private static final float DEFAULT_HEIGHT = 1.0f;
    private static final boolean DEFAULT_RESPONSE = false;
    @Nullable
    public PlayerAction attack;
    @Nullable
    public PlayerAction interaction;

    public Interaction(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.noPhysics = true;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_WIDTH_ID, Float.valueOf(1.0f));
        builder.define(DATA_HEIGHT_ID, Float.valueOf(1.0f));
        builder.define(DATA_RESPONSE_ID, false);
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag tag) {
        this.setWidth(tag.getFloatOr(TAG_WIDTH, 1.0f));
        this.setHeight(tag.getFloatOr(TAG_HEIGHT, 1.0f));
        this.attack = tag.read(TAG_ATTACK, PlayerAction.CODEC).orElse(null);
        this.interaction = tag.read(TAG_INTERACTION, PlayerAction.CODEC).orElse(null);
        this.setResponse(tag.getBooleanOr(TAG_RESPONSE, false));
        this.setBoundingBox(this.makeBoundingBox());
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag tag) {
        tag.putFloat(TAG_WIDTH, this.getWidth());
        tag.putFloat(TAG_HEIGHT, this.getHeight());
        tag.storeNullable(TAG_ATTACK, PlayerAction.CODEC, this.attack);
        tag.storeNullable(TAG_INTERACTION, PlayerAction.CODEC, this.interaction);
        tag.putBoolean(TAG_RESPONSE, this.getResponse());
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (DATA_HEIGHT_ID.equals(key) || DATA_WIDTH_ID.equals(key)) {
            this.refreshDimensions();
        }
    }

    @Override
    public boolean canBeHitByProjectile() {
        return false;
    }

    @Override
    public boolean isPickable() {
        return true;
    }

    @Override
    public PushReaction getPistonPushReaction() {
        return PushReaction.IGNORE;
    }

    @Override
    public boolean isIgnoringBlockTriggers() {
        return true;
    }

    @Override
    public boolean skipAttackInteraction(Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            DamageSource source = player.damageSources().generic().eventEntityDamager(entity);
            EntityDamageEvent event = CraftEventFactory.callNonLivingEntityDamageEvent(this, source, 1.0, false);
            if (event.isCancelled()) {
                return true;
            }
            this.attack = new PlayerAction(player.getUUID(), this.level().getGameTime());
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.PLAYER_HURT_ENTITY.trigger(serverPlayer, this, source, 1.0f, (float)event.getFinalDamage(), false);
            }
            return !this.getResponse();
        }
        return false;
    }

    @Override
    public final boolean hurtServer(ServerLevel level, DamageSource damageSource, float amount) {
        return false;
    }

    @Override
    public InteractionResult interact(Player player, InteractionHand hand) {
        if (this.level().isClientSide) {
            return this.getResponse() ? InteractionResult.SUCCESS : InteractionResult.CONSUME;
        }
        this.interaction = new PlayerAction(player.getUUID(), this.level().getGameTime());
        return InteractionResult.CONSUME;
    }

    @Override
    public void tick() {
    }

    @Override
    @Nullable
    public LivingEntity getLastAttacker() {
        return this.attack != null ? this.level().getPlayerByUUID(this.attack.player()) : null;
    }

    @Override
    @Nullable
    public LivingEntity getTarget() {
        return this.interaction != null ? this.level().getPlayerByUUID(this.interaction.player()) : null;
    }

    public void setWidth(float width) {
        this.entityData.set(DATA_WIDTH_ID, Float.valueOf(width));
    }

    public float getWidth() {
        return this.entityData.get(DATA_WIDTH_ID).floatValue();
    }

    public void setHeight(float height) {
        this.entityData.set(DATA_HEIGHT_ID, Float.valueOf(height));
    }

    public float getHeight() {
        return this.entityData.get(DATA_HEIGHT_ID).floatValue();
    }

    public void setResponse(boolean response) {
        this.entityData.set(DATA_RESPONSE_ID, response);
    }

    public boolean getResponse() {
        return this.entityData.get(DATA_RESPONSE_ID);
    }

    private EntityDimensions getDimensions() {
        return EntityDimensions.scalable(this.getWidth(), this.getHeight());
    }

    @Override
    public EntityDimensions getDimensions(Pose pose) {
        return this.getDimensions();
    }

    @Override
    protected AABB makeBoundingBox(Vec3 position) {
        return this.getDimensions().makeBoundingBox(position);
    }

    public record PlayerAction(UUID player, long timestamp) {
        public static final Codec<PlayerAction> CODEC = RecordCodecBuilder.create(istance -> istance.group((App)UUIDUtil.CODEC.fieldOf("player").forGetter(PlayerAction::player), (App)Codec.LONG.fieldOf("timestamp").forGetter(PlayerAction::timestamp)).apply((Applicative)istance, PlayerAction::new));
    }
}

