/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundSetEntityLinkPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import org.bukkit.event.entity.EntityUnleashEvent;

public interface Leashable {
    public static final String LEASH_TAG = "leash";
    public static final double LEASH_TOO_FAR_DIST = 10.0;
    public static final double LEASH_ELASTIC_DIST = 6.0;

    @Nullable
    public LeashData getLeashData();

    public void setLeashData(@Nullable LeashData var1);

    default public boolean isLeashed() {
        return this.getLeashData() != null && this.getLeashData().leashHolder != null;
    }

    default public boolean mayBeLeashed() {
        return this.getLeashData() != null;
    }

    default public boolean canHaveALeashAttachedToIt() {
        return this.canBeLeashed() && !this.isLeashed();
    }

    default public boolean canBeLeashed() {
        return true;
    }

    default public void setDelayedLeashHolderId(int delayedLeashHolderId) {
        this.setLeashData(new LeashData(delayedLeashHolderId));
        Leashable.dropLeash((Entity)((Object)this), false, false);
    }

    default public void readLeashData(CompoundTag tag) {
        LeashData leashData = tag.read(LEASH_TAG, LeashData.CODEC).orElse(null);
        if (this.getLeashData() != null && leashData == null) {
            this.removeLeash();
        }
        this.setLeashData(leashData);
    }

    default public void writeLeashData(CompoundTag tag, @Nullable LeashData leashData) {
        if (leashData != null && leashData.leashHolder != null && leashData.leashHolder.pluginRemoved) {
            return;
        }
        tag.storeNullable(LEASH_TAG, LeashData.CODEC, leashData);
    }

    private static <E extends Entity> void restoreLeashFromSave(E entity, LeashData leashData) {
        Level level;
        if (leashData.delayedLeashInfo != null && (level = entity.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Optional<UUID> optional = leashData.delayedLeashInfo.left();
            Optional<BlockPos> optional1 = leashData.delayedLeashInfo.right();
            if (optional.isPresent()) {
                Entity entity1 = serverLevel.getEntity(optional.get());
                if (entity1 != null) {
                    Leashable.setLeashedTo(entity, entity1, true);
                    return;
                }
            } else if (optional1.isPresent()) {
                Leashable.setLeashedTo(entity, LeashFenceKnotEntity.getOrCreateKnot(serverLevel, optional1.get()), true);
                return;
            }
            if (entity.tickCount > 100) {
                entity.forceDrops = true;
                entity.spawnAtLocation(serverLevel, Items.LEAD);
                entity.forceDrops = false;
                ((Leashable)((Object)entity)).setLeashData(null);
            }
        }
    }

    default public void dropLeash() {
        Leashable.dropLeash((Entity)((Object)this), true, true);
    }

    default public void removeLeash() {
        Leashable.dropLeash((Entity)((Object)this), true, false);
    }

    default public void onLeashRemoved() {
    }

    private static <E extends Entity> void dropLeash(E entity, boolean broadcastPacket, boolean dropItem) {
        LeashData leashData = ((Leashable)((Object)entity)).getLeashData();
        if (leashData != null && leashData.leashHolder != null) {
            ((Leashable)((Object)entity)).setLeashData(null);
            ((Leashable)((Object)entity)).onLeashRemoved();
            Level level = entity.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (dropItem) {
                    entity.forceDrops = true;
                    entity.spawnAtLocation(serverLevel, Items.LEAD);
                    entity.forceDrops = false;
                }
                if (broadcastPacket) {
                    serverLevel.getChunkSource().broadcast(entity, new ClientboundSetEntityLinkPacket(entity, null));
                }
            }
        }
    }

    public static <E extends Entity> void tickLeash(ServerLevel level, E entity) {
        LeashData leashData = ((Leashable)((Object)entity)).getLeashData();
        if (leashData != null && leashData.delayedLeashInfo != null) {
            Leashable.restoreLeashFromSave(entity, leashData);
        }
        if (leashData != null && leashData.leashHolder != null) {
            Entity leashHolder;
            if (!entity.isAlive() || !leashData.leashHolder.isAlive()) {
                EntityUnleashEvent event = new EntityUnleashEvent((org.bukkit.entity.Entity)entity.getBukkitEntity(), !entity.isAlive() ? EntityUnleashEvent.UnleashReason.PLAYER_UNLEASH : EntityUnleashEvent.UnleashReason.HOLDER_GONE, level.getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS) && !entity.pluginRemoved);
                event.callEvent();
                if (event.isDropLeash()) {
                    ((Leashable)((Object)entity)).dropLeash();
                } else {
                    ((Leashable)((Object)entity)).removeLeash();
                }
            }
            if ((leashHolder = ((Leashable)((Object)entity)).getLeashHolder()) != null && leashHolder.level() == entity.level()) {
                float f = entity.distanceTo(leashHolder);
                if (!((Leashable)((Object)entity)).handleLeashAtDistance(leashHolder, f)) {
                    return;
                }
                if ((double)f > entity.level().paperConfig().misc.maxLeashDistance.or(10.0)) {
                    ((Leashable)((Object)entity)).leashTooFarBehaviour();
                } else if ((double)f > 6.0) {
                    ((Leashable)((Object)entity)).elasticRangeLeashBehaviour(leashHolder, f);
                    entity.checkSlowFallDistance();
                } else {
                    ((Leashable)((Object)entity)).closeRangeLeashBehaviour(leashHolder);
                }
            }
        }
    }

    default public boolean handleLeashAtDistance(Entity leashHolder, float distance) {
        return true;
    }

    default public void leashTooFarBehaviour() {
        boolean dropLeash = true;
        Leashable leashable = this;
        if (leashable instanceof Entity) {
            Entity entity = (Entity)((Object)leashable);
            EntityUnleashEvent event = new EntityUnleashEvent((org.bukkit.entity.Entity)entity.getBukkitEntity(), EntityUnleashEvent.UnleashReason.DISTANCE, true);
            if (!event.callEvent()) {
                return;
            }
            dropLeash = event.isDropLeash();
        }
        if (dropLeash) {
            this.dropLeash();
        } else {
            this.removeLeash();
        }
    }

    default public void closeRangeLeashBehaviour(Entity entity) {
    }

    default public void elasticRangeLeashBehaviour(Entity leashHolder, float distance) {
        Leashable.legacyElasticRangeLeashBehaviour((Entity)((Object)this), leashHolder, distance);
    }

    private static <E extends Entity> void legacyElasticRangeLeashBehaviour(E entity, Entity leashHolder, float distance) {
        double d = (leashHolder.getX() - entity.getX()) / (double)distance;
        double d1 = (leashHolder.getY() - entity.getY()) / (double)distance;
        double d2 = (leashHolder.getZ() - entity.getZ()) / (double)distance;
        entity.setDeltaMovement(entity.getDeltaMovement().add(Math.copySign(d * d * 0.4, d), Math.copySign(d1 * d1 * 0.4, d1), Math.copySign(d2 * d2 * 0.4, d2)));
    }

    default public void setLeashedTo(Entity leashHolder, boolean broadcastPacket) {
        Leashable.setLeashedTo((Entity)((Object)this), leashHolder, broadcastPacket);
    }

    private static <E extends Entity> void setLeashedTo(E entity, Entity leashHolder, boolean broadcastPacket) {
        Level level;
        LeashData leashData = ((Leashable)((Object)entity)).getLeashData();
        if (leashData == null) {
            leashData = new LeashData(leashHolder);
            ((Leashable)((Object)entity)).setLeashData(leashData);
        } else {
            leashData.setLeashHolder(leashHolder);
        }
        if (broadcastPacket && (level = entity.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.getChunkSource().broadcast(entity, new ClientboundSetEntityLinkPacket(entity, leashHolder));
        }
        if (entity.isPassenger()) {
            entity.stopRiding();
        }
    }

    @Nullable
    default public Entity getLeashHolder() {
        return Leashable.getLeashHolder((Entity)((Object)this));
    }

    @Nullable
    private static <E extends Entity> Entity getLeashHolder(E entity) {
        Entity var3;
        LeashData leashData = ((Leashable)((Object)entity)).getLeashData();
        if (leashData == null) {
            return null;
        }
        if (leashData.delayedLeashHolderId != 0 && entity.level().isClientSide && (var3 = entity.level().getEntity(leashData.delayedLeashHolderId)) instanceof Entity) {
            leashData.setLeashHolder(var3);
        }
        return leashData.leashHolder;
    }

    public static final class LeashData {
        public static final Codec<LeashData> CODEC = Codec.xor((Codec)UUIDUtil.CODEC.fieldOf("UUID").codec(), BlockPos.CODEC).xmap(LeashData::new, leashData -> {
            Entity patt0$temp = leashData.leashHolder;
            if (patt0$temp instanceof LeashFenceKnotEntity) {
                LeashFenceKnotEntity leashFenceKnotEntity = (LeashFenceKnotEntity)patt0$temp;
                return Either.right(leashFenceKnotEntity.getPos());
            }
            return leashData.leashHolder != null ? Either.left(leashData.leashHolder.getUUID()) : Objects.requireNonNull(leashData.delayedLeashInfo, "Invalid LeashData had no attachment");
        });
        int delayedLeashHolderId;
        @Nullable
        public Entity leashHolder;
        @Nullable
        public Either<UUID, BlockPos> delayedLeashInfo;

        private LeashData(Either<UUID, BlockPos> delayedLeashInfo) {
            this.delayedLeashInfo = delayedLeashInfo;
        }

        LeashData(Entity leashHolder) {
            this.leashHolder = leashHolder;
        }

        LeashData(int delayedLeashInfoId) {
            this.delayedLeashHolderId = delayedLeashInfoId;
        }

        public void setLeashHolder(Entity leashHolder) {
            this.leashHolder = leashHolder;
            this.delayedLeashInfo = null;
            this.delayedLeashHolderId = 0;
        }
    }
}

