/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import org.bukkit.event.entity.EntityTargetEvent;

public interface NeutralMob {
    public static final String TAG_ANGER_TIME = "AngerTime";
    public static final String TAG_ANGRY_AT = "AngryAt";

    public int getRemainingPersistentAngerTime();

    public void setRemainingPersistentAngerTime(int var1);

    @Nullable
    public UUID getPersistentAngerTarget();

    public void setPersistentAngerTarget(@Nullable UUID var1);

    public void startPersistentAngerTimer();

    default public void addPersistentAngerSaveData(CompoundTag nbt) {
        nbt.putInt(TAG_ANGER_TIME, this.getRemainingPersistentAngerTime());
        nbt.storeNullable(TAG_ANGRY_AT, UUIDUtil.CODEC, this.getPersistentAngerTarget());
    }

    default public void readPersistentAngerSaveData(Level level, CompoundTag tag) {
        this.setRemainingPersistentAngerTime(tag.getIntOr(TAG_ANGER_TIME, 0));
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            UUID uuid = tag.read(TAG_ANGRY_AT, UUIDUtil.CODEC).orElse(null);
            this.setPersistentAngerTarget(uuid);
            NeutralMob neutralMob = this;
            if (neutralMob instanceof Entity) {
                Entity entity = (Entity)((Object)neutralMob);
                if (!entity.firstTick) {
                    this.tickInitialPersistentAnger(level);
                }
            }
        }
    }

    default public void updatePersistentAnger(ServerLevel serverLevel, boolean updateAnger) {
        LivingEntity target = this.getTarget();
        UUID persistentAngerTarget = this.getPersistentAngerTarget();
        if ((target == null || target.isDeadOrDying()) && persistentAngerTarget != null && serverLevel.getEntity(persistentAngerTarget) instanceof Mob) {
            this.stopBeingAngry();
        } else {
            if (target != null && !Objects.equals(persistentAngerTarget, target.getUUID())) {
                this.setPersistentAngerTarget(target.getUUID());
                this.startPersistentAngerTimer();
            }
            if (!(this.getRemainingPersistentAngerTime() <= 0 || target != null && target.getType() == EntityType.PLAYER && updateAnger)) {
                this.setRemainingPersistentAngerTime(this.getRemainingPersistentAngerTime() - 1);
                if (this.getRemainingPersistentAngerTime() == 0) {
                    this.stopBeingAngry();
                }
            }
        }
    }

    default public boolean isAngryAt(LivingEntity entity, ServerLevel level) {
        return this.canAttack(entity) && (entity.getType() == EntityType.PLAYER && this.isAngryAtAllPlayers(level) || entity.getUUID().equals(this.getPersistentAngerTarget()));
    }

    default public boolean isAngryAtAllPlayers(ServerLevel level) {
        return level.getGameRules().getBoolean(GameRules.RULE_UNIVERSAL_ANGER) && this.isAngry() && this.getPersistentAngerTarget() == null;
    }

    default public boolean isAngry() {
        return this.getRemainingPersistentAngerTime() > 0;
    }

    default public void playerDied(ServerLevel level, Player player) {
        if (level.getGameRules().getBoolean(GameRules.RULE_FORGIVE_DEAD_PLAYERS) && player.getUUID().equals(this.getPersistentAngerTarget())) {
            this.stopBeingAngry();
        }
    }

    default public void forgetCurrentTargetAndRefreshUniversalAnger() {
        this.stopBeingAngry();
        this.startPersistentAngerTimer();
    }

    default public void stopBeingAngry() {
        this.setLastHurtByMob(null);
        this.setPersistentAngerTarget(null);
        this.setTarget(null, EntityTargetEvent.TargetReason.FORGOT_TARGET);
        this.setRemainingPersistentAngerTime(0);
    }

    @Nullable
    public LivingEntity getLastHurtByMob();

    public void setLastHurtByMob(@Nullable LivingEntity var1);

    public void setTarget(@Nullable LivingEntity var1);

    public boolean setTarget(@Nullable LivingEntity var1, @Nullable EntityTargetEvent.TargetReason var2);

    public boolean canAttack(LivingEntity var1);

    @Nullable
    public LivingEntity getTarget();

    default public void tickInitialPersistentAnger(Level level) {
        UUID uuid = this.getPersistentAngerTarget();
        if (uuid == null) {
            return;
        }
        Entity entity = level.getEntity(uuid);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            this.setTarget(livingEntity, null);
        }
    }
}

