/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.Applicative;
import java.util.function.Function;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import org.bukkit.craftbukkit.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;

public class BabyFollowAdult {
    public static OneShot<AgeableMob> create(UniformInt followRange, float speedModifier) {
        return BabyFollowAdult.create(followRange, entity -> Float.valueOf(speedModifier));
    }

    public static OneShot<AgeableMob> create(UniformInt followRange, Function<LivingEntity, Float> speedModifier) {
        return BehaviorBuilder.create(instance -> instance.group(instance.present(MemoryModuleType.NEAREST_VISIBLE_ADULT), instance.registered(MemoryModuleType.LOOK_TARGET), instance.absent(MemoryModuleType.WALK_TARGET)).apply((Applicative)instance, (nearestVisibleAdult, lookTarget, walkTarget) -> (level, mob, gameTime) -> {
            if (!mob.isBaby()) {
                return false;
            }
            LivingEntity ageableMob = (LivingEntity)instance.get(nearestVisibleAdult);
            if (mob.closerThan(ageableMob, followRange.getMaxValue() + 1) && !mob.closerThan(ageableMob, followRange.getMinValue())) {
                EntityTargetLivingEntityEvent event = CraftEventFactory.callEntityTargetLivingEvent(mob, ageableMob, EntityTargetEvent.TargetReason.FOLLOW_LEADER);
                if (event.isCancelled()) {
                    return false;
                }
                if (event.getTarget() == null) {
                    nearestVisibleAdult.erase();
                    return true;
                }
                ageableMob = ((CraftLivingEntity)event.getTarget()).getHandle();
                WalkTarget walkTarget1 = new WalkTarget(new EntityTracker(ageableMob, false), ((Float)speedModifier.apply(mob)).floatValue(), followRange.getMinValue() - 1);
                lookTarget.set(new EntityTracker(ageableMob, true));
                walkTarget.set(walkTarget1);
                return true;
            }
            return false;
        }));
    }
}

