/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.Applicative;
import java.util.function.Predicate;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.item.ItemEntity;
import org.bukkit.craftbukkit.entity.CraftItem;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.entity.EntityTargetEvent;

public class GoToWantedItem {
    public static BehaviorControl<LivingEntity> create(float speedModifier, boolean hasTarget, int maxDistToWalk) {
        return GoToWantedItem.create(entity -> true, speedModifier, hasTarget, maxDistToWalk);
    }

    public static <E extends LivingEntity> BehaviorControl<E> create(Predicate<E> canWalkToItem, float speedModifier, boolean hasTarget, int maxDistToWalk) {
        return BehaviorBuilder.create(instance -> {
            BehaviorBuilder behaviorBuilder = hasTarget ? instance.registered(MemoryModuleType.WALK_TARGET) : instance.absent(MemoryModuleType.WALK_TARGET);
            return instance.group(instance.registered(MemoryModuleType.LOOK_TARGET), behaviorBuilder, instance.present(MemoryModuleType.NEAREST_VISIBLE_WANTED_ITEM), instance.registered(MemoryModuleType.ITEM_PICKUP_COOLDOWN_TICKS)).apply((Applicative)instance, (lookTarget, walkTarget, nearestVisibleWantedItem, itemPickupCooldownTicks) -> (level, entity, gameTime) -> {
                ItemEntity itemEntity = (ItemEntity)instance.get(nearestVisibleWantedItem);
                if (instance.tryGet(itemPickupCooldownTicks).isEmpty() && canWalkToItem.test(entity) && itemEntity.closerThan(entity, maxDistToWalk) && entity.level().getWorldBorder().isWithinBounds(itemEntity.blockPosition()) && entity.canPickUpLoot()) {
                    if (entity instanceof Allay) {
                        EntityTargetEvent event = CraftEventFactory.callEntityTargetEvent(entity, itemEntity, EntityTargetEvent.TargetReason.CLOSEST_ENTITY);
                        if (event.isCancelled()) {
                            return false;
                        }
                        Entity patt0$temp = event.getTarget();
                        if (!(patt0$temp instanceof CraftItem)) {
                            nearestVisibleWantedItem.erase();
                            return false;
                        }
                        CraftItem targetItem = (CraftItem)patt0$temp;
                        itemEntity = targetItem.getHandle();
                    }
                    WalkTarget walkTarget1 = new WalkTarget(new EntityTracker(itemEntity, false), speedModifier, 0);
                    lookTarget.set(new EntityTracker(itemEntity, true));
                    walkTarget.set(walkTarget1);
                    return true;
                }
                return false;
            });
        });
    }
}

