/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.Applicative;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.memory.WalkTarget;

public class InteractWith {
    public static <T extends LivingEntity> BehaviorControl<LivingEntity> of(EntityType<? extends T> type, int interactionRange, MemoryModuleType<T> interactMemory, float speedModifier, int maxDist) {
        return InteractWith.of(type, interactionRange, entity -> true, entity -> true, interactMemory, speedModifier, maxDist);
    }

    public static <E extends LivingEntity, T extends LivingEntity> BehaviorControl<E> of(EntityType<? extends T> type, int interactionRange, Predicate<E> selfFilter, Predicate<T> targetFilter, MemoryModuleType<T> memory, float speedModifier, int maxDist) {
        int i = interactionRange * interactionRange;
        Predicate<LivingEntity> predicate = entity -> type.equals(entity.getType()) && targetFilter.test(entity);
        return BehaviorBuilder.create(instance -> instance.group(instance.registered(memory), instance.registered(MemoryModuleType.LOOK_TARGET), instance.absent(MemoryModuleType.WALK_TARGET), instance.present(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES)).apply((Applicative)instance, (interact, lookTarget, walkTarget, nearestVisibleLivingEntities) -> (level, entity, gameTime) -> {
            NearestVisibleLivingEntities nearestVisibleLivingEntities1 = (NearestVisibleLivingEntities)instance.get(nearestVisibleLivingEntities);
            if (selfFilter.test(entity) && nearestVisibleLivingEntities1.contains(predicate)) {
                Optional<LivingEntity> optional = nearestVisibleLivingEntities1.findClosest(testEntity -> testEntity.distanceToSqr(entity) <= (double)i && predicate.test((LivingEntity)testEntity));
                optional.ifPresent(target -> {
                    interact.set(target);
                    lookTarget.set(new EntityTracker((Entity)target, true));
                    walkTarget.set(new WalkTarget(new EntityTracker((Entity)target, false), speedModifier, maxDist));
                });
                return true;
            }
            return false;
        }));
    }
}

