/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.Applicative;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;

public class SetWalkTargetFromLookTarget {
    public static OneShot<LivingEntity> create(float speedModifier, int closeEnoughDist) {
        return SetWalkTargetFromLookTarget.create(entity -> true, entity -> Float.valueOf(speedModifier), closeEnoughDist);
    }

    public static OneShot<LivingEntity> create(Predicate<LivingEntity> canSetWalkTarget, Function<LivingEntity, Float> speedModifier, int closeEnoughDist) {
        return BehaviorBuilder.create(instance -> instance.group(instance.absent(MemoryModuleType.WALK_TARGET), instance.present(MemoryModuleType.LOOK_TARGET)).apply((Applicative)instance, (walkTarget, lookTarget) -> (level, entity, gameTime) -> {
            if (!canSetWalkTarget.test(entity)) {
                return false;
            }
            walkTarget.set(new WalkTarget((PositionTracker)instance.get(lookTarget), ((Float)speedModifier.apply(entity)).floatValue(), closeEnoughDist));
            return true;
        }));
    }
}

