/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.util.RandomSource;

public class ShufflingList<U>
implements Iterable<U> {
    protected final List<WeightedEntry<U>> entries;
    private final RandomSource random = RandomSource.create();
    private final boolean isUnsafe;

    public ShufflingList() {
        this(true);
    }

    public ShufflingList(boolean isUnsafe) {
        this.isUnsafe = isUnsafe;
        this.entries = Lists.newArrayList();
    }

    private ShufflingList(List<WeightedEntry<U>> entries) {
        this(entries, true);
    }

    private ShufflingList(List<WeightedEntry<U>> entries, boolean isUnsafe) {
        this.isUnsafe = isUnsafe;
        this.entries = Lists.newArrayList(entries);
    }

    public static <U> Codec<ShufflingList<U>> codec(Codec<U> codec) {
        return WeightedEntry.codec(codec).listOf().xmap(ShufflingList::new, list -> list.entries);
    }

    public ShufflingList<U> add(U data, int weight) {
        this.entries.add(new WeightedEntry<U>(data, weight));
        return this;
    }

    public ShufflingList<U> shuffle() {
        ArrayList list = this.isUnsafe ? Lists.newArrayList(this.entries) : this.entries;
        list.forEach(entry -> entry.setRandom(this.random.nextFloat()));
        list.sort(Comparator.comparingDouble(WeightedEntry::getRandWeight));
        return this.isUnsafe ? new ShufflingList<U>(list, this.isUnsafe) : this;
    }

    public Stream<U> stream() {
        return this.entries.stream().map(WeightedEntry::getData);
    }

    @Override
    public Iterator<U> iterator() {
        return Iterators.transform(this.entries.iterator(), WeightedEntry::getData);
    }

    public String toString() {
        return "ShufflingList[" + String.valueOf(this.entries) + "]";
    }

    public static class WeightedEntry<T> {
        final T data;
        final int weight;
        private double randWeight;

        WeightedEntry(T data, int weight) {
            this.weight = weight;
            this.data = data;
        }

        private double getRandWeight() {
            return this.randWeight;
        }

        void setRandom(float chance) {
            this.randWeight = -Math.pow(chance, 1.0f / (float)this.weight);
        }

        public T getData() {
            return this.data;
        }

        public int getWeight() {
            return this.weight;
        }

        public String toString() {
            return this.weight + ":" + String.valueOf(this.data);
        }

        public static <E> Codec<WeightedEntry<E>> codec(final Codec<E> codec) {
            return new Codec<WeightedEntry<E>>(){

                public <T> DataResult<Pair<WeightedEntry<E>, T>> decode(DynamicOps<T> ops, T input) {
                    Dynamic dynamic = new Dynamic(ops, input);
                    return dynamic.get("data").flatMap(arg_0 -> ((Codec)codec).parse(arg_0)).map(object -> new WeightedEntry<Object>(object, dynamic.get("weight").asInt(1))).map(weightedEntry -> Pair.of((Object)weightedEntry, (Object)ops.empty()));
                }

                public <T> DataResult<T> encode(WeightedEntry<E> input, DynamicOps<T> ops, T prefix) {
                    return ops.mapBuilder().add("weight", ops.createInt(input.weight)).add("data", codec.encodeStart(ops, input.data)).build(prefix);
                }
            };
        }
    }
}

