/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.Applicative;
import java.util.List;
import net.minecraft.core.GlobalPos;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.npc.Villager;
import org.apache.commons.lang3.mutable.MutableLong;

public class StrollToPoiList {
    public static BehaviorControl<Villager> create(MemoryModuleType<List<GlobalPos>> poiListMemory, float speedModifier, int closeEnoughDist, int maxDistFromPoi, MemoryModuleType<GlobalPos> mustBeCloseToMemory) {
        MutableLong mutableLong = new MutableLong(0L);
        return BehaviorBuilder.create(instance -> instance.group(instance.registered(MemoryModuleType.WALK_TARGET), instance.present(poiListMemory), instance.present(mustBeCloseToMemory)).apply((Applicative)instance, (walkTarget, poiList, mustBeCloseTo) -> (level, villager, gameTime) -> {
            List list = (List)instance.get(poiList);
            GlobalPos globalPos = (GlobalPos)instance.get(mustBeCloseTo);
            if (list.isEmpty()) {
                return false;
            }
            GlobalPos globalPos1 = (GlobalPos)list.get(level.getRandom().nextInt(list.size()));
            if (globalPos1 != null && level.dimension() == globalPos1.dimension() && globalPos.pos().closerToCenterThan(villager.position(), maxDistFromPoi)) {
                if (gameTime > mutableLong.getValue()) {
                    walkTarget.set(new WalkTarget(globalPos1.pos(), speedModifier, closeEnoughDist));
                    mutableLong.setValue(gameTime + 100L);
                }
                return true;
            }
            return false;
        }));
    }
}

