/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.gossip;

import com.destroystokyo.paper.entity.villager.Reputation;
import com.destroystokyo.paper.entity.villager.ReputationType;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.DoublePredicate;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.UUIDUtil;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.entity.ai.gossip.GossipType;

public class GossipContainer {
    public static final Codec<GossipContainer> CODEC = GossipEntry.CODEC.listOf().xmap(GossipContainer::new, gossipContainer -> gossipContainer.decompress());
    public static final int DISCARD_THRESHOLD = 2;
    public final Map<UUID, EntityGossips> gossips = new HashMap<UUID, EntityGossips>();

    public GossipContainer() {
    }

    private GossipContainer(List<GossipEntry> entries) {
        entries.forEach(entry -> this.getOrCreate((UUID)entry.target).entries.put((Object)entry.type, entry.value));
    }

    @VisibleForDebug
    public Map<UUID, Object2IntMap<GossipType>> getGossipEntries() {
        HashMap map = Maps.newHashMap();
        this.gossips.keySet().forEach(uuid -> {
            EntityGossips entityGossips = this.gossips.get(uuid);
            map.put(uuid, entityGossips.entries);
        });
        return map;
    }

    public void decay() {
        Iterator<EntityGossips> iterator = this.gossips.values().iterator();
        while (iterator.hasNext()) {
            EntityGossips entityGossips = iterator.next();
            entityGossips.decay();
            if (!entityGossips.isEmpty()) continue;
            iterator.remove();
        }
    }

    private Stream<GossipEntry> unpack() {
        return this.gossips.entrySet().stream().flatMap(entry -> ((EntityGossips)entry.getValue()).unpack((UUID)entry.getKey()));
    }

    private List<GossipEntry> decompress() {
        ObjectArrayList list = new ObjectArrayList();
        for (Map.Entry<UUID, EntityGossips> entry : this.gossips.entrySet()) {
            for (GossipEntry cur : entry.getValue().decompress(entry.getKey())) {
                if (cur.weightedValue() == 0) continue;
                list.add(cur);
            }
        }
        return list;
    }

    private Collection<GossipEntry> selectGossipsForTransfer(RandomSource random, int amount) {
        List<GossipEntry> list = this.decompress();
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        int[] ints = new int[list.size()];
        int i = 0;
        for (int i1 = 0; i1 < list.size(); ++i1) {
            GossipEntry gossipEntry = list.get(i1);
            ints[i1] = (i += Math.abs(gossipEntry.weightedValue())) - 1;
        }
        Set set = Sets.newIdentityHashSet();
        for (int i2 = 0; i2 < amount; ++i2) {
            int randomInt = random.nextInt(i);
            int i3 = Arrays.binarySearch(ints, randomInt);
            set.add(list.get(i3 < 0 ? -i3 - 1 : i3));
        }
        return set;
    }

    private EntityGossips getOrCreate(UUID identifier) {
        return this.gossips.computeIfAbsent(identifier, uuid -> new EntityGossips());
    }

    public void transferFrom(GossipContainer container, RandomSource randomSource, int amount) {
        Collection<GossipEntry> collection = container.selectGossipsForTransfer(randomSource, amount);
        collection.forEach(entry -> {
            int i = entry.value - entry.type.decayPerTransfer;
            if (i >= 2) {
                this.getOrCreate((UUID)entry.target).entries.mergeInt((Object)entry.type, i, GossipContainer::mergeValuesForTransfer);
            }
        });
    }

    public int getReputation(UUID identifier, Predicate<GossipType> gossip) {
        EntityGossips entityGossips = this.gossips.get(identifier);
        return entityGossips != null ? entityGossips.weightedValue(gossip) : 0;
    }

    public long getCountForType(GossipType gossipType, DoublePredicate gossipPredicate) {
        return this.gossips.values().stream().filter(gossips -> gossipPredicate.test(gossips.entries.getOrDefault((Object)gossipType, 0) * gossipType.weight)).count();
    }

    public void add(UUID identifier, GossipType gossipType, int gossipValue) {
        EntityGossips entityGossips = this.getOrCreate(identifier);
        entityGossips.entries.mergeInt((Object)gossipType, gossipValue, (i, i1) -> this.mergeValuesForAddition(gossipType, i, i1));
        entityGossips.makeSureValueIsntTooLowOrTooHigh(gossipType);
        if (entityGossips.isEmpty()) {
            this.gossips.remove(identifier);
        }
    }

    public void remove(UUID identifier, GossipType gossipType, int gossipValue) {
        this.add(identifier, gossipType, -gossipValue);
    }

    public void remove(UUID identifier, GossipType gossipType) {
        EntityGossips entityGossips = this.gossips.get(identifier);
        if (entityGossips != null) {
            entityGossips.remove(gossipType);
            if (entityGossips.isEmpty()) {
                this.gossips.remove(identifier);
            }
        }
    }

    public void remove(GossipType gossipType) {
        Iterator<EntityGossips> iterator = this.gossips.values().iterator();
        while (iterator.hasNext()) {
            EntityGossips entityGossips = iterator.next();
            entityGossips.remove(gossipType);
            if (!entityGossips.isEmpty()) continue;
            iterator.remove();
        }
    }

    public void clear() {
        this.gossips.clear();
    }

    public void putAll(GossipContainer other) {
        other.gossips.forEach((uuid, gossips) -> this.getOrCreate((UUID)uuid).entries.putAll(gossips.entries));
    }

    private static int mergeValuesForTransfer(int value1, int value2) {
        return Math.max(value1, value2);
    }

    private int mergeValuesForAddition(GossipType gossipType, int existing, int additive) {
        int i = existing + additive;
        return i > gossipType.max ? Math.max(gossipType.max, existing) : i;
    }

    public GossipContainer copy() {
        GossipContainer gossipContainer = new GossipContainer();
        gossipContainer.putAll(this);
        return gossipContainer;
    }

    public static class EntityGossips {
        final Object2IntMap<GossipType> entries = new Object2IntOpenHashMap();
        private static final GossipType[] TYPES = GossipType.values();

        public int weightedValue(Predicate<GossipType> gossipType) {
            int weight = 0;
            for (Object2IntMap.Entry entry : this.entries.object2IntEntrySet()) {
                if (!gossipType.test((GossipType)entry.getKey())) continue;
                weight += entry.getIntValue() * ((GossipType)entry.getKey()).weight;
            }
            return weight;
        }

        public List<GossipEntry> decompress(UUID uuid) {
            ObjectArrayList list = new ObjectArrayList();
            for (Object2IntMap.Entry entry : this.entries.object2IntEntrySet()) {
                list.add(new GossipEntry(uuid, (GossipType)entry.getKey(), entry.getIntValue()));
            }
            return list;
        }

        public Stream<GossipEntry> unpack(UUID identifier) {
            return this.entries.object2IntEntrySet().stream().map(gossip -> new GossipEntry(identifier, (GossipType)gossip.getKey(), gossip.getIntValue()));
        }

        public void decay() {
            ObjectIterator objectIterator = this.entries.object2IntEntrySet().iterator();
            while (objectIterator.hasNext()) {
                Object2IntMap.Entry entry = (Object2IntMap.Entry)objectIterator.next();
                int i = entry.getIntValue() - ((GossipType)entry.getKey()).decayPerDay;
                if (i < 2) {
                    objectIterator.remove();
                    continue;
                }
                entry.setValue(i);
            }
        }

        public boolean isEmpty() {
            return this.entries.isEmpty();
        }

        public void makeSureValueIsntTooLowOrTooHigh(GossipType gossipType) {
            int _int = this.entries.getInt((Object)gossipType);
            if (_int > gossipType.max) {
                this.entries.put((Object)gossipType, gossipType.max);
            }
            if (_int < 2) {
                this.remove(gossipType);
            }
        }

        public void remove(GossipType gossipType) {
            this.entries.removeInt((Object)gossipType);
        }

        public Reputation getPaperReputation() {
            EnumMap<ReputationType, Integer> map = new EnumMap<ReputationType, Integer>(ReputationType.class);
            for (Object2IntMap.Entry type : this.entries.object2IntEntrySet()) {
                map.put(EntityGossips.toApi((GossipType)type.getKey()), type.getIntValue());
            }
            return new Reputation(map);
        }

        public void assignFromPaperReputation(Reputation rep) {
            for (GossipType type : TYPES) {
                ReputationType api = EntityGossips.toApi(type);
                if (!rep.hasReputationSet(api)) continue;
                int reputation = rep.getReputation(api);
                if (reputation == 0) {
                    this.entries.removeInt((Object)type);
                    continue;
                }
                this.entries.put((Object)type, reputation);
            }
        }

        private static ReputationType toApi(GossipType type) {
            return switch (type) {
                default -> throw new MatchException(null, null);
                case GossipType.MAJOR_NEGATIVE -> ReputationType.MAJOR_NEGATIVE;
                case GossipType.MINOR_NEGATIVE -> ReputationType.MINOR_NEGATIVE;
                case GossipType.MINOR_POSITIVE -> ReputationType.MINOR_POSITIVE;
                case GossipType.MAJOR_POSITIVE -> ReputationType.MAJOR_POSITIVE;
                case GossipType.TRADING -> ReputationType.TRADING;
            };
        }
    }

    record GossipEntry(UUID target, GossipType type, int value) {
        public static final Codec<GossipEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)UUIDUtil.CODEC.fieldOf("Target").forGetter(GossipEntry::target), (App)GossipType.CODEC.fieldOf("Type").forGetter(GossipEntry::type), (App)ExtraCodecs.POSITIVE_INT.fieldOf("Value").forGetter(GossipEntry::value)).apply((Applicative)instance, GossipEntry::new));

        public int weightedValue() {
            return this.value * this.type.weight;
        }
    }
}

