/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.ClientAsset;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.StructureTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.variant.MoonBrightnessCheck;
import net.minecraft.world.entity.variant.PriorityProvider;
import net.minecraft.world.entity.variant.SpawnContext;
import net.minecraft.world.entity.variant.SpawnPrioritySelectors;
import net.minecraft.world.entity.variant.StructureCheck;
import net.minecraft.world.level.levelgen.structure.Structure;

public interface CatVariants {
    public static final ResourceKey<CatVariant> TABBY = CatVariants.createKey("tabby");
    public static final ResourceKey<CatVariant> BLACK = CatVariants.createKey("black");
    public static final ResourceKey<CatVariant> RED = CatVariants.createKey("red");
    public static final ResourceKey<CatVariant> SIAMESE = CatVariants.createKey("siamese");
    public static final ResourceKey<CatVariant> BRITISH_SHORTHAIR = CatVariants.createKey("british_shorthair");
    public static final ResourceKey<CatVariant> CALICO = CatVariants.createKey("calico");
    public static final ResourceKey<CatVariant> PERSIAN = CatVariants.createKey("persian");
    public static final ResourceKey<CatVariant> RAGDOLL = CatVariants.createKey("ragdoll");
    public static final ResourceKey<CatVariant> WHITE = CatVariants.createKey("white");
    public static final ResourceKey<CatVariant> JELLIE = CatVariants.createKey("jellie");
    public static final ResourceKey<CatVariant> ALL_BLACK = CatVariants.createKey("all_black");

    private static ResourceKey<CatVariant> createKey(String name) {
        return ResourceKey.create(Registries.CAT_VARIANT, ResourceLocation.withDefaultNamespace(name));
    }

    public static void bootstrap(BootstrapContext<CatVariant> context) {
        HolderGetter<Structure> holderGetter = context.lookup(Registries.STRUCTURE);
        CatVariants.registerForAnyConditions(context, TABBY, "entity/cat/tabby");
        CatVariants.registerForAnyConditions(context, BLACK, "entity/cat/black");
        CatVariants.registerForAnyConditions(context, RED, "entity/cat/red");
        CatVariants.registerForAnyConditions(context, SIAMESE, "entity/cat/siamese");
        CatVariants.registerForAnyConditions(context, BRITISH_SHORTHAIR, "entity/cat/british_shorthair");
        CatVariants.registerForAnyConditions(context, CALICO, "entity/cat/calico");
        CatVariants.registerForAnyConditions(context, PERSIAN, "entity/cat/persian");
        CatVariants.registerForAnyConditions(context, RAGDOLL, "entity/cat/ragdoll");
        CatVariants.registerForAnyConditions(context, WHITE, "entity/cat/white");
        CatVariants.registerForAnyConditions(context, JELLIE, "entity/cat/jellie");
        CatVariants.register(context, ALL_BLACK, "entity/cat/all_black", new SpawnPrioritySelectors(List.of(new PriorityProvider.Selector(new StructureCheck(holderGetter.getOrThrow(StructureTags.CATS_SPAWN_AS_BLACK)), 1), new PriorityProvider.Selector(new MoonBrightnessCheck(MinMaxBounds.Doubles.atLeast(0.9)), 0))));
    }

    private static void registerForAnyConditions(BootstrapContext<CatVariant> context, ResourceKey<CatVariant> key, String name) {
        CatVariants.register(context, key, name, SpawnPrioritySelectors.fallback(0));
    }

    private static void register(BootstrapContext<CatVariant> context, ResourceKey<CatVariant> key, String name, SpawnPrioritySelectors spawnConditions) {
        context.register(key, new CatVariant(new ClientAsset(ResourceLocation.withDefaultNamespace(name)), spawnConditions));
    }

    public static Optional<Holder.Reference<CatVariant>> selectVariantToSpawn(RandomSource random, RegistryAccess registryAccess, SpawnContext context) {
        return PriorityProvider.pick(registryAccess.lookupOrThrow(Registries.CAT_VARIANT).listElements(), Holder::value, random, context);
    }
}

