/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.animal.PigVariant;
import net.minecraft.world.entity.animal.TemperatureVariants;
import net.minecraft.world.entity.variant.BiomeCheck;
import net.minecraft.world.entity.variant.ModelAndTexture;
import net.minecraft.world.entity.variant.PriorityProvider;
import net.minecraft.world.entity.variant.SpawnContext;
import net.minecraft.world.entity.variant.SpawnPrioritySelectors;
import net.minecraft.world.level.biome.Biome;

public class PigVariants {
    public static final ResourceKey<PigVariant> TEMPERATE = PigVariants.createKey(TemperatureVariants.TEMPERATE);
    public static final ResourceKey<PigVariant> WARM = PigVariants.createKey(TemperatureVariants.WARM);
    public static final ResourceKey<PigVariant> COLD = PigVariants.createKey(TemperatureVariants.COLD);
    public static final ResourceKey<PigVariant> DEFAULT = TEMPERATE;

    private static ResourceKey<PigVariant> createKey(ResourceLocation name) {
        return ResourceKey.create(Registries.PIG_VARIANT, name);
    }

    public static void bootstrap(BootstrapContext<PigVariant> context) {
        PigVariants.register(context, TEMPERATE, PigVariant.ModelType.NORMAL, "temperate_pig", SpawnPrioritySelectors.fallback(0));
        PigVariants.register(context, WARM, PigVariant.ModelType.NORMAL, "warm_pig", BiomeTags.SPAWNS_WARM_VARIANT_FARM_ANIMALS);
        PigVariants.register(context, COLD, PigVariant.ModelType.COLD, "cold_pig", BiomeTags.SPAWNS_COLD_VARIANT_FARM_ANIMALS);
    }

    private static void register(BootstrapContext<PigVariant> context, ResourceKey<PigVariant> key, PigVariant.ModelType modelType, String name, TagKey<Biome> biomes) {
        HolderSet.Named<Biome> orThrow = context.lookup(Registries.BIOME).getOrThrow(biomes);
        PigVariants.register(context, key, modelType, name, SpawnPrioritySelectors.single(new BiomeCheck(orThrow), 1));
    }

    private static void register(BootstrapContext<PigVariant> context, ResourceKey<PigVariant> key, PigVariant.ModelType modelType, String name, SpawnPrioritySelectors spawnConditions) {
        ResourceLocation resourceLocation = ResourceLocation.withDefaultNamespace("entity/pig/" + name);
        context.register(key, new PigVariant(new ModelAndTexture<PigVariant.ModelType>(modelType, resourceLocation), spawnConditions));
    }

    public static Optional<Holder.Reference<PigVariant>> selectVariantToSpawn(RandomSource random, RegistryAccess registryAccess, SpawnContext context) {
        return PriorityProvider.pick(registryAccess.lookupOrThrow(Registries.PIG_VARIANT).listElements(), Holder::value, random, context);
    }
}

