/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;

public class TropicalFish
extends AbstractSchoolingFish {
    public static final Variant DEFAULT_VARIANT = new Variant(Pattern.KOB, DyeColor.WHITE, DyeColor.WHITE);
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.defineId(TropicalFish.class, EntityDataSerializers.INT);
    public static final List<Variant> COMMON_VARIANTS = List.of(new Variant(Pattern.STRIPEY, DyeColor.ORANGE, DyeColor.GRAY), new Variant(Pattern.FLOPPER, DyeColor.GRAY, DyeColor.GRAY), new Variant(Pattern.FLOPPER, DyeColor.GRAY, DyeColor.BLUE), new Variant(Pattern.CLAYFISH, DyeColor.WHITE, DyeColor.GRAY), new Variant(Pattern.SUNSTREAK, DyeColor.BLUE, DyeColor.GRAY), new Variant(Pattern.KOB, DyeColor.ORANGE, DyeColor.WHITE), new Variant(Pattern.SPOTTY, DyeColor.PINK, DyeColor.LIGHT_BLUE), new Variant(Pattern.BLOCKFISH, DyeColor.PURPLE, DyeColor.YELLOW), new Variant(Pattern.CLAYFISH, DyeColor.WHITE, DyeColor.RED), new Variant(Pattern.SPOTTY, DyeColor.WHITE, DyeColor.YELLOW), new Variant(Pattern.GLITTER, DyeColor.WHITE, DyeColor.GRAY), new Variant(Pattern.CLAYFISH, DyeColor.WHITE, DyeColor.ORANGE), new Variant(Pattern.DASHER, DyeColor.CYAN, DyeColor.PINK), new Variant(Pattern.BRINELY, DyeColor.LIME, DyeColor.LIGHT_BLUE), new Variant(Pattern.BETTY, DyeColor.RED, DyeColor.WHITE), new Variant(Pattern.SNOOPER, DyeColor.GRAY, DyeColor.RED), new Variant(Pattern.BLOCKFISH, DyeColor.RED, DyeColor.WHITE), new Variant(Pattern.FLOPPER, DyeColor.WHITE, DyeColor.YELLOW), new Variant(Pattern.KOB, DyeColor.RED, DyeColor.WHITE), new Variant(Pattern.SUNSTREAK, DyeColor.GRAY, DyeColor.WHITE), new Variant(Pattern.DASHER, DyeColor.CYAN, DyeColor.YELLOW), new Variant(Pattern.FLOPPER, DyeColor.YELLOW, DyeColor.YELLOW));
    private boolean isSchool = true;

    public TropicalFish(EntityType<? extends TropicalFish> entityType, Level level) {
        super((EntityType<? extends AbstractSchoolingFish>)entityType, level);
    }

    public static String getPredefinedName(int variantId) {
        return "entity.minecraft.tropical_fish.predefined." + variantId;
    }

    static int packVariant(Pattern pattern, DyeColor baseColor, DyeColor patternColor) {
        return pattern.getPackedId() & 0xFFFF | (baseColor.getId() & 0xFF) << 16 | (patternColor.getId() & 0xFF) << 24;
    }

    public static DyeColor getBaseColor(int variantId) {
        return DyeColor.byId(variantId >> 16 & 0xFF);
    }

    public static DyeColor getPatternColor(int variantId) {
        return DyeColor.byId(variantId >> 24 & 0xFF);
    }

    public static Pattern getPattern(int variantId) {
        return Pattern.byId(variantId & 0xFFFF);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_ID_TYPE_VARIANT, DEFAULT_VARIANT.getPackedId());
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.store("Variant", Variant.CODEC, new Variant(this.getPackedVariant()));
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        Variant variant = compound.read("Variant", Variant.CODEC).orElse(DEFAULT_VARIANT);
        this.setPackedVariant(variant.getPackedId());
    }

    public void setPackedVariant(int packedVariant) {
        this.entityData.set(DATA_ID_TYPE_VARIANT, packedVariant);
    }

    @Override
    public boolean isMaxGroupSizeReached(int size) {
        return !this.isSchool;
    }

    public int getPackedVariant() {
        return this.entityData.get(DATA_ID_TYPE_VARIANT);
    }

    public DyeColor getBaseColor() {
        return TropicalFish.getBaseColor(this.getPackedVariant());
    }

    public DyeColor getPatternColor() {
        return TropicalFish.getPatternColor(this.getPackedVariant());
    }

    public Pattern getPattern() {
        return TropicalFish.getPattern(this.getPackedVariant());
    }

    private void setPattern(Pattern pattern) {
        int packedVariant = this.getPackedVariant();
        DyeColor baseColor = TropicalFish.getBaseColor(packedVariant);
        DyeColor patternColor = TropicalFish.getPatternColor(packedVariant);
        this.setPackedVariant(TropicalFish.packVariant(pattern, baseColor, patternColor));
    }

    private void setBaseColor(DyeColor baseColor) {
        int packedVariant = this.getPackedVariant();
        Pattern pattern = TropicalFish.getPattern(packedVariant);
        DyeColor patternColor = TropicalFish.getPatternColor(packedVariant);
        this.setPackedVariant(TropicalFish.packVariant(pattern, baseColor, patternColor));
    }

    private void setPatternColor(DyeColor patternColor) {
        int packedVariant = this.getPackedVariant();
        Pattern pattern = TropicalFish.getPattern(packedVariant);
        DyeColor baseColor = TropicalFish.getBaseColor(packedVariant);
        this.setPackedVariant(TropicalFish.packVariant(pattern, baseColor, patternColor));
    }

    @Override
    @Nullable
    public <T> T get(DataComponentType<? extends T> component) {
        if (component == DataComponents.TROPICAL_FISH_PATTERN) {
            return TropicalFish.castComponentValue(component, this.getPattern());
        }
        if (component == DataComponents.TROPICAL_FISH_BASE_COLOR) {
            return TropicalFish.castComponentValue(component, this.getBaseColor());
        }
        return component == DataComponents.TROPICAL_FISH_PATTERN_COLOR ? TropicalFish.castComponentValue(component, this.getPatternColor()) : super.get(component);
    }

    @Override
    protected void applyImplicitComponents(DataComponentGetter componentGetter) {
        this.applyImplicitComponentIfPresent(componentGetter, DataComponents.TROPICAL_FISH_PATTERN);
        this.applyImplicitComponentIfPresent(componentGetter, DataComponents.TROPICAL_FISH_BASE_COLOR);
        this.applyImplicitComponentIfPresent(componentGetter, DataComponents.TROPICAL_FISH_PATTERN_COLOR);
        super.applyImplicitComponents(componentGetter);
    }

    @Override
    protected <T> boolean applyImplicitComponent(DataComponentType<T> component, T value) {
        if (component == DataComponents.TROPICAL_FISH_PATTERN) {
            this.setPattern(TropicalFish.castComponentValue(DataComponents.TROPICAL_FISH_PATTERN, value));
            return true;
        }
        if (component == DataComponents.TROPICAL_FISH_BASE_COLOR) {
            this.setBaseColor(TropicalFish.castComponentValue(DataComponents.TROPICAL_FISH_BASE_COLOR, value));
            return true;
        }
        if (component == DataComponents.TROPICAL_FISH_PATTERN_COLOR) {
            this.setPatternColor(TropicalFish.castComponentValue(DataComponents.TROPICAL_FISH_PATTERN_COLOR, value));
            return true;
        }
        return super.applyImplicitComponent(component, value);
    }

    @Override
    public void saveToBucketTag(ItemStack stack) {
        super.saveToBucketTag(stack);
        stack.copyFrom(DataComponents.TROPICAL_FISH_PATTERN, this);
        stack.copyFrom(DataComponents.TROPICAL_FISH_BASE_COLOR, this);
        stack.copyFrom(DataComponents.TROPICAL_FISH_PATTERN_COLOR, this);
    }

    @Override
    public ItemStack getBucketItemStack() {
        return new ItemStack(Items.TROPICAL_FISH_BUCKET);
    }

    @Override
    public SoundEvent getAmbientSound() {
        return SoundEvents.TROPICAL_FISH_AMBIENT;
    }

    @Override
    public SoundEvent getDeathSound() {
        return SoundEvents.TROPICAL_FISH_DEATH;
    }

    @Override
    public SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.TROPICAL_FISH_HURT;
    }

    @Override
    protected SoundEvent getFlopSound() {
        return SoundEvents.TROPICAL_FISH_FLOP;
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, EntitySpawnReason spawnReason, @Nullable SpawnGroupData spawnGroupData) {
        Variant variant;
        spawnGroupData = super.finalizeSpawn(level, difficulty, spawnReason, spawnGroupData);
        RandomSource random = level.getRandom();
        if (spawnGroupData instanceof TropicalFishGroupData) {
            TropicalFishGroupData tropicalFishGroupData = (TropicalFishGroupData)spawnGroupData;
            variant = tropicalFishGroupData.variant;
        } else if ((double)random.nextFloat() < 0.9) {
            variant = Util.getRandom(COMMON_VARIANTS, random);
            spawnGroupData = new TropicalFishGroupData(this, variant);
        } else {
            this.isSchool = false;
            Pattern[] patterns = Pattern.values();
            DyeColor[] dyeColors = DyeColor.values();
            Pattern pattern = Util.getRandom(patterns, random);
            DyeColor dyeColor = Util.getRandom(dyeColors, random);
            DyeColor dyeColor1 = Util.getRandom(dyeColors, random);
            variant = new Variant(pattern, dyeColor, dyeColor1);
        }
        this.setPackedVariant(variant.getPackedId());
        return spawnGroupData;
    }

    public static boolean checkTropicalFishSpawnRules(EntityType<TropicalFish> entityType, LevelAccessor level, EntitySpawnReason spawnReason, BlockPos pos, RandomSource random) {
        return level.getFluidState(pos.below()).is(FluidTags.WATER) && level.getBlockState(pos.above()).is(Blocks.WATER) && (level.getBiome(pos).is(BiomeTags.ALLOWS_TROPICAL_FISH_SPAWNS_AT_ANY_HEIGHT) || WaterAnimal.checkSurfaceWaterAnimalSpawnRules(entityType, level, spawnReason, pos, random));
    }

    public static enum Pattern implements StringRepresentable,
    TooltipProvider
    {
        KOB("kob", Base.SMALL, 0),
        SUNSTREAK("sunstreak", Base.SMALL, 1),
        SNOOPER("snooper", Base.SMALL, 2),
        DASHER("dasher", Base.SMALL, 3),
        BRINELY("brinely", Base.SMALL, 4),
        SPOTTY("spotty", Base.SMALL, 5),
        FLOPPER("flopper", Base.LARGE, 0),
        STRIPEY("stripey", Base.LARGE, 1),
        GLITTER("glitter", Base.LARGE, 2),
        BLOCKFISH("blockfish", Base.LARGE, 3),
        BETTY("betty", Base.LARGE, 4),
        CLAYFISH("clayfish", Base.LARGE, 5);

        public static final Codec<Pattern> CODEC;
        private static final IntFunction<Pattern> BY_ID;
        public static final StreamCodec<ByteBuf, Pattern> STREAM_CODEC;
        private final String name;
        private final Component displayName;
        private final Base base;
        private final int packedId;

        private Pattern(String name, Base base, int id) {
            this.name = name;
            this.base = base;
            this.packedId = base.id | id << 8;
            this.displayName = Component.translatable("entity.minecraft.tropical_fish.type." + this.name);
        }

        public static Pattern byId(int packedId) {
            return BY_ID.apply(packedId);
        }

        public Base base() {
            return this.base;
        }

        public int getPackedId() {
            return this.packedId;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        public Component displayName() {
            return this.displayName;
        }

        @Override
        public void addToTooltip(Item.TooltipContext context, Consumer<Component> tooltipAdder, TooltipFlag flag, DataComponentGetter componentGetter) {
            DyeColor dyeColor = componentGetter.getOrDefault(DataComponents.TROPICAL_FISH_BASE_COLOR, DEFAULT_VARIANT.baseColor());
            DyeColor dyeColor1 = componentGetter.getOrDefault(DataComponents.TROPICAL_FISH_PATTERN_COLOR, DEFAULT_VARIANT.patternColor());
            ChatFormatting[] chatFormattings = new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY};
            int index = COMMON_VARIANTS.indexOf(new Variant(this, dyeColor, dyeColor1));
            if (index != -1) {
                tooltipAdder.accept(Component.translatable(TropicalFish.getPredefinedName(index)).withStyle(chatFormattings));
            } else {
                tooltipAdder.accept(this.displayName.plainCopy().withStyle(chatFormattings));
                MutableComponent mutableComponent = Component.translatable("color.minecraft." + dyeColor.getName());
                if (dyeColor != dyeColor1) {
                    mutableComponent.append(", ").append(Component.translatable("color.minecraft." + dyeColor1.getName()));
                }
                mutableComponent.withStyle(chatFormattings);
                tooltipAdder.accept(mutableComponent);
            }
        }

        static {
            CODEC = StringRepresentable.fromEnum(Pattern::values);
            BY_ID = ByIdMap.sparse(Pattern::getPackedId, Pattern.values(), KOB);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Pattern::getPackedId);
        }
    }

    public record Variant(Pattern pattern, DyeColor baseColor, DyeColor patternColor) {
        public static final Codec<Variant> CODEC = Codec.INT.xmap(Variant::new, Variant::getPackedId);

        public Variant(int id) {
            this(TropicalFish.getPattern(id), TropicalFish.getBaseColor(id), TropicalFish.getPatternColor(id));
        }

        public int getPackedId() {
            return TropicalFish.packVariant(this.pattern, this.baseColor, this.patternColor);
        }
    }

    static class TropicalFishGroupData
    extends AbstractSchoolingFish.SchoolSpawnGroupData {
        final Variant variant;

        TropicalFishGroupData(TropicalFish leader, Variant variant) {
            super(leader);
            this.variant = variant;
        }
    }

    public static enum Base {
        SMALL(0),
        LARGE(1);

        final int id;

        private Base(int id) {
            this.id = id;
        }
    }
}

