/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.frog;

import java.util.Optional;
import net.minecraft.core.ClientAsset;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.animal.TemperatureVariants;
import net.minecraft.world.entity.animal.frog.FrogVariant;
import net.minecraft.world.entity.variant.BiomeCheck;
import net.minecraft.world.entity.variant.PriorityProvider;
import net.minecraft.world.entity.variant.SpawnContext;
import net.minecraft.world.entity.variant.SpawnPrioritySelectors;
import net.minecraft.world.level.biome.Biome;

public interface FrogVariants {
    public static final ResourceKey<FrogVariant> TEMPERATE = FrogVariants.createKey(TemperatureVariants.TEMPERATE);
    public static final ResourceKey<FrogVariant> WARM = FrogVariants.createKey(TemperatureVariants.WARM);
    public static final ResourceKey<FrogVariant> COLD = FrogVariants.createKey(TemperatureVariants.COLD);

    private static ResourceKey<FrogVariant> createKey(ResourceLocation name) {
        return ResourceKey.create(Registries.FROG_VARIANT, name);
    }

    public static void bootstrap(BootstrapContext<FrogVariant> context) {
        FrogVariants.register(context, TEMPERATE, "entity/frog/temperate_frog", SpawnPrioritySelectors.fallback(0));
        FrogVariants.register(context, WARM, "entity/frog/warm_frog", BiomeTags.SPAWNS_WARM_VARIANT_FROGS);
        FrogVariants.register(context, COLD, "entity/frog/cold_frog", BiomeTags.SPAWNS_COLD_VARIANT_FROGS);
    }

    private static void register(BootstrapContext<FrogVariant> context, ResourceKey<FrogVariant> key, String name, TagKey<Biome> biome) {
        HolderSet.Named<Biome> orThrow = context.lookup(Registries.BIOME).getOrThrow(biome);
        FrogVariants.register(context, key, name, SpawnPrioritySelectors.single(new BiomeCheck(orThrow), 1));
    }

    private static void register(BootstrapContext<FrogVariant> context, ResourceKey<FrogVariant> key, String name, SpawnPrioritySelectors spawnCondiftions) {
        context.register(key, new FrogVariant(new ClientAsset(ResourceLocation.withDefaultNamespace(name)), spawnCondiftions));
    }

    public static Optional<Holder.Reference<FrogVariant>> selectVariantToSpawn(RandomSource source, RegistryAccess registryAccess, SpawnContext context) {
        return PriorityProvider.pick(registryAccess.lookupOrThrow(Registries.FROG_VARIANT).listElements(), Holder::value, source, context);
    }
}

