/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import com.mojang.logging.LogUtils;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.bukkit.entity.Hanging;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.slf4j.Logger;

public abstract class BlockAttachedEntity
extends Entity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private int checkInterval;
    protected BlockPos pos;

    protected BlockAttachedEntity(EntityType<? extends BlockAttachedEntity> entityType, Level level) {
        super(entityType, level);
        this.checkInterval = this.getId() % this.level().spigotConfig.hangingTickFrequency;
    }

    protected BlockAttachedEntity(EntityType<? extends BlockAttachedEntity> entityType, Level level, BlockPos pos) {
        this(entityType, level);
        this.pos = pos;
    }

    protected abstract void recalculateBoundingBox();

    @Override
    public void tick() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.checkBelowWorld();
            if (this.checkInterval++ == this.level().spigotConfig.hangingTickFrequency) {
                this.checkInterval = 0;
                if (!this.isRemoved() && !this.survives()) {
                    HangingBreakEvent.RemoveCause cause = !this.level().getBlockState(this.blockPosition()).isAir() ? HangingBreakEvent.RemoveCause.OBSTRUCTION : HangingBreakEvent.RemoveCause.PHYSICS;
                    HangingBreakEvent event = new HangingBreakEvent((Hanging)this.getBukkitEntity(), cause);
                    this.level().getCraftServer().getPluginManager().callEvent((Event)event);
                    if (this.isRemoved() || event.isCancelled()) {
                        return;
                    }
                    this.discard(EntityRemoveEvent.Cause.DROP);
                    this.dropItem(serverLevel, null);
                }
            }
        }
    }

    public abstract boolean survives();

    @Override
    public boolean isPickable() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean skipAttackInteraction(Entity entity) {
        if (!(entity instanceof Player)) return false;
        Player player = (Player)entity;
        if (!this.level().mayInteract(player, this.pos)) return true;
        if (!this.hurtOrSimulate(this.damageSources().playerAttack(player), 0.0f)) return false;
        return true;
    }

    @Override
    public boolean hurtClient(DamageSource damageSource) {
        return !this.isInvulnerableToBase(damageSource);
    }

    @Override
    public boolean hurtServer(ServerLevel level, DamageSource damageSource, float amount) {
        if (this.isInvulnerableToBase(damageSource)) {
            return false;
        }
        if (!level.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING) && damageSource.getEntity() instanceof Mob) {
            return false;
        }
        if (!this.isRemoved()) {
            Entity damager;
            Entity entity = damager = !damageSource.isDirect() && damageSource.getEntity() != null ? damageSource.getEntity() : damageSource.getDirectEntity();
            Object event = damager != null ? new HangingBreakByEntityEvent((Hanging)this.getBukkitEntity(), (org.bukkit.entity.Entity)damager.getBukkitEntity(), damageSource.is(DamageTypeTags.IS_EXPLOSION) ? HangingBreakEvent.RemoveCause.EXPLOSION : HangingBreakEvent.RemoveCause.ENTITY) : new HangingBreakEvent((Hanging)this.getBukkitEntity(), damageSource.is(DamageTypeTags.IS_EXPLOSION) ? HangingBreakEvent.RemoveCause.EXPLOSION : HangingBreakEvent.RemoveCause.DEFAULT);
            this.level().getCraftServer().getPluginManager().callEvent((Event)event);
            if (this.isRemoved() || event.isCancelled()) {
                return true;
            }
            this.kill(level);
            this.markHurt();
            this.dropItem(level, damageSource.getEntity());
        }
        return true;
    }

    @Override
    public boolean ignoreExplosion(Explosion explosion) {
        return !explosion.shouldAffectBlocklikeEntities() || super.ignoreExplosion(explosion);
    }

    @Override
    public void move(MoverType type, Vec3 movement) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!this.isRemoved() && movement.lengthSqr() > 0.0) {
                HangingBreakEvent event = new HangingBreakEvent((Hanging)this.getBukkitEntity(), HangingBreakEvent.RemoveCause.PHYSICS);
                this.level().getCraftServer().getPluginManager().callEvent((Event)event);
                if (this.isRemoved() || event.isCancelled()) {
                    return;
                }
                this.kill(serverLevel);
                this.dropItem(serverLevel, null);
            }
        }
    }

    @Override
    public void push(double x, double y, double z, @Nullable Entity pushingEntity) {
    }

    @Override
    public void addAdditionalSaveData(CompoundTag nbt, boolean includeAll) {
        if (includeAll) {
            this.addAdditionalSaveData(nbt);
        }
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        tag.store("block_pos", BlockPos.CODEC, this.getPos());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        BlockPos blockPos = tag.read("block_pos", BlockPos.CODEC).orElse(null);
        if (blockPos != null && blockPos.closerThan(this.blockPosition(), 16.0)) {
            this.pos = blockPos;
        } else {
            LOGGER.error("Block-attached entity at invalid position: {}", (Object)blockPos);
        }
    }

    public abstract void dropItem(ServerLevel var1, @Nullable Entity var2);

    @Override
    protected boolean repositionEntityAfterLoad() {
        return false;
    }

    @Override
    public void setPos(double x, double y, double z) {
        this.pos = BlockPos.containing(x, y, z);
        this.recalculateBoundingBox();
        this.hasImpulse = true;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    @Override
    public void thunderHit(ServerLevel level, LightningBolt lightning) {
    }

    @Override
    public void refreshDimensions() {
    }
}

