/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRemoveEvent;

public interface InventoryCarrier {
    public static final String TAG_INVENTORY = "Inventory";

    public SimpleContainer getInventory();

    public static void pickUpItem(ServerLevel level, Mob mob, InventoryCarrier carrier, ItemEntity itemEntity) {
        ItemStack item = itemEntity.getItem();
        if (mob.wantsToPickUp(level, item)) {
            SimpleContainer inventory = carrier.getInventory();
            boolean canAddItem = inventory.canAddItem(item);
            if (!canAddItem) {
                return;
            }
            ItemStack remaining = new SimpleContainer(inventory).addItem(item);
            if (CraftEventFactory.callEntityPickupItemEvent(mob, itemEntity, remaining.getCount(), false).isCancelled()) {
                return;
            }
            mob.onItemPickup(itemEntity);
            int count = item.getCount();
            ItemStack itemStack = inventory.addItem(item);
            mob.take(itemEntity, count - itemStack.getCount());
            if (itemStack.isEmpty()) {
                itemEntity.discard(EntityRemoveEvent.Cause.PICKUP);
            } else {
                item.setCount(itemStack.getCount());
            }
        }
    }

    default public void readInventoryFromTag(CompoundTag tag, HolderLookup.Provider levelRegistry) {
        tag.getList(TAG_INVENTORY).ifPresent(listTag -> this.getInventory().fromTag((ListTag)listTag, levelRegistry));
    }

    default public void writeInventoryToTag(CompoundTag tag, HolderLookup.Provider levelRegistry) {
        tag.put(TAG_INVENTORY, this.getInventory().createTag(levelRegistry));
    }
}

